<?php
/**
 * GREYD.Blocks post-export extension
 * 
 * @deprecated since 2.0
 * the extension is already refactored into the greyd plugin
 */
namespace greyd\blocks;

if( ! defined( 'ABSPATH' ) ) exit;

new Post_Export($config);
class Post_Export {
	
	public function __construct() {

		// since this function exists, the extension is already refactored into the greyd plugin
		if ( function_exists( 'get_nested_post_patterns' ) ) {
			return;
		}
		
		add_filter( 'greyd_regex_nested_posts', array( $this, 'regex_nested_posts' ), 10, 3 );
		add_filter( 'greyd_regex_nested_terms', array( $this, 'regex_nested_terms' ), 10, 3 );
		add_filter( 'greyd_filter_post_content_before_post_import', array( $this, 'filter_content_on_import' ), 10, 3 );
	}

	/**
	 * Search & replace post-IDs or post_names inside post_content.
	 * 
	 * @filter 'greyd_regex_nested_posts'
	 * 
	 * @param array $patterns   @see get_nested_post_patterns() for details
	 * @param int $post_id      The post ID.
	 * @param WP_Post $post     The WP_Post Object
	 * 
	 * @return array $patterns  Filtered RegEx patterns
	 */
	public function regex_nested_posts( $patterns, $post_id, $post ) {

		if ( !has_blocks( $post->post_content ) ) return $patterns;

		// since this function exists, the extension is already refactored into the greyd plugin
		if ( function_exists( 'get_nested_post_patterns' ) ) {
			return $patterns;
		}

		do_action( "greyd_post_export_log", "\r\n---@filter: 'regex_nested_posts' for blocks" );

		// debug( esc_attr($post->post_content) );

		$patterns = array(

			/**
			 * ----------------- Posttypes -----------------
			 */

			/**
			 * Find nested Templates
			 */
			'greyd/dynamic' => array(
				'search'    => array( '<!-- wp:greyd\/dynamic {(.*?)\"template\":\"', '\"' ),
				'replace'   => array( '<!-- wp:greyd/dynamic {$1"template":"', '"' ),
				'post_type' => 'dynamic_template',
			),
			'greyd/dynamic/post' => array(
				'search'    => array( '<!-- wp:greyd\/dynamic {(.*?)\"postId\":\"', '\"' ),
				'replace'   => array( '<!-- wp:greyd/dynamic {$1"postId":"', '"' ),
				'post_type' => 'any',
			),

			/**
			 * Find nested GREYD.Forms
			 */
			'greyd/form' => array(
				'search'    => array( '<!-- wp:greyd\/form {\"id\":\"', '\"' ),
				'replace'   => array( '<!-- wp:greyd/form {"id":"', '"' ),
				'post_type' => 'tp_forms',
				'group'     => 1
			),
			'dynamic/greyd/form' => array(
				'search'    => array( '{\"dkey\":\"id\",\"dtype\":\"dropdown_forms\",(.*?),\"dvalue\":\"', '\"}' ),
				'replace'   => array( '{"dkey":"id","dtype":"dropdown_forms",$1,"dvalue":"', '"}' ),
				'post_type' => 'tp_forms',
			),

			/**
			 * Find nested GREYD.Popups
			 */
			'greyd/popup' => array(
				'search'    => array( '\"trigger\":{\"type\":\"popup\",\"params\":\"', '\"' ),
				'replace'   => array( '"trigger":{"type":"popup","params":"', '"' ),
				'post_type' => 'greyd_popup',
				'group'     => 1
			),
			'dynamic/greyd/popup' => array(
				'search'    => array( '{\"dkey\":\"trigger\",\"dtype\":\"textfield\",(.*?),\"dvalue\":\"%7B%22type%22%3A%22popup%22%2C%22params%22%3A%22', '%22%7D' ),
				'replace'   => array( '{"dkey":"trigger","dtype":"textfield",$1,"dvalue":"%7B%22type%22%3A%22popup%22%2C%22params%22%3A%22', '%22%7D' ),
				'post_type' => 'greyd_popup',
			),
			'greyd/inline/popup' => array(
				'search'    => array( 'data-type=\"popup\" data-params=\"&quot;', '&quot;\"' ),
				'replace'   => array( 'data-type="popup" data-params="&quot;', '&quot;"' ),
				'post_type' => 'greyd_popup',
				'group'     => 1
			),

			/**
			 * Find nested Reusables
			 */
			'core/reusable' => array(
				'search'    => array( '<!-- wp:block {\"ref\":', '}' ),
				'replace'   => array( '<!-- wp:block {"ref":', '}' ),
				'post_type' => 'wp_block',
				'group'     => 1
			),

			/**
			 * Find nested wp-template-parts
			 */
			'core/template-part' => array(
				'search'    => array( '<!-- wp:template-part {\"slug\":\"', '\"' ),
				'replace'   => array( '<!-- wp:template-part {"slug":"', '"' ),
				'post_type' => 'wp_template_part',
				'group'     => 1
			),

			/**
			 * Find nested wp_navigation (navigation menus)
			 */
			'core/template-part' => array(
				'search'    => array( '<!-- wp:navigation {\"navigationMenuId\":', '}' ),
				'replace'   => array( '<!-- wp:navigation {"navigationMenuId":', '}' ),
				'post_type' => 'wp_navigation',
				'group'     => 1
			),


			/**
			 * ----------------- Media files -----------------
			 */

			/**
			 * Find nested images in core blocks.
			 * 
			 * Supported blocks: image, cover, media-text, file
			 */
			'core/image' => array(
				'search'    => array( '<!-- wp:image {(.*?)\"id\":', ',' ),
				'replace'   => array( '<!-- wp:image {$1"id":', ',' ),
				'post_type' => 'attachment',
			),
			'core/image-class' => array(
				'search'    => array( 'class=\"([^\"]*?)wp-image-', '(\s|\")' ),
				'replace'   => array( 'class="$1wp-image-', '$2' ),
				'post_type' => 'attachment',
			),
			'core/cover' => array(
				'search'    => array( '<!-- wp:cover {(.*?)\"id\":', ',' ),
				'replace'   => array( '<!-- wp:cover {$1"id":', ',' ),
				'post_type' => 'attachment',
			),
			'core/media-text ' => array(
				'search'    => array( '<!-- wp:media-text {(.*?)\"mediaId\":', ',' ),
				'replace'   => array( '<!-- wp:media-text {$1"mediaId":', ',' ),
				'post_type' => 'attachment',
			),
			'core/file' => array(
				'search'    => array( '<!-- wp:file {(.*?)\"id\":', ',' ),
				'replace'   => array( '<!-- wp:file {$1"id":', ',' ),
				'post_type' => 'attachment',
			),

			/**
			 * Find nested videos in core blocks.
			 * 
			 * Supported blocks: video
			 */
			'core/video' => array(
				'search'    => array( '<!-- wp:video {([^}]*?)"id":', ',' ),
				'replace'   => array( '<!-- wp:video {$1"id":', ',' ),
				'post_type' => 'attachment',
			),
			
			/**
			 * Find nested images in greyd blocks.
			 * 
			 * Supported blocks: image, list, box, row
			 */
			'greyd/image' => array(
				'search'    => array( '<!-- wp:greyd\/image {(.*?)"image":{(.*?)"id":', ',' ),
				'replace'   => array( '<!-- wp:greyd/image {$1"image":{$2"id":', ',' ),
				'post_type' => 'attachment',
				'group'     => 3
			),
			// list
			'greyd/list' => array(
				'search'    => array( '<!-- wp:greyd\/list {(.*?)\"icon\":{\"id\":', ',' ),
				'replace'   => array( '<!-- wp:greyd/list {$1"icon":{"id":', ',' ),
				'post_type' => 'attachment',
			),
			'greyd/list-item' => array(
				'search'    => array( '<!-- wp:greyd\/list-item {(.*?)\"override\":{\"id\":', ',' ),
				'replace'   => array( '<!-- wp:greyd/list-item {$1"override":{"id":', ',' ),
				'post_type' => 'attachment',
			),
			// box- & row-backgrounds
			'greyd/background' => array(
				'search'    => array( '"background":{(.*?)"image":{"id":', ',' ),
				'replace'   => array( '"background":{$1"image":{"id":', ',' ),
				'post_type' => 'attachment'
			),
			// row background overlay custom pattern
			'greyd/background-pattern' => array(
				'search'    => array( '"pattern":{(.*?)"id":', ',' ),
				'replace'   => array( '"pattern":{$1"id":', ',' ),
				'post_type' => 'attachment',
			),

			// hotspot-wrapper
			'greyd/hotspot-wrapper' => array(
				'search'    => array( '<!-- wp:greyd\/hotspot-wrapper {(.*?)\"image\":{\"id\":', ',' ),
				'replace'   => array( '<!-- wp:greyd/hotspot-wrapper {$1"image":{"id":', ',' ),
				'post_type' => 'attachment',
			),
			// hotspot
			'greyd/hotspot' => array(
				'search'    => array( '<!-- wp:greyd\/hotspot {(.*?)\"hotspotImage\":{\"id\":', ',' ),
				'replace'   => array( '<!-- wp:greyd/hotspot {$1"hotspotImage":{"id":', ',' ),
				'post_type' => 'attachment',
			),

			/**
			 * Find nested images in dynamic contents.
			 * 
			 * Supported blocks: core/image, greyd/image, box, row
			 */
			'dynamic/core/image' => array(
				'search'    => array( '{\"dkey\":\"id\",\"dtype\":\"file_picker(.*?),\"dvalue\":\"', '\"' ),
				'replace'   => array( '{"dkey":"id","dtype":"file_picker$1,"dvalue":"', '"' ),
				'post_type' => 'attachment',
			),
			'dynamic/greyd/image' => array(
				'search'    => array( '{\"dkey\":\"image\",\"dtype\":\"textfield\",(.*?),\"dvalue\":\"%7B([^\"]*?)%22id%22%3A', '%2C%22' ),
				'replace'   => array( '{"dkey":"image","dtype":"textfield",$1,"dvalue":"%7B$2%22id%22%3A', '%2C%22' ),
				'post_type' => 'attachment',
				'group'     => 3
			),
			'dynamic/greyd/background' => array(
				'search'    => array( '{\"dkey\":\"background\/image\/id\",\"dtype\":\"file_picker(.*?),\"dvalue\":\"', '\"' ),
				'replace'   => array( '{"dkey":"background/image/id","dtype":"file_picker$1,"dvalue":"', '"' ),
				'post_type' => 'attachment',
			),

			/**
			 * Find nested images in GREYD.Forms.
			 * 
			 * Supported blocks: iconpanel
			 */
			'greyd-forms/iconpanel-normal' => array(
				'search'    => array( '<!-- wp:greyd-forms\/iconpanel {(.*?)\"normal\":{\"id\":', ',' ),
				'replace'   => array( '<!-- wp:greyd-forms/iconpanel {$1"normal":{"id":', ',' ),
				'post_type' => 'attachment',
			),
			'greyd-forms/iconpanel-hover' => array(
				'search'    => array( '<!-- wp:greyd-forms\/iconpanel {(.*?)\"hover\":{\"id\":', ',' ),
				'replace'   => array( '<!-- wp:greyd-forms/iconpanel {$1"hover":{"id":', ',' ),
				'post_type' => 'attachment',
			),
			'greyd-forms/iconpanel-active' => array(
				'search'    => array( '<!-- wp:greyd-forms\/iconpanel {(.*?)\"active\":{\"id\":', ',' ),
				'replace'   => array( '<!-- wp:greyd-forms/iconpanel {$1"active":{"id":', ',' ),
				'post_type' => 'attachment',
			),
		);

		return $patterns;
	}

	/**
	 * Get the patterns to replace term ids in post_content.
	 * 
	 * @param array   $patterns     @see get_nested_post_patterns() for details
	 * @param int     $post_id      The WP_Post ID.
	 * @param WP_Post $post         The WP_Post Object
	 * 
	 * @return array[] @see get_nested_post_patterns() for details.
	 */
	public function regex_nested_terms( $patterns, $post_id, $post ) {

		// since this function exists, the extension is already refactored into the greyd plugin
		if ( function_exists( 'get_nested_post_patterns' ) ) {
			return $patterns;
		}
		
		return array(
			'taxQuery' => array(
				'search'    => array( '\"taxQuery\":\{([^\}]+)(\[|,)', '(\]|,)' ),
				'replace'   => array( '"taxQuery":{$1$2', '$4' ),
				'group'     => 3
			),
		);
	}

	/**
	 * Filter the post content before import.
	 */
	public function filter_content_on_import( $content, $new_post_id, $post ) {
		$content = str_replace( '\\u002d\\u002d', '--', $content );
		$content = str_replace( '\u002d\u002d', '--', $content );
		$content = str_replace( 'u002du002d', '--', $content );

		return $content;
	}
}
