( function( blocks, element, blockEditor, components, serverSideRender, i18n, coreData ) {

	var el = element.createElement;
	const { __, _x } = i18n;


	if ( (greyd.data.post_type == "dynamic_template" && greyd.data.template_type == "woo") || greyd.data.post_id == greyd.woo.data.shop_page_id) {
		blocks.registerBlockType( 'greyd/woocontent', {
			title: __('Dynamischer WooCommerce Inhalt', 'greyd_blocks'),
			icon: el( 'img', { src: greyd.data.icon_url+"/woo.svg" } ),
			category: 'greyd-blocks',
			edit: function( props ) {
				// preview
				return el( 'div', { className: props.className+' preview-info-wrapper' }, [
					el( 'div', { className: 'preview-info-tag flex' }, [
						el( 'img', { className: 'preview-info-icon', src: greyd.data.icon_url+"/woo.svg" } ),
						el( 'div', { className: 'preview-info-title' },
							el( 'strong', {}, __('Dynamischer WooCommerce Inhalt', 'greyd_blocks')),
						),
					] ),
				] )
			},

			save: function( props ) {
				return "WOO_CONTENT"
			}
		} );
	}
	if ( greyd.data.post_id == greyd.woo.data.my_account_page_id) {
		blocks.registerBlockType( 'greyd/woo-account', {
			title: __('Mein Konto', 'greyd_blocks'),
			icon: el( 'img', { src: greyd.data.icon_url+"/woo.svg" } ),
			category: 'greyd-blocks',
			edit: function( props ) {
				// preview
				return el( 'div', { className: props.className+' preview-info-wrapper' }, [
					el( 'div', { className: 'preview-info-tag flex' }, [
						el( 'img', { className: 'preview-info-icon', src: greyd.data.icon_url+"/woo.svg" } ),
						el( 'div', { className: 'preview-info-title' },
							el( 'strong', {}, __('WooCommerce: Mein Konto', 'greyd_blocks')),
						),
					] ),
				] )
			},

			save: function( props ) {
				return "[woocommerce_my_account]"
			}
		} );
	}

	if ( greyd.data.post_id == greyd.woo.data.checkout_page_id) {
		blocks.registerBlockType( 'greyd/woo-checkout', {
			title: __('Kasse', 'greyd_blocks'),
			icon: el( 'img', { src: greyd.data.icon_url+"/woo.svg" } ),
			category: 'greyd-blocks',
			edit: function( props ) {
				// preview
				return el( 'div', { className: props.className+' preview-info-wrapper' }, [
					el( 'div', { className: 'preview-info-tag flex' }, [
						el( 'img', { className: 'preview-info-icon', src: greyd.data.icon_url+"/woo.svg" } ),
						el( 'div', { className: 'preview-info-title' },
							el( 'strong', {}, __('WooCommerce: Kasse', 'greyd_blocks')),
						),
					] ),
				] )
			},

			save: function( props ) {
				return "[woocommerce_checkout]"
			}
		} );
	}

	if ( greyd.data.post_id == greyd.woo.data.cart_page_id) {
		blocks.registerBlockType( 'greyd/woo-cart', {
			title: __('Warenkorb', 'greyd_blocks'),
			icon: el( 'img', { src: greyd.data.icon_url+"/woo.svg" } ),
			category: 'greyd-blocks',
			edit: function( props ) {
				// preview
				return el( 'div', { className: props.className+' preview-info-wrapper' }, [
					el( 'div', { className: 'preview-info-tag flex' }, [
						el( 'img', { className: 'preview-info-icon', src: greyd.data.icon_url+"/woo.svg" } ),
						el( 'div', { className: 'preview-info-title' },
							el( 'strong', {}, __('WooCommerce: Warenkorb', 'greyd_blocks')),
						),
					] ),
				] )
			},

			save: function( props ) {
				return "[woocommerce_cart]"
			}
		} );
	}


	
	if ( typeof greyd.data.plugins === 'object' && greyd.data.plugins !== null  && Object.values(greyd.data.plugins).includes("woocommerce-germanized/woocommerce-germanized.php")) {
		blocks.registerBlockType( 'greyd/gzd-payment-methods-info', {
			title: __('Info zu Zahlungsmethoden', 'greyd_blocks'),
			icon: el( 'img', { src: greyd.data.icon_url+"/woo_de.svg" } ),
			category: 'greyd-blocks',
			edit: function( props ) {
				// preview
				return el( 'div', { className: props.className+' preview-info-wrapper' }, [
					el( 'div', { className: 'preview-info-tag flex' }, [
						el( 'img', { className: 'preview-info-icon', src: greyd.data.icon_url+"/woo.svg" } ),
						el( 'div', { className: 'preview-info-title' },
							el( 'strong', {}, __('WooCommerce Germanized: Info zu Zahlungsmethoden', 'greyd_blocks')),
						),
					] ),
				] )
			},
	
			save: function( props ) {
				return "[payment_methods_info]"
			}
		} );
		blocks.registerBlockType( 'greyd/gzd-complaints', {
			title: __('Streitbeilegung', 'greyd_blocks'),
			icon: el( 'img', { src: greyd.data.icon_url+"/woo_de.svg" } ),
			category: 'greyd-blocks',
			edit: function( props ) {
				// preview
				return el( 'div', { className: props.className+' preview-info-wrapper' }, [
					el( 'div', { className: 'preview-info-tag flex' }, [
						el( 'img', { className: 'preview-info-icon', src: greyd.data.icon_url+"/woo.svg" } ),
						el( 'div', { className: 'preview-info-title' },
							el( 'strong', {}, __('WooCommerce Germanized: Streitbeilegung', 'greyd_blocks')),
						),
					] ),
				] )
			},
	
			save: function( props ) {
				return "[gzd_complaints]"
			}
		} );
	
		blocks.registerBlockType( 'greyd/gzd-revocation-form', {
			title: __('Widerrufsbelehrung', 'greyd_blocks'),
			icon: el( 'img', { src: greyd.data.icon_url+"/woo_de.svg" } ),
			category: 'greyd-blocks',
			edit: function( props ) {
				// preview
				return el( 'div', { className: props.className+' preview-info-wrapper' }, [
					el( 'div', { className: 'preview-info-tag flex' }, [
						el( 'img', { className: 'preview-info-icon', src: greyd.data.icon_url+"/woo.svg" } ),
						el( 'div', { className: 'preview-info-title' },
							el( 'strong', {}, __('WooCommerce Germanized: Widerrufsbelehrung', 'greyd_blocks')),
						),
					] ),
				] )
			},
	
			save: function( props ) {
				return "[revocation_form]"
			}
		} );
		blocks.registerBlockType( 'greyd/gzd-vat-info', {
			title: __('Steuer Info', 'greyd_blocks'),
			icon: el( 'img', { src: greyd.data.icon_url+"/woo_de.svg" } ),
			category: 'greyd-blocks',
			edit: function( props ) {
				// preview
				return el( 'div', { className: props.className+' preview-info-wrapper' }, [
					el( 'div', { className: 'preview-info-tag flex' }, [
						el( 'img', { className: 'preview-info-icon', src: greyd.data.icon_url+"/woo.svg" } ),
						el( 'div', { className: 'preview-info-title' },
							el( 'strong', {}, __('WooCommerce Germanized: Steuer Info', 'greyd_blocks')),
						),
					] ),
				] )
			},
	
			save: function( props ) {
				return "[gzd_vat_info]"
			}
		} );
	
		blocks.registerBlockType( 'greyd/gzd-sale-info', {
			title: __('Sale Info', 'greyd_blocks'),
			icon: el( 'img', { src: greyd.data.icon_url+"/woo_de.svg" } ),
			category: 'greyd-blocks',
			edit: function( props ) {
				// preview
				return el( 'div', { className: props.className+' preview-info-wrapper' }, [
					el( 'div', { className: 'preview-info-tag flex' }, [
						el( 'img', { className: 'preview-info-icon', src: greyd.data.icon_url+"/woo.svg" } ),
						el( 'div', { className: 'preview-info-title' },
							el( 'strong', {}, __('WooCommerce Germanized: Sale Info', 'greyd_blocks')),
						),
					] ),
				] )
			},
	
			save: function( props ) {
				return "[gzd_sale_info]"
			}
		} );
	}
	


})( 
	window.wp.blocks, 
	window.wp.element, 
	window.wp.blockEditor, 
	window.wp.components, 
	window.wp.serverSideRender, 
	window.wp.i18n, 
	window.wp.coreData, 
);

