/*
	WooCommerce Block Editor Additions
*/

( function( ) {

	var el = wp.element.createElement;
	var __ = wp.i18n.__;
	var _ = lodash;

	var wizardURL = greyd.woo.data.wizard_url

	if (greyd.data.post_id == greyd.woo.data.shop_page_id) {
		wp.data.dispatch( 'core/notices' ).createNotice(
			'info', // Can be one of: success, info, warning, error.
			__("Diese Seite wird standardmäßig für die Darstellung von Produkten & allen Shop-Übersichten verwendet. Wenn du genauere Kontrolle über die einzelnen Seiten haben möchtest, kannst du dir unter Templates > Neues Template spezielle WooCommerce-Templates erstellen.", "greyd_blocks"), 
			{
				isDismissible: true, 
				actions: [
					{
						url: wizardURL,
						label: 'Template erstellen',
					},
				],
			}
		);
	} else if (greyd.data.post_id == greyd.woo.data.my_account_page_id) {
		wp.data.dispatch( 'core/notices' ).createNotice(
			'info', // Can be one of: success, info, warning, error.
			__("Die einzelnen Unterpunkte und Inhalte des Kontobereichs werden automatisch erstellt. Du kannst dir aber unter Templates > Neues Template verschiedene Templates erstellen, die in den jeweiligen Unterseiten über oder unter dem Inhalt angezeigt werden. Wähle dafür als Art des Templates „Mein Konto“ und stelle die gewünschte Position ein.", "greyd_blocks"), 
			{
				isDismissible: true, 
				actions: [
					{
						url: wizardURL,
						label: 'Template erstellen',
					},
				],
			}
		);
	}


} )(
	window.wp, 
);
