/**
 * Registers all greyd/ blocks.
 */
( function ( blocks, element, components, i18n ) {

	var el = element.createElement;
	const { __, _x } = i18n;


	const transformDefaultAtts = function ( attributes ) {

		var newatts = {};
		if ( _.has( attributes, 'anchor' ) && attributes[ "anchor" ] != "" ) {
			newatts.anchor = attributes.anchor;
		}
		if ( _.has( attributes, 'className' ) && attributes[ "className" ] != "" ) {
			newatts.className = attributes.className;
		}
		if ( _.has( attributes, 'inline_css' ) && attributes[ "inline_css" ] != "" ) {
			newatts.inline_css = attributes.inline_css;
			newatts.inline_css_id = attributes.inline_css_id;
		}
		if ( _.has( attributes, 'trigger' ) && attributes[ "trigger" ] != "" ) {
			newatts.trigger = attributes.trigger;
		}
		return newatts;
	};

	blocks.registerBlockType( 'greyd/anchor', {
		title: __( 'Anker Ziel', 'greyd_blocks' ),
		description: __( 'Definition von Sprungmarken', 'greyd_blocks' ),
		icon: greyd.tools.getBlockIcon('anchor'),
		category: 'greyd-blocks',

		supports: {
			className: false,
			customClassName: false,
		},
		attributes: {
			anchor: { type: 'string', default: '' },
			greydStyles: { type: 'object' },
		},

		edit: function ( props ) {
			var offset = "";
			if ( has( props.attributes, "greydStyles.marginTop" ) ) {
				props.attributes.greydStyles[ '--anchorcustommargin' ] = props.attributes.greydStyles.marginTop;
				delete props.attributes.greydStyles.marginTop;
			}
			if ( has( props.attributes, "greydStyles.--anchorcustommargin" ) ) offset = props.attributes.greydStyles[ '--anchorcustommargin' ];

			return [
				// inspector
				el( InspectorControls, {}, [
					el( PanelBody, { title: __( 'Allgemein', 'greyd_blocks' ), initialOpen: true }, [
						el( components.TextControl, {
							label: __( 'Anker Bezeichnung', 'greyd_blocks' ),
							value: props.attributes.anchor,
							onChange: function ( value ) { props.setAttributes( { anchor: value } ); },
						} )
					] ),
					el( StylingControlPanel, {
						title: __( 'Versatz', 'greyd_blocks' ),
						initialOpen: false,
						supportsResponsive: true,
						blockProps: props,
						controls: [ {
							label: __( 'Vertikaler Versatz', 'greyd_blocks' ),
							attribute: "--anchorcustommargin",
							control: RangeUnitControl,
							min: -500,
							max: 500
						} ]
					} ),
				] ),
				// preview
				el( 'div', { className: props.className + ' preview-info-wrapper' }, [
					props.isSelected && offset !== "" && el( 'div', { className: 'preview-anchor-helper', style: { marginTop: offset } } ),
					el( 'div', { className: 'preview-info-tag flex' }, [
						greyd.tools.getBlockIcon('anchor'),
						el( 'div', { className: 'preview-info-title' }, [
							el( 'ul', {}, el( 'li', { id: props.attributes.anchor, }, [
								el( 'strong', {}, __( 'Anker Ziel', 'greyd_blocks' ) + ': ' ),
								el( wp.blockEditor.RichText, {
									format: 'string',
									tagName: 'span',
									style: { flex: '1' },
									value: props.attributes.anchor,
									placeholder: __( 'Ankernamen eingeben', 'greyd_blocks' ),
									allowedFormats: [],
									onChange: function ( value ) {
										props.setAttributes( { anchor: value } );
									},
								} ),
							] ) ),
						] ),
					] ),
				] )
			];
		},
		save: function ( props ) {
			return el( 'div', {
				style: { all: 'unset', position: 'relative' }
			}, [
				el( 'div', {
					id: props.attributes.anchor,
					className: 'greyd-anchor-target',
				} )
			] );
		},

		deprecated: [
			/**
			 * @since 1.8.5 Wrap anchor in relative div to prevent mislocation.
			 */
			{
				attributes: {
					anchor: { type: 'string', default: '' },
					greydStyles: { type: 'object' },
				},
				supports: {
					className: false,
					customClassName: false,
				},
				save: function ( props ) {
					return el( 'div', {
						id: props.attributes.anchor,
						className: 'greyd-anchor-target',
					} );
				},
			},
		],

		transforms: {
			to: [
				{
					type: 'block',
					blocks: [ 'core/group' ],
					isMatch: function ( attributes ) {
						// console.log(attributes);
						if ( _.has( attributes, 'anchor' ) && attributes[ "anchor" ] != "" ) {
							return true;
						}
						return false;
					},
					transform: function ( attributes, innerBlocks ) {
						console.log( 'convert group to anchor' );
						// console.log(attributes);
						// console.log(innerBlocks);

						var newatts = transformDefaultAtts( attributes );

						return blocks.createBlock(
							'core/group',
							newatts,
							[]
						);
					},
				}
			]
		}
	} );

} )(
	window.wp.blocks,
	window.wp.element,
	window.wp.components,
	window.wp.i18n
);

