( function ( wp ) {

	const {
		createElement: el,
	} = wp.element;

	const {
		__,
		_x
	} = wp.i18n;

	const {
		PanelBody,
		ToggleControl,
		Button,
		Icon,
		Tip
	} = wp.components;

	const {
		InnerBlocks,
		InspectorControls
	} = wp.blockEditor;

	/**
	 * Register the conditional content block.
	 */
	wp.blocks.registerBlockType( 'greyd/conditional-content', {
		title: __( 'Conditional Content', 'greyd_blocks' ),
		description: __( 'Abhängigkeit von Nutzerrollen, Tageszeit und anderen Parametern', 'greyd_blocks' ),
		icon: greyd.tools.getBlockIcon('condition'),
		category: 'greyd-blocks',
		supports: {
			customClassName: false,
		},
		attributes: {
			operator: { type: 'string', default: 'OR' },
			conditions: { type: 'array', default: [] },
			debug: { type: 'bool', default: false },
		},

		edit: function ( props ) {

			const hasChildBlocks = greyd.tools.hasChildBlocks( props.clientId );
			const defaultCondition = {
				type: 'urlparam',
				operator: 'is',
				value: '',
				detail: '',
				custom: '',
			};

			const types = {
				urlparam: { value: 'urlparam', label: _x( "URL Parameter", 'small', 'greyd_blocks' ) },
				cookie: { value: 'cookie', label: _x( "Session Cookie", 'small', 'greyd_blocks' ) },
				userrole: { value: 'userrole', label: _x( "Benutzerrolle", 'small', 'greyd_blocks' ) },
				time: { value: 'time', label: _x( "Tageszeit", 'small', 'greyd_blocks' ) },
				posttype: { value: 'posttype', label: _x( "Post Type", 'small', 'greyd_blocks' ) },
				field: { value: 'field', label: _x( "Post Type Feld des aktuellen Beitrags", 'small', 'greyd_blocks' ) },
				taxonomy: { value: 'taxonomy', label: _x( "Taxonomie des aktuellen Beitrags", 'small', 'greyd_blocks' ) },
				archivetax: { value: 'archivetax', label: _x( "Taxonomie des aktuellen Archivs", 'small', 'greyd_blocks' ) },
				search: { value: 'search', label: _x( "Anzahl gefundener Beiträge", 'small', 'greyd_blocks' ) },
				postIndex: { value: 'postIndex', label: _x( "Index des aktuellen Beitrags", 'small', 'greyd_blocks' ) },
			};
			const operators = {
				urlparam: {
					is: { value: 'is', label: _x( "hat den Wert:", 'small', 'greyd_blocks' ) },
					has: { value: 'has', label: _x( "enthält den Wert:", 'small', 'greyd_blocks' ) },
					has_not: { value: 'has_not', label: _x( "enthält nicht den Wert:", 'small', 'greyd_blocks' ) },
					is_not: { value: 'is_not', label: _x( "hat nicht den Wert:", 'small', 'greyd_blocks' ) },
					not_empty: { value: 'not_empty', label: _x( "ist gesetzt", 'small', 'greyd_blocks' ) },
					empty: { value: 'empty', label: _x( "ist nicht gesetzt", 'small', 'greyd_blocks' ) },
				},
				userrole: {
					is: { value: 'is', label: _x( "ist:", 'small', 'greyd_blocks' ) },
					is_not: { value: 'is_not', label: _x( "ist nicht:", 'small', 'greyd_blocks' ) },
				},
				posttype: {
					is: { value: 'is', label: _x( "ist:", 'small', 'greyd_blocks' ) },
					is_not: { value: 'is_not', label: _x( "ist nicht:", 'small', 'greyd_blocks' ) },
				},
				field: {
					is: { value: 'is', label: _x( "hat den Wert:", 'small', 'greyd_blocks' ) },
					has: { value: 'has', label: _x( "enthält den Wert:", 'small', 'greyd_blocks' ) },
					has_not: { value: 'has_not', label: _x( "enthält nicht den Wert:", 'small', 'greyd_blocks' ) },
					not_empty: { value: 'not_empty', label: _x( "ist gesetzt", 'small', 'greyd_blocks' ) },
					empty: { value: 'empty', label: _x( "ist nicht gesetzt", 'small', 'greyd_blocks' ) },
				},
				taxonomy: {
					has: { value: 'has', label: _x( "hat die Taxonomie(n):", 'small', 'greyd_blocks' ) },
					has_not: { value: 'has_not', label: _x( "hat nicht die Taxonomie(n):", 'small', 'greyd_blocks' ) },
				},
				archivetax: {
					is: { value: 'is', label: _x( "ist Archiv dieser Taxonomie:", 'small', 'greyd_blocks' ) },
					is_not: { value: 'is_not', label: _x( "ist nicht Archiv dieser Taxonomie:", 'small', 'greyd_blocks' ) },
				},
				search: {
					multiple: { value: 'multiple', label: _x( "mehrere Ergebnisse gefunden", 'small', 'greyd_blocks' ) },
					single: { value: 'single', label: _x( "genau 1 Ergebnis gefunden", 'small', 'greyd_blocks' ) },
					empty: { value: 'empty', label: _x( "Suchergebnisse sind leer", 'small', 'greyd_blocks' ) },
				},
				postIndex: {
					is: { value: 'is', label: _x( "ist", 'small', 'greyd_blocks' ) },
					is_not: { value: 'is_not', label: _x( "ist nicht", 'small', 'greyd_blocks' ) },
					less: { value: 'less', label: _x( "kleiner als", 'small', 'greyd_blocks' ) },
					greater: { value: 'greater', label: _x( "größer als", 'small', 'greyd_blocks' ) },
					even: { value: 'even', label: _x( "gerade", 'small', 'greyd_blocks' ) },
					odd: { value: 'odd', label: _x( "ungerade", 'small', 'greyd_blocks' ) },
				},
			};
			operators.cookie = operators.urlparam;
			operators.time = operators.userrole;

			const times = {
				'': { value: '', label: __( 'Uhrzeit wählen', 'greyd_blocks' ) },
				'5-12': { value: '5-12', label: _x( "morgens (ab 5 Uhr)", 'small', 'greyd_blocks' ) },
				'12-17': { value: '12-17', label: _x( "mittags (ab 12 Uhr)", 'small', 'greyd_blocks' ) },
				'17-23': { value: '17-23', label: _x( "abends (ab 17 Uhr)", 'small', 'greyd_blocks' ) },
				'23-24,0-5': { value: '23-24,0-5', label: _x( "nachts (23 Uhr bis 5 Uhr)", 'small', 'greyd_blocks' ) },
				'custom': { value: 'custom', label: _x( "individuell", 'small', 'greyd_blocks' ) }
			};

			return [

				// sidebar
				el( InspectorControls, {}, [
					// operator
					el( PanelBody, {
						title: __( 'Zusammenhang der Bedingungen', 'greyd_blocks' ),
						initialOpen: true
					}, [
						el( greyd.components.ButtonGroupControl, {
							value: props.attributes.operator,
							options: [
								{ value: 'OR', label: __( 'ODER', 'greyd_blocks' ) },
								{ value: 'AND', label: __( 'UND', 'greyd_blocks' ) },
							],
							onChange: ( value ) => { props.setAttributes( { operator: value } ); },
						} ),
						el( Tip, {}, __( 'Bei UND müssen alle Bedingungen zutreffen, bei ODER mindestens eine.', 'greyd_blocks' ) ),
					] ),
					// conditions
					el( greyd.components.AdvancedPanelBody, {
						title: __( 'Bedingungen', 'greyd_blocks' ),
						holdsChange: props.attributes.conditions.length > 0,
						initialOpen: true
					}, [
						el( 'div', {
							className: 'components-greyd-controlgroup',
						}, [
							...props.attributes.conditions.map( ( condition, i ) => {

								condition = { ...defaultCondition, ...condition };

								// get all taxonomies & terms
								const postTypes = [], taxonomies = [], terms = [], fields = [];
								
								if ( condition.type == 'taxonomy' || condition.type == 'archivetax' ) {
									for ( const [ slug, taxes ] of Object.entries( greyd.data.all_taxes ) ) {
										if ( taxes.length ) {
											postTypes.push( {
												value: slug,
												label: slug
											} );

											if ( slug == condition.detail ) {
												taxes.forEach( taxonomy => {
													if ( taxonomy.values.length ) {
														taxonomies.push( {
															value: taxonomy.slug,
															label: taxonomy.title
														} );

														if ( taxonomy.slug == condition.custom ) {
															taxonomy.values.forEach( term => {
																terms.push( {
																	value: term.slug,
																	label: term.title
																} );
															} );
														}
													}
												} );
											}
										}
									}
								}
								else if ( condition.type == 'posttype' ) {
									for ( const [ i, slug ] of Object.entries( greyd.data.all_posttypes ) ) {
										postTypes.push( {
											value: slug,
											label: slug
										} );
									}
								}
								else if ( condition.type == 'field' ) {
									greyd.data.post_types.forEach( (pt) => {
										if ( pt.fields ) {
											postTypes.push( {
												value: pt.slug,
												label: pt.slug
											} );
											if ( pt.slug == condition.detail ) {
												pt.fields.forEach( (field) => {
													fields.push( {
														value: field.name,
														label: field.label
													} );
												} );
											}
										}
									} );
								}

								const groupComponents = [];

								// remove
								groupComponents.push( el( Button, {
									className: "components-greyd-controlgroup__remove",
									onClick: () => {
										const newConditions = [ ...props.attributes.conditions ];
										newConditions.splice( i, 1 );
										props.setAttributes( { conditions: newConditions } );
									},
									title: __( 'Bedingung entfernen', 'greyd_blocks' )
								}, el( Icon, { icon: 'no-alt' } ) ) );

								// type
								groupComponents.push( el( greyd.components.OptionsControl, {
									label: __( "Art der Bedingung", 'greyd_blocks' ),
									value: condition.type,
									options: Object.values( types ),
									onChange: ( value ) => {
										const newConditions = [ ...props.attributes.conditions ];
										if ( value === 'search' ) {
											newConditions[ i ] = { ...defaultCondition, type: value, operator: 'multiple' };
										} else if ( value === 'taxonomy' ) {
											newConditions[ i ] = { ...defaultCondition, type: value, operator: 'has', value: [] };
										} else if ( value == 'archivetax' ) {
											newConditions[ i ] = { ...defaultCondition, type: value, operator: 'is', value: [] };
										} else if ( value == 'posttype' || value == 'field' ) {
											newConditions[ i ] = { ...defaultCondition, type: value, operator: 'is', value: [] };
										} else if ( value == 'postIndex' ) {
											newConditions[ i ] = { ...defaultCondition, type: value, operator: 'is', value: [] };
										} else if ( value == 'postIndex' ) {
											newConditions[ i ] = { ...defaultCondition, type: value, operator: 'is', value: [] };
										} else {
											newConditions[ i ] = { ...defaultCondition, type: value };
										}
										props.setAttributes( { conditions: newConditions } );
									},
								} ) );

								// url-parm / cookie detail
								if ( condition.type == 'urlparam' || condition.type == 'cookie' ) {
									groupComponents.push( el( greyd.components.OptionsControl, {
										// label: __("Parameter", 'greyd_blocks'),
										value: condition.detail,
										options: [
											{ value: '', label: __( 'Parameter wählen', 'greyd_blocks' ) },
											...greyd.data.url_params.map( param => {
												return {
													label: param.nicename,
													value: param.name
												};
											} ),
											{ value: 'custom', label: __( 'individueller Parameter', 'greyd_blocks' ) },
										],
										onChange: ( value ) => {
											const newConditions = [ ...props.attributes.conditions ];
											newConditions[ i ].detail = value;
											props.setAttributes( { conditions: newConditions } );
										},
									} ) );
									if ( condition.detail == 'custom' ) {
										groupComponents.push( el( 'input', {
											value: condition.custom,
											placeholder: __( 'individueller Parameter', 'greyd_blocks' ),
											className: 'components-text-control__input components-base-control',
											onInput: ( event ) => {
												const index = parseInt( event.target.closest( '.components-greyd-controlgroup__item' ).dataset.index );
												const newConditions = [ ...props.attributes.conditions ];
												newConditions[ index ].custom = event.target.value;
												props.setAttributes( { conditions: newConditions } );
											}
										} ) );
									}
								}

								// taxonomy detail
								if ( condition.type == 'taxonomy' || condition.type == 'archivetax' || condition.type == 'field' ) {

									// posttype
									groupComponents.push( el( greyd.components.SelectCustomControl, {
										value: condition.detail,
										options: [
											{ value: '', label: __( 'Post Type wählen', 'greyd_blocks' ) },
											...postTypes,
										],
										onChange: ( value ) => {
											const newConditions = [ ...props.attributes.conditions ];
											newConditions[ i ].detail = value;
											newConditions[ i ].custom = '';
											newConditions[ i ].value = [];
											props.setAttributes( { conditions: newConditions } );
										},
									} ) );

									// taxonomy
									if ( !_.isEmpty( condition.detail ) && condition.type !== 'field' ) {
										groupComponents.push( el( greyd.components.SelectCustomControl, {
											value: condition.custom,
											options: [
												{ value: '', label: __( 'Taxonomie wählen', 'greyd_blocks' ) },
												...taxonomies,
											],
											onChange: ( value ) => {
												const newConditions = [ ...props.attributes.conditions ];
												newConditions[ i ].custom = value;
												newConditions[ i ].value = [];
												props.setAttributes( { conditions: newConditions } );
											},
										} ) );
									}
									// field
									if ( !_.isEmpty( condition.detail ) && condition.type == 'field' ) {
										groupComponents.push( el( greyd.components.SelectCustomControl, {
											value: condition.custom,
											options: [
												{ value: '', label: __( 'Feld wählen', 'greyd_blocks' ) },
												...fields,
											],
											onChange: ( value ) => {
												const newConditions = [ ...props.attributes.conditions ];
												newConditions[ i ].custom = value;
												newConditions[ i ].value = [];
												props.setAttributes( { conditions: newConditions } );
											},
										} ) );
									}

								}

								// operator
								groupComponents.push( el( greyd.components.OptionsControl, {
									label: __( "Bedingung", 'greyd_blocks' ),
									value: condition.operator,
									options: Object.values( operators[ condition.type ] ),
									onChange: ( value ) => {
										const newConditions = [ ...props.attributes.conditions ];
										newConditions[ i ].operator = value;
										props.setAttributes( { conditions: newConditions } );
									},
								} ) );

								// value
								if (
									condition.operator !== 'empty'
									&& condition.operator !== 'not_empty'
									&& condition.type !== 'search'
									&& condition.operator !== 'even'
									&& condition.operator !== 'odd'
								) {

									groupComponents.push( el( 'div', { style: { marginBottom: '4px' } }, __( "Wert", 'greyd_blocks' ) ) );

									if ( condition.type == 'urlparam' || condition.type == 'cookie' ) {
										groupComponents.push( el( 'input', {
											value: condition.value,
											placeholder: __( 'Wert des Parameters', 'greyd_blocks' ),
											className: 'components-text-control__input components-base-control',
											onInput: ( event ) => {
												const index = parseInt( event.target.closest( '.components-greyd-controlgroup__item' ).dataset.index );
												const newConditions = [ ...props.attributes.conditions ];
												newConditions[ index ].value = event.target.value;
												props.setAttributes( { conditions: newConditions } );
											}
										} ) );
										if ( condition.detail === 'optin' || condition.detail === 'optout' ) {
											groupComponents.push( el( 'div', {
												// className: 'components-tip',
												style: { marginBottom: '10px', color: '#757575', fontSize: 'small' },
												dangerouslySetInnerHTML: {
													__html: [
														"<ol style=\"margin:1em 0 1em 3em;\">",
														"<li><b>true-just</b>: " + _x( 'die Aktion (Opt-in bzw. Opt-out) wurde mit diesem Seitenaufruf erfolgreich durchgeführt.', 'small', 'core' ) + "</li>",
														"<li><b>true-already</b>: " + _x( 'die Aktion (Opt-in bzw. Opt-out) wurde bereits erfolgreich durchgeführt.', 'small', 'core' ) + "</li>",
														"<li><b>false-found</b>: " + _x( 'es konnte kein entsprechender Eintrag gefunden werden.', 'small', 'core' ) + "</li>",
														"<li><b>false-out</b>: " + _x( 'der Eintrag konnte nicht verifiziert werden (Opt-in), da ihm bereits widersprochen wurde (Opt-out).', 'small', 'core' ) + "</li>",
														"</ol>",
														"<i>" + __( 'Beispiel: Du möchtest einen Inhalt nur anzeigen, wenn der Nutzer seine Identität bestätigt hat (Opt-in). Wähle als Parameter „Formular Opt-in“. Als Bedingung stellst du „enthält den Wert:“ ein und als Wert gibst du „true“ ein. Jetzt trifft die Bedingung auf beide Werte mit dem Zusatz „true“ zu.', 'core' ) + "</i>"
													].join( "" )
												}
											} ) );
										}
									}
									else if ( condition.type == 'userrole' ) {
										groupComponents.push( el( greyd.components.OptionsControl, {
											value: condition.value,
											options: [
												{ value: '', label: _x( 'Nutzerrolle wählen', 'small', 'greyd_blocks' ) },
												{ value: 'none', label: _x( 'unbekannt (nicht eingeloggt)', 'small', 'greyd_blocks' ) },
												...Object.entries( greyd.data.user_roles ).map( param => {
													return {
														label: param[ 1 ].name,
														value: param[ 0 ]
													};
												} ),
											],
											onChange: ( value ) => {
												const newConditions = [ ...props.attributes.conditions ];
												newConditions[ i ].value = value;
												props.setAttributes( { conditions: newConditions } );
											},
										} ) );
									}
									else if ( condition.type == 'time' ) {
										groupComponents.push( el( greyd.components.OptionsControl, {
											value: condition.value,
											options: Object.values( times ),
											onChange: ( value ) => {
												const newConditions = [ ...props.attributes.conditions ];
												newConditions[ i ].value = value;
												props.setAttributes( { conditions: newConditions } );
											},
										} ) );
										if ( condition.value == 'custom' ) {
											groupComponents.push( el( 'input', {
												value: condition.custom,
												placeholder: __( 'individuelle Uhrzeit', 'greyd_blocks' ),
												className: 'components-text-control__input components-base-control',
												onInput: ( event ) => {
													const index = parseInt( event.target.closest( '.components-greyd-controlgroup__item' ).dataset.index );
													const newConditions = [ ...props.attributes.conditions ];
													newConditions[ index ].custom = event.target.value;
													props.setAttributes( { conditions: newConditions } );
												}
											} ) );
											groupComponents.push( el( 'div', {
												// className: 'components-tip',
												style: { marginBottom: '10px', color: '#757575', fontSize: 'small' },
												dangerouslySetInnerHTML: {
													__html: __( 'Uhrzeiten in vollen Stunden oder mit Minuten angeben und mit Bindestrichen trennen (z.B. für 12 bis 13:30 Uhr: <code>12-13:30</code>). Mehrere Zeitabschnitte mit Komma trennen (z.B. <code>12-13,15-16</code>). Uhrzeiten vor und nach Mitternacht als einzelne Abschnitte angeben (z.B. für 22 bis 4 Uhr morgens: <code>22-24,0-4</code>).', 'greyd_blocks' )
												}
											} ) );
										}
									}
									else if ( condition.type == 'taxonomy' || condition.type == 'archivetax' ) {

										if ( terms.length ) {
											groupComponents.push(
												el( greyd.components.SelectCustomControl, {
													value: condition.value,
													options: terms,
													multiple: condition.type == 'taxonomy',
													// disabled: !terms.length,
													onChange: ( value ) => {
														const newConditions = [ ...props.attributes.conditions ];
														newConditions[ i ].value = value;
														props.setAttributes( { conditions: newConditions } );
													},
												} )
											);
										}
										else {
											groupComponents.push(
												el( wp.components.TextControl, {
													value: condition.value,
													onChange: ( value ) => {
														const newConditions = [ ...props.attributes.conditions ];
														newConditions[ i ].value = value;
														props.setAttributes( { conditions: newConditions } );
													},
												} )
											);
										}

									}
									else if ( condition.type == 'field' ) {

										groupComponents.push(
											el( wp.components.TextControl, {
												value: condition.value,
												onChange: ( value ) => {
													const newConditions = [ ...props.attributes.conditions ];
													newConditions[ i ].value = value;
													props.setAttributes( { conditions: newConditions } );
												},
											} )
										);

									}
									else if ( condition.type == 'posttype' ) {
										groupComponents.push(
											el( greyd.components.SelectCustomControl, {
												value: condition.value,
												options: [
													{ value: '', label: __( 'Post Type wählen', 'greyd_blocks' ) },
													...postTypes,
												],
												disabled: !postTypes.length,
												onChange: ( value ) => {
													const newConditions = [ ...props.attributes.conditions ];
													newConditions[ i ].value = value;
													props.setAttributes( { conditions: newConditions } );
												},
											} )
										);
									}
									else if ( condition.type == 'postIndex' ) {
										groupComponents.push( el( wp.components.__experimentalNumberControl, {
											value: condition.value,
											isDragEnabled: true,
											isShiftStepEnabled: true,
											min: 0,
											step: 1,
											onChange: ( value ) => {
												const newConditions = [ ...props.attributes.conditions ];
												newConditions[ i ].value = value;
												props.setAttributes( { conditions: newConditions } );
											}
										} ) );
									}
								};

								// info
								if ( condition.type == 'search' ) {
									groupComponents.push( el( 'div', {
										className: 'components-tip',
										style: { marginBottom: '10px' }
									}, __( 'Die Abhängigkeit von gefundenen Beiträgen funktioniert nur in „Suche“- & „Archiv“-Templates. Andererseits wird dieser Inhalt nicht dargestellt.', 'greyd_blocks' ) ) );
								}
								else if ( condition.type == 'taxonomy' ) {
									groupComponents.push( el( 'div', {
										className: 'components-tip',
										style: { marginBottom: '10px' }
									}, __( 'Die Abhängigkeit von Taxonomien funktioniert nur in „Beitragsseiten“-Templates. Andererseits wird dieser Inhalt nicht dargestellt.', 'greyd_blocks' ) ) );
								}
								else if ( condition.type == 'archivetax' ) {
									groupComponents.push( el( 'div', {
										className: 'components-tip',
										style: { marginBottom: '10px' }
									}, __( 'Die Abhängigkeit von Archiv-Taxonomien funktioniert nur in „Archiv“-Templates. Andererseits wird dieser Inhalt nicht dargestellt.', 'greyd_blocks' ) ) );
								}
								else if ( condition.type == 'field' ) {
									groupComponents.push( el( 'div', {
										className: 'components-tip',
										style: { marginBottom: '10px' }
									}, __( 'Die Abhängigkeit von Post Type Feldern funktioniert nur mit GREYD Post Types. Andererseits wird dieser Inhalt nicht dargestellt.', 'greyd_blocks' ) ) );
								}
								else if ( condition.type == 'postIndex' ) {
									groupComponents.push( el( 'div', {
										className: 'components-tip',
										style: { marginBottom: '10px' }
									}, __( "Die Abhängigkeit vom Index des aktuellen Beitrags funktioniert nur in Abfrage-Loops. Der erste dargestellte Beitrag hat den Index '1', der Zweite '2' und so weiter. Ansonsten ist dieser Wert immer '0'.", 'greyd_blocks' ) ) );
								}

								return el( 'div', {
									className: 'components-greyd-controlgroup__item',
									'data-index': i,
								}, groupComponents );
							} ),
							el( Button, {
								className: 'components-greyd-controlgroup__add' + ( props.attributes.conditions.length === 0 ? ' group_is_empty' : '' ),
								onClick: ( event ) => {
									props.setAttributes( { conditions: [ ...props.attributes.conditions, defaultCondition ] } );
									// console.log(props.attributes.conditions);
								},
								title: __( 'Bedingung hinzufügen', 'greyd_blocks' )
							}, [
								el( Icon, { icon: 'plus-alt2' } ),
								props.attributes.conditions.length === 0 ? el( 'span', {}, __( 'Bedingung hinzufügen', 'greyd_blocks' ) ) : null
							] )
						] )
					] ),
					// debug
					el( greyd.components.AdvancedPanelBody, {
						title: __( 'Debug Modus', 'greyd_blocks' ),
						holdsChange: props.attributes.debug,
						initialOpen: true
					}, [
						el( ToggleControl, {
							label: __( 'Debug Modus aktivieren', 'greyd_blocks' ),
							checked: props.attributes.debug,
							onChange: ( value ) => { props.setAttributes( { debug: value } ); },
							help: __( 'Es wird ein Text im Frontend dargestellt, der dabei hilft, Probleme zu identifizieren. Achtung: Nicht auf Live-Seiten verwenden!', 'greyd_blocks' ),
						} ),
					] ),
				] ),

				// preview
				el( 'div', { className: props.className + ' preview-info-wrapper' }, [
					el( 'div', { className: 'preview-info-tag flex' }, [
						greyd.tools.getBlockIcon('condition'),
						el( 'div', { className: 'preview-info-title' },
							el( "ul", {}, props.attributes.conditions.map( ( condition, i ) => {

								condition = { ...defaultCondition, ...condition };
								let prefix = i < 1 ? "" : ( props.attributes.operator === 'AND' ? __( 'UND', 'greyd_blocks' ) : __( 'ODER', 'greyd_blocks' ) ) + " ";
								let label = types[ condition.type ].label + " ";
								let oprtr = operators[ condition.type ][ condition.operator ].label;
								let value = condition.operator === 'empty' || condition.operator === 'not_empty' ? "" : " '" + condition.value + "'";

								if ( condition.type === 'urlparam' || condition.type === 'cookie' ) {
									if ( condition.detail === 'custom' ) {
										label += "'" + condition.custom + "' ";
									} else {
										label += "'" + condition.detail + "' ";
									}
								}
								else if ( condition.type === 'time' ) {
									if ( condition.value === 'custom' ) value = " '" + condition.custom + "' " + __( 'Uhr', 'greyd_blocks' );
									else value = " " + times[ condition.value ].label;
								}
								else if ( condition.type === 'search' ) {
									value = "";
								}

								return el( "li", { dangerouslySetInnerHTML: { __html: prefix + "<strong>" + label + "</strong>" + oprtr + value + "." } } );
							} ) )
						),
					] ),
					el( 'div', { className: 'preview-info-content' }, [
						el( InnerBlocks, { renderAppender: hasChildBlocks ? InnerBlocks.DefaultBlockAppender : InnerBlocks.ButtonBlockAppender } )
					] )
				] )
			];
		},
		save: function ( props ) {
			return el( InnerBlocks.Content );
		}
	} );

} )(
	window.wp
);