<?php
/**
 * Register Popover block.
 *
 * @since 1.4.3
 */
function greyd_register_popover_block() {

	// in case we need to update the scripts & styles
	$version = defined( 'GREYD_BLOCKS_VERSION' ) ? constant( 'GREYD_BLOCKS_VERSION' ) : '1.2';

	// register the scripts
	if ( function_exists( 'wp_register_script' ) ) {

		wp_register_script(
			'greyd-popover-editor-script',
			trailingslashit( plugin_dir_url( __FILE__ ) ) . 'editor.js',
			array( 'greyd-tools', 'wp-blocks', 'wp-element', 'wp-block-editor', 'wp-components', 'wp-i18n', 'lodash', 'wp-core-data', 'wp-edit-post' ),
			$version
		);

		wp_register_script(
			'greyd-popover-frontend-script',
			trailingslashit( plugin_dir_url( __FILE__ ) ) . 'frontend.js',
			null,
			$version
		);

		// add script translations
		if ( function_exists( 'wp_set_script_translations' ) ) {
			wp_set_script_translations( 'greyd-popover-editor-script', 'greyd_blocks', trailingslashit( WP_PLUGIN_DIR ) . 'greyd_blocks/languages' );
		}
	}

	// register the styles
	if ( function_exists( 'wp_register_style' ) ) {
		wp_register_style(
			'greyd-popover-frontend-style',
			trailingslashit( plugin_dir_url( __FILE__ ) ) . 'style.css',
			null,
			$version
		);
		wp_register_style(
			'greyd-popover-hamburger-style',
			trailingslashit( plugin_dir_url( __FILE__ ) ) . 'hamburger.css',
			null,
			$version
		);
		wp_register_style(
			'greyd-popover-editor-style',
			trailingslashit( plugin_dir_url( __FILE__ ) ) . 'editor.css',
			null,
			$version
		);
	}

	// register the blocks
	if ( function_exists( 'register_block_type' ) ) {
		register_block_type(
			'greyd/popover',
			array(
				'editor_script' => 'greyd-popover-editor-script',
				'editor_style'  => 'greyd-popover-editor-style',
				'view_script'   => 'greyd-popover-frontend-script',
				'style'         => 'greyd-popover-frontend-style',
			)
		);
		register_block_type(
			'greyd/popover-popup',
			array(
				'editor_script' => 'greyd-popover-editor-script',
			)
		);
		register_block_type(
			'greyd/popover-button',
			array(
				'editor_script' => 'greyd-popover-editor-script',
				'style'         => 'greyd-popover-hamburger-style'
			)
		);
	}
}
add_action( 'init', 'greyd_register_popover_block', 99 );

require_once __DIR__ . '/render.php';
