<?php
/**
 * Render Popover block.
 * 
 * @since 1.4.2
 * @see https://developer.wordpress.org/reference/hooks/render_block/
 * 
 * @param string $block_content     pre-rendered Block Content
 * @param object $block             parsed Block
 * 
 * @return string $block_content    altered Block Content
 */
function greyd_render_popover_block( $block_content, $block ) {

	if ($block['blockName'] !== 'greyd/popover') return $block_content;

	// add truly unique id
	$uniqid        = wp_unique_id( 'popover-' );
	$block_content = str_replace( 'popover-ID', $uniqid, $block_content );

	return $block_content;
}
add_filter( 'render_block', 'greyd_render_popover_block', 10, 2 );