<?php
/**
 * Register old post vc-modules for the block editor.
 * 
 * all hidden and @deprecated
 */
namespace greyd\blocks\deprecated;

if( ! defined( 'ABSPATH' ) ) exit;

new Blocks($config);
class Blocks {

	/**
	 * Holds the plugin config
	 */
	private $config;

	/**
	 * Constructor
	 */
	public function __construct($config) {

		if ( !function_exists('register_block_type') ) return;

		// set config
		$this->config = (object)$config;

		// setup
		if (!function_exists('get_plugin_data')) require_once(ABSPATH . '/wp-admin/includes/plugin.php');
		$this->config->plugin_version = get_plugin_data($this->config->plugin_file)['Version'];
		$this->config->assets_url = plugin_dir_url($this->config->plugin_file).'inc/deprecated';

		// register blocks
		add_action( 'init', array($this, 'register_blocks'), 98 );
	}

	/**
	 * Register the blocks
	 */
	public function register_blocks() {

		// register assets
		wp_register_script(
			'greyd-blocks-editor-deprecated-script',
			$this->config->assets_url.'/editor.js',
			array( 'greyd-tools', 'wp-blocks', 'wp-element', 'wp-block-editor', 'wp-components', 'wp-i18n', 'lodash', 'wp-core-data', 'wp-edit-post' ),
			$this->config->plugin_version
		);
		
		// posts
		register_block_type( 'greyd/posts', array(
			'supports' => array( 
				'anchor' => true,
				'inserter' => false, // hide this block from the inserter
			),
			'attributes' => array(
				'inline_css' 	=> array( 'type' => 'string', 'default' => '' ),
				'inline_css_id' => array( 'type' => 'string', 'default' => '' ),
				'post_setup_mode' 	=> array( 'type' => 'string', 'default' => 'manual' ),
				'post_setup' 		=> array( 'type' => 'string', 'default' => '' ),
				'template' 			=> array( 'type' => 'string', 'default' => '' ),
				'options' 			=> array( 'type' => 'string', 'default' => '' ),
				'dynamic_content' 	=> array( 'type' => 'string', 'default' => '' ),
				'raw' 				=> array( 'type' => 'string', 'default' => '' ),
			),
			'editor_script' => 'greyd-blocks-editor-deprecated-script',
			'render_callback' =>  array($this, 'render_posts'),
		) );
		register_block_type( 'greyd/template-posts', array(
			'supports' => array( 
				'anchor' => true,
				'inserter' => false, // hide this block from the inserter
			),
			'attributes' => array(
				'inline_css' 	=> array( 'type' => 'string', 'default' => '' ),
				'inline_css_id' => array( 'type' => 'string', 'default' => '' ),
				'post_setup_mode' 	=> array( 'type' => 'string', 'default' => 'manual' ),
				'raw' 				=> array( 'type' => 'string', 'default' => '' ),
			),
			'editor_script' => 'greyd-blocks-editor-deprecated-script',
			'render_callback' => array($this, 'render_template_posts'),
		) );
		register_block_type( 'greyd/template-post', array(
			'supports' => array( 
				'anchor' => true,
				'inserter' => false, // hide this block from the inserter 
			),
			'attributes' => array(
				'inline_css' 	=> array( 'type' => 'string', 'default' => '' ),
				'inline_css_id' => array( 'type' => 'string', 'default' => '' ),
				'post_setup_mode' 	=> array( 'type' => 'string', 'default' => 'manual' ),
				'raw' 				=> array( 'type' => 'string', 'default' => '' ),
			),
			'editor_script' => 'greyd-blocks-editor-deprecated-script',
			'render_callback' => array($this, 'render_template_post'),
		) );
		register_block_type( 'greyd/template-details', array(
			'supports' => array( 
				'anchor' => true,
				'inserter' => false, // hide this block from the inserter 
			),
			'attributes' => array(
				'inline_css' 	=> array( 'type' => 'string', 'default' => '' ),
				'inline_css_id' => array( 'type' => 'string', 'default' => '' ),
				'raw' 				=> array( 'type' => 'string', 'default' => '' ),
			),
			'editor_script' => 'greyd-blocks-editor-deprecated-script',
			'render_callback' =>  array($this, 'render_template_details'),
		) );
		
		register_block_type( 'greyd/copyright', array(
			'supports' => array( 
				'anchor' => true,
				'inserter' => false, // hide this block from the inserter 
			),
			'attributes' => array(
				'inline_css' 	=> array( 'type' => 'string', 'default' => '' ),
				'inline_css_id' => array( 'type' => 'string', 'default' => '' ),
				'layout' 		=> array( 'type' => 'string', 'default' => 'center' ),
				'text' 			=> array( 'type' => 'string', 'default' => '_c_ _year_ _name_' ),
				'img' 			=> array( 'type' => 'string', 'default' => '' ),
			),
			'editor_script' => 'greyd-blocks-editor-deprecated-script',
			'render_callback' => array($this, 'render_copyright'),
		) );
		register_block_type( 'greyd/counter', array(
			'supports' => array( 
				'anchor' => true,
				'inserter' => false, // hide this block from the inserter 
			),
			'attributes' => array(
				'inline_css' 	=> array( 'type' => 'string', 'default' => '' ),
				'inline_css_id' => array( 'type' => 'string', 'default' => '' ),
				'type' 			=> array( 'type' => 'string', 'default' => 'manual' ),
				'manual' 		=> array( 'type' => 'string', 'default' => '42' ),
				'posttype' 		=> array( 'type' => 'string', 'default' => '' ),
				'anim_time' 	=> array( 'type' => 'string', 'default' => '1s' ),
				'content' 		=> array( 'type' => 'string', 'default' => '_count_' ),
			),
			'editor_script' => 'greyd-blocks-editor-deprecated-script',
			'render_callback' => array($this, 'render_counter'),
		) );

		register_block_type( 'greyd/accord', array(
			'editor_script' => 'greyd-blocks-editor-deprecated-script',
		) );
		register_block_type( 'greyd/accord-item', array(
			'editor_script' => 'greyd-blocks-editor-deprecated-script',
		) );
	}

	/**
	 * Render post archive links vc-module.
	 */
	public static function render_posts_links($atts) {
		$attributes = (array)json_decode($atts['raw']);
		return \vc\shortcode_posts::posts_links_sc($attributes, "").helper::get_style();
	}

	/**
	 * Render post overview vc-module.
	 */
	public static function render_posts($atts) {
		// debug($atts);
		$attributes = (array)json_decode($atts['raw']);
		$attributes['post_setup_mode'] = $atts['post_setup_mode'];
		$attributes['post_setup'] = urlencode($atts['post_setup']);
		$attributes['post_template'] = $atts['template'];
		$attributes['post_template_options'] = $atts['options'];
		$attributes['dynamic_post_content'] = $atts['dynamic_content'];
		// debug($attributes);
		return \vc\shortcode_posts::posts_overview_sc($attributes, "").helper::get_style();
	}

	/**
	 * Render post template vc-module.
	 */
	public static function render_template_post($atts) {
		$attributes = (array)json_decode($atts['raw']);
		return \vc\shortcode_posts::post_template_sc($attributes, "").helper::get_style();
	}

	/**
	 * Render posts template vc-module.
	 */
	public static function render_template_posts($atts) {
		$attributes = (array)json_decode($atts['raw']);
		return \vc\shortcode_posts::posts_template_sc($attributes, "").helper::get_style();
	}

	/**
	 * Render post details vc-module.
	 */
	public static function render_template_details($atts) {
		$attributes = (array)json_decode($atts['raw']);
		return \vc\shortcode_posts::posts_details_sc($attributes, "").helper::get_style();
	}

	/**
	 * Render counter vc-module.
	 */
	public static function render_counter($atts) {
		return \vc\shortcode::counter_sc($atts, $atts['content']);
	}

	/**
	 * Render copyright vc-module.
	 */
	public static function render_copyright($atts) {
		return \vc\shortcode::copyright_sc($atts, "");
	}
}