/**
 * Render old post vc-modules inside the block editor.
 * 
 * all hidden and @deprecated
 */
( function( blocks, element, blockEditor, components, serverSideRender, i18n, coreData ) {

	var el = element.createElement;
	const { __, _x } = i18n;

	blocks.registerBlockType( 'greyd/posts', {
		title: __('Post Übersicht', 'greyd_blocks'),
		description: __('Posts als Slider, Raster o.Ä. darstellen', 'greyd_blocks'),
		// icon: greyd.tools.getBlockIcon('query'),
		category: 'greyd-blocks',
		// parent: parent_blocks,
		
		// todo refactor class
		edit: class extends wp.element.Component {
			constructor(props) {
				super(props);
				this.state = { mode: '', href: '', content: '' };
				this.loading = false;
			}
			render() {
				// console.log(this);
				if (this.props.isSelected && this.props.attributes.post_setup_mode == 'template') {
					// greyd.dynamic.getDynamicTemplate(this);
					var templates = [ { label: __('Bitte wählen', 'greyd_blocks'), value: '' } ];
					for (var i=0; i<greyd.data.all_templates.length; i++) {
						if (greyd.data.all_templates[i].blocks) continue;
						if (greyd.data.all_templates[i].type != 'dynamic_template') continue;
						if (greyd.data.post_id == greyd.data.all_templates[i].id) continue;
						templates.push( { label: greyd.data.all_templates[i].title, value: greyd.data.all_templates[i].slug } );
					}
				}
				var props = this.props;
				var state = this.state;

				return [
					el( 'div', { id: props.attributes.anchor, className: props.className },
						// placeholder todo
						el( serverSideRender, {
							block: 'greyd/posts',
							attributes: props.attributes,
							httpMethod: 'POST',
						} )
					),
					el( InspectorControls, {},
						el( PanelBody, { title: __('Allgemein', 'greyd_blocks'), initialOpen: true },
							// raw todo
							el( components.TextareaControl, {
								rows: 10,
								value: props.attributes.raw,
								onChange: function(value) { props.setAttributes( { raw: value } ); },
							} ),
							el( wp.components.SelectControl, {
								label: __('Layout der Beiträge', 'greyd_blocks'),
								value: props.attributes.post_setup_mode,
								options: [
									{ label: __('manuell', 'greyd_blocks'), value: 'manual' },
									{ label: __('Template verwenden', 'greyd_blocks'), value: 'template' },
								],
								onChange: function(value) { props.setAttributes( { post_setup_mode: value } ); },
							} ),
						),
						(props.attributes.post_setup_mode == 'template') ? 
						el( PanelBody, { title: __('Template', 'greyd_blocks'), initialOpen: true },
							el( components.SelectControl, {
								label: __('Template', 'greyd_blocks'),
								value: props.attributes.template,
								options: templates,
								onChange: function(value) { props.setAttributes( { template: value } ); },
							} ),
							greyd.dynamic.dynamicControls(props, state)
						) : 
						el( PanelBody, { title: __('Manueller Aufbau', 'greyd_blocks'), initialOpen: true },
							// raw todo (deprecated)
							el( components.TextareaControl, {
								rows: 20,
								value: props.attributes.post_setup,
								onChange: function(value) { props.setAttributes( { post_setup: value } ); },
							} ) 
						),
					),
				];
			}
		},
	} );

	// console.log(posttype);
	if (greyd.data.post_type == "dynamic_template") {
		
		if (greyd.data.template_type == "single") {
			
			blocks.registerBlockType( 'greyd/template-post', {
				title: __('Post Elemente', 'greyd_blocks'),
				description: __('Darstellung von Beitragselementen in „single“-Templates', 'greyd_blocks'),
				// icon: greyd.tools.getBlockIcon('query'),
				category: 'greyd-blocks',
				// parent: parent_blocks,
				
				edit: function( props ) {
					return [
						el( 'div', { id: props.attributes.anchor, className: props.className },
							el( serverSideRender, {
								block: 'greyd/template-post',
								attributes: props.attributes,
								httpMethod: 'POST',
							} )
						),
						el( InspectorControls, {},
							el( PanelBody, { title: __('RAW', 'greyd_blocks'), initialOpen: true },
								// raw todo
								el( 'pre', { }, 'Post Elemente\nsetup_mode: '+props.attributes.post_setup_mode ), 
								el( components.TextareaControl, {
									rows: 33,
									value: props.attributes.raw,
									onChange: function(value) { props.setAttributes( { raw: value } ); },
								} ),
							)
						),
					];
				},
			} );
		}
		else if (greyd.data.template_type == "archives" || greyd.data.template_type == "search") {

			blocks.registerBlockType( 'greyd/template-posts', {
				title: __('Gefundene Beiträge', 'greyd_blocks'),
				description: __('Übersicht gefundener Beiträge in „archive“- und „search“-Templates', 'greyd_blocks'),
				// icon: greyd.tools.getBlockIcon('query'),
				category: 'greyd-blocks',
				// parent: parent_blocks,

				edit: function( props ) {
					return [
						el( 'div', { id: props.attributes.anchor, className: props.className },
							el( serverSideRender, {
								block: 'greyd/template-posts',
								attributes: props.attributes,
								httpMethod: 'POST',
							} )
						),
						el( InspectorControls, {},
							el( PanelBody, { title: __('RAW', 'greyd_blocks'), initialOpen: true },
								// raw todo
								el( 'pre', { }, 'Gefundene Beiträge\nsetup_mode: '+props.attributes.post_setup_mode ), 
								el( components.TextareaControl, {
									rows: 33,
									value: props.attributes.raw,
									onChange: function(value) { props.setAttributes( { raw: value } ); },
								} ),
							)
						),
					];
				},
			} );

			blocks.registerBlockType( 'greyd/template-details', {
				title: __('Ergebnisdetails', 'greyd_blocks'),
				description: __('Darstellung von Filterkriterien in „archive“ und „search“-Templates', 'greyd_blocks'),
				// icon: greyd.tools.getBlockIcon('query'),
				category: 'greyd-blocks',
				// parent: parent_blocks,
				
				edit: function( props ) {
					return [
						el( 'div', { id: props.attributes.anchor, className: props.className },
							el( serverSideRender, {
								block: 'greyd/template-details',
								attributes: props.attributes,
								httpMethod: 'POST',
							} )
						),
						el( InspectorControls, {},
							el( PanelBody, { title: __('RAW', 'greyd_blocks'), initialOpen: true },
								// raw todo
								el( 'pre', { }, 'Ergebnisdetails' ), 
								el( components.TextareaControl, {
									rows: 33,
									value: props.attributes.raw,
									onChange: function(value) { props.setAttributes( { raw: value } ); },
								} ),
							)
						),
					];
				},
			} );
		}
	}

	blocks.registerBlockType( 'greyd/copyright', {
		title: __('Copyright', 'greyd_blocks'),
		description: __('Copyright mit Text, häufig im Footer', 'greyd_blocks'),
		// icon: el( 'img', { src: greyd.data.icon_url+"/copyright.svg" } ),
		category: 'greyd-blocks-wip',
		// parent: parent_blocks,
		
		edit: function( props ) {
			var atts = {
				layout: props.attributes.layout,
				text: props.attributes.text,
				img: props.attributes.img,
			}
			return [
				el( 'div', { id: props.attributes.anchor },
					el( serverSideRender, {
						block: 'greyd/copyright',
						attributes: atts,
						className: props.className,
					} ),
				),
				el( InspectorControls, {},
					el( PanelBody, { title: __('Allgemein', 'greyd_blocks'), initialOpen: true },
						el( components.SelectControl, {
							label: __('Layout', 'greyd_blocks'),
							value: props.attributes.layout,
							options: [
								{ label: __('Icon links, Text rechts', 'greyd_blocks'), value: "right" },
								{ label: __('Text links, Icon rechts', 'greyd_blocks'), value: 'left' },
								{ label: __('Text zentriert, kein Icon', 'greyd_blocks'), value: "center" },
								{ label: __('Icon zentriert, kein Text', 'greyd_blocks'), value: "center2" },
							],
							onChange: function(value) { props.setAttributes( { layout: value } ); },
						} ),
						el( components.TextControl, {
							label: __('Text', 'greyd_blocks'),
							help: __("Wenn du folgende Platzhalter eingibst, werden diese Informationen generiert: \n _c_: Copyright-Zeichen \n _year_: Jahreszahl \n _name_: Name der Homepage", 'greyd_blocks'),
							value: props.attributes.text,
							onChange: function(value) { props.setAttributes( { text: value } ); },
						} ),
						el( blockEditor.MediaUpload, {
							onSelect: function(value) { props.setAttributes( { img: value.id } ); },
							type: 'image',
							render: function(obj) {
								var el_choose = el( components.Button, {
									className: 'is-secondary',
									onClick: obj.open
								}, el( 'span', {}, __('Icon auswählen', 'greyd_blocks') ) );
								var el_trash = "";
								if (props.attributes.img != "")
									el_trash = el( components.Button, {
										icon: 'trash',
										className: 'is-destructive',
										onClick: function(value) { props.setAttributes( { img: '' } ) }
									} );
								return el( 'div', { className: "is-flex" }, 
									el_choose,
									el_trash
								);
							}
						}),
					)
				),
			];
		},
	} );
	
	blocks.registerBlockType( 'greyd/counter', {
		title: __('Counter', 'greyd_blocks'),
		description: __('Animierter Zähler für manuelle Werte oder Beiträge', 'greyd_blocks'),
		// icon: el( 'img', { src: greyd.data.icon_url+"/counter.svg" } ),
		category: 'greyd-blocks-wip',
		// parent: parent_blocks,
		
		edit: function( props ) {
			var atts = {
				type: props.attributes.type,
				manual: props.attributes.manual,
				posttype: props.attributes.posttype,
				content: props.attributes.content,
				anim_time: props.attributes.anim_time,
			}
			return [
				el( 'div', { id: props.attributes.anchor },
					el( serverSideRender, {
						block: 'greyd/counter',
						attributes: atts,
						className: props.className,
					} ),
				),
				el( InspectorControls, {},
					el( PanelBody, { title: __('Allgemein', 'greyd_blocks'), initialOpen: true },
						el( components.SelectControl, {
							label: __('Art', 'greyd_blocks'),
							value: props.attributes.type,
							options: [
								{ label: __('manuell', 'greyd_blocks'), value: "manual" },
								{ label: __('Anzahl bestimmter Beiträge', 'greyd_blocks'), value: "dynamic" },	// todo
								{ label: __('Anzahl gefundener Beiträge', 'greyd_blocks'), value: "found", disabled: true },	// todo
							],
							onChange: function(value) { props.setAttributes( { type: value } ); },
						} ),
						el( 'div', { className: (props.attributes.type != "manual") ? 'hidden' : "" },
							el( components.TextControl, {
								label: __('Wert', 'greyd_blocks'),
								help: __("Bitte nur Zahlen eingeben.", 'greyd_blocks'),
								value: props.attributes.manual,
								onChange: function(value) { props.setAttributes( { manual: value } ); },
							} ),
						),
						el( 'div', { className: (props.attributes.type != "dynamic") ? 'hidden' : "" },
							el( components.SelectControl, {
								label: __('Post Type', 'greyd_blocks'),
								value: props.attributes.posttype,
								options: [
									{ label: __('bitte wählen', 'greyd_blocks'), value: "" },
									{ label: __('Beiträge', 'greyd_blocks'), value: "post", disabled: true },	// todo
									{ label: __('Seiten', 'greyd_blocks'), value: "page", disabled: true },	// todo
								],
								onChange: function(value) { props.setAttributes( { posttype: value } ); },
							} ),
							// *_taxonomy todo
							// *_term todo
						),
						el( 'div', { className: (props.attributes.type != "found") ? 'hidden' : "" },
							// todo
						),
						el( components.TextareaControl, {
							label: __('Text', 'greyd_blocks'),
							help: __("Benutze den Platzhalter _count_, um den Wert einzufügen.", 'greyd_blocks'),
							value: props.attributes.content,
							onChange: function(value) { props.setAttributes( { content: value } ); },
						} ),
						el( components.TextControl, {
							label: __('Dauer der Animation', 'greyd_blocks'),
							help: __("In Sekunden. Frei lassen für keine Animation.", 'greyd_blocks'),
							value: props.attributes.anim_time,
							onChange: function(value) { props.setAttributes( { anim_time: value } ); },
						} ),
					)
				),
			];
		},
	} );

	blocks.registerBlockType( 'greyd/accord', {
		title: __('Akkordeon', 'greyd_blocks'),
		description: __('Zusammenklappbare Inhalte', 'greyd_blocks'),
		// icon: el( 'img', { src: greyd.data.icon_url+"/accordion.svg" } ),
		category: 'greyd-blocks-wip',
		// parent: parent_blocks,
		// child: [ 'greyd/accord-item' ],

		supports: {
			anchor: true,
			color: {
				background: true,
				gradients: true,
				text: false,
			},
			inserter: false,
		},
		attributes: {
			dynamic_parent: { type: 'string' }, // dynamic template backend helper
			dynamic_value: { type: 'string' }, // dynamic template frontend helper
			inline_css: { type: 'string' },
			inline_css_id: { type: 'string' },
			active_section: { type: 'string', default: "1" },
			autoplay: { type: 'string', default: "0" },
			collapsible_all: { type: 'boolean', default: false },
			spacing: { type: 'string', default: "" },
			gap: { type: 'string', default: "" },
			c_align: { type: 'string', default: "left" },
		},

		edit: function( props ) {
			return [
				el( 'div', { 
					id: props.attributes.anchor, 
					className: [props.className, "vc-accordion"].join(' ') 
				}, el( InnerBlocks, { allowedBlocks: [ 'greyd/accord-item' ] } ) ),
				el( InspectorControls, {},
					el( PanelBody, { title: __('Allgemein', 'greyd_blocks'), initialOpen: true },
						el( components.TextControl, {
							label: __('Akkordeon Bereich', 'greyd_blocks'),
							help: __( 'Welcher Abschnitt soll initial ausgeklappt sein? (Hinweis: Wenn alle Abschnitte beim ersten Laden geschlossen sein sollen, gib eine nicht vorhandene Nummer ein)', 'greyd_blocks' ),
							type: 'number',
							min: '0',
							value: props.attributes.active_section,
							onChange: function(value) { props.setAttributes( { active_section: value } ); },
						} ),
						el( components.RangeControl, {
							label: __('Autoplay', 'greyd_blocks'),
							help: __( 'Nach wie vielen Sekunden soll automatisch der nächste Abschnitt angezeigt werden? (Standard: aus)', 'greyd_blocks' ),
							value: props.attributes.autoplay,
							onChange: function(value) { props.setAttributes( { autoplay:  value } ); },
						} ),
						el( components.ToggleControl, {
							label: __('Alle schließen', 'greyd_blocks'),
							help: __( 'Erlaubt dem Nutzer, alle Bereiche einzuklappen.', 'greyd_blocks' ),
							checked: props.attributes.collapsible_all,
							onChange: function(value) { props.setAttributes( { collapsible_all: value } ); },
						} ),
						el( components.SelectControl, {
							label: __('Ausrichtung Titel', 'greyd_blocks'),
							value: props.attributes.c_align,
							options: [
								{ label: __('linksbündig', 'greyd_blocks'), value: 'left' },
								{ label: __('zentriert', 'greyd_blocks'), value: 'center' },
								{ label: __('rechtsbündig', 'greyd_blocks'), value: 'right' },
							],
							onChange: function(value) { props.setAttributes( { c_align: value } ); },
						} ),
						el( components.__experimentalUnitControl, {
							label: __('Abstand unter dem Titel', 'greyd_blocks'),
							labelPosition: 'edge',
							className: 'is-edge-layout',
							value: props.attributes.spacing,
							onChange: function(value) { props.setAttributes( { spacing: value } ); },
						} ),
						el( components.__experimentalUnitControl, {
							label: __('Abstand unter dem Inhalt', 'greyd_blocks'),
							labelPosition: 'edge',
							className: 'is-edge-layout',
							value: props.attributes.gap,
							onChange: function(value) { props.setAttributes( { gap: value } ); },
						} ),
					),
				),
			];
		},
		save: function( props ) {
			return el( 'div', { 
				id: props.attributes.anchor, 
				className: [props.className, "vc-accordion"].join(' ') 
			}, el( InnerBlocks ) );
		}
	} );
	blocks.registerBlockType( 'greyd/accord-item', {
		title: __('Inhaltsbereich', 'greyd_blocks'),
		// icon: el( 'img', { src: greyd.data.icon_url+"/accordion.svg" } ),
		category: 'greyd-blocks-wip',
		parent: [ 'greyd/accord' ],
		
		supports: {
			anchor: true,
			inserter: false,
		},
		attributes: {
			dynamic_parent: { type: 'string' }, // dynamic template backend helper
			dynamic_value: { type: 'string' }, // dynamic template frontend helper
			inline_css: { type: 'string' },
			inline_css_id: { type: 'string' },
			title: { type: 'string', default: __('Inhaltsbereich', 'greyd_blocks') },
		},

		edit: function( props ) {
			return [
				el( 'div', { className: [props.className, "vc-accordion-item"].join(' ') },
					el( 'pre', { className: "vc-accordion-headline" },
						props.attributes.title
					), 
					el( InnerBlocks )
				),
				el( InspectorControls, {},
					el( PanelBody, { title: __('Allgemein', 'greyd_blocks'), initialOpen: true },
						el( components.TextControl, {
							label: __('Titel', 'greyd_blocks'),
							value: props.attributes.title,
							onChange: function(value) { props.setAttributes( { title: value } ); },
						} )
					)
				),
			];
		},
		save: function( props ) {
			return el( 'div', { className: [props.className, "vc-accordion-item"].join(' ') },
				el( InnerBlocks.Content )
			);
		}
	} );


} )( 
	window.wp.blocks, 
	window.wp.element, 
	window.wp.blockEditor, 
	window.wp.components, 
	window.wp.serverSideRender, 
	window.wp.i18n, 
	window.wp.coreData, 
);

