<?php
/**
 * Register old function calls.
 * 
 * @deprecated since 1.4.4
 * 
 * Those functions will be removed in future versions.
 */
namespace greyd\blocks\deprecated;

if( ! defined( 'ABSPATH' ) ) exit;

new Functions( $config );
class Functions {

	public $config;

	public function __construct( $config ) {

		// set config
		$this->config = (object)$config;

		add_action( 'admin_init', array( $this, 'maybe_update_hub_plugin' ) );
	}

	/**
	 * Update Hub plugin if below Version 1.5.0 to ensure compatiblity.
	 */
	public function maybe_update_hub_plugin() {
		$plugin_slug      = 'greyd_tp_management';
		$plugin_file      = $plugin_slug.'/init.php';
		$plugin_zip       = 'https://update.greyd.io/public/plugins/greyd_hub/versions/greyd_tp_management_146.zip';
		$required_version = $this->config->required_versions['greyd_hub'];

		if( ! function_exists( 'get_plugin_data' ) ) {
			require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
		}
		$plugin_data = get_plugin_data( WP_PLUGIN_DIR . '/'.$plugin_file );

		if ( !$plugin_data || !isset( $plugin_data['Version'] ) ) return;

		$current_version = esc_attr($plugin_data['Version']);

		$needs_update = version_compare( $required_version, $current_version, '>' );

		if ( ! $needs_update ) return;

		// update the plugin
		if ( !class_exists('Plugin_Upgrader', false) ) {
			require_once ABSPATH.'wp-admin/includes/class-wp-upgrader.php';
		}
		ob_start();
		wp_cache_flush();
		$upgrader = new \Plugin_Upgrader();
		$result = $upgrader->upgrade( $plugin_file );
		ob_end_clean();
	}

	/**
	 * @see \Greyd\Dynamic\Render_Blocks::get_dynamic_url
	 */
	public static function get_dynamic_url($dtag, $block=null, $wp_post=null) {

		/**
		 * Call the new function.
		 */
		if ( method_exists( '\Greyd\Dynamic\Render_Blocks', 'get_dynamic_url' ) ) {
			return \Greyd\Dynamic\Render_Blocks::get_dynamic_url($dtag, $block, $wp_post);
		}


		$post = $wp_post ? (object) $wp_post : get_post();
		$url = '';
	
		if ($dtag == 'home') {
			$url = get_bloginfo('url');
		}
		else if ($dtag == 'site-logo') {
			$pid = get_theme_mod( 'custom_logo', -1 );
			if ($pid != -1) $url = wp_get_attachment_image_src( $pid , 'full' )[0];
		}
		else if ($dtag == 'post') {
			$url = method_exists('\vc\helper', 'get_post_permalink_encoded') ? \vc\helper::get_post_permalink($post) : ( isset($post->permalink) ? $post->permalink : get_the_permalink($post) );
			$url = self::filter_url( $url );
		}
		else if ($dtag == 'image') {
			$url = method_exists('\vc\helper', 'get_the_post_thumbnail_url') ? \vc\helper::get_the_post_thumbnail_url($post) : ( isset($post->image) ? $post->image : get_the_post_thumbnail_url($post) );
		}
		else if ($dtag == 'author') {
			$url = \vc\helper::make_authorlink_string($post->post_author);
		}
		// else if ($dtag == 'email') $url = 'mailto:'.get_the_author_meta('user_email', $post->post_author);
		else if ($dtag == 'post-next') {
			$url = get_permalink(get_adjacent_post(false, '', false)->ID);
			$url = $url;
		}
		else if ($dtag == 'post-previous') {
			$url = get_permalink(get_adjacent_post(false, '', true)->ID);
			$url = $url;
		}
		else if ($dtag == 'woo_ajax') {
			if ( isset($block["attrs"]["trigger"]["params"])) {
				$params = $block["attrs"]["trigger"]["params"];
				$redirects = isset($params['redirects']) ? $params['redirects'] : "default";
				$not_twice = isset($params['notTwice']) && $params['notTwice'] == true ? "1" : "0";
				$clear	   = isset($params['clear']) && $params['clear'] == true ? "1" : "0";
				$ajax_params =  "|".$redirects."|".$not_twice."|".$clear;
			}
			
			$url = method_exists('\vc\helper', 'make_ajax_link') ? \vc\helper::make_ajax_link( $post, $ajax_params ) : "_woo_ajax={$post->ID}{$atts}_";
		}
		else {
			// loop/archives
			if ( $block && is_array($block) && isset($block['attrs']) && 
				isset($block['attrs']['queryTags']) && isset($block['attrs']['queryTags'][$dtag]) ) {
				// debug($block);
				// 'page-next'
				// 'page-previous'
				if (isset($block['attrs']['queryTags'][$dtag]) && $block['attrs']['queryTags'][$dtag] != '') {
					// $url = 'window.open(("'.$block['attrs']['queryTags'][$dtag].'").split("&#038;").join("&"), "'.$target.'");';
					$url = implode("&", explode("&#038;", $block['attrs']['queryTags'][$dtag]));
				}
			}
			else {
				// dpt
				// debug($dtag);
				$dtags = method_exists('\vc\helper', 'get_dynamic_posttype_tags') ? \vc\helper::get_dynamic_posttype_tags($post) : array();
				if (isset($dtags[$dtag])) {
					if (isset($dtags[$dtag.'-link'])) $dtag .= '-link';
					$url = implode("&", explode("&#038;", urldecode($dtags[$dtag])));
				}

				// $ddtag = explode('-', $dtag, 2);
				// if (count($ddtag) == 2) {
				// 	$ddtag = $ddtag[1];
				// 	$dtags = \vc\helper::get_dynamic_posttype_tags($post);
				// 	// debug($dtags);
				// 	if (isset($dtags[$ddtag])) {
				// 		if (isset($dtags[$ddtag.'-link'])) $ddtag .= '-link';
				// 		// $url = 'window.open(("'.urldecode($dtags[$ddtag]).'").split("&#038;").join("&"), "'.$target.'");';
				// 		$url = implode("&", explode("&#038;", urldecode($dtags[$ddtag])));
				// 	}
				// }
			}
		}
		return $url;
	}

	/**
	 * @see \Greyd\Helper::filter_url
	 */
	public static function filter_url( $url ) {

		/**
		 * Call the new function.
		 */
		if ( method_exists( '\Greyd\Helper', 'filter_url' ) ) {
			return \Greyd\Helper::filter_url( $url );
		}
		
		/**
		 * WPML: filter Post ID and look for tranlated version.
		 * @see https://wpml.org/wpml-hook/wpml_object_id/
		 */
		$filtered_url = apply_filters( 'wpml_permalink', $url, self::get_language_code() );
		if ( $filtered_url && $filtered_url != $url && $filtered_url != trailingslashit($url) ) {
			$url = $filtered_url;
		}

		$post_id = apply_filters( 'greyd_filter_url', $url );

		return strval( $url );
	}

	/**
	 * @see \Greyd\Dynamic\Render_Blocks::match_dynamic_tags
	 */
	public static function match_dynamic_tags( $block, $block_content, $wp_post=null ) {

		/**
		 * Call the new function.
		 */
		if ( method_exists( '\Greyd\Dynamic\Render_Blocks', 'match_dynamic_tags' ) ) {
			return \Greyd\Dynamic\Render_Blocks::match_dynamic_tags( $block, $block_content, $wp_post );
		}

		if (strpos($_SERVER['REQUEST_URI'], "/wp-json/wp/v2") === false) {
			preg_match_all('/(?<=<span data-tag=")([^"]+)(?=")/', $block_content, $dtags);
			if (isset($dtags[0]) && count($dtags[0]) > 0) {
				// debug($dtags);
				for ($i=0; $i<count($dtags[0]); $i++) {
					$dtag= $dtags[0][$i];
					preg_match_all('/(?<=<span data-tag="'.$dtag.'" data-params=")([^"]*)(?>" class="is-tag">)([^<]*)(?=<\/span>)/', $block_content, $dcontent);
					// debug($dcontent);
					if (count($dcontent[0]) > 0) {
						for ($j=0; $j<count($dcontent[0]); $j++) {
							$old = '<span data-tag="'.$dtag.'" data-params="'.$dcontent[1][$j].'" class="is-tag">'.$dcontent[2][$j].'</span>';
							$new = self::render_dynamic_tag($block, $dtag, $dcontent[1][$j], $wp_post);
							// debug(htmlspecialchars($block_content));
							$block_content = str_replace($old, $new, $block_content);
							$block_content = str_replace(array('<p><p>', '</p></p>'), array('<p>', '</p>'), $block_content);
						}
					}
				}
			}
			else if (json_decode($block_content)) {
				$data = json_decode($block_content);
				if (is_object($data) && isset($data->type) && $data->type == "dynamic") {
					if (isset($data->tag)) {
						// debug("dynamic image found");
						$url = self::get_dynamic_url($data->tag, null, $wp_post);
						$data->type = "image";
						$data->url = $url;
						$data->tag = "";
						$data->id = -1;
						$block_content = json_encode($data);
					}
					if (isset($data->params)) {
						// debug("dynamic trigger found");
						if (!$data->params->tag == "woo_ajax") {
							$url = self::get_dynamic_url($data->params->tag, null, $wp_post);
							$data->type = "link";
							$data->params->url = $url;
							$data->params->tag = "";
						}
						$block_content = json_encode($data);
					}
				}
			}
		}
		return $block_content;
	}

	/**
	 * unused outside this class
	 */
	public static function render_dynamic_tag( $block, $dtag, $params, $wp_post=null ) {
		$new = "";
		$params = json_decode(stripslashes(html_entity_decode($params)), true);
		// debug($params);

		// website dtags or global search
		if (strpos($dtag, 'site-') === 0) {

			// if ( isset($wp_post) ) debug( $wp_post );

			if ($dtag == 'site-title') {
				$new = method_exists('\vc\helper', 'get_site_title') ? \vc\helper::get_site_title( empty($wp_post) ? get_post() : $wp_post ) : get_bloginfo('name');
			}
			else if ($dtag == 'site-url') {
				$new = method_exists('\vc\helper', 'get_site_url') ? \vc\helper::get_site_url( empty($wp_post) ? get_post() : $wp_post ) : get_site_url();
			}
			else if ($dtag == 'site-sub') {
				$new = get_bloginfo('description');
			}

			// make them a link
			if ($new != "" && isset($params['isLink']) && $params['isLink']) {
				$class  = isset($params['linkStyle']) && $params['linkStyle'] != '' ? 'class="'.$params['linkStyle'].'"' : '';
				$href   = method_exists('\vc\helper', 'get_site_url') ? \vc\helper::get_site_url( $wp_post ) : get_site_url();
				$target = isset($params['blank']) && $params['blank'] ? 'target="_blank"' : '';
				$new    = '<a '.$class.' href="'.$href.'" '.$target.' rel="home">'.$new.'</a>';
			}

			if ($dtag == 'site-logo') {
				$pid = get_theme_mod( 'custom_logo', -1 );
				if ($pid != -1) {
					$psrc = wp_get_attachment_image_src( $pid , 'full' )[0];
					$ptitle = get_the_title($pid);
					$pwidth = isset($params['width']) && $params['width'] != '' ? 'style="width:'.$params['width'].'"' : '';
					$palt = method_exists('\vc\helper', 'get_attachment_text') ? \vc\helper::get_attachment_text($pid) : "";
					$new = '<img loading="lazy" class="wp-image-'.$pid.'" '.$pwidth.' src="'.$psrc.'" title="'.$ptitle.'" alt="'.$palt.'" >';
					if (isset($params['isLink']) && $params['isLink']) {
						$href = get_bloginfo('url');
						$target = isset($params['blank']) && $params['blank'] ? 'target="_blank"' : '';
						$new = '<a href="'.$href.'" '.$target.' rel="home">'.$new.'</a>';
					}
				}
			}
			// ...
		}

		// basic dtags
		else {
			if ($dtag == 'now') {
				$prms = $dtag;
				if (isset($params['format'])) $prms .= '|'.$params['format'];
				$new = method_exists('\vc\helper', 'make_date_string') ? \vc\helper::make_date_string( (object)array( 'post_date' => date('Y-m-d H:i:s') ), $prms) : mysql2date( get_option('date_format'), date('Y-m-d H:i:s'));
			}
			else if ($dtag == 'symbol') {
				if (isset($params['symbol'])) {
					if ($params['symbol'] == 'copyright')   $new = "©";
					if ($params['symbol'] == 'arrow-up')    $new = "↑";
					if ($params['symbol'] == 'arrow-down')  $new = "↓";
					if ($params['symbol'] == 'arrow-left')  $new = "←";
					if ($params['symbol'] == 'arrow-right') $new = "→";
					// ...
				}
			}
			else if ($dtag == 'count') {
				if (isset($params['format'])) {
					if ($params['format'] == 'posttype' && isset($params['posttype'])) {
						$posttype = isset($params['posttype']) ? esc_attr($params['posttype']) : "";
						if (!empty($posttype) && post_type_exists($posttype)) {
							$new = wp_count_posts($posttype)->publish;
							if (isset($params['taxonomy'])) {
								$taxonomy = esc_attr($params['taxonomy']);
								if ( !empty($taxonomy) && taxonomy_exists($taxonomy) ) {
									$new  = "0";
									$term   = isset($params['term']) ? esc_attr($params['term']) : "";
									if ( !empty($term) ) {
										$wp_term = get_term($term);
										if (!is_wp_error($wp_term) && !empty($wp_term)) $new = $wp_term->count;
									}
								}
							}
						}
					}
					// ...
				}
			}
			else {
				// classic dtags
				$post = empty($wp_post) ? get_post() : $wp_post;
				// debug($post->ID);
				// $params = $dtag;
				if ($dtag == 'post-type') {
					$new = get_post_type_object($post->post_type)->labels->singular_name;
				}
				else if ($dtag == 'title') {
					$new = method_exists('\Greyd\Dynamic\Dynamic_Helper', 'get_the_title') ? \Greyd\Dynamic\Dynamic_Helper::get_the_title($post) : get_the_title($post);
					if (isset($params['isLink']) && $params['isLink']) {
						$class = isset($params['linkStyle']) && $params['linkStyle'] != '' ? 'class="'.$params['linkStyle'].'"' : '';
						$href = get_the_permalink($post);
						$target = isset($params['blank']) && $params['blank'] ? 'target="_blank"' : '';
						$new = '<a '.$class.' href="'.$href.'" '.$target.' rel="home">'.$new.'</a>';
					}
				}
				else if ($dtag == 'author') {
					$new = get_the_author_meta('display_name', $post->post_author);
					if (isset($params['format']) && $params['format'] != '') {
						if ($params['format'] == 'avatar') {
							$width = isset($params['width']) ? intval($params['width']) : 24;
							$new = get_avatar(get_the_author_meta('ID', $post->post_author), $width);
						}
						else $new = get_the_author_meta($params['format'], $post->post_author);
					}
					if (isset($params['isLink']) && $params['isLink']) {
						$email = get_the_author_meta('user_email', $post->post_author);
						$url = get_author_posts_url($post->post_author);
						$class = isset($params['linkStyle']) && $params['linkStyle'] != '' ? 'class="'.$params['linkStyle'].'"' : '';
						$href = $params['format'] == 'user_email' ? 'mailto:'.$email : $url;
						$target = isset($params['blank']) && $params['blank'] ? 'target="_blank"' : '';
						$new = '<a '.$class.' href="'.$href.'" '.$target.'>'.$new.'</a>';
					}
					// debug(htmlspecialchars($old));
					// debug(htmlspecialchars($new));
				}
				else if ($dtag == 'image') {
					$pid = get_post_thumbnail_id($post);
					$psrc = get_the_post_thumbnail_url($post);
					$ptitle = get_the_title($pid);
					$pwidth = isset($params['width']) && $params['width'] != '' ? 'style="width:'.$params['width'].'"' : '';
					$palt = method_exists('\vc\helper', 'get_attachment_text') ? \vc\helper::get_attachment_text($pid) : "";
					$new = '<img loading="lazy" class="wp-image-'.$pid.'" '.$pwidth.' src="'.$psrc.'" title="'.$ptitle.'" alt="'.$palt.'" >';
					if (isset($params['isLink']) && $params['isLink']) {
						$href = get_the_permalink($post);
						$target = isset($params['blank']) && $params['blank'] ? 'target="_blank"' : '';
						$new = '<a href="'.$href.'" '.$target.'>'.$new.'</a>';
					}
				}
				else if ($dtag == 'date') {
					$prms = $dtag;
					if (isset($params['format'])) $prms .= '|'.$params['format'];
					$new = method_exists('\vc\helper', 'make_date_string') ? \vc\helper::make_date_string($post, $prms) : mysql2date( get_option('date_format'), $post->post_date);
				}
				else if ($dtag == 'content') {
					/**
					 * Don't parse the content when in a REST request.
					 * 
					 * This could lead to an error on where single-templates cannot be
					 * safed because the wp-block-parser is running into a max execution
					 * timeout.
					 * 
					 * @since 1.1.2
					 */
					// we need the wp-block-parser for live query requests
					$is_livequery_request = isset($_REQUEST['rest_route']) && $_REQUEST['rest_route'] === "/greyd/v1/livequery";
					$is_rest_request      = method_exists( '\Greyd\Helper', 'is_rest_request' ) ? \Greyd\Helper::is_rest_request() : (defined('REST_REQUEST') && REST_REQUEST);

					if ( !$is_rest_request || $is_livequery_request ) {
						$prms = $dtag;
						if (isset($params['count'])) $prms .= '|'.$params['count'];
						$new = method_exists('\vc\helper', 'make_content_string') ? \vc\helper::make_content_string($post, $prms) : get_the_content($post);
					}
				}
				else if ($dtag == 'categories' || $dtag == 'tags') {
					$prms = $dtag;
					if (isset($params['format'])) $prms .= '|'.$params['format'];
					else $prms .= '|';
					if (isset($params['isLink']) && $params['isLink']) $prms .= '|1';
					if ($dtag == 'categories') {
						$new = method_exists('\vc\helper', 'make_categories_string') ? \vc\helper::make_categories_string($post, $prms) : '';
					}
					if ($dtag == 'tags') {
						$new = method_exists('\vc\helper', 'make_tags_string') ? \vc\helper::make_tags_string($post, $prms) : '';
					}
				}
				else if ($dtag == 'archive-title') {
					$new = get_the_archive_title();
					$prms = $dtag;
					if ( isset($params['hidePrefix']) && $params['hidePrefix'] && strpos($new, ":") !== false ) {
						$new = trim( explode(":", $new, 2)[1] );
					}
				}
				else if ($dtag == 'excerpt') {
					$strip_tags = isset($params['dontStripTags']) && $params['dontStripTags'] ? false : true;
					$new = method_exists('\Greyd\Dynamic\Dynamic_Helper', 'get_the_excerpt') ? \Greyd\Dynamic\Dynamic_Helper::get_the_excerpt($post, $strip_tags) : get_the_excerpt($post);
				}
				// advanced search
				else if ($dtag == 'post-views') {
					$new = method_exists('\vc\helper', 'get_post_views') ? \vc\helper::get_post_views($post) : "";
				}
				// woo
				else if ($dtag == 'price' ) {
					$new = method_exists('\Greyd\Dynamic\Dynamic_Helper', 'get_woo_price') ? \Greyd\Dynamic\Dynamic_Helper::get_woo_price($post, $params) : "";
				}
				else if ($dtag == 'sale-badge') {
					$new = method_exists('\Greyd\Dynamic\Dynamic_Helper', 'get_woo_sale_flash') ? \Greyd\Dynamic\Dynamic_Helper::get_woo_sale_flash($post, $params) : "";
				}
				else if ($dtag == 'vat' ) {
					$new = method_exists('\vc\helper', 'make_woo_vat') ? \vc\helper::make_woo_vat($post, "") : "";
				}
				else if ($dtag == 'cart_excerpt' ) {
					if ( is_plugin_active('woocommerce-germanized/woocommerce-germanized.php') ) {
						$new = method_exists('\vc\helper', 'make_woo_cart_excerpt') ? \vc\helper::make_woo_cart_excerpt($post, "") : "";
					}
				}
				/**
				 * Custom WooCommerce Germanized dynamic tags.
				 * 
				 * @since 1.1.2
				 */
				else if ( strpos($dtag, "gzd_") === 0 || strpos($dtag, "gzd-") === 0 ) {
					if ( is_plugin_active('woocommerce-germanized/woocommerce-germanized.php') ) {

						$shortcode_tag = str_replace('-', '_', $dtag);

						/**
						 * Render germanized shortcodes.
						 * @see https://vendidero.de/dokument/preisauszeichnungen-anpassen
						 */
						$new = trim( do_shortcode( "[$shortcode_tag  product=\"{$post->ID}\"]" ) );

						/**
						 * Convert <p> tags into <span> tags to enable inline embedding
						 * into headlines, paragraphs...
						 */
						if ( !empty( $new ) && substr( $new, 0, 2 ) == "<p" && substr( $new, -2 ) == "p>" ) {
							$new = "<span" . substr( substr( $new, 0, -2 ), 2 ) . "span>";
						}
					}
				}
 				else {
					// debug($block['attrs']);
					// loop/archives
					if (isset($block['attrs']['queryTags']) && isset($block['attrs']['queryTags'][$dtag])) {
						// debug($block);
						// 'category'
						// 'tag'
						// 'post-count'
						// 'posts-per-page'
						// 'page-num'
						// 'page-count'
						// search
						// 'query'
						// 'filter'
						$new = $block['attrs']['queryTags'][$dtag];
					}
					else {
						// dpt
						// debug($dtag);
						$dtags = method_exists('\vc\helper', 'get_dynamic_posttype_tags') ? \vc\helper::get_dynamic_posttype_tags($post) : array();
						if (isset($dtags[$dtag])) {
							if (strpos($dtag, 'customtax') === 0) {
								// custom tax
								$prms = $dtag;
								if (isset($params['format'])) $prms .= '|'.$params['format'];
								if (isset($params['isLink']) && $params['isLink']) $prms .= '|1';
								$new = call_user_func( $dtags[$dtag], $post, $prms, $dtag );
							}
							else {
								// custom field
								$pid = $dtags[$dtag];
								if (intval($pid) == $pid && isset($dtags[$dtag.'-link'])) {
									// image
									$psrc = urldecode($dtags[$dtag.'-link']);
									$ptitle = get_the_title($pid);
									$palt = method_exists('\vc\helper', 'get_attachment_text') ? \vc\helper::get_attachment_text($pid) : "";
									$new = '<img loading="lazy" class="wp-image-'.$pid.'" src="'.$psrc.'" title="'.$ptitle.'" alt="'.$palt.'" >';
								}
								else {
									$new         = $dtags[$dtag];
									$new_decoded = html_entity_decode( $new );
									$new         = $new === strip_tags( $new_decoded ) ? $new : $new_decoded;
								}
							}
						}
						else {
							$qtags = self::get_query_tags( [ 'query' => [ 'inherit' => true ] ] );
							if ( isset( $qtags[$dtag] ) ) {
								$new = $qtags[$dtag];
							}
						}

						// $ddtag = explode('-', $dtag, 2);
						// if (count($ddtag) == 2) {
						// 	$dtags = \vc\helper::get_dynamic_posttype_tags($post);
						// 	// debug($dtags);
						// 	if ($ddtag[0] == 'customtax') {
						// 		if (isset($dtags[$dtag])) {
						// 			// custom tax
						// 			$prms = $dtag;
						// 			if (isset($params['format'])) $prms .= '|'.$params['format'];
						// 			if (isset($params['isLink']) && $params['isLink']) $prms .= '|1';
						// 			$new = call_user_func( $dtags[$dtag], $post, $prms, $dtag );
						// 		}
						// 	}
						// 	else {
						// 		$ddtag = $ddtag[1];
						// 		if (isset($dtags[$ddtag])) {
						// 			$pid = $dtags[$ddtag];
						// 			if (intval($pid) == $pid && isset($dtags[$ddtag.'-link'])) {
						// 				// image
						// 				$psrc = urldecode($dtags[$ddtag.'-link']);
						// 				$ptitle = get_the_title($pid);
						// 				$new = '<img loading="lazy" class="wp-image-'.$pid.'" src="'.$psrc.'" title="'.$ptitle.'" alt="" >';
						// 			}
						// 			else $new = urldecode($dtags[$ddtag]);
						// 		}
						// 	}
						// }
					}
				}
				// else {
				// 	global $wp_query;
				// 	debug($wp_query);
				// }

			}
		}
		return $new;
	}

	/**
	 * unused outside this class
	 */
	public static $query_tags = array();

	/**
	 * unused outside this class
	 */
	public static function get_query_tags($atts) {
		// debug($atts);

		// // get the query ID
		// if ( isset( $atts['query']['inherit'] ) && $atts['query']['inherit'] != false ) {
		// 	// inherit the main query
		// 	$queryId = -1;
		// }
		// else if ( isset( $atts['queryId'] ) ) {
		// 	// this is a custom query
		// 	$queryId = intval( $atts['queryId'] );
		// }
		// else {
		// 	// this is an undefined query
		// 	$last_queryId = array_key_last(self::$query_tags);
		// 	$queryId =  $last_queryId === null ? 0 : ( intval( $last_queryId ) + 1 );
		// }

		// // return cached query tags
		// if ( isset(self::$query_tags[ $queryId ]) ) {
		// 	return self::$query_tags[ $queryId ];
		// }

		// get hash
		$hash_key = md5(json_encode($atts));

		// return cached query tags
		if ( isset(self::$query_tags[ $hash_key ]) ) {
			return self::$query_tags[ $hash_key ];
		}

		$page_key = isset($atts['queryId']) ? 'query-'.$atts['queryId'].'-page' : 'query-page';
		$page     = empty($_GET[$page_key]) ? 1 : (int) $_GET[$page_key];
	
		$query_args = method_exists('\Greyd\Dynamic\Dynamic_Helper', 'build_query') ? \Greyd\Dynamic\Dynamic_Helper::build_query($atts, $page) : array();
		// Override the custom query with the global query if needed.
		$use_global_query = (isset($atts['query']['inherit']) && $atts['query']['inherit'] != false);
		if ($use_global_query) {
			global $wp_query;
			if ($wp_query && isset($wp_query->query_vars) && is_array($wp_query->query_vars)) {
				// Unset `offset` because if is set, $wp_query overrides/ignores the paged parameter and breaks pagination.
				unset($query_args['offset']);
				$query_args = wp_parse_args($wp_query->query_vars, $query_args);
	
				if (empty($query_args['post_type']) && is_singular()) {
					$query_args['post_type'] = get_post_type(get_the_ID());
				}
				$page = isset($query_args['paged']) && $query_args['paged'] != "0" ? $query_args['paged'] : "1";
				// debug($query_args);
				$props = array(
					'current' => 1,
					'previous_link' => '',
					'next_link' => '',
					'pages' => array()
				);
				$pagination_array = paginate_links( array(
					'prev_text' => 'x',
					'next_text' => 'x',
					'type' => 'array',
					'current' => $page
				) );
				// debug($pagination_array);
				
				if ($pagination_array) {
	
					foreach ($pagination_array as $link) {
						// debug( htmlspecialchars($link) );
						// <span aria-current="page" class="page-numbers current">2</span>
		
						// get href
						$href = "";
						preg_match( '/href="([^"])+?"/', $link, $matches );
						if ( $matches && count($matches) ) {
							$href = str_replace( array('href="', '"'), "", $matches[0] );
						}
		
						// prev
						if (strpos($link, 'prev')) {
							$props['previous_link'] = $href;
						}
		
						// next
						else if (strpos($link, 'next')) {
							$props['next_link'] = $href;
						}
		
						// page numbers
						else {
							// get page number (either a number or the filler "…")
							$num = null;
							preg_match( '/>([^<])+?</', $link, $matches );
							if ( $matches && count($matches) ) {
								$num = str_replace( array('>', '<'), "", $matches[0] );
							}
		
							// current page
							if (strpos($link, 'current')) {
								$props['current'] = $num;
								$href = "";
							}
							
							if ( isset($props['pages'][$num]) ) $num = "&#8230;"; // filler "…" could be set twice on long paginations
		
							$props['pages'][$num] = $href;
						}
					}
				}
				// debug($props);


			}
		}
	
		$query = new \WP_Query($query_args);
		// debug($query);
		$max_page = ($query->max_num_pages > 0) ? $query->max_num_pages : 1;
		// if (!$use_global_query && isset($atts['query']['pages'])) {
		// 	if ($atts['query']['pages'] > 0 && $atts['query']['pages'] < $max_page) {
		// 		$max_page = $atts['query']['pages'];
		// 	}
		// }

		$max_post = $query->query_vars['posts_per_page'] * $max_page;
		$tags = array(
			'query'         => "<span class='query--search-query'>".get_search_query()."</span>",
			'filter'        => method_exists('\vc\helper', 'make_filter_string') ? \vc\helper::make_filter_string($query, null) : "",
			'post-type'     => method_exists('\vc\helper', 'make_posttype_string') ? \vc\helper::make_posttype_string($query, null) : "",
			'category'      => method_exists('\vc\helper', 'make_category_string') ? \vc\helper::make_category_string($query, null) : "",
			'tag'           => method_exists('\vc\helper', 'make_tag_string') ? \vc\helper::make_tag_string($query, null) : "",
			// 'post-count'    => $max_post, // $query->found_posts*$max_page,
			'post-count'    => "<span class='query--found-posts'>".$query->found_posts."</span>",
			'posts-per-page'=> $query->query_vars['posts_per_page'],
			'page-count'    => $max_page,
		);
		if ($use_global_query) $tags = array_merge($tags, array(
			'page-num'      => $props['current'],
			'page-next'		=> esc_url($props['next_link']),
			'page-previous' => esc_url($props['previous_link']),
			'page-key' 		=> '',
			'page-keys' 	=> $props['pages'],
		));
		else $tags = array_merge($tags, array(
			'page-num'      => $page,
			'page-next'		=> '',
			'page-previous' => '',
			'page-key' 		=> '',
		));
		// debug($tags);
		wp_reset_postdata();

		// set cached query tags
		// self::$query_tags[ $queryId ] = $tags;
		self::$query_tags[ $hash_key ] = $tags;
	
		return $tags;
	}

	/**
	 * unused outside this class
	 */
	static function build_query($atts, $page) {
		$query = array(
			'post_type'    => 'post',
			'order'        => 'DESC',
			'orderby'      => 'date',
			'post__not_in' => array(),
			'post_status'       => 'publish',
			'suppress_filters'  => false,
		);

		if (isset($atts['query'])) {
			if (!empty($atts['query']['postType'])) {
				$post_type_param = $atts['query']['postType'];
				if (is_post_type_viewable($post_type_param)) {
					$query['post_type'] = $post_type_param;
				}
			}
			if (isset($atts['query']['sticky']) && !empty($atts['query']['sticky'])) {
				$sticky = get_option('sticky_posts');
				if ('only' === $atts['query']['sticky']) {
					$query['post__in'] = $sticky;
				} 
				else {
					$query['post__not_in'] = array_merge($query['post__not_in'], $sticky);
				}
			}
			if (!empty($atts['query']['exclude'])) {
				$excluded_post_ids = array_map('intval', $atts['query']['exclude']);
				$excluded_post_ids = array_filter($excluded_post_ids);
				$query['post__not_in'] = array_merge($query['post__not_in'], $excluded_post_ids);
			}
			if (isset($atts['query']['perPage']) &&
				is_numeric($atts['query']['perPage'])) {
				$per_page = absint($atts['query']['perPage']);
				$offset = 0;
				if (isset($atts['query']['offset']) &&
					is_numeric($atts['query']['offset'])) {
					$offset = absint($atts['query']['offset']);
				}
				$query['offset'] = ($per_page * ($page - 1)) + $offset;
				$query['posts_per_page'] = $per_page;
			}
			/**
			 * @deprecated WordPress 5.9
			 */
			if (!empty($atts['query']['categoryIds'])) {
				$term_ids = array_map('intval', $atts['query']['categoryIds']);
				$term_ids = array_filter($term_ids);
				$query['category__in'] = $term_ids;
			}
			if (!empty($atts['query']['tagIds'])) {
				$term_ids = array_map('intval', $atts['query']['tagIds']);
				$term_ids = array_filter($term_ids);
				$query['tag__in'] = $term_ids;
			}
			if (isset($atts['query']['order']) &&
				in_array(strtoupper($atts['query']['order']), array('ASC', 'DESC'), true)) {
				$query['order'] = strtoupper($atts['query']['order']);
			}
			if (isset($atts['query']['orderBy'])) {
				$query['orderby'] = $atts['query']['orderBy'];
			}
			if (isset($atts['query']['author']) &&
				(int) $atts['query']['author'] > 0) {
				$query['author'] = (int) $atts['query']['author'];
			}
			if (!empty($atts['query']['search'])) {
				$query['s'] = $atts['query']['search'];
			}
			/**
			 * @since WordPress 5.9
			 */
			if ( isset($atts['query']['taxQuery']) && !empty($atts['query']['taxQuery']) ) {
				$query['tax_query'] = array();
				foreach( $atts['query']['taxQuery'] as $taxonomy => $term_ids ) {
					if ( !empty($term_ids) ) {
						array_push( $query['tax_query'], array_merge(
								array(
									'taxonomy' => $taxonomy,
									'terms'    => $term_ids
								),
								count($term_ids) > 1 ? array(
									/**
									 * @filter greyd_query_filter_tax_query_term_relationship
									 * 
									 * @since 1.3.2
									 * 
									 * @param string $operator  Operator for term filters. Default: 'IN'.
									 * @param string $taxonomy  Taxonomy name of the terms.
									 * @param array $term_ids   Term IDs to be filtered by.
									 * 
									 * @return string $operator
									 */
									'operator' => apply_filters( 'greyd_query_filter_tax_query_term_operator', 'IN', $taxonomy, $term_ids )
								) : array()
							)
						);
					}
				}

				if ( count($query['tax_query']) > 1 ) {
					/**
					 * @filter greyd_query_filter_tax_query_relationship
					 * 
					 * @since 1.3.2
					 * 
					 * @param string $relationship  Relationship between taxonomy filters. Default: 'AND'.
					 * @param array $query_args     Query arguments.
					 * 
					 * @return string $relationship
					 */
					$query['tax_query']['relation'] = apply_filters( 'greyd_query_filter_tax_query_relationship', 'AND', $query );
				}
			}
			/**
			 * @deprecated WordPress 5.9
			 */
			else if ($query['post_type'] != "post" && $query['post_type'] != "page") {
				// filter query
				// https://codex.wordpress.org/Class_Reference/WP_Query#Taxonomy_Parameters
				$query['tax_query'] = array();
				// category and tag
				if (isset($query[$query['post_type'].'_categoryIds']) && count($query[$query['post_type'].'_categoryIds']) > 0) {
					foreach ($query[$query['post_type'].'_categoryIds'] as $cat_id) {
						array_push($query['tax_query'], array(
							'taxonomy'      => $query['post_type'].'_category',
							'terms'         => $cat_id,
							'operator'      => 'IN'
						));
					}
				}
				if (isset($query[$query['post_type'].'_tagIds']) && count($query[$query['post_type'].'_tagIds']) > 0) {
					foreach ($query[$query['post_type'].'_tagIds'] as $tag_id) {
						array_push($query['tax_query'], array(
							'taxonomy'      => $query['post_type'].'_tag',
							'terms'         => $tag_id,
							'operator'      => 'IN'
						));
					}
				}
				// custom taxonomies
				if ($custom_taxonomies = self::preg_match_keys("/^".$query['post_type']."_.+/", $atts['query'])) {
					foreach ((array)$custom_taxonomies as $tax_name => $tax_ids ) {
						$tax_slug = str_replace( "Ids", "", $tax_name );
						foreach ($tax_ids as $tax_id) {
							array_push($query['tax_query'], array(
								'taxonomy'      => $tax_slug,
								'terms'         => $tax_id,
								'operator'      => 'IN'
							));
						}
					}
				}
				// set relation
				if ( count($query['tax_query']) > 1 ) $query['tax_query']['relation'] = 'AND';
			}
		}
		return $query;
	}

	/**
	 * unused outside this class
	 */
	public static function preg_match_keys(string $pattern, array $input, $flags = 0) {
		return array_intersect_key(
			$input,
			array_flip( preg_grep(
				$pattern,
				array_keys($input),
				$flags
			) )
		);
	}

	/**
	 * @see \Greyd\Helper::filter_post_id
	 */
	public static function filter_post_id( $post_id, $post_type='post' ) {

		/**
		 * Call the new function.
		 */
		if ( method_exists( '\Greyd\Helper', 'filter_post_id' ) ) {
			return \Greyd\Helper::filter_post_id( $post_id, $post_type );
		}
		
		/**
		 * WPML: filter Post ID and look for tranlated version.
		 * @see https://wpml.org/wpml-hook/wpml_object_id/
		 */
		$filtered_id = apply_filters( 'wpml_object_id', $post_id, $post_type, null, null );
		if ( $filtered_id && $filtered_id != $post_id ) {
			$post_id = $filtered_id;
		}

		$post_id = apply_filters( 'greyd_filter_post_id', intval( $post_id ), $post_type );

		return $post_id;
	}

	/**
	 * unused outside this class
	 */
	public static function get_language_code() {
		return defined('ICL_LANGUAGE_CODE') ? ICL_LANGUAGE_CODE : explode('_', get_locale(), 2)[0];
	}

	/**
	 * @see \Greyd\Helper::get_attachment_text
	 */
	public static function get_attachment_text( $image_id ) {
		return method_exists( '\Greyd\Helper', 'get_attachment_text') ? \Greyd\Helper::get_attachment_text($image_id) : \vc\helper::get_attachment_text($image_id);
	}

	/**
	 * @see \Greyd\Layout\Enqueue::get_breakpoints();
	 */
	public static function get_breakpoints() {
		$grid = array( 'sm' => 576, 'md' => 992, 'lg' => 1200, 'xl' => 1621 );
		if ( class_exists("Greyd\Layout\Enqueue") ) {
			$grid = \Greyd\Layout\Enqueue::get_breakpoints();
		}
		else if ( class_exists("greyd\blocks\layout\Enqueue") ) {
			$grid = \greyd\blocks\layout\Enqueue::get_breakpoints();
		}
		return $grid;
	}

	/**
	 * @see \Greyd\Helper::get_post_language
	 */
	public static function get_post_language($post, $language_default=null) {

		/**
		 * Call the new function.
		 */
		if ( method_exists( '\Greyd\Helper', 'get_post_language' ) ) {
			return \Greyd\Helper::get_post_language( $post, $language_default );
		}
		
		/**
		 * old function - moved from enqueue.php
		 */
		
		// get language
		$language = apply_filters('wpml_post_language_details', NULL, $post->ID);

		if ( !$language || !is_array($language) || !isset($language['language_code']) ) return get_locale();
		
		$lang = $language['language_code'];

		if ($lang != $language_default) {

			// get original id
			$id_original = apply_filters( 'wpml_object_id', $post->ID, $post->post_type, false, $language_default );
			if ($id_original && $id_original != $post->ID) {
				$language['original_id'] = $id_original;
			}
		}
		return $language;

	}
}