/**
 * GREYD.Blocks Frontend Script for Lottie Animations Feature.
 *
 * This file is loaded in the frontend only.
 */
(function() {
	
	jQuery(function() {

		if (typeof $ === 'undefined') $ = jQuery;
		
		/**
		 * lottie
		 * split from theme default.js 'icons' function
		 */
		greyd.lottie.init();

		// console.log("Frontend Lottie Script: loaded");
	} );

} )(jQuery);


/**
 * Lottie/Bodymovin
 */
greyd.lottie = new function() {

	this.className = '.lottie-animation';
	this.setup = {
		lottie: { mode: 'default' },
		lazyload: 'false',
	};
	this.anims = {};

	this.init = function() {
		
		// check for animations
		if ( $(this.className).length == 0 ) {
			// console.warn("no lottie animations found");
			return;
		}

		// get setup
		if (typeof greyd.setup.lottie !== 'undefined') {
			this.setup.lottie = greyd.setup.lottie;
		}
		if (typeof greyd.setup.lazyload !== 'undefined') {
			this.setup.lazyload = greyd.setup.lazyload;
		}

		// Stop loading if Lottie is disabled
		if (this.setup.lottie.mode == 'disable') return;

		// get animations
		if ( typeof bodymovin === 'undefined' && this.setup.lottie.mode === 'lazy' ) {
			// lazyload lottie
			var is_mobile = ($('html').hasClass('ios') || $('html').hasClass('android'));
			if (!is_mobile || this.setup.lottie.mobile === "true") {
				var libsrc = this.setup.lottie.src;
				setTimeout(function() {
					$.getScript(libsrc, function() {
						// console.log("lottie lib loaded");
						greyd.lottie.initIcons();
						greyd.lottie.scroll();
					});
				}, this.setup.lottie.time*1000);
			}
		} 
		else {
			// load now
			this.initIcons();
		}

		this.addEvents();
		// console.log('lottie Script: loaded');
	}
	
	this.initIcons = function () {
		if (typeof bodymovin === 'undefined') return;

		$('body').trigger('lottieLoaded');
		
		$(this.className).each(function() {
			// console.log($(this).attr('id'));
			var id = $(this).attr('id');
			var src = $(this).data('src');
			var anim = $(this).data('anim');
			var auto = false;
			if (anim == "auto") auto = true;
			greyd.lottie.addIcon(id, src, auto);
			$(this).removeAttr('data-src');
		});
	}
	this.addIcon = function(icon, src, autoplay) {
		if (typeof bodymovin === 'undefined') return;

		//console.log(icon+', '+src+', '+autoplay);
		if (!this.anims[icon]) {
			if ( this.setup.lazyload === 'true' ) {
				// lazyload animation
				this.anims[icon] = { 'status': "lazy", 'icon': icon, 'src': src, 'autoplay': autoplay };
			}
			else {
				// load now
				this.loadIcon( { 'icon': icon, 'src': src, 'autoplay': autoplay } );
			}
		}
	}
	this.loadIcon = function(config) { 
		// console.log(config);
		var { icon, autoplay, src } = config;
		this.anims[icon] = bodymovin.loadAnimation( {
								container: document.getElementById(icon),
								renderer: 'svg',
								loop: true,
								autoplay: autoplay,
								path: src
							} );
		this.anims[icon].setSubframe(false);
		this.anims[icon].addEventListener('DOMLoaded', function(e) { 
			// console.log('element loaded'); 
			$('#'+icon).parent().find('.lottie-animation-placeholder').hide();
			$('#'+icon).css('display', 'inline-block');
			if (!greyd.lottie.anims[icon].autoplay) greyd.lottie.scroll();
		});
	}
	
	this.addEvents = function() {
		// json on hover
		$(document).on('mouseenter', this.className+'.hover', this.enter);
		$(document).on('mouseleave', this.className+'.hover', this.leave);
		// scroll and resize
		$(window).scroll(this.scroll);
		$(window).resize(this.scroll);
		this.scroll();
	}

	this.scroll = function () {
		// console.log("scrolling");
		var viewportTop = $(window).scrollTop();
		var viewportHeight = $(window).height();
		var viewportBottom = viewportTop + viewportHeight;
		
		var loading = [];
		for (var icon in greyd.lottie.anims) {
			var anim = greyd.lottie.anims[icon];
			if (anim.status == "lazy") {
				var wrapper = $('#'+icon).parent();
				var elementTop = wrapper.offset().top - 50;
				var elementBottom = elementTop + wrapper.outerHeight() + 100;
				if (elementBottom > viewportTop && elementTop < viewportBottom) {
					// console.log("lazyload "+icon);
					loading.push(anim.src);
					greyd.lottie.loadIcon(anim);
				}
			}
			else if (!anim.autoplay) {
				var wrapper = anim.wrapper;
				var elementTop = $(wrapper).offset().top;
				var elementBottom = elementTop + $(wrapper).outerHeight();
				if (elementBottom > viewportTop && elementTop < viewportBottom) {
					if (!$(wrapper).data('visible') || $(wrapper).data('visible') == false) {
						// console.log("enter "+icon);
						$(wrapper).data('visible', true);
						anim.play();
					}
				} 
				else {
					if ($(wrapper).data('visible') == true) {
						// console.log("leave "+icon);
						$(wrapper).data('visible', false);
						anim.pause();
					}
				}
			}
		}

		// load other anims with the same src
		if (loading.length > 0) {
			for (var icon in greyd.lottie.anims) {
				var anim = greyd.lottie.anims[icon];
				if (anim.status == "lazy") {
					if (loading.indexOf(anim.src) > -1) {
						// console.log("found one more");
						greyd.lottie.loadIcon(anim);
					}
				}
			}
		}
	}
	
	this.enter = function(e) {
		var icon = e.currentTarget.id;
		// console.log("enter "+icon);
		if (!greyd.lottie.anims[icon].autoplay)
			greyd.lottie.anims[icon].play();
	}
	this.leave = function(e) {
		var icon = e.currentTarget.id;
		// console.log("leave "+icon);
		if (!greyd.lottie.anims[icon].autoplay)
			greyd.lottie.anims[icon].pause();
	}
	
}
