<?php
/**
 * GREYD.Blocks settings
 * 
 * @since 1.2.7 - Reduce DOM size.
 * * removed empty html tags (span, strong, em...)
 * * removed div around content box without background.
 * * removed div around dynamic templates without classes.
 * 
 * @deprecated since 1.8.4
 */
namespace greyd\blocks;

if (!defined( 'ABSPATH' )) exit;

return;

new Settings();
class Settings {

	/**
	 * Settings default.
	 * 
	 * @var array
	 */
	private static $defaults = array(
		'reduce_dom' => false
	);
	
	/**
	 * Constructor
	 */
	public function __construct() {
		add_filter( 'greyd_settings_more', array($this, 'render_settings'), 9, 3 );
		add_filter( 'greyd_settings_more_save', array($this, 'save_settings'), 9, 3 );
		add_filter( 'greyd_settings_default_site', array($this, 'add_default_settings') );
	}

	/**
	 * Retrieve block settings.
	 * 
	 * @param string $option    Name of the option to retrieve. Leavy empty for all settings.
	 * 
	 * @return mixed|null|array Mixed value if option isset and found.
	 *                          Null when option is not found.
	 *                          Array of settings when no option isset.
	 */
	public static function get_setting( string $option="" ) {

		if ( \method_exists( '\Greyd\Settings', 'get_setting' ) ) {

			if ( !empty($option) ) {
				return \Greyd\Settings::get_setting( array('site', 'blocks', $option) );
			} else {
				return \Greyd\Settings::get_setting( array('site', 'blocks') );
			}
		}
		
		if ( \method_exists( '\tp\management\settings', 'get_setting' ) ) {

			if ( !empty($option) ) {
				return \tp\management\settings::get_setting( array('site', 'blocks', $option) );
			} else {
				return \tp\management\settings::get_setting( array('site', 'blocks') );
			}
		}

		$block_settings = class_exists("\basics") ? \basics::get_setting( array('site', 'blocks') ) : false;

		if ( $block_settings && is_array($block_settings) ) {
			$block_settings = wp_parse_args( $block_settings, self::$defaults );
		} else {
			$block_settings = self::$defaults;
		}


		if ( !empty($option) ) {
			return isset( $block_settings[$option] ) ? $block_settings[$option] : null;
		}

		return $block_settings;
	}

	/**
	 * Render the settings.
	 * 
	 * @param string $content   Content of all additional settings.
	 * @param string $mode      'site' | 'network_site' | 'network_admin'
	 * @param array $data       Current settings.
	 * 
	 * @return string $content  Modified settings content.
	 */
	public function render_settings( $content, $mode, $data ) {

		if ( $mode == 'network_admin' ) return $content;

		$block_settings = self::get_setting();

		$content .= "<table class='form-table'>".
			"<tr>".
				"<th>".__('DOM Tiefe', 'greyd_blocks')."</th>".
				"<td>".
					"<label for='blocks[reduce_dom]'>".
						"<input type='checkbox' id='blocks[reduce_dom]' name='blocks[reduce_dom]' ".( $block_settings['reduce_dom'] ? "checked='checked'" : "" )."/>".
						"<span>".__('DOM Tiefe reduzieren', 'greyd_blocks').
						//"&nbsp;<span class='feature-tag'>Beta</span></span><br>".
						"<small class='color_light'>".__('Dies reduziert die DOM-Tiefe deiner Website um etwa 10%, indem unnötige Wrapper, Spans und andere Elemente weg gelassen werden. Wir testen und verbessern diese Funktion kontinuierlich. Es kann derzeit noch zu kleineren Darstellungsunterschieden kommen.', 'greyd_blocks')."</small>".
					"</label><br>".
				"</td>".
			"</tr>".
		"</table>";
		return $content;
	}

	/**
	 * Save the settings.
	 * 
	 * @param array $settings   Current site settings.
	 * @param array $defaults   Default values.
	 * @param array $data       Raw $_POST data.
	 * 
	 * @return array $settings  Modified site settings.
	 */
	public function save_settings( $settings, $defaults, $data ) {

		$block_settings = self::$defaults;

		foreach( $block_settings as $key => $default ) {
			if ( isset($data['blocks']) && isset($data['blocks'][$key]) ) {
				$block_settings[ $key ] = \settype( $data['blocks'][$key], \gettype( $default ) );
			}
		}
		
		$settings['blocks'] = $block_settings;

		return $settings;
	}

	/**
	 * Add settings to defaults.
	 * This is necessary to not delete the option during sanitization.
	 * 
	 * @since 1.2.9
	 * 
	 * @param  array $settings
	 * @return array $settings
	 */
	public function add_default_settings( $settings ) {

		$settings = array_merge(
			$settings,
			array( 'blocks' => self::$defaults )
		);

		return $settings;
	}
}