/**
 * Helper functions & utils for trigger features in block editor.
 */
var greyd = greyd || {};

greyd.trigger = new function() {

	var el = wp.element.createElement;
	var __ = wp.i18n.__;

	//
	// trigger event controls
	this.triggerEventControls = function(props) {
		
		var makeActions = function(props) {
			var controls = [];
			if (_.has(props.attributes, 'trigger_event') && _.has(props.attributes.trigger_event, 'actions')) {
				for (var i=0; i<props.attributes.trigger_event.actions.length; i++) {
					var action = props.attributes.trigger_event.actions[i];
					controls.push(
						el( 'div', {
							className: 'components-greyd-controlgroup__item',
							'data-index': i,
						}, [
							// remove
							el( wp.components.Button, { 
								className: "components-greyd-controlgroup__remove",
								onClick: (event) => {
									var index = parseInt(event.target.closest('.components-greyd-controlgroup__item').dataset.index);
									// console.log("remove action "+index);
									var actions = props.attributes.trigger_event.actions;
									actions.splice(index, 1);
									props.setAttributes( { trigger_event: { ...props.attributes.trigger_event, actions: actions } } ); 
								},
								title: __('Aktion entfernen', 'greyd_blocks')
							}, el( wp.components.Icon, { icon: 'no-alt' } ) ),
							// name
							el( 'div', {}, __("Name", 'greyd_blocks') ),
							el( 'input', {
								className: 'components-text-control__input components-base-control',
								placeholder: __('Trigger Name', 'greyd_blocks'),
								// help: __("Gebe deinem Trigger einen eindeutigen Namen zur Referenzierung im Trigger-Picker.", 'greyd_blocks'),
								value: action.name,
								onChange: function(event) { 
									var index = parseInt(event.target.closest('.components-greyd-controlgroup__item').dataset.index);
									var val = event.target.value;
									// console.log("change action "+index+" name: "+val);
									var actions = props.attributes.trigger_event.actions;
									actions[index].name = val;
									props.setAttributes( { trigger_event: { ...props.attributes.trigger_event, actions: actions } } ); 
								},
							} ),
							// action
							// el( 'div', { style: { marginTop: '10px' }}, __("Aktion", 'greyd_blocks') ),
							el( greyd.components.OptionsControl, {
								label: __("Aktion", 'greyd_blocks'),
								// help: __("Was soll beim Auslösen des Triggers mit diesem Block geschehen?", 'greyd_blocks'),
								// className: 'components-select-control__input',
								value: action.action,
								onChange: function(value, event) { 
									var index = parseInt(event.target.closest('.components-greyd-controlgroup__item').dataset.index);
									// console.log("change action "+index+": "+val);
									var actions = props.attributes.trigger_event.actions;
									actions[index].action = value;
									props.setAttributes( { trigger_event: { ...props.attributes.trigger_event, actions: actions } } ); 
								},
								options: [
									{ value: 'show', label: __('anzeigen', 'greyd_blocks') },
									{ value: 'hide', label: __('ausblenden', 'greyd_blocks') },
									{ value: 'toggle', label: __('aus- & einblenden', 'greyd_blocks') },
									{ value: 'fadeIn', label: __('animiert einblenden', 'greyd_blocks') },
									{ value: 'fadeOut', label: __('animiert ausblenden', 'greyd_blocks') },
									{ value: 'fadeToggle', label: __('animiert aus- & einblenden', 'greyd_blocks') },
									{ value: 'slideDown', label: __('aufklappen', 'greyd_blocks') },
									{ value: 'slideUp', label: __('zuklappen', 'greyd_blocks') },
									{ value: 'slideToggle', label: __('auf- & zuklappen', 'greyd_blocks') }
								]
							} ),
						] )
					);
				}
			}
			return controls;
		}

		return el( AdvancedPanelBody, { 
			title: __('Aktionen', 'greyd_blocks'), 
			initialOpen: false, 
			holdsChange: (_.has(props.attributes, 'trigger_event')) && !isEmpty(props.attributes.trigger_event.actions) 
		}, [
			// actions
			el( 'div', { className: 'components-greyd-controlgroup'}, [
				makeActions(props),
				el( wp.components.Button, {
					className: 'components-greyd-controlgroup__add'+( !_.has(props.attributes.trigger_event, 'actions') || props.attributes.trigger_event.actions.length === 0 ? ' group_is_empty': '' ),
					onClick: function() {
						// console.log('adding parameter');
						var value = [];
						var names = [];
						if (_.has(props.attributes, 'trigger_event') && _.has(props.attributes.trigger_event, 'actions'))
							value = props.attributes.trigger_event.actions;
						for (var i=0; i<value.length; i++) names.push(value[i].name);
						var name = 'Trigger '+(value.length+1);
						while (names.indexOf(name) > -1) {
							name += '1';
						}
						value.push({ name: name, action: 'show' });
						props.setAttributes( { trigger_event: { ...props.attributes.trigger_event, actions: value } } ); 
					},
					title: __('Aktion hinzufügen', 'greyd_blocks')
				}, [
					el( wp.components.Icon, { icon: 'plus-alt2' } ),
					!_.has(props.attributes.trigger_event, 'actions') || props.attributes.trigger_event.actions.length === 0 ? el( 'span', {}, __('Aktion hinzufügen', 'greyd_blocks') ) : null
				] )
			] ),

			// onload
			// el( 'span', {}, __('Zustand beim Seitenaufruf', 'greyd_blocks') ),
			el( ButtonGroupControl, {
				value: (_.has(props.attributes, 'trigger_event')) && props.attributes.trigger_event.onload === 'hide' ? 'hide' : '',
				label: __('Zustand beim Seitenaufruf', 'greyd_blocks'),
				options: [
					{ label: __("Normal", "greyd_blocks"), value: "" },
					{ label: __("Ausgeblendet", "greyd_blocks"), value: "hide" }
				],
				style: { marginBottom: '10px' },
				onChange: function(value) { 
					props.setAttributes( { trigger_event: { ...props.attributes.trigger_event, onload: value } } ); 
				},
			} ),
			// siblings todo
			el( wp.components.ToggleControl, {
				label: __('Benachbarte Trigger-Elemente ausblenden', 'greyd_blocks'),
				// help: __("Wenn ausgewählt, werden alle benachbarten Trigger-Elemente (z.B. in der gleichen Spalte) ausgeblendet, sobald dieses Element eingeblendet wird.", 'greyd_blocks'),
				checked: (_.has(props.attributes, 'trigger_event')) ? props.attributes.trigger_event.siblings : false,
				onChange: function(value) { 
					props.setAttributes( { trigger_event: { ...props.attributes.trigger_event, siblings: value } } ); 
				},
			} )
		] );

	}

	//
	// trigger picker controls
	this.triggerPickerControlsLogic = function(props) {
		
		// vars
		var tr = { type: "link", params: {} };
		var triggerType = "";
		if (_.has(props.attributes, "trigger") && _.has(props.attributes.trigger, "type")) {
			triggerType = props.attributes.trigger.type;
			// tr = props.attributes.trigger;
			tr.type = triggerType;
			tr.params[triggerType] = props.attributes.trigger.params;
		}
		var triggerTitle = function() {
			// console.log(triggerType);
			for (var i=0; i<types.length; i++) {
				if (types[i].value == triggerType) 
					return types[i].label;
			}
		}

		// states
		var [ active, setActive ] = wp.element.useState(false);
		var [ hover, setHover ] = wp.element.useState(false);
		var [ edit, setEdit ] = wp.element.useState(false);
		var [ trigger, setTrigger ] = wp.element.useState(tr);
		if (!active && !isEqual(trigger, tr)) setTrigger(tr);

		// types
		var types = [
			// { value: '', label: __('Trigger wählen', 'greyd_blocks') },
			{ value: 'link',    label: '🔗 ' + __('Link', 'greyd_blocks') },
			{ value: 'dynamic', label: '💾 ' + __('Dynamischer Link', 'greyd_blocks') },
			{ value: 'scroll',  label: '↕️ ' + __('Scroll to', 'greyd_blocks') },
			{ value: 'popup',   label: '🎉 ' + __('Pop-up', 'greyd_blocks') },
			{ value: 'back',    label: '🔙 ' + __('Zurück', 'greyd_blocks') },
			{ value: 'email',   label: '📧 ' + __('E-Mail', 'greyd_blocks') },
			{ value: 'file',    label: '↓ ' + __('Download', 'greyd_blocks') },
			{ value: 'event',   label: '🎯 ' + __('Trigger Event', 'greyd_blocks') },
		];

		if ( greyd.data.post_type === 'greyd_popup' ) {
			types.push( { value: 'popup_close', label: __('Pop-up schließen', 'greyd_blocks') } );
		}

		// options
		var { blocks, popups, files } = wp.data.useSelect(select => ({
			// all blocks to filter anchors and triger_events
			blocks: select("core/block-editor").getBlocks(),
			// popups
			popups: [], // select("core").getEntityRecords( 'postType', 'greyd_popup', { per_page: 100 } ),
			// files
			files: [], // select("core").getEntityRecords( 'postType', 'attachment', { per_page: 100 } ),
		}));

		// dynamic
		var dynamic = [
			{ value: '', label: __('Dynamischen Link wählen', 'greyd_blocks') },
			greyd?.dynamic?.tags?.getCurrentOptions('trigger', props.clientId),
			{ label: __('Website', 'greyd_blocks'), options: greyd?.dynamic?.tags?.getOptions('trigger', 'site') },
		];

		/**
		 * @filter greyd.dynamic.tags.getRichTextOptions
		 */
		dynamic = wp.hooks.applyFilters( 'greyd.dynamic.triggerOptions', dynamic );

		// make options arrays
		var options = function(type) {
			if (type == 'type') return types;
			if (type == 'scroll') return [
				{ value: '', label: __('Ziel wählen', 'greyd_blocks') },
				{ value: '_top', label: __('Seitenanfang', 'greyd_blocks') },
				...makeOptions(greyd.tools.searchAttribute(blocks, 'anchor')),
				{ value: '_bottom', label: __('Seitenende', 'greyd_blocks') } 
			];
			if (type == 'popup') return [
				{ value: '', label: __('Pop-up wählen', 'greyd_blocks') },
				...greyd.dynamic.getOptions(greyd.data.popups)
			];
			if (type == 'file') return [
				{ value: '', label: __('Datei wählen', 'greyd_blocks') },
				...greyd.dynamic.getOptions(greyd.data.media_urls)
			];
			if (type == 'event') return [
				{ value: '', label: __('Event wählen', 'greyd_blocks') },
				...makeOptions(greyd.tools.searchAttribute(blocks, 'trigger_event')),
				{ value: '__custom', label: __('Trigger eingeben', 'greyd_blocks') }
			];
			if (type == 'dynamic') {
				return dynamic;
			}
		}
		// make options array
		var makeOptions = function(items) {
			// console.log(items);
			var options = [];
			for (var i=0; i<items.length; i++) {
				// console.log(items[i]);
				if (_.has(items[i], 'id')) {
					var label = items[i].title.rendered;
					if (_.has(items[i], 'source_url')) {
						var path = items[i].source_url.split('/');
						label = path[path.length-1];
					}
					options.push( { value: items[i].id, label: label } );
				}
			}
			return options;
		}

		var checkTrigger = function() {

			// doesn't need params
			if (trigger.type == 'back' || 
				trigger.type == 'popup_close') return true;

			// needs params
			if (_.has(trigger.params, trigger.type) && !isEmpty(trigger.params[trigger.type])) {

				// single param
				if (trigger.type == 'scroll' || 
					trigger.type == 'popup' || 
					trigger.type == 'file') {
						return true;
				}
				// multiple params
				else {
					if (trigger.type == '' || trigger.type == 'link') {
						if (!isEmpty(trigger.params[trigger.type].url))
							return true;
					}
					if (trigger.type == 'email') {
						if (!isEmpty(trigger.params[trigger.type].address)) {
							if (trigger.params[trigger.type].address.indexOf('@') > -1 &&
								trigger.params[trigger.type].address.indexOf('.') > -1)
								return true;
						}
					}
					if (trigger.type == 'event') {
						if (!isEmpty(trigger.params[trigger.type].name)) {
							if (trigger.params[trigger.type].name == '__custom') {
								if (!isEmpty(trigger.params[trigger.type].custom))
									return true;
							}
							else return true;
						}
					}
					if (trigger.type == 'dynamic') {
						if (!isEmpty(trigger.params[trigger.type].tag))
							return true;
					}
				}
			}
			return false;
		}
		var applyTrigger = function() {
			setEdit(false);
			var new_trigger = { type: trigger.type };
			if (_.has(trigger.params, trigger.type)) {
				new_trigger.params = trigger.params[trigger.type];
			}
			props.setAttributes( { trigger: new_trigger } );
		}

		// preview
		var parseTitle = function(items, slug) {
			// console.log(items);
			// console.log(slug);
			var label = "";
			var help = "";
			for (var i=0; i<items.length; i++)
				if (items[i].id == slug) { 
					var str = items[i].title.rendered.split(' ('); 
					label = str[0];
					if (str.length > 1) {
						str = str[1].split(')');
						help = str[0];
					}
					return { label: label, help: help };
				}
			return false;
		}
		var makePreview = function() {
			var label = '';
			var url = '';
			var atts = {
				onMouseOver: function() { setHover(true) },
				onMouseOut: function() { setHover(false) }
			}

			// link
			if (trigger.type == 'link' && !isEmpty(trigger.params.link)) {
				url = trigger.params.link.url;
				label = trigger.params.link.url;
				if (!isEmpty(trigger.params.link.title)) label = trigger.params.link.title;
				atts.href = url;
				atts.target = '_blank';
			}
			// back
			else if (trigger.type == 'back') {
				label = __('Zur letzten Seite', 'greyd_blocks');
			}
			// popup close
			else if (trigger.type == 'popup_close') {
				label = __('aktuelles Pop-up', 'greyd_blocks');
			}
			// scroll
			else if (trigger.type == 'scroll' && !isEmpty(trigger.params.scroll)) {
				label = trigger.params.scroll;
				if (label == '_top') label = __('Seitenanfang', 'greyd_blocks');
				else if (label == '_bottom') label = __('Seitenende', 'greyd_blocks');
				else {
					var title = parseTitle(greyd.tools.searchAttribute(blocks, 'anchor'), label);
					if (title) {
						label = title.label;
						url = title.help;
					}
				}
			}
			// popup
			else if (trigger.type == 'popup' && !isEmpty(trigger.params.popup)) {
				label = trigger.params.popup;
				for (var i=0; i<greyd.data.popups.length; i++)
					if (greyd.data.popups[i].id == label) { 
						label = greyd.data.popups[i].title; 
						break; 
					}
			}
			// email
			else if (trigger.type == 'email' && !isEmpty(trigger.params.email)) {
				label = trigger.params.email.address;
				var mailto = 'mailto:'+trigger.params.email.address;
				if (!isEmpty(trigger.params.email.subject)) {
					url = trigger.params.email.subject;
					mailto += '?subject='+url;
				}
				atts.href = mailto;
			}
			// file
			else if (trigger.type == 'file' && !isEmpty(trigger.params.file)) {
				label = trigger.params.file;
				url = "";
				if (greyd.data.media_urls[trigger.params.file]) { 
					label = greyd.data.media_urls[trigger.params.file].title; 
					url = greyd.data.media_urls[trigger.params.file].src;
				}
				if (url != "") {
					var path = url.split('/');
					label = path[path.length-1];
				}
				atts.href = url;
				atts.download = '';
			}
			// event
			else if (trigger.type == 'event' && !isEmpty(trigger.params.event)) {
				if (trigger.params.event.name != '__custom') {
					label = trigger.params.event.name;
					var title = parseTitle(greyd.tools.searchAttribute(blocks, 'trigger_event'), label);
					if (title) {
						label = title.label;
						url = title.help;
					}
				}
				else label = trigger.params.event.custom;
			}
			// dynamic
			else if (trigger.type == 'dynamic' && !isEmpty(trigger.params.dynamic.tag)) {
				label = greyd.dynamic.tags.renderLabel(trigger.params.dynamic.tag, dynamic);
			}
			// different type
			else {
				// console.log(trigger);
				// console.log(dynamic);
			}
			
			return [
				el( 'a', atts, label),
				(url != '') ? el( 'span', { className: 'greyd-inspector-help' }, url ) : ''
			];
		}

		// hover preview
		var makeHoverPreview = function() {

			// link
			if (trigger.type == 'link' && !isEmpty(trigger.params.link)) {
				return el( 'div', { style: { width: 'calc(1280px * 0.2)', height: 'calc(768px * 0.2)' } }, 
					el( 'iframe', { 
						name: "popup-preview-0",
						className: 'greyd-iframe-preview',
						src: trigger.params.link.url+'/?popup_preview=abcde'
					} )
				);
			}
			// back
			// scroll
			// popup
			// email
			// file
			if (trigger.type == 'file' && !isEmpty(trigger.params.file)) {
				var width = 250; // '300px'
				var height = 200; // '240px';
				var url = "";
				if (greyd.data.media_urls[trigger.params.file]) { 
					var file = greyd.data.media_urls[trigger.params.file];
					url = file.src;
					if (file.type.indexOf('image') == 0) {
						return el( 'div', { style: { display: 'flex', width: width+'px', height: height+'px' }, className: 'editor-post-featured-image__preview' }, [
							el( 'img', { 
								className: 'greyd-img-preview',
								src: url 
							} )
						] );
					}
					if (file.type == 'application/pdf') {
						return el( 'div', { style: { display: 'flex', width: width+'px', height: height+'px' } }, [
							el( 'iframe', { 
								className: 'greyd-pdf-preview',
								src: url 
							} )
						] );
					}
				}
			}
			// event
			// dynamic

			return '';
		}

		// edit settings
		var makeSettings = function() {

			// link
			if (trigger.type == '' || trigger.type == 'link') {
				return el( wp.blockEditor.__experimentalLinkControl, {
					value: trigger.params.link,
					onChange: function(value) { 
						// console.log("set link:");
						// console.log(value);
						setTrigger({ ...trigger, params: { ...trigger.params, link: value } });
					},
					settings: [
						{
							id: 'opensInNewTab',
							title: __( "In neuem Tab öffnen", 'greyd_blocks' ),
						},

						/**
						 * @since 1.7.4 Option to add rel="noreferrer" and rel="external"
						 */
						{
							id: 'noReferrer',
							title: __( "Keine Weiterleitungsinformationen (noreferrer)", 'greyd_blocks' ),
						},
						{
							id: 'external',
							title: __( "Externer Link", 'greyd_blocks' ),
						},
						/**
						 * @since 1.7.4 Option to not filter the url
						 */
						...(
							typeof wpml_get_block_editor === 'undefined'
							?  []
							: [ {
								id: 'isRawURL',
								title: __( 'Filterung des Links verhindern (WPML)', 'greyd_blocks' ),
							} ]
						)
					]
				} );
			}
			// back (no sets)
			// scroll
			else if (trigger.type == 'scroll') {
				return el( 'div', { className: 'trigger-body__content' }, [
					el( greyd.components.OptionsControl, {
						style: { width: "100%" },
						value: trigger.params.scroll,
						options: options('scroll'),
						onChange: function(value) { 
							// console.log("select anchor: "+value);
							setTrigger({ ...trigger, params: { ...trigger.params, scroll: value } });
						},
					} )
				] );
			}
			// popup
			else if (trigger.type == 'popup') {
				return el( 'div', { className: 'trigger-body__content' }, [
					el( greyd.components.OptionsControl, {
						style: { width: "100%" },
						value: trigger.params.popup,
						options: options('popup'),
						onChange: function(value) { 
							// console.log("select popup: "+value);
							setTrigger({ ...trigger, params: { ...trigger.params, popup: value } });
						},
					} )
				] );
			}
			// email
			else if (trigger.type == 'email') {
				return el( 'div', { className: 'trigger-body__content' }, [
					el( wp.components.TextControl, {
						label: __('E-Mail Adresse', 'greyd_blocks'),
						value: (_.has(trigger.params, 'email')) ? trigger.params.email.address : '',
						onChange: function(value) { 
							// console.log("change email address: "+value);
							var email = { address: value };
							if (_.has(trigger.params, 'email')) email = { ...trigger.params.email, address: value };
							setTrigger({ ...trigger, params: { ...trigger.params, email: email } });
						},
					} ),
					el( wp.components.TextControl, {
						label: __('Betreff', 'greyd_blocks'),
						value: (_.has(trigger.params, 'email')) ? trigger.params.email.subject : '',
						onChange: function(value) { 
							// console.log("change email subject: "+value);
							var email = { subject: value };
							if (_.has(trigger.params, 'email')) email = { ...trigger.params.email, subject: value };
							setTrigger({ ...trigger, params: { ...trigger.params, email: email } });
						},
					} )
				] );
			}
			// file
			else if (trigger.type == 'file') {
				return el( 'div', { className: 'trigger-body__content' }, [
					el( greyd.components.OptionsControl, {
						style: { width: "100%" },
						value: trigger.params.file,
						options: options('file'),
						onChange: function(value) { 
							// console.log("select file: "+value);
							setTrigger({ ...trigger, params: { ...trigger.params, file: value } });
						},
					} )
				] );
			}
			// event
			else if (trigger.type == 'event') {
				return el( 'div', { className: 'trigger-body__content' }, [
					el( greyd.components.OptionsControl, {
						style: { width: "100%" },
						value: (_.has(trigger.params, 'event')) ? trigger.params.event.name : '',
						options: options('event'),
						onChange: function(value) { 
							// console.log("select event: "+value);
							var event = { name: value };
							if (_.has(trigger.params, 'event')) event = { ...trigger.params.event, name: value };
							if (event.name != '__custom') delete(event.custom);
							setTrigger({ ...trigger, params: { ...trigger.params, event: event } });
						},
					} ),
					(_.has(trigger.params, 'event') && trigger.params.event.name == '__custom') ?
						el( wp.components.TextControl, {
							label: __('Name des Events', 'greyd_blocks'),
							value: (_.has(trigger.params, 'event')) ? trigger.params.event.custom : '',
							onChange: function(value) { 
								// console.log("change custom event name: "+value);
								var event = { custom: value };
								if (_.has(trigger.params, 'event')) event = { ...trigger.params.event, custom: value };
								setTrigger({ ...trigger, params: { ...trigger.params, event: event } });
							},
						} ) : '',
					el( wp.components.ToggleControl, {
						label: __('Bereits on Hover auslösen', 'greyd_blocks'),
						checked: (_.has(trigger.params, 'event')) ? trigger.params.event.hover : false,
						onChange: function(value) { 
							// console.log("toggle hover: "+value);
							var event = { hover: value };
							if (_.has(trigger.params, 'event')) event = { ...trigger.params.event, hover: value };
							setTrigger({ ...trigger, params: { ...trigger.params, event: event } });
						},
					} ),
					el( wp.components.ToggleControl, {
						label: __('Trigger überall auslösen', 'greyd_blocks'),
						checked: (_.has(trigger.params, 'event')) ? trigger.params.event.global : false,
						onChange: function(value) { 
							// console.log("toggle hover: "+value);
							var event = { global: value };
							if (_.has(trigger.params, 'event')) event = { ...trigger.params.event, global: value };
							setTrigger({ ...trigger, params: { ...trigger.params, event: event } });
						},
					} )
				] );
			}
			// dynamic
			else if (trigger.type == 'dynamic') {
				const isWooAjax = _.has(trigger.params, 'dynamic') && _.has(trigger.params.dynamic, 'tag') && trigger.params.dynamic.tag == "woo_ajax";

				return el( 'div', { className: 'trigger-body__content' }, [
					el( greyd.components.OptionsControl, {
						style: { width: '100%' },
						value: (_.has(trigger.params, 'dynamic')) ? trigger.params.dynamic.tag : '',
						options: options('dynamic'),
						onChange: function(value) { 
							// console.log("select dynamic: "+value);
							var dynamic = { tag: value };
							if (_.has(trigger.params, 'dynamic')) dynamic = { ...trigger.params.dynamic, tag: value };
							setTrigger({ ...trigger, params: { ...trigger.params, dynamic: dynamic } });
						},
					} ),
					// if woo give some extra options
					isWooAjax ? 
					[ 
						el( greyd.components.OptionsControl, {
							label: __('Linkziel', 'greyd_blocks'),
							style: { width: "100%"},
							value: (_.has(trigger.params, 'dynamic')) ? trigger.params.dynamic.redirects : false,
							options: [
								{ value: 'default', label: __("Standard", 'greyd_blocks') },
								{ value: 'cart', label: __("zum Warenkorb", 'greyd_blocks') },
								{ value: 'checkout', label: __("zur Kasse", 'greyd_blocks') },
								{ value: 'shop', label: __("zum Shop", 'greyd_blocks') },
								{ value: 'false', label: __("nicht weiterleiten", 'greyd_blocks') },
							],
							onChange: function(value) { 
								// console.log(trigger);
								var dynamic = { redirects: value };
								if (_.has(trigger.params, 'dynamic')) dynamic = { ...trigger.params.dynamic, redirects: value };
								setTrigger({ ...trigger, params: { ...trigger.params, dynamic: dynamic } });
							},
						} ),
						el( wp.components.ToggleControl, {
							label: __('Nicht doppelt hinzufügen', 'greyd_blocks'),
							checked: (_.has(trigger.params, 'dynamic')) ? trigger.params.dynamic.notTwice : false,
							onChange: function(value) { 
								var dynamic = { notTwice: value };
								if (_.has(trigger.params, 'dynamic')) dynamic = { ...trigger.params.dynamic, notTwice: value };
								setTrigger({ ...trigger, params: { ...trigger.params, dynamic: dynamic } });
							},
						} ), 
						el( wp.components.ToggleControl, {
							label: __('Warenkorb davor leeren', 'greyd_blocks'),
							checked: (_.has(trigger.params, 'dynamic')) ? trigger.params.dynamic.clear : false,
							onChange: function(value) { 
								var dynamic = { clear: value };
								if (_.has(trigger.params, 'dynamic')) dynamic = { ...trigger.params.dynamic, clear: value };
								setTrigger({ ...trigger, params: { ...trigger.params, dynamic: dynamic } });
							},
						} ), 
					]
					: el( wp.components.ToggleControl, {
						label: __('In neuem Tab öffnen', 'greyd_blocks'),
						checked: (_.has(trigger.params, 'dynamic')) ? trigger.params.dynamic.opensInNewTab : false,
						onChange: function(value) { 
							// console.log("toggle opensInNewTab: "+value);
							var dynamic = { opensInNewTab: value };
							if (_.has(trigger.params, 'dynamic')) dynamic = { ...trigger.params.dynamic, opensInNewTab: value };
							setTrigger({ ...trigger, params: { ...trigger.params, dynamic: dynamic } });
						},
					} )
				] );
			}

			return '';
		}

		// render popover content
		var popoverContent = function() {

			return (!isEmpty(triggerType) && !edit) ? [
				// preview mode
				el( 'div', { className: 'trigger-head flex' }, [
					// label
					el( 'span', {
						className: 'trigger-label'
					}, triggerTitle() ),
					// remove button
					el( wp.components.Button, {
						className: 'is-small',
						style: { color: 'darkred' },
						label: __('Trigger entfernen', 'greyd_blocks'),
						icon: el( GreydIcon, { icon: 'no' } ),
						onClick: function() { 
							// console.log("remove");
							setTrigger({ type: '', params: {} });
							props.setAttributes( { trigger: undefined } );
						},
					} ),
					// edit button
					el( wp.components.Button, {
						className: 'is-small',
						label: __('Trigger anpassen', 'greyd_blocks'),
						icon: el( GreydIcon, { icon: 'edit' } ),
						onClick: function() { 
							// console.log("edit");
							setEdit(true);
						},
					} ),
				] ),
				el( 'div', { className: 'trigger-body' }, [
					// preview
					el( 'span', { 
						className: 'trigger-preview' 
					}, makePreview() ),
					// hover preview
					(hover)
					? el( wp.components.Popover, {
						className: 'components-greyd-preview__content',
					}, makeHoverPreview() )
					: '',
				] )
			] : [ 
				// edit mode
				el( 'div', { className: 'trigger-head' }, [
					// label
					el( 'label', {}, __('Aktion wählen', 'greyd_blocks') ),
					el( 'div', {
						className: 'flex'
					}, [
						// type
						el( greyd.components.OptionsControl, {
							style: { width: '100%' },
							value: trigger.type,
							options: options('type'),
							onChange: function(value) { 
								// console.log("select");
								setTrigger({ ...trigger, type: value });
							},
						} ),
						// set button
						el( wp.components.Button, {
							disabled: !checkTrigger(),
							className: 'is-small is-primary',
							label: __('Trigger setzen', 'greyd_blocks'),
							icon: el( GreydIcon, { icon: 'saved' } ),
							onClick: function() { 
								// console.log("set");
								applyTrigger();
							},
						} )
					] ),
				] ),
				// settings
				el( 'div', { className: 'trigger-body' },
					makeSettings(),
				)	
			];
		}

		// reset if clicked away
		if (!props.isSelected && active) {
			if (checkTrigger()) applyTrigger();
			setActive(false);
		}

		return {
			triggerType: triggerType,
			active: active,
			setActive: setActive,
			edit: edit,
			popoverContent: popoverContent
		};
		
	}

	//
	// trigger picker controls
	this.triggerPickerControls = function(props) {
		
		const {
			triggerType,
			active,
			setActive,
			edit,
			popoverContent
		} = this.triggerPickerControlsLogic(props);

		// trigger toolbar
		var className = "components-toolbar";
		if (!isEmpty(triggerType)) className += ' is-pressed';
		if (_.has(props.attributes, "dynamic_parent")) {
			var enabled = false;
			if (_.has(props.attributes, 'dynamic_fields') && props.attributes.dynamic_fields && props.attributes.dynamic_fields.length > 0) {
				for (var k=0; k<props.attributes.dynamic_fields.length; k++) {
					if (props.attributes.dynamic_fields[k].key == 'trigger') {
						enabled = true;
						break;
					}
				}
			}
			if (!enabled) className += ' disabled';
			// console.log(props.attributes);
		}
		
		return [
			el( wp.components.ToolbarButton, {
				className: className,
				label: isEmpty(triggerType) ? __('Trigger wählen', 'greyd_blocks') : __('Trigger anpassen', 'greyd_blocks'),
				icon: el( GreydIcon, { icon: 'external' } ),
				onClick: function() { 
					// console.log("toggle popover");
					setActive(!active);
				},
			} ),
			active && el( wp.components.Popover, {
				className: 'components-greyd-dropdown__content'+(isEmpty(triggerType) || edit ? ' is-edit' : ''),
			}, popoverContent() )
		];

	}

};
