<?php
/*
Plugin Name:    Greyd.Blocks
Description:    Greyd Blocks erweitert die nativen Gutenberg Blocks um die Funktionen der Greyd.Suite. Es enthält zusätzliche Blöcke sowie umfangreiche Erweiterungen für bestehende Blöcke.
Theme URI:      https://greyd.de
Author:         GREYD
Author URI:     https://greyd.de
Version:        1.19.0
Text Domain:    greyd_blocks
Domain Path:    /languages/
*/
namespace greyd\blocks;

if( !defined( 'ABSPATH' ) ) exit;

if ( !defined( 'GREYD_BLOCKS_VERSION' ) ) {
	define( 'GREYD_BLOCKS_VERSION', '1.19.0' );
}

/**
 * Check if Greyd Blocks Features should be loaded based on Version:
 * <= 1.14.0: Features are loaded here
 * >= 1.15.0: Fearures are loaded in greyd_tp_management/greyd-plugin
 */
$hub_version = '0.0.0';
if ( defined( 'GREYD_VERSION' ) ) {
    // check version constant
    $hub_version = GREYD_VERSION;
}
else {
    // check the version manually
    if ( !function_exists( 'get_plugin_data' ) ) {
        require_once ABSPATH.'wp-admin/includes/plugin.php';
    }
    $plugin_data = get_plugin_data( WP_PLUGIN_DIR."/greyd_tp_management/init.php" );
    $hub_version = $plugin_data["Version"];
}
if ( version_compare( $hub_version, '1.14.0', '>' ) ) {
    // abort greyd_blocks - features are loaded in greyd_tp_management/greyd-plugin
    return;
}

// config vars
$config = array(
    'plugin_name_full' => "GREYD.Blocks",
    'plugin_name'      => "greyd_blocks",
    'plugin_file'      => __FILE__,
    'plugin_path'      => __DIR__,
    'update_file'      => 'https://update.greyd.io/public/plugins/greyd_blocks/metadata.json',
    'autoupdate'       => false,
    'required_versions' => array(
        'greyd_suite' => '1.8.0',
        'greyd_hub' => '1.8.0',
        'greyd_forms' => '1.8.0',
    )
);

// add version infos to 'greyd_versions' filter
add_filter( 'greyd_versions', function($versions) use($config) {
    if ( !function_exists('get_plugin_data') ) require_once ABSPATH.'wp-admin/includes/plugin.php';
    $plugin_data = get_plugin_data( $config['plugin_file'] );
    $versions[$config['plugin_name']] = array(
        'version' => $plugin_data['Version'],
        'required' => $config['required_versions']
    );
    return $versions;
} );

// includes
require_once __DIR__.'/manage.php';
require_once __DIR__.'/inc/enqueue.php';
require_once __DIR__.'/inc/deprecated/functions.php';
require_once __DIR__.'/inc/deprecated/icons.php';
require_once __DIR__.'/inc/helper.php';
require_once __DIR__.'/inc/render.php';

// blocks
require_once __DIR__.'/inc/blocks.php';
require_once __DIR__.'/inc/blocks/init.php';
require_once __DIR__.'/inc/block-patterns.php';
// require_once __DIR__.'/inc/deprecated/blocks.php';

// features
require_once __DIR__.'/inc/lottie/init.php';
require_once __DIR__.'/inc/layout/init.php';
require_once __DIR__.'/inc/trigger/init.php';
require_once __DIR__.'/inc/animations/init.php';
require_once __DIR__.'/inc/meta.php';
require_once __DIR__.'/inc/settings.php';
require_once __DIR__.'/extensions/post-export.php';
require_once __DIR__.'/extensions/wpml.php';
require_once __DIR__.'/extensions/woocommerce/blocks.php';