/*
	Comments: Javascript File for Plugin Backend
*/

jQuery( function () {
	forms.init();
} );

var forms = new function () {

	this.debug = false;

	this.init = function () {
		// add some events to the wrapper
		this.addEvents();
	};

	this.addEvents = function () {
		$ = jQuery;

		// WP color picker
		if ( $( 'input.mm-color-picker' ).length > 0 ) {
			setTimeout( function () {
				if ( typeof $.fn.wpColorPicker === "function" ) {
					$( 'input.mm-color-picker' ).wpColorPicker();
				}
				else if ( typeof $.fn.wpColorPickerL10n === "function" ) {
					$( 'input.mm-color-picker' ).wpColorPickerL10n();
				}
			}, 10 );
		}

		// Tab-Bar navigation
		$( ".meta_tab_bar li a" ).on( "click", function ( e ) {
			e.preventDefault();
			forms.meta_set_tab( jQuery( this ).data( "href" ) );
		} );
		// set active tab on load
		//if (window.location.hash.length) forms.meta_set_tab(window.location.hash);

		// update Conditions
		$( 'input[type="checkbox"], input[type="radio"], select' ).on( "change", function ( e ) {
			forms.meta_update_conditions( $( this ) );
		} );

		// toggle multistep-class to body
		if ( $( 'input[type="checkbox"][name="multistep"]' ).prop( 'checked' ) === true )
			$( 'body' ).addClass( 'multistep_form' );
		$( 'input[type="checkbox"][name="multistep"]' ).on( "change", function ( e ) {
			$( 'body' ).toggleClass( 'multistep_form' );
		} );

		// prevent submit for API buttons
		$( 'button.greyd' ).on( "click", function ( e ) { e.preventDefault(); } );


		// TODO: Refactor this
		//----//
		const formModeRadios = document.querySelectorAll( 'input[name="form_mode"]' );
		if ( formModeRadios.length ) {

			const tabs = document.querySelectorAll( '.meta_tab_bar > li' );
			const initialFormMode = document.querySelector( 'input[name="form_mode"]:checked' ).value;

			const formModeOptions = JSON.parse( document.getElementById( 'form_mode_options' ).getAttribute( "data-form-mode-options" ) );
			const visibleInitialTabs = formModeOptions[ initialFormMode ][ 'tabs' ];

			tabs.forEach( tab => {
				const tabName = tab.firstChild.getAttribute( 'data-href' ).replace( "#formsettings_", '' );

				if ( visibleInitialTabs.includes( tabName ) ) {
					tab.firstChild.classList.remove( "hidden" );
				} else {
					tab.firstChild.classList.add( "hidden" );
				}
			} );


			formModeRadios.forEach( radio => {
				radio.addEventListener( 'click', function () {
					const formMode = radio.value;
					const visibleTabs = formModeOptions[ formMode ][ 'tabs' ];
					tabs.forEach( tab => {
						const tabName = tab.firstChild.getAttribute( 'data-href' ).replace( "#formsettings_", '' );

						if ( visibleTabs.includes( tabName ) ) {
							tab.firstChild.classList.remove( "hidden" );
						} else {
							tab.firstChild.classList.add( "hidden" );
						}
					} );
				} );
			} );
		}

		//----//


		// Add all triggers for API fields
		this.api_add_row_trigger( $( 'button.add' ) );
		this.api_remove_row_trigger( $( '.button.remove' ) );
		this.api_update_disabled_options( $( 'select.api_field' ) );


		// Copy Links to clipboard
		$( '.copy-link' ).on( "click", function ( e ) {
			forms.entry_copy_links( $( this ) );
		} );

		this.enableCustomUrls();
	};

	this.meta_set_tab = function ( link ) {
		if ( typeof link !== undefined ) {

			var tab = $( ".meta_tab_bar li a[data-href='" + link + "']" ),
				content = $( ".meta_tab_content " + link );

			if ( !tab.hasClass( 'active' ) ) {
				// show new
				$( ".meta_tab_bar li a.active" ).removeClass( 'active' );
				tab.addClass( 'active' );
				content.css( 'display', 'block' );
				content.siblings().css( 'display', 'none' );
			}
		}
	};

	this.meta_update_conditions = function ( $this ) {
		// not for API fields
		if ( !$this.hasClass( 'api_field' ) ) {

			var name = $this.attr( 'name' ),
				value = $this.val();
			if ( value == name ) // for checkboxes
				value = $this.prop( 'checked' );
			if ( forms.debug ) console.log( name, value );

			$( '*[data-condition]' ).each( function () {
				// `this` is the div
				var dependant = $( this ).attr( 'data-condition' );
				var condition = $( this ).attr( 'data-value' );
				if ( dependant.includes( name ) ) {
					if ( condition.includes( value ) )
						$( this ).prop( 'disabled', false ).removeClass( 'hide' );
					else
						$( this ).prop( 'disabled', true ).addClass( 'hide' );
				}
			} );
		}
	};

	this.entry_copy_links = function ( $this ) {
		var id = $this.attr( 'id' ),
			el = document.getElementById( id ),
			content = $this.data( 'text' ),
			message = $this.data( 'message' ),
			range = document.createRange();
		// get selection
		range.selectNodeContents( el );
		var sel = window.getSelection();
		sel.removeAllRanges();
		sel.addRange( range );
		document.execCommand( 'copy' );

		// add user feedback
		$this.addClass( 'success' ).html( content + "<span>" + message + "</span>" );
		setTimeout( function () {
			$this.removeClass( 'success' ).text( content );
		}, 700 );
	};

	// API META BOX

	// trigger for "add new table row"
	this.api_add_row_trigger = function ( button ) {
		button.on( "click", function ( event ) {
			// get last row
			var tobecloned = $( this ).closest( 'tr' ).prev();
			var code = tobecloned.html();
			var number = parseInt( tobecloned.data( 'index' ) ) + 1;
			// replace attributes
			var newcode = code;
			newcode = newcode.replace( /(\[frm\]\[)\d+(\])/g, "[frm][" + number + "]" );
			newcode = newcode.replace( /(\[api\]\[)\d+(\])/g, "[api][" + number + "]" );
			newcode = newcode.replace( /selected="selected"/g, 'disabled' );
			newcode = "<tr data-index='" + number + "'>" + newcode + "</tr>";
			// get old values
			var old_frm_val = tobecloned.find( 'select.api_field.frm' ).val();
			var old_api_val = tobecloned.find( 'select.api_field.api' ).val();

			// insert new row
			var $new = $( newcode ).insertAfter( tobecloned ).removeClass( 'hide' );
			// disable previous selected options
			$new.find( 'select.api_field.frm option[value="' + old_frm_val + '"]' ).prop( 'disabled', true );
			$new.find( 'select.api_field.api option[value="' + old_api_val + '"]' ).prop( 'disabled', true );
			// enable defaults & custom options
			$new.find( 'option[value="custom"], option[value="bitte wählen"], option[value="none"]' ).prop( 'disabled', false );
			// reset values
			$new.find( '.custom' ).removeClass( 'custom' );
			$new.find( 'input' ).val( '' );
			$new.find( 'select' ).prop( 'selectedIndex', 0 );
			$new.find( '.error_log' ).remove();

			$( 'body' ).trigger( 'api_row_updated', [ $new ] );

			// set append triggers
			forms.api_remove_row_trigger( $new.find( '.button.remove' ) );
			forms.api_update_disabled_options( $new.find( 'select.api_field' ) );
		} );
	};

	// trigger for "remove selected row"
	this.api_remove_row_trigger = function ( button ) {
		button.on( "click", function ( event ) {

			// enabled deleted values in other selects
			$( this ).closest( 'tr' ).find( 'select.api_field' ).each( function () {
				var val = $( this ).val(),
					name = $( this ).attr( 'name' ),
					clss = $( this ).hasClass( 'api' ) ? 'api' : 'frm';
				$( this ).closest( '.inner-table' ).find( 'select.api_field.' + clss + ' option[value="' + val + '"]' ).prop( 'disabled', false );
			} );
			// remove row
			$( this ).closest( 'tr' ).remove();
		} );
	};

	// trigger on select change for "update disabled options"
	this.api_update_disabled_options = function ( select ) {
		// if select clicked
		select.on( 'focus', function () {
			var lastVal = $( this ).val();
			if ( forms.debug ) console.log( "lastVal: " + lastVal );

			// if select changed
			$( this ).on( 'change', function () {
				var val = $( this ).val(),
					name = $( this ).attr( 'name' ),
					clss = $( this ).hasClass( 'api' ) ? 'api' : 'frm';
				if ( forms.debug ) console.log( "val: " + val );

				// if value has changed
				if ( val !== null && val.length > 0 && val !== lastVal ) {
					// remove error from select
					$( this ).closest( 'tr' ).removeClass( 'error' );
					// dis- or enable value in other selects
					$( this ).closest( '.inner-table' ).find( 'select.api_field.' + clss + ':not([name="' + name + '"])' ).each( function () {
						if ( forms.debug ) console.log( $( this ) );
						if ( val !== 'bitte wählen' && val !== 'none' && val !== 'custom' )
							$( this ).find( 'option[value="' + val + '"]' ).prop( 'disabled', true );
						$( this ).find( 'option[value="' + lastVal + '"]' ).prop( 'disabled', false );
					} );
				}
				// show or hide custom select
				if ( select.hasClass( 'smc_type' ) ) {
					if ( val === 'custom' )
						$( this ).addClass( 'custom' );
					else
						$( this ).removeClass( 'custom' );
				}
			} );
		} );
	};

	this.enableCustomUrls = function () {
		$( "select[name=verify_link], select[name=opt_out_link]" ).on( 'input change', function () {
			if ( $( this ).val() == 'custom' ) {
				$( this ).next().removeClass( 'hidden' );
			} else {
				$( this ).next().addClass( 'hidden' );
			}
		} );
	};
};
