/**
 * Form block
 */
( function () {

	// basics
	const {
		blocks,
		element,
		components,
		serverSideRender,
		i18n,
	} = window.wp;
	const el = element.createElement;
	const __ = i18n.__;


	/**
	 * Form block
	 */
	blocks.registerBlockType( 'greyd/form', {
		title: __( "Form", 'greyd_forms' ),
		description: __( "Integrates a form", 'greyd_forms' ),
		icon: typeof greyd.tools.getBlockIcon !== "undefined" ? greyd.tools.getBlockIcon('form') : el( 'img', { src: greyd.data.icon_url + "/block-greyd-form.svg" } ),
		category: 'greyd-blocks',
		// parent: parent_blocks,

		edit: function ( props ) {
			const formId = String( props.attributes.id );
			const formEmpty = props.attributes.id === '';

			/**
			 * Fallbacks for the functions 'getForms' and 'getOptions'
			 * which don't exist if 'Dynamic Templates' feature is deactivated.
			 * Copied from 'greyd-plugin\features\dynamic\assets\js\dynamic.js'
			 * @since 1.14.1
			 */
			const getForms = greyd?.dynamic?.getForms || function(form_id) {
				var __ = wp.i18n.__;
				var options = [ 
					{ value: "", label: __("Select form", 'greyd_hub') },
					...getOptions(greyd.data.forms, form_id)
				];

				// console.log(options);
				return options;
			}
			const getOptions = greyd?.dynamic?.getOptions || function(data, post_id=-1) {
				var __ = wp.i18n.__;
				var parts = { };
				var options = [];
		
				let currentLanguage = greyd.data.language.default;
				if ( !isEmpty( greyd.data.language.post ) ) {
					currentLanguage = _.has(greyd.data.language.post, 'language_code') ? greyd.data.language.post.language_code : greyd.data.language.post;
				}
		
				// sort post list
				var filter = [];
				for ([key, value] of Object.entries(data)) {
					if (greyd.data.post_id == value['id']) continue;
					var language = "default";
					if (has(value, 'lang') && typeof value.lang === 'object' && value.lang.language_code != "") {
						// console.log(value.lang);
						language = value.lang.language_code;
		
						// this post has an original id
						if ( has(value.lang, 'original_id') ) {
							if ( language == currentLanguage ) {
								// this is the correct language, filter the other one out
								filter.push(value.lang['original_id']);
							} else {
								// filter this one out...
								continue;
							}
						}
					}
					if (!has(parts, language)) parts[language] = [];
					parts[language].push( { value: value['id'], label: value['title'] } );
				}
				// console.log(filter);
		
				// make optgroups
				if (!isEmpty(parts)) {
					var part_options = [];
					// make optgroup with language codes
					for ([lang, opts] of Object.entries(parts)) {
						var opts_filtered = [];
						if (filter.length == 0) opts_filtered = opts;
						else {
							for (var i=0; i<opts.length; i++) {
								// console.log(opts[i]);
								if (filter.indexOf(opts[i].value) == -1 || opts[i].value == post_id) {
									opts_filtered.push(opts[i]);
								}
								// else console.log("skipped: "+opts[i].value);
							}
						}
						if (opts_filtered.length > 0) {
							if (lang == 'default') part_options.unshift( ...opts_filtered );
							else part_options.push( { label: lang, options: opts_filtered } );
						}
					}
					if (part_options.length > 0) options.push(...part_options);
				}
		
				// console.log(options);
				return options;
			}
			
			// get all forms grouped by language
			var options_grouped = getForms( props.attributes.id );

			var blockProps = wp.blockEditor.useBlockProps( { id: props.attributes.anchor } );

			return [

				// sidebar
				el( InspectorControls, {}, [
					el( PanelBody, { title: __( "General", 'greyd_forms' ), initialOpen: true }, [
						// choose form
						el( greyd.components.OptionsControl, {
							style: { maxWidth: '100%' },
							value: props.attributes.id,
							options: options_grouped,
							onChange: function ( value ) {
								// console.log(value);
								props.setAttributes( { id: String( value ) } );
							},
						} ),
						// edit form
						!formEmpty && el( wp.components.Button, {
							variant: 'link',
							href: 'post.php?post=' + formId + '&action=edit',
							target: '_blank',
							text: __( "Edit form", 'greyd_forms' )
						} ),
						// replace with translation
						!formEmpty && el( greyd.components.TranslationHint, {
							label: __( "Für das eingebundene Formular wurde eine Übersetzung gefunden", 'greyd_blocks' ) + ": ",
							post_id: formId,
							posts: greyd.data.forms,
							onClick: function ( value ) {
								// console.log("change to "+value);
								props.setAttributes( { id: String( value ) } );
							}
						} )
					] )
				] ),

				// toolbar
				el( wp.blockEditor.BlockControls, {}, [
					// select form
					!formEmpty && el( greyd.components.ToolbarOptionsMenu, {
						className: "show-label",
						label: __( "Select form", 'greyd_forms' ),
						itemAsLabel: true,
						showLabel: true,
						value: formId,
						options: options_grouped,
						onChange: function ( value ) {
							// console.log(value);
							props.setAttributes( { id: String( value ) } );
						},
					} ),
					// edit form
					!formEmpty && el( wp.components.ToolbarGroup, {
						className: 'show-label'
					}, (
						el( wp.components.ToolbarItem, {
							as: wp.components.ToolbarButton,
							label: __( "Edit form", 'greyd_forms' ),
							icon: 'edit',
							onClick: () => {
								window.open( 'post.php?post=' + formId + '&action=edit', '_blank' );
							},
						} )
					) ),
				] ),

				// preview
				el( 'div', { ...blockProps }, [
					formEmpty
					? el( components.Placeholder, {
						// render placeholder
						icon: typeof greyd.tools.getBlockIcon !== "undefined" ? greyd.tools.getBlockIcon('form') : el( 'img', { src: greyd.data.icon_url + "/block-greyd-form.svg" } ),
						label: __( "Select form", 'greyd_forms' ),
						instructions: __( "Select a from from the list or create a new form.", 'greyd_forms' ),
					}, [
						el( wp.components.BaseControl, {}, [
							// choose form
							el( greyd.components.OptionsControl, {
								style: { margin: '0 0 10px', alignSelf: 'center' },
								value: '',
								options: options_grouped,
								onChange: function ( value ) {
									// console.log(value);
									props.setAttributes( { id: String( value ) } );
								},
							} ),
						] ),
						el( "div", {
							style: { margin: '0 10px 10px', alignSelf: 'center' },
						}, __( "or", 'greyd_forms' ) ),
						el( components.Button, {
							className: 'is-secondary',
							style: { margin: '0 0 10px', alignSelf: 'center' },
							onClick: function () { window.open( 'post-new.php?post_type=tp_forms', '_blank' ); },
						}, __( "Create new form", 'greyd_forms' ) )
					] )
					: el( serverSideRender, {
						block: 'greyd/form',
						attributes: { id: formId },
						className: props.className,
						EmptyResponsePlaceholder: () => { return el( 'p', {}, __( "Loading form...", 'greyd_forms' ) ); }
					} ),
				] ),
			];
		},
	} );

} )();

