<?php
/**
 * Register admin menu & dashboard items.
 */
namespace Greyd\Forms;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

new Admin_Menu( $config );
class Admin_Menu {

	private $config;

	function __construct( $config ) {

		// set config
		$this->config = (object) $config;

		// dashboard panel
		add_filter( 'greyd_dashboard_active_panels', array( $this, 'add_greyd_forms_dashboard_panel' ) );
		add_filter( 'greyd_dashboard_panels', array( $this, 'add_greyd_classic_forms_dashboard_panel' ) );

		// adminbar frontend
		add_filter( 'greyd_admin_bar_group', array( $this, 'add_greyd_forms_admin_bar_group_item' ) );
	}

	/**
	 * Add Forms dashboard panel
	 *
	 * @see filter 'greyd_dashboard_active_panels'
	 */
	public function add_greyd_forms_dashboard_panel( $panels ) {
		$panels[ 'greyd-forms' ] = true;
		return $panels;
	}

	/**
	 * Add Forms dashboard panel
	 *
	 * @see filter 'greyd_dashboard_panels'
	 */
	public function add_greyd_classic_forms_dashboard_panel( $panels ) {
		array_push(
			$panels,
			array(
				'icon'     => 'forms',
				'title'    => __( 'Greyd.Forms', 'greyd_hub' ),
				'descr'    => __( 'Erstelle und verwalte individuelle Formulare inkl. Folgeaktionen, Schnittstellen u.v.m.', 'greyd_hub' ),
				'btn'      => array(
					array(
						'text' => __( 'zu den Formularen', 'greyd_hub' ),
						'url'  => admin_url( 'edit.php?post_type=tp_forms' ),
					),
					array(
						'text'  => __( "Settings", 'greyd_hub' ),
						'url'   => admin_url( 'edit.php?post_type=tp_forms&page=greyd_settings_forms' ),
						'class' => 'button button-ghost',
					),
				),
				'cap'      => get_post_type_object( 'tp_forms' ) ? get_post_type_object( 'tp_forms' )->cap->edit_posts : 'edit_posts',
				'priority' => 60,
			)
		);

		return $panels;
	}

	/**
	 * Add Forms items to Greyd.Suite adminbar group.
	 *
	 * @see filter 'greyd_admin_bar_group'
	 */
	public function add_greyd_forms_admin_bar_group_item( $items ) {
		// debug($items);

		// in frontend
		if ( is_admin() ) {
			return $items;
		}

		$cap = get_post_type_object( 'tp_forms' ) ? get_post_type_object( 'tp_forms' )->cap->edit_posts : 'edit_posts';

		if ( ! current_user_can( $cap ) ) {
			return $items;
		}

		$args = array(
			'parent'   => 'greyd_toolbar',
			'id'       => 'forms',
			'title'    => __( "Forms", 'greyd_hub' ),
			'href'     => admin_url( 'edit.php?post_type=tp_forms' ),
			'priority' => 30,
		);
		array_push( $items, $args );

		// submenu
		$parent_slug = 'forms';
		$parent_href = 'edit.php?post_type=tp_forms';

		$args = array(
			'id'     => $parent_slug . '-show',
			'title'  => __( "All forms", 'greyd_hub' ),
			'parent' => $parent_slug,
			'href'   => admin_url( $parent_href ),
		);
		array_push( $items, $args );

		$args = array(
			'id'     => $parent_slug . '-add',
			'title'  => __( "Create", 'greyd_hub' ),
			'parent' => $parent_slug,
			'href'   => admin_url( 'post-new.php?post_type=tp_forms' ),
		);
		array_push( $items, $args );

		$args = array(
			'id'     => $parent_slug . '-entry',
			'title'  => __( "Entries", 'greyd_hub' ),
			'parent' => $parent_slug,
			'href'   => admin_url( $parent_href . '_entry' ),
		);
		array_push( $items, $args );

		$args = array(
			'id'     => $parent_slug . '-export',
			'title'  => __( "Export", 'greyd_hub' ),
			'parent' => $parent_slug,
			'href'   => admin_url( $parent_href . '&page=greyd_forms_export' ),
		);
		array_push( $items, $args );

		if ( current_user_can( 'manage_options' ) ) {
			$args = array(
				'id'     => $parent_slug . '-settings',
				'title'  => __( "Settings", 'greyd_hub' ),
				'parent' => $parent_slug,
				'href'   => admin_url( $parent_href . '&page=greyd_settings_forms' ),
			);
			array_push( $items, $args );
		}

		return $items;
	}
}
