/*
	Comments: Javascript File for Plugin Backend
*/

jQuery( function () {
	vc_forms.init();
} );

var vc_forms = new function () {

	this.debug = false;

	this.init = function () {
		// add some events to the wrapper
		this.addEvents();
	};

	this.addEvents = function () {
		$ = jQuery;

		// call vc_edit functions after page is setup
		setTimeout( function () {
			$( 'a#vc_form_conditional' ).on( "click", function () {
				setTimeout( function () { vc_forms.vc_edit_trigger(); }, 0 );
			} );
			vc_forms.vc_edit_trigger();
		}, 0 );
	};

	// CONDITIONAL FIELDS VISUAL COMPOSER

	/* Overwrite tt-tabs functionality for conditional fields
			source:
				js_composer/assets/js/dist/backend.min.js
				line (if beautified): 5613
			initial function:
				window.VcBackendTtaViewInterface.prototype.vc_add_section();

			further explanation:
			 - timeouts to wait for the small time-difference js_composer needs to create html-elements
			 - with vc_edit_trigger() the class needed for the default tt-tabs trigger is deleted
			 - the old class is set to "display:none" via backend.css to prevent errors
			 - on the new class, the vc.shortcodes.create function is triggered with the specific params
	*/
	this.vc_trigger;
	this.vc_edit_trigger = function () {
		vc_forms.vc_trigger = $( '.wpb_vc_form_conditional .vc_tta-section-append' );
		vc_forms.vc_trigger.removeClass( 'vc_tta-section-append' ).addClass( 'vc_form_condition-append' );
		vc_forms.vc_trigger.on( "click", function ( e ) {
			e.preventDefault();
			var newTabTitle, params;
			newTabTitle = forms_wordings.new_condition;
			params = {
				shortcode: "vc_form_condition",
				params: {
					title: forms_wordings.new_condition
				},
				parent_id: $( this ).closest( '.wpb_vc_form_conditional' ).data( 'model-id' ),
				order: vc.shortcodes.getNextOrder(),
				prepend: undefined
			};
			vc.shortcodes.create( params );
			if ( vc_forms.debug ) console.log( 'new condition' );
		} );
	};
};


function vc_add_section( $this = {} ) {
	var newTabTitle, params;
	return newTabTitle = forms_wordings.new_condition, params = {
		shortcode: "vc_form_condition",
		params: {
			title: forms_wordings.new_condition
		},
		parent_id: $this.closest( 'vc_form_conditional' ).data( 'model-id' ),
		order: vc.shortcodes.getNextOrder(),
		prepend: undefined
	}, vc.shortcodes.create( params ), console.log( params );
}
