
jQuery( function ( $ ) {
	if ( typeof $ === 'undefined' ) $ = jQuery;

	console.log( "VC Forms Scripts: loaded" );

	vc_forms.init();
} );

var vc_forms = new function () {

	this.init = function () {

		$( ".form_tag" ).on( "click", function () {
			// vc_forms.insertTagText(this);
		} );

		this.highlightRequiredFields();
	};

	this.insertTagText = function ( elem ) {
		var wrapper = $( elem ).closest( ".vc_shortcode-param" );
		var tag = String( $( elem ).text() );

		// normal textarea
		if ( wrapper.data( "param_type" ) !== "textarea_html" ) {

			var input = wrapper.find( '.wpb_vc_param_value' );
			var val = input.val();
			var selStart = input.prop( 'selectionStart' );
			var selEnd = input.prop( 'selectionEnd' );

			// input hasn't been touched yet
			if ( selStart === 0 && selEnd === 0 ) {
				input.val( val == '' ? tag : val + ' ' + tag );
			}
			else {
				var textBefore = val.substring( 0, selStart );
				var textAfter = val.substring( selEnd, val.length );
				if ( tag.indexOf( "(" ) > 0 ) {
					var textSel = val.substring( selStart, selEnd );
					var explode = tag.split( "(" );
					tag = explode[ 0 ] + "(" + textSel + explode[ 1 ];
				}
				input.val( textBefore + tag + textAfter );
			}
		}

		// tinyMCE
		else {
			// default vc tinymce editor
			if ( typeof tinyMCE !== 'undefined' && typeof tinyMCE.editors !== 'undefined' && typeof tinyMCE.editors.wpb_tinymce_content !== 'undefined' ) {
				var elem = tinyMCE.editors.wpb_tinymce_content;
				var val = elem.getContent();
				var newval = val == '' ? tag : val + ' ' + tag;
				elem.setContent( newval );
			}
			else {
				var tmce_wrapper = container.children( '.wp-editor-wrap' );
				// dynamic content tinymce editor
				if ( tmce_wrapper.length > 0 && tmce_wrapper.hasClass( 'tmce-active' ) ) {
					var switch_html = tmce_wrapper.find( 'button.switch-html' );
					var switch_tmce = tmce_wrapper.find( 'button.switch-tmce' );
					switch_html.trigger( 'click' );
				}
				var elem = container.find( 'textarea' );
				var val = elem.val();
				var newval = val == '' ? tag : ( val.match( /.*\<\/\p\>$/ ) ? val.replace( /\<\/\p\>$/, ' ' + tag + '</p>' ) : val + ' ' + tag );
				elem.val( newval );
				elem.trigger( "change" );
				if ( typeof switch_tmce !== 'undefined' ) switch_tmce.trigger( 'click' );
			}
		}
	};

	/**
	 * Highlight required backend fields
	 */
	this.highlightRequiredFields = function () {
		$( ".vc_shortcode-param.required input" ).each( function () {
			if ( $( this ).val().length === 0 ) {
				$( this ).addClass( "error" );
			}
			$( this ).on( "input change", function () {
				if ( $( this ).val().length === 0 ) {
					$( this ).addClass( "error" );
				}
				else {
					$( this ).removeClass( "error" );
				}
			} );
		} );
	};
};