<?php
/**
 * Visual Composer Modules
 *
 * @deprecated since greyd_blocks
 */
namespace Greyd\Forms;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

new Composer( $config );
class Composer {

	/**
	 * Plugin config
	 */
	private $config;

	/**
	 * Module prefix
	 */
	private $pre = 'vc_form_';

	/**
	 * Module base weight
	 */
	private $weight = 50;

	/**
	 * Module category
	 */
	private $category = 'Form Elements';

	/**
	 * Hold all the input fields of the current form
	 */
	private $inputs = null;

	/**
	 * Holds all the form module shortcodes
	 */
	private $shortcodes = array(
		'input',
		'button',
		'checkbox',
		'radio',
		'icon_panels',
		'icon_panel',
		'condition',
		'dropdown',
		'info',
		'upload',
		'captcha',
		'hidden',
		'conditional',
		'condition',
		'button_steps',
		'range',
		'math',
	);


	/**
	 * =================================================================
	 *                          SETUP
	 * =================================================================
	 */

	/**
	 * Construct the class
	 */
	public function __construct( $config ) {

		// set config
		$this->config = (object) $config;

		add_action( 'after_setup_theme', array( $this, 'init' ) );
	}

	/**
	 * Add actions & filter
	 */
	public function init() {

		if (
			! is_admin() ||
			! class_exists( '\vc\helper' ) ||
			! \vc\helper::is_active_plugin( 'js_composer/js_composer.php' )
		) {
			return;
		}

		// add vc roles
		add_filter( 'greyd_add_vc_posttypes', array( $this, 'add_vc_roles' ) );

		// add modules
		add_action( 'vc_before_init', array( $this, 'add_form_module' ) );
		add_action( 'vc_before_init', array( $this, 'add_input_modules' ) );

		// add controls
		add_action( 'vc_before_init', array( $this, 'add_custom_controls' ) );

		// modify modules
		add_action( 'admin_notices', array( $this, 'remove_modules_by_posttype' ) );
		add_action( 'vc_frontend_editor_hook_load_edit', array( $this, 'remove_modules_by_posttype' ) );
		add_action( 'vc_after_init', array( $this, 'mod_default_modules' ) );
	}

	/**
	 * Add vc roles
	 */
	public function add_vc_roles( $rules = array() ) {
		return array_merge( $rules, array( $this->config->plugin_post_type ) );
	}

	/**
	 * Add general module for shortcode 'vc_form'
	 */
	public function add_form_module() {
		// return if vc is not installed
		if ( ! is_callable( 'vc_map' ) ) {
			return;
		}

		// make some vars
		$this->category = __( "Content", 'greyd_forms' );

		// get all forms
		$forms    = Helper::get_all_forms( array( 0 => __( "please select", 'greyd_forms' ) ) );
		$vc_forms = array();
		if ( ! empty( $forms ) ) {
			foreach ( $forms as $id => $title ) {
				$vc_forms[] = array( $id, $title );
			}
		}

		// add control for buttons to form
		vc_add_shortcode_param(
			'link_button',
			function ( $settings, $value ) {
				$param  = esc_attr( $settings['param_name'] );
				$return = "<input type='hidden' name='$param' class='wpb_vc_param_value $param' value='$value' />" .
				'<div class="wpb_element_label">&nbsp;</div>';

				if ( ! empty( $settings['link'] ) ) {
					$link    = $settings['link'];
					$text    = ! empty( $settings['text'] ) ? $settings['text'] : sprintf( __( "Edit %s", 'greyd_forms' ), __( "Form", 'greyd_forms' ) );
					$return .= '<a class="button" href="' . $link . '" target="_blank" style="padding: 7px 23px;font-size:14px">' .
								$text .
								'<span class="dashicons dashicons-external" style="margin-left: 6px;font-size: 1.7em;height: 1em;width: 1em;"></span>' .
							'</a>';
					return $return;
				}
			}
		);

		// make visual composer modul for shortcode 'vc_form'
		$vc = array(
			'name'        => __( "Form", 'greyd_forms' ),
			'description' => __( "Integrates a form", 'greyd_forms' ),
			'base'        => 'vc_form',
			'category'    => $this->category,
			'icon'        => plugins_url( '../assets/icon/forms.svg', __FILE__ ),
			'js_view'     => 'VcFormsView',
			'params'      => array(
				// make attributes/vc-params
				array(
					'type'       => 'seperator',
					'heading'    => __( "Form", 'greyd_forms' ),
					'param_name' => 'seperator_form',
				),
				// dynamic id
				array(
					'type'             => 'dynamic',
					'param_name'       => 'dynamic_id',
					'heading'          => __( "Type", 'greyd_forms' ),
					'text'             => __( "By making content from modules in templates dynamic, you can fill them later in a page. This allows you to use the template in different places with different content.", 'greyd_forms' ),
					'value'            => 'static',
					'params'           => array(
						'type'  => 'dropdown_forms',
						'field' => 'id',
					),
					'edit_field_class' => 'vc_col-xs-12',
				),
				array(
					'type'             => 'dropdown',
					'heading'          => __( "Form", 'greyd_forms' ),
					'description'      => __( "Choose a form to insert. You can create forms on the left under \"Forms\".", 'greyd_forms' ),
					'param_name'       => 'id',
					'edit_field_class' => 'vc_col-xs-6',
					'admin_label'      => true,
					'value'            => $vc_forms,
				),
			),
		);

		// add all buttons to forms
		if ( count( $forms ) > 0 ) {
			foreach ( $forms as $id => $title ) {

				$name       = 'create_form';
				$link       = admin_url( 'post-new.php?post_type=tp_forms' );
				$text       = sprintf( __( "Create %s", 'greyd_forms' ), __( "Form", 'greyd_forms' ) );
				$dependency = array(
					'element' => 'id',
					'value'   => '0',
				);

				if ( ! empty( $id ) ) {
					$id   = strval( $id );
					$name = 'to_form_' . $id;
					$link = get_edit_post_link( $id );

					$text  = sprintf( __( "Edit %s", 'greyd_forms' ), "'%s'" );
					$title = strlen( $title ) > 20 ? trim( substr( $title, 0, 17 ) ) . '...' : $title;
					$text  = sprintf( $text, $title );

					$dependency = array(
						'element' => 'id',
						'value'   => strval( $id ),
					);
				}

				$vc['params'][] = array(
					'type'             => 'link_button',
					'link'             => $link,
					'text'             => $text,
					'param_name'       => $name,
					'edit_field_class' => 'vc_col-xs-6',
					'dependency'       => $dependency,
				);
			}
		}

		vc_map( $vc );

	}


	/**
	 * =================================================================
	 *                          ADD MODULES
	 * =================================================================
	 */

	/**
	 * Add modules inside form posttype
	 */
	public function add_input_modules() {

		// return if vc is not installed
		if ( ! is_callable( 'vc_map' ) ) {
			return;
		}

		// Set Class vars
		$this->category = __( "Form elements", 'greyd_forms' );
		$this->weight   = 50;
		$this->inputs   = array_merge(
			array(
				__( "please select", 'greyd_forms' ),
			),
			(
				isset( $_POST['post_id'] ) ? Helper::get_all_input_names( $_POST['post_id'] ) : array()
			)
		);

		/**
		 * Add the modules
		 */

		// top
		$this->input_module();
		$this->checkbox_module();
		$this->dropdown_module();
		$this->radio_module();
		$this->icon_panel_module();

		// middle
		$this->range_module();
		$this->upload_module();
		$this->conditions_module();
		$this->captcha_module();
		$this->hidden_field_module();
		$this->math_module();

		// bottom
		$this->button_steps_module();
		$this->submit_button_module();

		// deprecated
		$this->deprecated_modules();
	}

	/**
	 * Input
	 *
	 * @shortcode 'vc_form_input'
	 */
	public function input_module() {
		vc_map(
			array(
				'name'        => __( "Input field", 'greyd_forms' ),
				'description' => __( "For entering text, email, date, number...", 'greyd_forms' ),
				'base'        => $this->pre . 'input',
				'category'    => $this->category,
				'weight'      => $this->weight,
				'icon'        => plugins_url( '../assets/icon/forms_input.svg', __FILE__ ),
				'params'      => array_merge(
					array(

						// Überschrift
						array(
							'type'       => 'seperator',
							'heading'    => __( "General", 'greyd_forms' ),
							'param_name' => 'seperator_title',
							'weight'     => 10,
						),

						// Type
						array(
							'type'             => 'dropdown',
							'heading'          => __( "Field type", 'greyd_forms' ),
							'description'      => __( "What should the user enter here?", 'greyd_forms' ),
							'param_name'       => 'type',
							'edit_field_class' => 'vc_col-xs-6',
							'value'            => array(
								_x( "text", 'small', 'greyd_forms' ) => 'text',
								_x( "email", 'small', 'greyd_forms' ) => 'email',
								_x( "phone number", 'small', 'greyd_forms' ) => 'tel',
								_x( "link", 'small', 'greyd_forms' ) => 'url',
								_x( "number", 'small', 'greyd_forms' ) => 'number',
								'------' => '',
								_x( "time", 'small', 'greyd_forms' ) => 'time',
								_x( "date", 'small', 'greyd_forms' ) => 'date',
								_x( "date & time", 'small', 'greyd_forms' ) => 'datetime-local',
								_x( "week", 'small', 'greyd_forms' ) => 'week',
								_x( "month", 'small', 'greyd_forms' ) => 'month',
							),
							'weight'           => 9,
						),

						// Required
						array(
							'type'             => 'checkbox',
							'heading'          => __( "Required field", 'greyd_forms' ),
							'description'      => __( "The user must fill in this field.", 'greyd_forms' ),
							'param_name'       => 'required',
							'admin_label'      => true,
							'edit_field_class' => 'vc_col-xs-6',
							'weight'           => 8,
							'value'            => array(
								_x( "Yes", 'small', 'greyd_forms' )   => 'true',
							),
						),

						// Unterüberschrift
						array(
							'type'       => 'seperator',
							'heading'    => __( "Labeling", 'greyd_forms' ),
							'param_name' => 'seperator_naming',
						),

						// Label
						array(
							'type'             => 'textfield',
							'heading'          => __( 'Label', 'greyd_forms' ),
							'description'      => __( "Displayed above the field.", 'greyd_forms' ),
							'param_name'       => 'label',
							'edit_field_class' => 'vc_col-xs-6',
							'admin_label'      => true,
						),

						// Name
						array(
							'type'             => 'textfield',
							'heading'          => __( "Field name", 'greyd_forms' ),
							'description'      => __( "Unique value of the field that is passed with the form.", 'greyd_forms' ),
							'param_name'       => 'name',
							'edit_field_class' => 'vc_col-xs-6 required',
							'admin_label'      => true,
						),

						// Placeholder
						array(
							'type'             => 'textfield',
							'heading'          => __( "Placeholder", 'greyd_forms' ),
							'description'      => __( "Placeholder text in the input field. (default: please select)", 'greyd_forms' ),
							'param_name'       => 'placeholder',
							'edit_field_class' => 'vc_col-xs-6',
							'dependency'       => array(
								'element' => 'type',
								'value'   => array( 'text', 'email', 'tel', 'url', 'number' ),
							),
						),

						// Autocomplete
						array(
							'type'             => 'dropdown',
							'heading'          => __( 'AutoFill', 'greyd_forms' ),
							'description'      => __( "Helps the user fill in with automatic suggestions.", 'greyd_forms' ),
							'param_name'       => 'autocomplete',
							'edit_field_class' => 'vc_col-xs-6',
							'value'            => array(
								_x( "automatically", 'small', 'greyd_forms' ) => 'on',
								_x( "off", 'small', 'greyd_forms' ) => 'off',
								'------' => '',
								_x( "name", 'small', 'greyd_forms' ) => 'name',
								_x( "first name", 'small', 'greyd_forms' ) => 'given-name',
								_x( "last name", 'small', 'greyd_forms' ) => 'family-name',
								_x( "email", 'small', 'greyd_forms' ) => 'email',
								_x( "phone number", 'small', 'greyd_forms' ) => 'tel',
								_x( "street & house number", 'small', 'greyd_forms' ) => 'street-address',
								_x( "zip code", 'small', 'greyd_forms' ) => 'postal-code',
								_x( "city", 'small', 'greyd_forms' ) => 'address-level2',
								_x( "country", 'small', 'greyd_forms' ) => 'country-name',
								_x( "country abbreviation", 'small', 'greyd_forms' ) . ' ' . __( "(e.g. DE)", 'greyd_forms' ) => 'country',
							),
						),

						// Hilfetext
						array(
							'type'             => 'textarea',
							'heading'          => __( "Tooltip", 'greyd_forms' ),
							'description'      => __( "This text can be accessed via an info icon as a help and explains to the user the special features of the field (e.g. that an email field must contain an @-character.", 'greyd_forms' ),
							'param_name'       => 'tooltip',
							'edit_field_class' => 'vc_col-xs-9',
							'dependency'       => array(
								'element'   => 'label',
								'not_empty' => true,
							),
						),

						// Unterüberschrift
						array(
							'type'       => 'seperator',
							'heading'    => __( "Characters & columns", 'greyd_forms' ),
							'param_name' => 'seperator_chars',
						),

						// Zeichenanzahl (min)
						array(
							'type'             => 'textfield',
							'heading'          => __( "Min. characters", 'greyd_forms' ),
							'description'      => __( "How many characters must be entered at least?", 'greyd_forms' ),
							'param_name'       => 'minlength',
							'edit_field_class' => 'vc_col-xs-6',
							'dependency'       => array(
								'element' => 'type',
								'value'   => array( 'text', 'email', 'tel', 'url' ),
							),
						),

						// Zeichenanzahl (max)
						array(
							'type'             => 'textfield',
							'heading'          => __( "Max. characters", 'greyd_forms' ),
							'description'      => __( "How many characters can be entered? (default: unlimited)", 'greyd_forms' ),
							'param_name'       => 'maxlength',
							'edit_field_class' => 'vc_col-xs-6',
							'dependency'       => array(
								'element' => 'type',
								'value'   => array( 'text', 'email', 'tel', 'url' ),
							),
						),

						// min value (number only)
						array(
							'type'             => 'textfield',
							'heading'          => __( "Minimum value", 'greyd_forms' ),
							// 'description' => __('Welchen Wert soll die eingegebene Zahl mindestens haben?', 'greyd_forms'),
							'param_name'       => 'min',
							'edit_field_class' => 'vc_col-xs-4',
							'dependency'       => array(
								'element' => 'type',
								'value'   => array( 'number', 'time', 'date', 'datetime-local', 'week', 'month' ),
							),
						),

						// max value (number only)
						array(
							'type'             => 'textfield',
							'heading'          => __( "Maximum value", 'greyd_forms' ),
							// 'description' => __('Welchen Wert darf die eingegebene Zahl maximal haben? (Standard: unbegrenzt)', 'greyd_forms'),
							'param_name'       => 'max',
							'edit_field_class' => 'vc_col-xs-4',
							'dependency'       => array(
								'element' => 'type',
								'value'   => array( 'number', 'time', 'date', 'datetime-local', 'week', 'month' ),
							),
						),

						// start value (number only)
						array(
							'type'             => 'textfield',
							'heading'          => __( "Start value", 'greyd_forms' ),
							'param_name'       => 'start',
							'edit_field_class' => 'vc_col-xs-4',
							'dependency'       => array(
								'element' => 'type',
								'value'   => array( 'number', 'time', 'date', 'datetime-local', 'week', 'month' ),
							),
						),

						array(
							'type'             => 'info_text',
							'param_name'       => 'format_info',
							'text'             => __( "For the minimum & maximum values of time data, certain formats must be adhered to:", 'greyd_forms' ) .
								'<br><b>' . __( "time", 'greyd_forms' ) . '</b>: „18:00“,
							&nbsp;<b>' . __( "date", 'greyd_forms' ) . '</b>: „2020-12-31“,
							&nbsp;<b>' . __( "date & time", 'greyd_forms' ) . '</b>: „2020-12-31T18:00“,
							&nbsp;<b>' . __( "week", 'greyd_forms' ) . '</b>: „2020-W52“,
							&nbsp;<b>' . __( "month", 'greyd_forms' ) . '</b>: „2020-12“',
							'styling'          => 'info',
							'edit_field_class' => 'vc_col-xs-12',
							'dependency'       => array(
								'element' => 'type',
								'value'   => array( 'time', 'date', 'datetime-local', 'week', 'month' ),
							),
						),

						// step (number only)
						array(
							'type'             => 'textfield',
							'heading'          => __( "Steps", 'greyd_forms' ),
							'description'      => __( "How exactly should the value be specified (e.g.: '0.1' means a decimal place)? (default: 1)", 'greyd_forms' ),
							'param_name'       => 'steps',
							'edit_field_class' => 'vc_col-xs-6',
							'dependency'       => array(
								'element' => 'type',
								'value'   => 'number',
							),
						),

						// Mehrzeilig?
						array(
							'type'             => 'checkbox',
							'heading'          => __( "Multi-line", 'greyd_forms' ),
							'description'      => __( "For text input only.", 'greyd_forms' ),
							'param_name'       => 'area',
							'edit_field_class' => 'vc_col-xs-6',
							'value'            => array(
								_x( "Yes", 'small', 'greyd_forms' )   => 'true',
							),
							'dependency'       => array(
								'element' => 'type',
								'value'   => 'text',
							),
						),

						// Rows
						array(
							'type'             => 'textfield',
							'heading'          => __( "Height", 'greyd_forms' ),
							'description'      => __( "Number of rows displayed. (default: 5, max. 15)", 'greyd_forms' ),
							'param_name'       => 'rows',
							'edit_field_class' => 'vc_col-xs-6',
							'dependency'       => array(
								'element' => 'area',
								'value'   => 'true',
							),
						),
					),
					// layout options
					array(
						// layout options
						array(
							'type'       => 'seperator',
							'heading'    => __( "Appearance", 'greyd_forms' ),
							'param_name' => 'seperator_layout',
						),
						// alignment
						array(
							'type'             => 'dropdown',
							'heading'          => __( "Alignment", 'greyd_forms' ),
							'param_name'       => 'alignment',
							'edit_field_class' => 'vc_col-xs-4',
							'value'            => array(
								_x( "left", 'small', 'greyd_forms' ) => 'left',
								_x( "center", 'small', 'greyd_forms' ) => 'center',
								_x( "right", 'small', 'greyd_forms' ) => 'right',
							),
						),
						// width
						array(
							'type'             => 'textfield',
							'heading'          => __( "Width", 'greyd_forms' ),
							'description'      => __( "in px or %", 'greyd_forms' ),
							'param_name'       => 'width',
							'edit_field_class' => 'vc_col-xs-4',
						),
						// // Größe
						// array(
						// "type"          => "dropdown",
						// "heading"       => __("Size", 'greyd_forms'),
						// "description"   => __('Hier können Sie die Größe des Eingabefeldes auswählen', 'greyd_forms'),
						// "param_name"    => "size",
						// 'admin_label'   =>  true,
						// 'edit_field_class' => 'vc_col-xs-4',
						// "value"         => array(
						// __("default", 'greyd_forms') => '',
						// __("big", 'greyd_forms') => '_big',
						// ),
						// ),

						array(
							'type'       => 'new_line',
							'param_name' => 'new_line_type',
						),
						// type
						array(
							'type'             => 'dropdown',
							'heading'          => __( "Appearance", 'greyd_forms' ),
							'description'      => __( "What should the field look like?", 'greyd_forms' ),
							'param_name'       => 'style',
							'edit_field_class' => 'vc_col-xs-4',
							'admin_label'      => true,
							'value'            => array(
								_x( "primary field", 'small', 'greyd_forms' ) => '',
								_x( "secondary field", 'small', 'greyd_forms' ) => 'sec',
								_x( "overwrite individually", 'small', 'greyd_forms' ) => 'custom',
							),
						),

					),
					// merge with helper array for custom element
					\vc\helper::custom_element_params_vc( 'input', 'style', 'custom' ),
					// Label Options
					array(
						array(
							'type'       => 'sub_seperator',
							'heading'    => __( 'Label', 'greyd_forms' ),
							'param_name' => 'seperator_label',
						),
						// font-size
						array(
							'type'             => 'textfield',
							'heading'          => __( "Font size", 'greyd_forms' ),
							'description'      => __( "in px or em", 'greyd_forms' ),
							'param_name'       => 'label_font_size',
							'edit_field_class' => 'vc_col-xs-4',
						),
					),
					// Design Tab
					array(
						array(
							'type'       => 'css_editor',
							'heading'    => __( "CSS", 'greyd_forms' ),
							'param_name' => 'css',
							'group'      => __( "Design settings", 'greyd_forms' ),
						),
					)
				),
			)
		);
	}

	/**
	 * Checkbox
	 *
	 * @shortcode 'vc_form_checkbox'
	 */
	public function checkbox_module() {
		vc_map(
			array(
				'name'        => __( "checkbox", 'greyd_forms' ),
				'description' => __( "Single selection field for hooking", 'greyd_forms' ),
				'base'        => $this->pre . 'checkbox',
				'category'    => $this->category,
				'weight'      => $this->weight,
				'icon'        => plugins_url( '../assets/icon/forms_check.svg', __FILE__ ),
				'params'      => array(

					// // Überschrift
					// array(
					// "type"        => 'seperator',
					// "heading"     => __("General", 'greyd_forms'),
					// "param_name"  => 'seperator_title',
					// ),

					// AGB?
					array(
						'type'             => 'dropdown',
						'heading'          => __( "Content", 'greyd_forms' ),
						// 'description' => __('wie soll der Inhalt definiert werden?', 'greyd_forms'),
						'param_name'       => 'is_agb',
						'edit_field_class' => 'vc_col-xs-6',
						'admin_label'      => true,
						'value'            => array(
							_x( "enter text", 'small', 'greyd_forms' ) => 'default',
							_x( "use default privacy text", 'small', 'greyd_forms' ) => 'agb',
						),
					),

					array(
						'type'             => 'info_text',
						'param_name'       => 'sfmc_privacy_info',
						'text'             => __( "The default privacy text is defined at Forms > Settings.", 'greyd_forms' ),
						'styling'          => 'info',
						'edit_field_class' => 'vc_col-xs-12',
						'dependency'       => array(
							'element' => 'is_agb',
							'value'   => 'agb',
						),
					),

					// Inhalt
					array(
						'type'             => 'textarea_html',
						'heading'          => __( "text", 'greyd_forms' ),
						'description'      => __( "What should be next to the checkbox?", 'greyd_forms' ),
						'param_name'       => 'content',
						'edit_field_class' => 'vc_col-xs-12',
						'admin_label'      => true,
						'dependency'       => array(
							'element' => 'is_agb',
							'value'   => 'default',
						),
					),

					// Name
					array(
						'type'             => 'textfield',
						'heading'          => __( "Field name", 'greyd_forms' ),
						'description'      => __( "Unique value of the field that is passed with the form.", 'greyd_forms' ),
						'param_name'       => 'name',
						'edit_field_class' => 'vc_col-xs-6 required',
						'admin_label'      => true,
					),

					// Darstellung
					array(
						'type'             => 'dropdown',
						'heading'          => __( "Appearance", 'greyd_forms' ),
						'description'      => __( "What should the field look like?", 'greyd_forms' ),
						'param_name'       => 'style',
						'edit_field_class' => 'vc_col-xs-3',
						'value'            => array(
							_x( "checkbox", 'small', 'greyd_forms' )       => '_checkbox',
							_x( "radio button", 'small', 'greyd_forms' )   => 'radio',
							_x( "iOS switch", 'small', 'greyd_forms' )     => 'switch',
						),
					),

					// Required
					array(
						'type'             => 'checkbox',
						'heading'          => __( "Required field", 'greyd_forms' ),
						'description'      => __( "The user must fill in this field.", 'greyd_forms' ),
						'param_name'       => 'required',
						'edit_field_class' => 'vc_col-xs-3',
						'admin_label'      => true,
						'value'            => array(
							_x( "Yes", 'small', 'greyd_forms' ) => 'true',
						),
					),

					// Prechecked
					array(
						'type'       => 'checkbox',
						'heading'    => __( "State", 'greyd_forms' ),
						'param_name' => 'prechecked',
						// 'edit_field_class' => 'vc_col-xs-6',
						'value'      => array(
							__( "Pre-checked on load", 'greyd_forms' ) => 'yes',
						),
					),

					// Unter-Überschrift
					array(
						'type'       => 'seperator',
						'heading'    => __( "Appearance", 'greyd_forms' ),
						'param_name' => 'seperator_naming',
					),

					// iOS Switch Color
					array(
						'type'             => 'colorselect',
						'heading'          => __( "Switch color", 'greyd_forms' ),
						'description'      => __( "Normal color of the iOS switch.", 'greyd_forms' ),
						'param_name'       => 'switch_color',
						'value'            => 'color_22',
						'edit_field_class' => 'vc_col-xs-6',
						'dependency'       => array(
							'element' => 'style',
							'value'   => 'switch',
						),
					),

					// iOS Switch Color (aktiv)
					array(
						'type'             => 'colorselect',
						'heading'          => __( "Switch color (active)", 'greyd_forms' ),
						'description'      => __( "Color of the iOS switch when active.", 'greyd_forms' ),
						'param_name'       => 'switch_color_selected',
						'value'            => 'color_13',
						'edit_field_class' => 'vc_col-xs-6',
						'dependency'       => array(
							'element' => 'style',
							'value'   => 'switch',
						),
					),

					// Abstand zu Checkbox
					array(
						'type'             => 'textfield',
						'heading'          => __( "Space", 'greyd_forms' ),
						'description'      => __( "Space between checkbox and text. (Unit: in px or %)", 'greyd_forms' ),
						'param_name'       => 'marginleft',
						'edit_field_class' => 'vc_col-xs-4',
					),

					// Font-size
					array(
						'type'             => 'textfield',
						'heading'          => __( "Font size", 'greyd_forms' ),
						'description'      => __( "in px or em", 'greyd_forms' ),
						'param_name'       => 'fontsize',
						'edit_field_class' => 'vc_col-xs-4',
					),

					// Line-height
					array(
						'type'             => 'textfield',
						'heading'          => __( "Line height", 'greyd_forms' ),
						'description'      => __( "in px, em or %", 'greyd_forms' ),
						'param_name'       => 'lineheight',
						'edit_field_class' => 'vc_col-xs-4',
					),

					// Textfarbe
					array(
						'type'       => 'colorselect',
						'heading'    => __( "Font color", 'greyd_forms' ),
						'param_name' => 'textcolor',
					),

					// Design Tab
					array(
						'type'       => 'css_editor',
						'heading'    => __( "CSS", 'greyd_forms' ),
						'param_name' => 'css',
						'group'      => __( "Design settings", 'greyd_forms' ),
					),
				),
			)
		);
	}

	/**
	 * Dropdown
	 *
	 * @shortcode 'vc_form_dropdown'
	 */
	public function dropdown_module() {
		vc_map(
			array(
				'name'        => __( 'Dropdown', 'greyd_forms' ),
				'description' => __( "Selection from a list", 'greyd_forms' ),
				'base'        => $this->pre . 'dropdown',
				'category'    => $this->category,
				'weight'      => $this->weight,
				'icon'        => plugins_url( '../assets/icon/forms_dropdown.svg', __FILE__ ),
				'params'      => array_merge(
					array(

						// Überschrift
						array(
							'type'       => 'seperator',
							'heading'    => __( "General", 'greyd_forms' ),
							'param_name' => 'seperator_title',
						),

						// Multiselect
						array(
							'type'             => 'checkbox',
							'heading'          => __( "Enable multiselect", 'greyd_forms' ),
							'description'      => __( "The user can select multiple options.", 'greyd_forms' ),
							'param_name'       => 'multiselect',
							'admin_label'      => true,
							'edit_field_class' => 'vc_col-xs-4',
							'value'            => array(
								_x( "Yes", 'small', 'greyd_forms' )   => 'true',
							),
						),

						// Required
						array(
							'type'             => 'checkbox',
							'heading'          => __( "Required field", 'greyd_forms' ),
							'description'      => __( "The user must fill in this field.", 'greyd_forms' ),
							'param_name'       => 'required',
							'admin_label'      => true,
							'edit_field_class' => 'vc_col-xs-4',
							'value'            => array(
								_x( "Yes", 'small', 'greyd_forms' )   => 'true',
							),
						),

						// Unter-Überschrift
						array(
							'type'       => 'seperator',
							'heading'    => __( "Labeling", 'greyd_forms' ),
							'param_name' => 'seperator_naming',
						),

						// Label
						array(
							'type'             => 'textfield',
							'heading'          => __( 'Label', 'greyd_forms' ),
							'description'      => __( "Displayed above the field.", 'greyd_forms' ),
							'param_name'       => 'label',
							'edit_field_class' => 'vc_col-xs-6',
							'admin_label'      => true,
						),

						// Name
						array(
							'type'             => 'textfield',
							'heading'          => __( "Field name", 'greyd_forms' ),
							'description'      => __( "Unique value of the field that is passed with the form.", 'greyd_forms' ),
							'param_name'       => 'name',
							'edit_field_class' => 'vc_col-xs-6 required',
							'admin_label'      => true,
						),

						// Placeholder
						array(
							'type'             => 'textfield',
							'heading'          => __( "Placeholder", 'greyd_forms' ),
							'description'      => __( "Placeholder text in the input field. (default: please select)", 'greyd_forms' ),
							'param_name'       => 'placeholder',
							'edit_field_class' => 'vc_col-xs-6',
						),

						// Hilfetext
						array(
							'type'             => 'textarea',
							'heading'          => __( "Tooltip", 'greyd_forms' ),
							'description'      => __( "This text is available for assistance via an info icon and may contain additional explanations.", 'greyd_forms' ),
							'param_name'       => 'tooltip',
							'edit_field_class' => 'vc_col-xs-9',
							'dependency'       => array(
								'element'   => 'label',
								'not_empty' => true,
							),
						),
					),
					$this->make_options(),
					array(
						// layout options
						array(
							'type'       => 'seperator',
							'heading'    => __( "Appearance", 'greyd_forms' ),
							'param_name' => 'seperator_layout',
						),
						// alignment
						array(
							'type'             => 'dropdown',
							'heading'          => __( "Alignment", 'greyd_forms' ),
							'param_name'       => 'alignment',
							'edit_field_class' => 'vc_col-xs-4',
							'value'            => array(
								_x( "left", 'small', 'greyd_forms' ) => 'left',
								_x( "center", 'small', 'greyd_forms' ) => 'center',
								_x( "right", 'small', 'greyd_forms' ) => 'right',
							),
						),
						// width
						array(
							'type'             => 'textfield',
							'heading'          => __( "Width", 'greyd_forms' ),
							'description'      => __( "in px or %", 'greyd_forms' ),
							'param_name'       => 'width',
							'edit_field_class' => 'vc_col-xs-4',
						),
						// // Größe
						// array(
						// "type"          => "dropdown",
						// "heading"       => __("Size", 'greyd_forms'),
						// "description"   => __('Hier können Sie die Größe des Eingabefeldes auswählen', 'greyd_forms'),
						// "param_name"    => "size",
						// 'admin_label'   =>  true,
						// 'edit_field_class' => 'vc_col-xs-4',
						// "value"         => array(
						// __("default", 'greyd_forms') => '',
						// __("big", 'greyd_forms') => '_big',
						// ),
						// ),

						array(
							'type'       => 'new_line',
							'param_name' => 'new_line_type',
						),
						// type
						array(
							'type'             => 'dropdown',
							'heading'          => __( "Appearance", 'greyd_forms' ),
							'description'      => __( "What should the field look like?", 'greyd_forms' ),
							'param_name'       => 'style',
							'edit_field_class' => 'vc_col-xs-4',
							'admin_label'      => true,
							'value'            => array(
								_x( "primary field", 'small', 'greyd_forms' ) => '',
								_x( "secondary field", 'small', 'greyd_forms' ) => 'sec',
								_x( "overwrite individually", 'small', 'greyd_forms' ) => 'custom',
							),
						),

					),
					// merge with helper array for custom element
					\vc\helper::custom_element_params_vc( 'dropdown', 'style', 'custom' ),
					// Label Options
					array(
						array(
							'type'       => 'sub_seperator',
							'heading'    => __( 'Label', 'greyd_forms' ),
							'param_name' => 'seperator_label',
						),
						// font-size
						array(
							'type'             => 'textfield',
							'heading'          => __( "Font size", 'greyd_forms' ),
							'description'      => __( "in px or em", 'greyd_forms' ),
							'param_name'       => 'label_font_size',
							'edit_field_class' => 'vc_col-xs-4',
						),
					),
					array(
						// Design Tab
						array(
							'type'       => 'css_editor',
							'heading'    => __( "CSS", 'greyd_forms' ),
							'param_name' => 'css',
							'group'      => __( "Design settings", 'greyd_forms' ),
						),
					)
				),
			)
		);
	}

	/**
	 * Radio Buttons
	 *
	 * @shortcode 'vc_form_radio'
	 */
	public function radio_module() {
		vc_map(
			array(
				'name'        => __( "Radio buttons", 'greyd_forms' ),
				'description' => __( "Selection from multiple options", 'greyd_forms' ),
				'base'        => $this->pre . 'radio',
				'category'    => $this->category,
				'weight'      => $this->weight,
				'icon'        => plugins_url( '../assets/icon/forms_radio.svg', __FILE__ ),
				'params'      => array_merge(
					array(

						// Überschrift
						array(
							'type'       => 'seperator',
							'heading'    => __( "General", 'greyd_forms' ),
							'param_name' => 'seperator_title',
						),

						// Anordnung
						array(
							'type'             => 'dropdown',
							'heading'          => __( "Arrangement", 'greyd_forms' ),
							'description'      => __( "How should the individual radio buttons be arranged?", 'greyd_forms' ),
							'param_name'       => 'layout',
							'edit_field_class' => 'vc_col-xs-4',
							'value'            => array(
								_x( "below each other", 'small', 'greyd_forms' )      => 'block',
								_x( "next to each other", 'small', 'greyd_forms' )      => 'inline',
							),
						),

						// Darstellung
						array(
							'type'             => 'dropdown',
							'heading'          => __( "Appearance", 'greyd_forms' ),
							'description'      => __( "What should the radio buttons look like?", 'greyd_forms' ),
							'param_name'       => 'style',
							'edit_field_class' => 'vc_col-xs-4',
							'value'            => array(
								_x( "Radio buttons", 'small', 'greyd_forms' )   => 'radio',
								_x( "checkboxes", 'small', 'greyd_forms' )      => '_checkbox',
								_x( "iOS switch", 'small', 'greyd_forms' )      => 'switch',
							),
						),

						// Multiselect
						array(
							'type'             => 'checkbox',
							'heading'          => __( "Enable multiselect", 'greyd_forms' ),
							'description'      => __( "The user can select multiple options.", 'greyd_forms' ),
							'param_name'       => 'multiselect',
							'admin_label'      => true,
							'edit_field_class' => 'vc_col-xs-4',
							'value'            => array(
								_x( "Yes", 'small', 'greyd_forms' )   => 'true',
							),
						),

						// Required
						array(
							'type'             => 'checkbox',
							'heading'          => __( "Required field", 'greyd_forms' ),
							'description'      => __( "The user must fill in this field.", 'greyd_forms' ),
							'param_name'       => 'required',
							'admin_label'      => true,
							'edit_field_class' => 'vc_col-xs-4',
							'value'            => array(
								_x( "Yes", 'small', 'greyd_forms' )   => 'true',
							),
						),

						// Überschrift
						array(
							'type'       => 'seperator',
							'heading'    => __( "Labeling", 'greyd_forms' ),
							'param_name' => 'seperator_naming',
						),

						// Label
						array(
							'type'             => 'textfield',
							'heading'          => __( 'Label', 'greyd_forms' ),
							'description'      => __( "Displayed above the field.", 'greyd_forms' ),
							'param_name'       => 'label',
							'edit_field_class' => 'vc_col-xs-6',
							'admin_label'      => true,
						),

						// Name
						array(
							'type'             => 'textfield',
							'heading'          => __( "Field name", 'greyd_forms' ),
							'description'      => __( "Unique value of the field that is passed with the form.", 'greyd_forms' ),
							'param_name'       => 'name',
							'edit_field_class' => 'vc_col-xs-6 required',
							'admin_label'      => true,
						),

						// Hilfetext
						array(
							'type'             => 'textarea',
							'heading'          => __( "Tooltip", 'greyd_forms' ),
							'description'      => __( "This text is available for assistance via an info icon and may contain additional explanations.", 'greyd_forms' ),
							'param_name'       => 'tooltip',
							'edit_field_class' => 'vc_col-xs-9',
							'dependency'       => array(
								'element'   => 'label',
								'not_empty' => true,
							),
						),
					),
					$this->make_options(),
					// Label Options
					array(
						array(
							'type'       => 'seperator',
							'heading'    => __( "Appearance", 'greyd_forms' ),
							'param_name' => 'seperator_label',
						),

						// iOS Switch Color
						array(
							'type'             => 'colorselect',
							'heading'          => __( "Switch color", 'greyd_forms' ),
							'description'      => __( "Normal color of the iOS switch.", 'greyd_forms' ),
							'param_name'       => 'switch_color',
							'edit_field_class' => 'vc_col-xs-6',
							'dependency'       => array(
								'element' => 'style',
								'value'   => 'switch',
							),
						),

						// iOS Switch Color (aktiv)
						array(
							'type'             => 'colorselect',
							'heading'          => __( "Switch color (active)", 'greyd_forms' ),
							'description'      => __( "Color of the iOS switch when active.", 'greyd_forms' ),
							'param_name'       => 'switch_color_selected',
							'edit_field_class' => 'vc_col-xs-6',
							'dependency'       => array(
								'element' => 'style',
								'value'   => 'switch',
							),
						),

						// label font-size
						array(
							'type'             => 'textfield',
							'heading'          => __( "Label font size", 'greyd_forms' ),
							'description'      => __( "in px or em", 'greyd_forms' ),
							'param_name'       => 'label_font_size',
							'edit_field_class' => 'vc_col-xs-4',
						),

						// options font-size
						array(
							'type'             => 'textfield',
							'heading'          => __( "Options font size", 'greyd_forms' ),
							'description'      => __( "in px or em", 'greyd_forms' ),
							'param_name'       => 'options_font_size',
							'edit_field_class' => 'vc_col-xs-4',
						),
					),
					array(

						// Design Tab
						array(
							'type'       => 'css_editor',
							'heading'    => __( "CSS", 'greyd_forms' ),
							'param_name' => 'css',
							'group'      => __( "Design settings", 'greyd_forms' ),
						),
					)
				),
			)
		);
	}

	/**
	 * Icon panels
	 *
	 * @shortcode 'vc_form_icon_panels' (parent)
	 * @shortcode 'vc_form_icon_panel' (child)
	 */
	public function icon_panel_module() {

		// Parent
		vc_map(
			array(
				'name'            => __( "Image panels", 'greyd_forms' ),
				'description'     => __( "Clickable panels with image and text", 'greyd_forms' ),
				'base'            => $this->pre . 'icon_panels',
				'as_parent'       => array( 'only' => $this->pre . 'icon_panel' ),
				'js_view'         => 'VcColumnView',
				// "content_element" => true,
				// "show_settings_on_create" => false,
				// "controls" => "full",
				// "is_container"    => true,
				'category'        => $this->category,
				'weight'          => $this->weight,
				'icon'            => plugins_url( '../assets/icon/forms_panels.svg', __FILE__ ),
				'default_content' => '[vc_form_icon_panel][vc_form_icon_panel]',
				'params'          => array(

					// Überschrift
					array(
						'type'       => 'seperator',
						'heading'    => __( "Labeling", 'greyd_forms' ),
						'param_name' => 'seperator_title',
					),

					// Label
					array(
						'type'             => 'textfield',
						'heading'          => __( 'Label', 'greyd_forms' ),
						'description'      => __( "Displayed above the field.", 'greyd_forms' ),
						'param_name'       => 'label',
						'edit_field_class' => 'vc_col-xs-4',
					),

					// Name
					array(
						'type'             => 'textfield',
						'heading'          => __( "name", 'greyd_forms' ),
						'description'      => __( "Unique value of the field that is passed with the form.", 'greyd_forms' ),
						'param_name'       => 'name',
						'edit_field_class' => 'vc_col-xs-4 required',
					),

					// Required
					array(
						'type'             => 'checkbox',
						'heading'          => __( "Required field", 'greyd_forms' ),
						'description'      => __( "The user must fill in this field.", 'greyd_forms' ),
						'param_name'       => 'required',
						'admin_label'      => true,
						'edit_field_class' => 'vc_col-xs-4',
						'value'            => array(
							_x( "Yes", 'small', 'greyd_forms' ) => 'true',
						),
					),

					// Hilfetext
					array(
						'type'             => 'textarea',
						'heading'          => __( "Tooltip", 'greyd_forms' ),
						'description'      => __( "This text is available for assistance via an info icon and may contain additional explanations.", 'greyd_forms' ),
						'param_name'       => 'tooltip',
						'edit_field_class' => 'vc_col-xs-8',
						'dependency'       => array(
							'element'   => 'label',
							'not_empty' => true,
						),
					),

					// Multiselect
					array(
						'type'             => 'checkbox',
						'heading'          => __( "Enable multiselect", 'greyd_forms' ),
						'description'      => __( "The user can select multiple options.", 'greyd_forms' ),
						'param_name'       => 'multiselect',
						'admin_label'      => true,
						'edit_field_class' => 'vc_col-xs-4',
						'value'            => array(
							_x( "Yes", 'small', 'greyd_forms' ) => 'true',
						),
					),

					// Layout
					array(
						'type'       => 'seperator',
						'heading'    => __( 'Layout', 'greyd_forms' ),
						'param_name' => 'seperator_layout',
					),

					// Anordnung
					array(
						'type'             => 'dropdown',
						'heading'          => __( "Arrangement", 'greyd_forms' ),
						'description'      => __( "Arrangement of each panel.", 'greyd_forms' ),
						'param_name'       => 'flex_direction',
						'edit_field_class' => 'vc_col-xs-5',
						'value'            => array(
							_x( "next to each other", 'small', 'greyd_forms' )      => 'flex-row',
							_x( "below each other", 'small', 'greyd_forms' )      => 'flex-column',
						),
					),

					// Ausrichtung
					array(
						'type'             => 'dropdown',
						'heading'          => __( "Justify", 'greyd_forms' ),
						'description'      => __( "Distribution of each panel.", 'greyd_forms' ),
						'param_name'       => 'justify_content',
						'edit_field_class' => 'vc_col-xs-5',
						'value'            => array(
							'□□□     | ' . _x( "left", 'small', 'greyd_forms' )       => 'flex-justify-start',
							'  □□□   | ' . _x( "center", 'small', 'greyd_forms' )         => 'flex-justify-center',
							'    □□□ | ' . _x( "right", 'small', 'greyd_forms' )      => 'flex-justify-end',
							'––––––––––––––––––––––––––––––––––––––'                   => '',
							'□  □  □ | ' . _x( "space between", 'small', 'greyd_forms' ) => 'flex-justify-between',
							' □ □ □  | ' . _x( "space around", 'small', 'greyd_forms' )     => 'flex-justify-around',
							' ⟷ ⟷ ⟷ | ' . _x( "stretch", 'small', 'greyd_forms' )       => 'flex-justify-stretch',
						),
						'dependency'       => array(
							'element' => 'flex_direction',
							'value'   => 'flex-row',
						),
					),

					// same Height?
					array(
						'type'             => 'checkbox',
						'heading'          => __( "Same height", 'greyd_forms' ),
						'param_name'       => 'same_height',
						'edit_field_class' => 'vc_col-xs-2',
						'value'            => array(
							_x( "Yes", 'small', 'greyd_forms' ) => 'true',
						),
						'dependency'       => array(
							'element' => 'flex_direction',
							'value'   => 'flex-row',
						),
					),

					// Responsive
					array(
						'type'             => 'dropdown',
						'heading'          => __( "Responsive behavior", 'greyd_forms' ),
						'description'      => __( "How do you want the panels to arrange on smaller screens?", 'greyd_forms' ),
						'param_name'       => 'responsive',
						'edit_field_class' => 'vc_col-xs-5',
						'value'            => array(
							_x( "line break", 'small', 'greyd_forms' )              => '',
							_x( "scroll horizontally", 'small', 'greyd_forms' )    => 'overflow',
						),
						'dependency'       => array(
							'element' => 'flex_direction',
							'value'   => 'flex-row',
						),
					),

					// Abstand
					array(
						'type'             => 'textfield',
						'heading'          => __( "Space", 'greyd_forms' ),
						'description'      => __( "Between the tiles. (Unit: in px or em)", 'greyd_forms' ),
						'param_name'       => 'between',
						'edit_field_class' => 'vc_col-xs-3',
					),

					// Max width
					array(
						'type'             => 'textfield',
						'heading'          => __( "Max. width", 'greyd_forms' ),
						'description'      => __( "Width of each tile. (Unit: in px, em or %)", 'greyd_forms' ),
						'param_name'       => 'max_width',
						'edit_field_class' => 'vc_col-xs-3',
					),

					// Label Options
					array(
						'type'       => 'seperator',
						'heading'    => __( "Appearance", 'greyd_forms' ),
						'param_name' => 'seperator_label',
					),
					// label font-size
					array(
						'type'             => 'textfield',
						'heading'          => __( "Label font size", 'greyd_forms' ),
						'description'      => __( "in px or em", 'greyd_forms' ),
						'param_name'       => 'label_font_size',
						'edit_field_class' => 'vc_col-xs-4',
					),

					// new Tab:
					//
					// Kacheln
					array(
						'type'       => 'seperator',
						'heading'    => __( 'Layout', 'greyd_forms' ),
						'param_name' => 'seperator_panels',
						'group'      => __( "Panel settings", 'greyd_forms' ),
					),

					// Anordnung
					array(
						'type'             => 'dropdown',
						'heading'          => __( "Arrangement of the contents", 'greyd_forms' ),
						'param_name'       => 'panel_flex_direction',
						'edit_field_class' => 'vc_col-xs-6',
						'value'            => array(
							_x( "image above text", 'small', 'greyd_forms' )         => 'flex-column',
							_x( "image below text", 'small', 'greyd_forms' )        => 'flex-column-reverse',
							_x( "image to the left of text", 'small', 'greyd_forms' )  => 'flex-row',
							_x( "image to the right of text", 'small', 'greyd_forms' ) => 'flex-row-reverse',
						),
						'group'            => __( "Panel settings", 'greyd_forms' ),
					),

					// Ausrichtung
					array(
						'type'             => 'dropdown',
						'heading'          => __( "Alignment of the contents", 'greyd_forms' ),
						'param_name'       => 'align_items',
						'edit_field_class' => 'vc_col-xs-6',
						'value'            => array(
							_x( "top center", 'small', 'greyd_forms' )    => 'flex-align-center',
							_x( "top left", 'small', 'greyd_forms' )     => 'flex-align-start',
							_x( "top right", 'small', 'greyd_forms' )    => 'flex-align-end',
							_x( "center left", 'small', 'greyd_forms' )    => 'flex-align-start flex-justify-center',
							_x( "center middle", 'small', 'greyd_forms' )   => 'flex-align-center flex-justify-center',
							_x( "center right", 'small', 'greyd_forms' )   => 'flex-align-end flex-justify-center',
							_x( "bottom left", 'small', 'greyd_forms' )    => 'flex-align-start flex-justify-end',
							_x( "bottom center", 'small', 'greyd_forms' )   => 'flex-align-center flex-justify-end',
							_x( "bottom right", 'small', 'greyd_forms' )   => 'flex-align-end flex-justify-end',
						),
						'dependency'       => array(
							'element' => 'panel_flex_direction',
							'value'   => array( 'flex-column', 'flex-column-reverse' ),
						),
						'group'            => __( "Panel settings", 'greyd_forms' ),
					),

					// Ausrichtung 2
					array(
						'type'             => 'dropdown',
						'heading'          => __( "Alignment", 'greyd_forms' ),
						'param_name'       => 'align_items2',
						'edit_field_class' => 'vc_col-xs-6',
						'value'            => array(
							_x( "center", 'small', 'greyd_forms' ) => 'flex-align-center',
							_x( "top", 'small', 'greyd_forms' ) => 'flex-align-start',
							_x( "bottom", 'small', 'greyd_forms' ) => 'flex-align-end',
						),
						'dependency'       => array(
							'element' => 'panel_flex_direction',
							'value'   => array( 'flex-row', 'flex-row-reverse' ),
						),
						'group'            => __( "Panel settings", 'greyd_forms' ),
					),

					// // Größen & Abstände
					// array(
					// "type"        => 'sub_seperator',
					// "heading"     => __("Größen & Abstände", 'greyd_forms'),
					// "param_name"  => 'seperator_sizes',
					// 'group' => __( 'einzelne Kacheln', 'greyd_forms'),
					// ),

					// Icon Größe
					array(
						'type'             => 'textfield',
						'heading'          => __( "Image size", 'greyd_forms' ),
						'description'      => __( "in px, em or %", 'greyd_forms' ),
						'param_name'       => 'icon_size',
						'edit_field_class' => 'vc_col-xs-3',
						'group'            => __( "Panel settings", 'greyd_forms' ),
					),

					// Abstand
					array(
						'type'             => 'textfield',
						'heading'          => __( "Space to the text", 'greyd_forms' ),
						'description'      => __( "in px or em", 'greyd_forms' ),
						'param_name'       => 'between_inner',
						'edit_field_class' => 'vc_col-xs-3',
						'group'            => __( "Panel settings", 'greyd_forms' ),
					),

					// Padding-Y
					array(
						'type'             => 'textfield',
						'heading'          => __( "Padding top/bottom", 'greyd_forms' ),
						'description'      => __( "in px or em", 'greyd_forms' ),
						'param_name'       => 'padding_y',
						'edit_field_class' => 'vc_col-xs-3',
						'value'            => '1em',
						'group'            => __( "Panel settings", 'greyd_forms' ),
					),

					// Padding-X
					array(
						'type'             => 'textfield',
						'heading'          => __( "Padding sideways", 'greyd_forms' ),
						'description'      => __( "in px or em", 'greyd_forms' ),
						'param_name'       => 'padding_x',
						'edit_field_class' => 'vc_col-xs-3',
						'value'            => '1em',
						'group'            => __( "Panel settings", 'greyd_forms' ),
					),

					// Design
					array(
						'type'       => 'seperator',
						'heading'    => __( "Appearance", 'greyd_forms' ),
						'param_name' => 'seperator_design',
						'group'      => __( "Panel settings", 'greyd_forms' ),
					),

					// Radius
					array(
						'type'             => 'textfield',
						'heading'          => __( "Border radius", 'greyd_forms' ),
						'description'      => __( "in px or em", 'greyd_forms' ),
						'param_name'       => 'border_radius',
						'edit_field_class' => 'vc_col-xs-2',
						'group'            => __( "Panel settings", 'greyd_forms' ),
					),
					// array(
					// "type"        => 'new_line',
					// "param_name"  => 'new_line_text',
					// 'group' => __( "Panel settings", 'greyd_forms'),
					// ),

					// Textgröße
					array(
						'type'             => 'textfield',
						'heading'          => __( "Font size", 'greyd_forms' ),
						'description'      => __( "in px or em", 'greyd_forms' ),
						'param_name'       => 'font_size',
						'edit_field_class' => 'vc_col-xs-3',
						'group'            => __( "Panel settings", 'greyd_forms' ),
					),

					// Line height
					array(
						'type'             => 'textfield',
						'heading'          => __( "Line height", 'greyd_forms' ),
						'description'      => __( "in px, em or %", 'greyd_forms' ),
						'param_name'       => 'line_height',
						'edit_field_class' => 'vc_col-xs-3',
						'group'            => __( "Panel settings", 'greyd_forms' ),
					),

					// Font weight
					array(
						'type'             => 'dropdown',
						'heading'          => __( "Font style", 'greyd_forms' ),
						'param_name'       => 'font_weight',
						'edit_field_class' => 'vc_col-xs-2',
						'value'            => array(
							_x( "default", 'small', 'greyd_forms' ) => '',
							_x( 'light', 'small', 'greyd_forms' ) => '300',
							_x( 'regular', 'small', 'greyd_forms' ) => '400',
							_x( 'semi-bold', 'small', 'greyd_forms' ) => '600',
							_x( 'bold', 'small', 'greyd_forms' ) => '700',
						),
						'group'            => __( "Panel settings", 'greyd_forms' ),
					),

					// Box Shadow
					array(
						'type'             => 'checkbox',
						'heading'          => __( "Shadow", 'greyd_forms' ),
						'param_name'       => 'box_shadow',
						'edit_field_class' => 'vc_col-xs-2',
						'group'            => __( "Panel settings", 'greyd_forms' ),
						'value'            => array(
							__( "enable", 'greyd_forms' ) => 'yes',
						),
					),

					// Border?
					array(
						'type'       => 'sub_seperator',
						'heading'    => __( "Border", 'greyd_forms' ),
						'param_name' => 'sub_seperator_border',
						'group'      => __( "Panel settings", 'greyd_forms' ),
					),
					array(
						'type'             => 'checkbox',
						'param_name'       => 'border_active',
						'edit_field_class' => 'vc_col-xs-4',
						'group'            => __( "Panel settings", 'greyd_forms' ),
						'value'            => array(
							__( "enable", 'greyd_forms' ) => 'yes',
						),
					),
					array(
						'type'       => 'new_line',
						'param_name' => 'new_line_border',
						'group'      => __( "Panel settings", 'greyd_forms' ),
					),

					// Border Style
					array(
						'type'             => 'dropdown',
						'heading'          => __( "Border style", 'greyd_forms' ),
						'param_name'       => 'border_style',
						'edit_field_class' => 'vc_col-xs-4',
						'value'            => array(
							sprintf( _x( "solid %s", 'small', 'greyd_forms' ), '–––––––––––' )             => 'solid',
							sprintf( _x( "dotted %s", 'small', 'greyd_forms' ), '······················' )    => 'dotted',
							sprintf( _x( "dashed %s", 'small', 'greyd_forms' ), '- - - - - - - - - -' )     => 'dashed',
						),
						'dependency'       => array(
							'element'   => 'border_active',
							'not_empty' => true,
						),
						'group'            => __( "Panel settings", 'greyd_forms' ),
					),

					// Border Top
					array(
						'type'             => 'textfield',
						'heading'          => __( "top", 'greyd_forms' ),
						'description'      => __( 'in px', 'greyd_forms' ),
						'param_name'       => 'border_top',
						'value'            => 1,
						'edit_field_class' => 'vc_col-xs-2',
						'dependency'       => array(
							'element'   => 'border_active',
							'not_empty' => true,
						),
						'group'            => __( "Panel settings", 'greyd_forms' ),
					),

					// Border Top
					array(
						'type'             => 'textfield',
						'heading'          => __( "right", 'greyd_forms' ),
						'description'      => __( 'in px', 'greyd_forms' ),
						'param_name'       => 'border_right',
						'value'            => 1,
						'edit_field_class' => 'vc_col-xs-2',
						'dependency'       => array(
							'element'   => 'border_active',
							'not_empty' => true,
						),
						'group'            => __( "Panel settings", 'greyd_forms' ),
					),

					// Border Top
					array(
						'type'             => 'textfield',
						'heading'          => __( "left", 'greyd_forms' ),
						'description'      => __( 'in px', 'greyd_forms' ),
						'param_name'       => 'border_left',
						'value'            => 1,
						'edit_field_class' => 'vc_col-xs-2',
						'dependency'       => array(
							'element'   => 'border_active',
							'not_empty' => true,
						),
						'group'            => __( "Panel settings", 'greyd_forms' ),
					),

					// Border Top
					array(
						'type'             => 'textfield',
						'heading'          => __( "bottom", 'greyd_forms' ),
						'description'      => __( 'in px', 'greyd_forms' ),
						'param_name'       => 'border_bottom',
						'value'            => 1,
						'edit_field_class' => 'vc_col-xs-2',
						'dependency'       => array(
							'element'   => 'border_active',
							'not_empty' => true,
						),
						'group'            => __( "Panel settings", 'greyd_forms' ),
					),

					// Farben
					array(
						'type'       => 'seperator',
						'heading'    => __( "Colors", 'greyd_forms' ),
						'param_name' => 'seperator_colors',
						'group'      => __( "Panel settings", 'greyd_forms' ),
					),

					// BG
					array(
						'type'             => 'colorselect',
						'heading'          => __( "Background", 'greyd_forms' ),
						'param_name'       => 'bgcolor',
						'edit_field_class' => 'vc_col-xs-6',
						'group'            => __( "Panel settings", 'greyd_forms' ),
					),

					// Textfarbe
					array(
						'type'             => 'colorselect',
						'heading'          => __( "Font", 'greyd_forms' ),
						'param_name'       => 'textcolor',
						'edit_field_class' => 'vc_col-xs-6',
						'group'            => __( "Panel settings", 'greyd_forms' ),
					),

					// Border
					array(
						'type'             => 'colorselect',
						'heading'          => __( "Border", 'greyd_forms' ),
						'param_name'       => 'bordercolor',
						'edit_field_class' => 'vc_col-xs-6',
						'dependency'       => array(
							'element'   => 'border_active',
							'not_empty' => true,
						),
						'group'            => __( "Panel settings", 'greyd_forms' ),
					),

					// Deckkraft
					array(
						'type'             => 'dropdown',
						'heading'          => __( "Opacy", 'greyd_forms' ),
						'param_name'       => 'opacity',
						'edit_field_class' => 'vc_col-xs-6',
						'value'            => array(
							'100 %' => '1',
							'90 %'  => '.9',
							'80 %'  => '.8',
							'70 %'  => '.7',
							'60 %'  => '.6',
							'50 %'  => '.5',
							'40 %'  => '.4',
							'30 %'  => '.3',
							'20 %'  => '.2',
							'10 %'  => '.1',
							'0 %'   => '0',
						),
						'group'            => __( "Panel settings", 'greyd_forms' ),
					),

					// hover
					array(
						'type'       => 'sub_seperator',
						'heading'    => __( 'Hover', 'greyd_forms' ),
						'param_name' => 'seperator_colors_hover',
						'group'      => __( "Panel settings", 'greyd_forms' ),
					),

					// Hover BG
					array(
						'type'             => 'colorselect',
						'heading'          => __( "Background", 'greyd_forms' ),
						'param_name'       => 'bgcolor_hover',
						'edit_field_class' => 'vc_col-xs-6',
						'group'            => __( "Panel settings", 'greyd_forms' ),
					),

					// Textfarbe
					array(
						'type'             => 'colorselect',
						'heading'          => __( "Font", 'greyd_forms' ),
						'param_name'       => 'textcolor_hover',
						'edit_field_class' => 'vc_col-xs-6',
						'group'            => __( "Panel settings", 'greyd_forms' ),
					),

					// Border
					array(
						'type'             => 'colorselect',
						'heading'          => __( "Border", 'greyd_forms' ),
						'param_name'       => 'bordercolor_hover',
						'edit_field_class' => 'vc_col-xs-6',
						'dependency'       => array(
							'element'   => 'border_active',
							'not_empty' => true,
						),
						'group'            => __( "Panel settings", 'greyd_forms' ),
					),

					// Deckkraft
					array(
						'type'             => 'dropdown',
						'heading'          => __( "Opacy", 'greyd_forms' ),
						'param_name'       => 'opacity_hover',
						'edit_field_class' => 'vc_col-xs-6',
						'value'            => array(
							'100 %' => '1',
							'90 %'  => '.9',
							'80 %'  => '.8',
							'70 %'  => '.7',
							'60 %'  => '.6',
							'50 %'  => '.5',
							'40 %'  => '.4',
							'30 %'  => '.3',
							'20 %'  => '.2',
							'10 %'  => '.1',
							'0 %'   => '0',
						),
						'group'            => __( "Panel settings", 'greyd_forms' ),
					),

					// aktiv
					array(
						'type'       => 'sub_seperator',
						'heading'    => __( "after selection", 'greyd_forms' ),
						'param_name' => 'seperator_colors_active',
						'group'      => __( "Panel settings", 'greyd_forms' ),
					),

					// Selected BG
					array(
						'type'             => 'colorselect',
						'heading'          => __( "Background", 'greyd_forms' ),
						'param_name'       => 'bgcolor_select',
						'edit_field_class' => 'vc_col-xs-6',
						'group'            => __( "Panel settings", 'greyd_forms' ),
					),

					// Textfarbe
					array(
						'type'             => 'colorselect',
						'heading'          => __( "Font", 'greyd_forms' ),
						'param_name'       => 'textcolor_select',
						'edit_field_class' => 'vc_col-xs-6',
						'group'            => __( "Panel settings", 'greyd_forms' ),
					),

					// Border
					array(
						'type'             => 'colorselect',
						'heading'          => __( "Border", 'greyd_forms' ),
						'param_name'       => 'bordercolor_select',
						'edit_field_class' => 'vc_col-xs-6',
						'dependency'       => array(
							'element'   => 'border_active',
							'not_empty' => true,
						),
						'group'            => __( "Panel settings", 'greyd_forms' ),
					),

					// Deckkraft
					array(
						'type'             => 'dropdown',
						'heading'          => __( "Opacy", 'greyd_forms' ),
						'param_name'       => 'opacity_select',
						'edit_field_class' => 'vc_col-xs-6',
						'value'            => array(
							'100 %' => '1',
							'90 %'  => '.9',
							'80 %'  => '.8',
							'70 %'  => '.7',
							'60 %'  => '.6',
							'50 %'  => '.5',
							'40 %'  => '.4',
							'30 %'  => '.3',
							'20 %'  => '.2',
							'10 %'  => '.1',
							'0 %'   => '0',
						),
						'group'            => __( "Panel settings", 'greyd_forms' ),
					),

					// CSS Tab
					array(
						'type'       => 'css_editor',
						'heading'    => __( "CSS", 'greyd_forms' ),
						'param_name' => 'css',
						'group'      => __( "Design settings", 'greyd_forms' ),
					),
				),
			)
		);

		// Child
		vc_map(
			array(
				'name'        => __( "Image panel", 'greyd_forms' ),
				'description' => __( "Panel with image & text", 'greyd_forms' ),
				'base'        => $this->pre . 'icon_panel',
				'as_child'    => array( 'only' => $this->pre . 'icon_panels' ),
				// "content_element" => true,
				'category'    => $this->category,
				'weight'      => $this->weight,
				'icon'        => plugins_url( '../assets/icon/forms_panel.svg', __FILE__ ),
				'params'      => array(
					// Bild
					array(
						'type'             => 'attach_image',
						'heading'          => __( "Image", 'greyd_forms' ),
						'param_name'       => 'icon',
						'edit_field_class' => 'vc_col-xs-4',
					),

					// Bild hover
					array(
						'type'             => 'attach_image',
						'heading'          => __( "Image", 'greyd_forms' ) . ' <u>' . __( 'Hover', 'greyd_forms' ) . '</u>',
						'description'      => __( "Override the normal image.", 'greyd_forms' ),
						'param_name'       => 'icon_hover',
						'edit_field_class' => 'vc_col-xs-4',
					),

					// Bild selected
					array(
						'type'             => 'attach_image',
						'heading'          => __( "Image", 'greyd_forms' ) . ' <u>' . str_replace( ' ', '&nbsp;', __( "after selection", 'greyd_forms' ) ) . '</u>',
						'description'      => __( "Override the normal & hover image.", 'greyd_forms' ),
						'param_name'       => 'icon_select',
						'edit_field_class' => 'vc_col-xs-4',
					),
					array(
						'type'       => 'new_line',
						'param_name' => 'new_line_images',
					),

					// Unter-Überschrift
					array(
						'type'       => 'seperator',
						'heading'    => __( "Labeling", 'greyd_forms' ),
						'param_name' => 'seperator_naming',
					),

					// Label
					array(
						'type'             => 'textfield',
						'heading'          => __( "text", 'greyd_forms' ),
						'description'      => __( "What should be in the panel?", 'greyd_forms' ),
						'param_name'       => 'label',
						'edit_field_class' => 'vc_col-xs-4',
						'admin_label'      => true,
					),

					// Name
					array(
						'type'             => 'textfield',
						'heading'          => __( "Field value", 'greyd_forms' ),
						'description'      => __( "Information to be submitted when the field is selected.", 'greyd_forms' ),
						'param_name'       => 'name',
						'edit_field_class' => 'vc_col-xs-4 required',
						'admin_label'      => true,
					),

					// Selected
					array(
						'type'             => 'checkbox',
						'heading'          => __( "On pageload", 'greyd_forms' ),
						'param_name'       => 'selected',
						'admin_label'      => true,
						'edit_field_class' => 'vc_col-xs-4',
						'value'            => array(
							_x( "selected", 'small', 'greyd_forms' ) => 'selected',
						),
					),

					// Unter-Überschrift
					array(
						'type'       => 'seperator',
						'heading'    => __( "Extended", 'greyd_forms' ),
						'param_name' => 'seperator_more',
					),

					// extra Klasse
					array(
						'type'        => 'textfield',
						'heading'     => __( "CSS class name", 'greyd_forms' ),
						'description' => __( "Design this element individually - set a class name and refer to it in your CSS. (Note: enter without dot or diamond in front of it).", 'greyd_forms' ),
						'param_name'  => 'icon_panel_class',
						// 'edit_field_class' => 'vc_col-xs-6',
						'admin_label' => true,
					),

					// Design Tab
					array(
						'type'       => 'css_editor',
						'heading'    => __( 'CSS', 'greyd_forms' ),
						'param_name' => 'css',
						'group'      => __( "Design settings", 'greyd_forms' ),
					),
				),
			)
		);
	}

	/**
	 * Range
	 *
	 * @shortcode 'vc_form_range'
	 * @since 0.8.8
	 */
	public function range_module() {
		vc_map(
			array(
				'name'        => __( "Slider", 'greyd_forms' ),
				'description' => __( "Intuitive slider control for numbers", 'greyd_forms' ),
				'base'        => $this->pre . 'range',
				'category'    => $this->category,
				'weight'      => $this->weight,
				'icon'        => plugins_url( '../assets/icon/forms_range.svg', __FILE__ ),
				'params'      => array_merge(
					array(

						// General
						array(
							'type'       => 'seperator',
							'heading'    => __( "General", 'greyd_forms' ),
							'param_name' => 'seperator_title',
						),
						array(
							'type'             => 'textfield',
							'heading'          => __( "Field name", 'greyd_forms' ),
							'description'      => __( "Unique value of the field that is passed with the form.", 'greyd_forms' ),
							'param_name'       => 'name',
							'edit_field_class' => 'vc_col-xs-6 required',
							'admin_label'      => true,
						),
						array(
							'type'             => 'checkbox',
							'heading'          => __( "Required field", 'greyd_forms' ),
							'description'      => __( "The user must fill in this field.", 'greyd_forms' ),
							'param_name'       => 'required',
							'admin_label'      => true,
							'edit_field_class' => 'vc_col-xs-6',
							'weight'           => 8,
							'value'            => array(
								_x( "Yes", 'small', 'greyd_forms' ) => 'true',
							),
						),

						// Label
						array(
							'type'       => 'seperator',
							'heading'    => __( 'Label', 'greyd_forms' ),
							'param_name' => 'seperator_naming',
						),
						array(
							'type'             => 'textfield',
							'heading'          => __( "Text before", 'greyd_forms' ),
							'description'      => __( "Displayed before the value.", 'greyd_forms' ),
							'param_name'       => 'label',
							'edit_field_class' => 'vc_col-xs-6',
							'admin_label'      => true,
						),
						array(
							'type'             => 'textfield',
							'heading'          => __( "Text afterwards", 'greyd_forms' ),
							'description'      => __( "Displayed after the value, convenient for units. (e.g. \"€\", \"per day\")", 'greyd_forms' ),
							'param_name'       => 'suffix',
							'edit_field_class' => 'vc_col-xs-6',
						),
						array(
							'type'             => 'textfield',
							'heading'          => __( "Font size", 'greyd_forms' ),
							'description'      => __( "in px or em", 'greyd_forms' ),
							'param_name'       => 'label_font_size',
							'edit_field_class' => 'vc_col-xs-4',
						),
						array(
							'type'             => 'textarea',
							'heading'          => __( "Tooltip", 'greyd_forms' ),
							'description'      => __( "This text can be accessed via an info icon as a help and explains to the user the special features of the field (e.g. that an email field must contain an @-character.", 'greyd_forms' ),
							'param_name'       => 'tooltip',
							'edit_field_class' => 'vc_col-xs-9',
						),

						// Values
						array(
							'type'       => 'seperator',
							'heading'    => __( "Values", 'greyd_forms' ),
							'param_name' => 'seperator_value',
						),
						array(
							'type'             => 'textfield',
							'heading'          => __( "Minimum value", 'greyd_forms' ),
							'description'      => __( "Default: 0", 'greyd_forms' ),
							'param_name'       => 'min',
							'edit_field_class' => 'vc_col-xs-6',
						),
						array(
							'type'             => 'textfield',
							'heading'          => __( "Maximum value", 'greyd_forms' ),
							'description'      => __( "Default (100%)", 'greyd_forms' ),
							'param_name'       => 'max',
							'edit_field_class' => 'vc_col-xs-6',
						),
						array(
							'type'             => 'textfield',
							'heading'          => __( "Start value", 'greyd_forms' ),
							'param_name'       => 'start',
							'edit_field_class' => 'vc_col-xs-6',
						),
						array(
							'type'             => 'textfield',
							'heading'          => __( "Steps", 'greyd_forms' ),
							'description'      => __( "How exactly should the value be specified (e.g.: '0.1' means a decimal place)? (default: 1)", 'greyd_forms' ),
							'param_name'       => 'step',
							'edit_field_class' => 'vc_col-xs-6',
						),
					),
					// Design Group
					array(

						// Track
						array(
							'type'       => 'seperator',
							'heading'    => __( "Rail", 'greyd_forms' ),
							'param_name' => 'seperator_track',
							'group'      => __( "Layout", 'greyd_forms' ),
						),
						array(
							'type'             => 'textfield',
							'heading'          => __( "Height", 'greyd_forms' ),
							'description'      => __( "in px or em", 'greyd_forms' ) . ' (' . sprintf( __( "Default: %s", 'greyd_forms' ), '3px' ) . ')',
							'param_name'       => 'rail_font_size',
							// 'value'              => '3px',
							'edit_field_class' => 'vc_col-xs-6',
							'group'            => __( "Layout", 'greyd_forms' ),
						),
						array(
							'type'             => 'textfield',
							'heading'          => __( "Border radius", 'greyd_forms' ),
							'description'      => __( "in px or %", 'greyd_forms' ) . ' (' . sprintf( __( "Default: %s", 'greyd_forms' ), '1px' ) . ')',
							'param_name'       => 'rail_border_radius',
							// 'value'              => '1px',
							'edit_field_class' => 'vc_col-xs-6',
							'group'            => __( "Layout", 'greyd_forms' ),
						),
						array(
							'type'             => 'colorselect',
							'heading'          => __( "Color of the rail", 'greyd_forms' ),
							'param_name'       => 'rail_background_color',
							'value'            => 'color_22',
							'edit_field_class' => 'vc_col-xs-6',
							'group'            => __( "Layout", 'greyd_forms' ),
						),
						array(
							'type'             => 'colorselect',
							'heading'          => __( "Rail (active)", 'greyd_forms' ),
							'param_name'       => 'rail_background_color_focus',
							'value'            => 'color_22',
							'edit_field_class' => 'vc_col-xs-6',
							'group'            => __( "Layout", 'greyd_forms' ),
						),
						array(
							'type'             => 'colorselect',
							'heading'          => __( "Track", 'greyd_forms' ),
							'param_name'       => 'track_background_color',
							'value'            => 'color_21',
							'edit_field_class' => 'vc_col-xs-6',
							'group'            => __( "Layout", 'greyd_forms' ),
						),
						array(
							'type'             => 'colorselect',
							'heading'          => __( "Track (active)", 'greyd_forms' ),
							'param_name'       => 'track_background_color_focus',
							'value'            => 'color_21',
							'edit_field_class' => 'vc_col-xs-6',
							'group'            => __( "Layout", 'greyd_forms' ),
						),

						// Thumb
						array(
							'type'       => 'seperator',
							'heading'    => __( "Handle", 'greyd_forms' ),
							'param_name' => 'seperator_thumb',
							'group'      => __( "Layout", 'greyd_forms' ),
						),
						array(
							'type'             => 'textfield',
							'heading'          => __( "Size", 'greyd_forms' ),
							'description'      => __( "in px or em", 'greyd_forms' ) . ' (' . sprintf( __( "Default: %s", 'greyd_forms' ), '20px' ) . ')',
							'param_name'       => 'thumb_wrapper_font_size',
							// 'value'              => '20px',
							'edit_field_class' => 'vc_col-xs-6',
							'group'            => __( "Layout", 'greyd_forms' ),
						),
						array(
							'type'             => 'textfield',
							'heading'          => __( "Border radius", 'greyd_forms' ),
							'description'      => __( "in px or %", 'greyd_forms' ) . ' (' . sprintf( __( "Default: %s", 'greyd_forms' ), '100%' ) . ')',
							'param_name'       => 'thumb_border_radius',
							// 'value'              => '100%',
							'edit_field_class' => 'vc_col-xs-6',
							'group'            => __( "Layout", 'greyd_forms' ),
						),
						array(
							'type'             => 'colorselect',
							'heading'          => __( "Color", 'greyd_forms' ),
							'param_name'       => 'thumb_background_color',
							'value'            => 'color_62',
							'edit_field_class' => 'vc_col-xs-6',
							'group'            => __( "Layout", 'greyd_forms' ),
						),
						array(
							'type'             => 'colorselect',
							'heading'          => __( "Color (active)", 'greyd_forms' ),
							'param_name'       => 'thumb_background_color_focus',
							'value'            => 'color_62',
							'edit_field_class' => 'vc_col-xs-6',
							'group'            => __( "Layout", 'greyd_forms' ),
						),
						array(
							'type'             => 'colorselect',
							'heading'          => __( "Border color", 'greyd_forms' ),
							'param_name'       => 'thumb_color',
							'value'            => 'color_32',
							'edit_field_class' => 'vc_col-xs-6',
							'group'            => __( "Layout", 'greyd_forms' ),
						),
						array(
							'type'             => 'colorselect',
							'heading'          => __( "Border color (active)", 'greyd_forms' ),
							'param_name'       => 'thumb_color_focus',
							'value'            => 'color_31',
							'edit_field_class' => 'vc_col-xs-6',
							'group'            => __( "Layout", 'greyd_forms' ),
						),

						// Tooltip
						array(
							'type'       => 'seperator',
							'heading'    => __( "Tooltip (value)", 'greyd_forms' ),
							'param_name' => 'seperator_tooltip',
							'group'      => __( "Layout", 'greyd_forms' ),
						),
						array(
							'type'             => 'textfield',
							'heading'          => __( "Font size", 'greyd_forms' ),
							'description'      => __( "in px or em", 'greyd_forms' ) . ' (' . sprintf( __( "Default: %s", 'greyd_forms' ), '12px' ) . ')',
							'param_name'       => 'tooltip_font_size',
							// 'value'              => '12px',
							'edit_field_class' => 'vc_col-xs-6',
							'group'            => __( "Layout", 'greyd_forms' ),
						),
						array(
							'type'             => 'textfield',
							'heading'          => __( "Border radius", 'greyd_forms' ),
							'description'      => __( "in px or %", 'greyd_forms' ) . ' (' . sprintf( __( "Default: %s", 'greyd_forms' ), '2px' ) . ')',
							'param_name'       => 'tooltip_border_radius',
							// 'value'              => '2px',
							'edit_field_class' => 'vc_col-xs-6',
							'group'            => __( "Layout", 'greyd_forms' ),
						),
						array(
							'type'             => 'colorselect',
							'heading'          => __( "Background color", 'greyd_forms' ),
							'param_name'       => 'tooltip_background_color',
							'value'            => 'color_21',
							'edit_field_class' => 'vc_col-xs-6',
							'group'            => __( "Layout", 'greyd_forms' ),
						),
						array(
							'type'             => 'colorselect',
							'heading'          => __( "Text color", 'greyd_forms' ),
							'param_name'       => 'tooltip_color',
							'value'            => 'color_33',
							'edit_field_class' => 'vc_col-xs-6',
							'group'            => __( "Layout", 'greyd_forms' ),
						),
					)
				),
			)
		);
	}

	/**
	 * Upload
	 *
	 * @shortcode 'vc_form_upload'
	 */
	public function upload_module() {
		vc_map(
			array(
				'name'        => __( 'Upload', 'greyd_forms' ),
				'description' => __( "File upload by the user", 'greyd_forms' ),
				'base'        => $this->pre . 'upload',
				'category'    => $this->category,
				'weight'      => $this->weight,
				'icon'        => plugins_url( '../assets/icon/forms_upload.svg', __FILE__ ),
				'params'      => array_merge(
					array(

						// Überschrift
						array(
							'type'       => 'seperator',
							'heading'    => __( "General", 'greyd_forms' ),
							'param_name' => 'seperator_title',
						),

						// Type
						array(
							'type'             => 'dropdown',
							'heading'          => __( "File type", 'greyd_forms' ),
							'description'      => __( "What type of file should be uploaded?", 'greyd_forms' ),
							'param_name'       => 'filetype',
							'edit_field_class' => 'vc_col-xs-6',
							'value'            => array(
								_x( "all file types", 'small', 'greyd_forms' )           => '*',
								_x( "ZIP archive", 'small', 'greyd_forms' )                => '.zip',
								_x( 'PDF', 'small', 'greyd_forms' )                       => 'application/pdf',
								_x( "Image", 'small', 'greyd_forms' )                      => 'image/*',
								_x( "text file", 'small', 'greyd_forms' )                 => 'text/*',
								_x( "audio", 'small', 'greyd_forms' )                     => 'audio/*',
								_x( "video", 'small', 'greyd_forms' )                     => 'video/*',
								_x( "other (manual input)", 'small', 'greyd_forms' ) => 'other',
							),
							'admin_label'      => true,
						),

						// Dateigröße max
						array(
							'type'             => 'textfield',
							'heading'          => __( "File size", 'greyd_forms' ),
							'description'      => __( "Maximum allowed file size in MB (e.g. 1.5).", 'greyd_forms' ),
							'param_name'       => 'max',
							'edit_field_class' => 'vc_col-xs-3',
						),

						// Required
						array(
							'type'             => 'checkbox',
							'heading'          => __( "Required field", 'greyd_forms' ),
							'description'      => __( "The user must fill in this field.", 'greyd_forms' ),
							'param_name'       => 'required',
							'admin_label'      => true,
							'edit_field_class' => 'vc_col-xs-3',
							'value'            => array(
								_x( "Yes", 'small', 'greyd_forms' )   => 'true',
							),
						),

						// File types
						array(
							'type'             => 'textfield',
							'heading'          => __( "Allowed file formats", 'greyd_forms' ),
							'description'      => __( "Which file formats should be allowed (example: .xlsx, .xls, .doc)?", 'greyd_forms' ),
							'param_name'       => 'custom_filetype',
							'edit_field_class' => 'vc_col-xs-6',
							'dependency'       => array(
								'element' => 'filetype',
								'value'   => 'other',
							),
						),

						// Unter-Überschrift
						array(
							'type'       => 'seperator',
							'heading'    => __( "Labeling", 'greyd_forms' ),
							'param_name' => 'seperator_naming',
						),

						// Label
						array(
							'type'             => 'textfield',
							'heading'          => __( 'Label', 'greyd_forms' ),
							'description'      => __( "Displayed above the field.", 'greyd_forms' ),
							'param_name'       => 'label',
							'edit_field_class' => 'vc_col-xs-6',
							'admin_label'      => true,
						),

						// Name
						array(
							'type'             => 'textfield',
							'heading'          => __( "Field name", 'greyd_forms' ),
							'description'      => __( "Unique value of the field that is passed with the form.", 'greyd_forms' ),
							'param_name'       => 'name',
							'edit_field_class' => 'vc_col-xs-6 required',
						),

						// Placeholder
						array(
							'type'             => 'textfield',
							'heading'          => __( "Placeholder", 'greyd_forms' ),
							'description'      => __( "Placeholder text in the field. (default: please select)", 'greyd_forms' ),
							'param_name'       => 'placeholder',
							'edit_field_class' => 'vc_col-xs-6',
						),

						// Hilfetext
						array(
							'type'             => 'textarea',
							'heading'          => __( "Tooltip", 'greyd_forms' ),
							'description'      => __( "This text is available for assistance via an info icon and contains explanations of file type and file size by default.", 'greyd_forms' ),
							'param_name'       => 'tooltip',
							'edit_field_class' => 'vc_col-xs-9',
							'dependency'       => array(
								'element'   => 'label',
								'not_empty' => true,
							),
						),

						array(
							'type'       => 'new_line',
							'param_name' => 'new_line_icon',
						),
					),
					// Icon
					array(
						array(
							'type'       => 'seperator',
							'heading'    => __( "Appearance", 'greyd_forms' ),
							'param_name' => 'seperator_icon',
						),
					),
					\vc\helper::custom_icon_params_vc( '' ),
					array(
						// Box Layout Infos
						array(
							'type'       => 'info_text',
							'above'      => __( 'Box-Layout:', 'greyd_forms' ),
							'text'       => __( "Select the position on the <b>left</b> for an icon above the placeholder and on the <b>right</b> for one below. The best way is to set the distance to the text to <b>0px</b> and make the icon much larger, e.g. <b>300%</b>.", 'greyd_forms' ),
							'param_name' => 'box_layout_info_icon',
							'styling'    => 'info',
							'dependency' => array(
								'element' => 'layout',
								'value'   => 'upload-box',
							),
						),
					),
					// Aussehen
					array(
						array(
							'type'       => 'sub_seperator',
							'heading'    => __( 'Layout', 'greyd_forms' ),
							'param_name' => 'seperator_layout',
						),

						// Layout
						array(
							'type'             => 'dropdown',
							'heading'          => __( 'Layout', 'greyd_forms' ),
							'description'      => __( "What should the field look like?", 'greyd_forms' ),
							'param_name'       => 'layout',
							'edit_field_class' => 'vc_col-xs-4',
							'value'            => array(
								_x( "Input field", 'small', 'greyd_forms' ) => '',
								_x( "box", 'small', 'greyd_forms' ) => 'upload-box',
							),
							'admin_label'      => true,
						),

						// Box Layout Infos
						array(
							'type'             => 'info_text',
							'above'            => __( 'Box-Layout:', 'greyd_forms' ),
							'text'             => __( "For a square box, enter the same value for height and width, e.g. <b>150px</b>.", 'greyd_forms' ),
							'param_name'       => 'box_layout_info',
							'edit_field_class' => 'vc_col-xs-8',
							'styling'          => 'info',
							'dependency'       => array(
								'element' => 'layout',
								'value'   => 'upload-box',
							),
						),

						// alignment
						array(
							'type'             => 'dropdown',
							'heading'          => __( "Alignment", 'greyd_forms' ),
							'param_name'       => 'alignment',
							'edit_field_class' => 'vc_col-xs-4',
							'value'            => array(
								_x( "left", 'small', 'greyd_forms' ) => 'left',
								_x( "center", 'small', 'greyd_forms' ) => 'center',
								_x( "right", 'small', 'greyd_forms' ) => 'right',
							),
						),
						// width
						array(
							'type'             => 'textfield',
							'heading'          => __( "Width", 'greyd_forms' ),
							'description'      => __( "in px or %", 'greyd_forms' ),
							'param_name'       => 'width',
							'edit_field_class' => 'vc_col-xs-4',
						),

						// Height (only for box)
						array(
							'type'             => 'textfield',
							'heading'          => __( "Height", 'greyd_forms' ),
							'description'      => __( "in px or %", 'greyd_forms' ),
							'param_name'       => 'height',
							'edit_field_class' => 'vc_col-xs-4',
							'dependency'       => array(
								'element' => 'layout',
								'value'   => 'upload-box',
							),
						),

						array(
							'type'       => 'new_line',
							'param_name' => 'new_line_type',
						),
						// type
						array(
							'type'             => 'dropdown',
							'heading'          => __( "Appearance", 'greyd_forms' ),
							'description'      => __( "What should the field look like?", 'greyd_forms' ),
							'param_name'       => 'style',
							'edit_field_class' => 'vc_col-xs-4',
							'admin_label'      => true,
							'value'            => array(
								_x( "primary field", 'small', 'greyd_forms' ) => '',
								_x( "secondary field", 'small', 'greyd_forms' ) => 'sec',
								_x( "overwrite individually", 'small', 'greyd_forms' ) => 'custom',
							),
						),

					),
					// merge with helper array for custom element
					\vc\helper::custom_element_params_vc( 'input', 'style', 'custom' ),
					// Label Options
					array(
						array(
							'type'       => 'sub_seperator',
							'heading'    => __( 'Label', 'greyd_forms' ),
							'param_name' => 'seperator_label',
						),
						// font-size
						array(
							'type'             => 'textfield',
							'heading'          => __( "Font size", 'greyd_forms' ),
							'description'      => __( "in px or em", 'greyd_forms' ),
							'param_name'       => 'label_font_size',
							'edit_field_class' => 'vc_col-xs-4',
						),
					),
					array(

						// Design Tab
						array(
							'type'       => 'css_editor',
							'heading'    => __( 'CSS', 'greyd_forms' ),
							'param_name' => 'css',
							'group'      => __( "Design settings", 'greyd_forms' ),
						),
					)
				),
			)
		);
	}

	/**
	 * Conditional Fields
	 *
	 * @shortcode 'vc_form_conditional' (parent)
	 * @shortcode 'vc_form_condition' (child)
	 */
	public function conditions_module() {

		// Conditional Fields (Parent)
		vc_map(
			array(
				'name'                    => __( "Conditional container", 'greyd_forms' ),
				'description'             => __( "Interdependent fields", 'greyd_forms' ),
				'base'                    => $this->pre . 'conditional', // Shortcode name
				'category'                => $this->category,
				'weight'                  => $this->weight,
				'icon'                    => plugins_url( '../assets/icon/forms_conditional.svg', __FILE__ ),
				'is_container'            => true,
				'show_settings_on_create' => true,
				'as_parent'               => array(
					'only' => $this->pre . 'condition',
				),
				'js_view'                 => 'VcBackendTtaTabsView',
				'custom_markup'           => '
				<div class="vc_tta-container" data-vc-action="collapse">
					<div class="vc_general vc_tta vc_tta-tabs vc_tta-color-backend-tabs-white vc_tta-style-flat vc_tta-shape-rounded vc_tta-spacing-1 vc_tta-tabs-position-top vc_tta-controls-align-left">
						<div class="vc_tta-tabs-container">'
										   . '<ul class="vc_tta-tabs-list">'
										   . '<li class="vc_tta-tab" data-vc-tab data-vc-target-model-id="{{ model_id }}" data-element_type="' . $this->pre . 'condition"><a href="javascript:;" data-vc-tabs data-vc-container=".vc_tta" data-vc-target="[data-model-id=\'{{ model_id }}\']" data-vc-target-model-id="{{ model_id }}"><span class="vc_tta-title-text">{{ section_title }}</span></a></li>'
										   . '</ul>
						</div>
						<div class="vc_tta-panels vc_clearfix {{container-class}}">
						  {{ content }}
						</div>
					</div>
				</div>',
				'default_content'         => '
				[' . $this->pre . 'condition title="' . __( "first condition", 'greyd_forms' ) . '" options="%5B%7B%22field%22%3A%220%22%2C%22condition%22%3A%22not_empty%22%7D%5D"][/' . $this->pre . 'condition' . ']
				[' . $this->pre . 'condition title="' . __( "second condition", 'greyd_forms' ) . '"][/' . $this->pre . 'condition' . ']
			',
				'admin_enqueue_js'        => array(
					vc_asset_url( 'lib/vc_tabs/vc-tabs.min.js' ), // required tta-tabs javascript
				),
				'params'                  => array(

					// Überschrift
					array(
						'type'       => 'seperator',
						'heading'    => __( "General", 'greyd_forms' ),
						'param_name' => 'seperator_title',
					),

					// // Feld Name (as text input)
					// array(
					// 'type' => 'textfield',
					// 'param_name' => 'dependant_field',
					// 'heading' => __( "Field name", 'greyd_forms' ),
					// 'description' => __( "Which field does this section depend on?", 'greyd_forms' ),
					// 'edit_field_class' => 'vc_col-xs-6',
					// ),

					// Feld Name (as dropdown)
					array(
						'type'             => 'dropdown',
						'param_name'       => 'dependant_field',
						'heading'          => __( "Reference field", 'greyd_forms' ),
						'description'      => __( "Which field does this section depend on?", 'greyd_forms' ) . '<br><br>',
						'edit_field_class' => 'vc_col-xs-6',
						'value'            => $this->inputs,
					),

					// Info
					array(
						'type'             => 'info_text',
						'param_name'       => 'info_text2',
						'text'             => __( "Refresh the page if your field name does not appear in the overview.", 'greyd_forms' ),
						'styling'          => 'info',
						'edit_field_class' => 'vc_col-xs-6',
					),

					// array(
					// "type"        => 'new_line',
					// "param_name"  => 'new_line_type',
					// ),

					// Second?
					array(
						'type'             => 'checkbox',
						'param_name'       => 'second',
						'heading'          => __( "Second reference field", 'greyd_forms' ),
						'value'            => array( __( "enable", 'greyd_forms' ) => 'true' ),
						'edit_field_class' => 'vc_col-xs-3',
						'dependency'       => array(
							'element'   => 'dependant_field',
							'not_empty' => true,
						),
					),

					// second field
					array(
						'type'             => 'dropdown',
						'param_name'       => 'dependant_field2',
						'heading'          => __( "Reference field", 'greyd_forms' ),
						'edit_field_class' => 'vc_col-xs-6',
						'value'            => $this->inputs,
						'dependency'       => array(
							'element'   => 'second',
							'not_empty' => true,
						),
					),

					// seperator
					array(
						'type'       => 'new_line',
						'param_name' => 'new_line',
					),

					// Third?
					array(
						'type'             => 'checkbox',
						'param_name'       => 'third',
						'heading'          => __( "Third reference field", 'greyd_forms' ),
						'value'            => array( __( "enable", 'greyd_forms' ) => 'true' ),
						'edit_field_class' => 'vc_col-xs-3',
						'dependency'       => array(
							'element'   => 'second',
							'not_empty' => true,
						),
					),

					// third field
					array(
						'type'             => 'dropdown',
						'param_name'       => 'dependant_field3',
						'heading'          => __( "Reference field", 'greyd_forms' ),
						'edit_field_class' => 'vc_col-xs-6',
						'value'            => $this->inputs,
						'dependency'       => array(
							'element' => 'third',
							'value'   => 'true',
						),
					),

					// seperator
					array(
						'type'       => 'seperator',
						'param_name' => 'seperator_anim',
					),

					// Animation
					array(
						'type'             => 'dropdown',
						'heading'          => __( 'Animation', 'greyd_forms' ),
						'description'      => __( "How do you want to hide & display the fields?", 'greyd_forms' ),
						'param_name'       => 'anim',
						'edit_field_class' => 'vc_col-xs-6',
						'admin_label'      => true,
						'value'            => array(
							_x( "slide", 'small', 'greyd_forms' ) => 'slide',
							_x( "fade-in & -out", 'small', 'greyd_forms' ) => 'fade',
							_x( "slide & fade", 'small', 'greyd_forms' ) => 'slide fade',
							_x( "none", 'small', 'greyd_forms' ) => 'none',
						),
					),

					// Info
					array(
						'type'             => 'info_text',
						'param_name'       => 'info_text',
						'text'             => __( "This container represents different ranges depending on the value of the specified field. The exact values & contents are set within the tabs.", 'greyd_forms' ),
						'styling'          => 'info',
						'edit_field_class' => 'vc_col-xs-6',
					),

					// reset after
					array(
						'type'             => 'checkbox',
						'param_name'       => 'reset_after',
						'heading'          => __( "Leave containers standing after submission?", 'greyd_forms' ),
						'description'      => __( "If the check mark is set, the container is not reset.", 'greyd_forms' ),
						'edit_field_class' => 'vc_col-xs-6',
						'value'            => array(
							_x( "Yes", 'small', 'greyd_forms' ) => 'true',
						),
					),
				),
			)
		);

		// Condition (Child)
		vc_map(
			array(
				'name'                      => __( "Content of the condition", 'greyd_forms' ),
				'base'                      => $this->pre . 'condition',
				'icon'                      => plugins_url( '../assets/icon/forms_conditional.svg', __FILE__ ),
				'allowed_container_element' => 'vc_row',
				'is_container'              => true,
				'show_settings_on_create'   => false,
				'as_child'                  => array(
					'only' => $this->pre . 'conditional',
				),
				'category'                  => $this->category,
				'weight'                    => $this->weight,
				'js_view'                   => 'VcBackendTtaSectionView',
				'custom_markup'             => '
				<div class="vc_tta-panel-heading">
					<h4 class="vc_tta-panel-title vc_tta-controls-icon-position-left"><a href="javascript:;" data-vc-target="[data-model-id=\'{{ model_id }}\']" data-vc-accordion data-vc-container=".vc_tta-container"><span class="vc_tta-title-text">{{ section_title }}</span><i class="vc_tta-controls-icon vc_tta-controls-icon-plus"></i></a></h4>
				</div>
				<div class="vc_tta-panel-body">
					{{ editor_controls }}
					<div class="{{ container-class }}">
					{{ content }}
					</div>
				</div>',
				'params'                    => array(

					// Title
					array(
						'type'             => 'textfield',
						'param_name'       => 'title',
						'heading'          => __( "Tab name", 'greyd_forms' ),
						'description'      => __( "Name of the tab in the backend.", 'greyd_forms' ),
						'edit_field_class' => 'vc_col-xs-6',
					),

					// Default view
					array(
						'type'             => 'dropdown',
						'heading'          => __( "Initial appearance", 'greyd_forms' ),
						'description'      => __( "Do you want to display the container when the page is loaded?", 'greyd_forms' ),
						'param_name'       => 'default_view',
						'edit_field_class' => 'vc_col-xs-6',
						'admin_label'      => true,
						'value'            => array(
							_x( "hide", 'small', 'greyd_forms' ) => 'hide',
							_x( "show", 'small', 'greyd_forms' ) => 'show',
						),
					),

					// Info
					array(
						'type'             => 'info_text',
						'param_name'       => 'info_view',
						'text'             => __( "The container disappears as soon as another condition applies.", 'greyd_forms' ),
						'styling'          => 'info',
						'edit_field_class' => 'vc_col-xs-12',
						'dependency'       => array(
							'element' => 'default_view',
							'value'   => 'show',
						),
					),

					// Überschrift
					array(
						'type'       => 'seperator',
						'param_name' => 'seperator_title',
						'dependency' => array(
							'element' => 'default_view',
							'value'   => 'hide',
						),
					),

					// && oder ||
					array(
						'type'             => 'dropdown',
						'heading'          => __( "What must be true?", 'greyd_forms' ),
						'param_name'       => 'condition_type',
						'edit_field_class' => 'vc_col-xs-6',
						'admin_label'      => true,
						'value'            => array(
							_x( "at least one property (or)", 'small', 'greyd_forms' ) => '||',
							_x( "all properties", 'small', 'greyd_forms' ) => '&&',
						),
						'dependency'       => array(
							'element' => 'default_view',
							'value'   => 'hide',
						),
					),

					// Optionen
					array(
						'type'        => 'param_group',
						'heading'     => __( "Properties", 'greyd_forms' ),
						'description' => __( "As soon as one of the properties is true, the container is displayed. Be careful not to set conflicting values.", 'greyd_forms' ),
						'param_name'  => 'options',
						'dependency'  => array(
							'element' => 'default_view',
							'value'   => 'hide',
						),
						'params'      => array_merge(
							array(
								// Feld Wert
								array(
									'type'             => 'dropdown',
									'param_name'       => 'field',
									'heading'          => __( "Reference field", 'greyd_forms' ),
									'edit_field_class' => 'vc_col-xs-3',
									'admin_label'      => true,
									'value'            => array(
										_x( "first reference field", 'small', 'greyd_forms' ) => 0,
										_x( "Second reference field", 'small', 'greyd_forms' ) . ' ' . __( "(if defined)", 'greyd_forms' ) => 1,
										_x( "Third reference field", 'small', 'greyd_forms' ) . ' ' . __( "(if defined)", 'greyd_forms' ) => 2,
									),
								),
								array(
									'type'             => 'dropdown',
									'heading'          => __( "Condition", 'greyd_forms' ),
									'param_name'       => 'condition',
									'edit_field_class' => 'vc_col-xs-3',
									'admin_label'      => true,
									'value'            => array(
										_x( "has the value:", 'small', 'greyd_forms' ) => 'is',
										_x( "contains the value:", 'small', 'greyd_forms' ) => 'has',
										_x( "has not the value:", 'small', 'greyd_forms' ) => 'is_not',
										_x( "is empty", 'small', 'greyd_forms' ) => 'empty',
										_x( "is not empty", 'small', 'greyd_forms' ) => 'not_empty',
										_x( "greater (>)", 'small', 'greyd_forms' ) => 'greater',
										_x( "greater than or equal to (>=)", 'small', 'greyd_forms' ) => 'greater_equal',
										_x( "smaller (<)", 'small', 'greyd_forms' ) => 'smaller',
										_x( "less than or equal to (<=)", 'small', 'greyd_forms' ) => 'smaller_equal',
									),
								),
								// Feld Wert
								array(
									'type'             => 'textfield',
									'param_name'       => 'value',
									'heading'          => __( "Value", 'greyd_forms' ),
									'description'      => __( "For checkboxes, the values 'on' and 'off' apply.", 'greyd_forms' ),
									'edit_field_class' => 'vc_col-xs-6',
									'admin_label'      => true,
									'dependency'       => array(
										'element' => 'condition',
										'value'   => array( 'is', 'is_not', 'has', 'greater', 'greater_equal', 'smaller', 'smaller_equal', 'same' ),
									),
								),
							)
						),
					),

					// // Info
					// array(
					// 'type' => 'info_text',
					// 'param_name' => 'info_checkbox',
					// 'text' => __( "For checkboxes, the values 'on' and 'off' apply.", 'greyd_forms' ),
					// 'styling' => 'info',
					// 'edit_field_class' => 'vc_col-xs-12',
					// ),
				),
			)
		);
	}

	/**
	 * reCAPTCHA
	 *
	 * @shortcode 'vc_form_captcha'
	 */
	public function captcha_module() {
		vc_map(
			array(
				'name'        => __( 'reCAPTCHA', 'greyd_forms' ),
				'description' => __( 'Google reCAPTCHA', 'greyd_forms' ),
				'base'        => $this->pre . 'captcha',
				'category'    => $this->category,
				'weight'      => $this->weight,
				'icon'        => plugins_url( '../assets/icon/forms_captcha.svg', __FILE__ ),
				'params'      => array(

					// Überschrift
					array(
						'type'       => 'seperator',
						'heading'    => __( "General", 'greyd_forms' ),
						'param_name' => 'seperator_title',
					),

					// Hide Badge?
					array(
						'type'             => 'checkbox',
						'heading'          => __( "Hide?", 'greyd_forms' ),
						'description'      => sprintf(
							__( "By default, the reCAPTCHA disruptor is displayed. We do not recommend hiding it, as the disruptor is used to display the privacy policy that applies to the reCAPTCHA. You can find them here: %1\$1s, %2\$2s.", 'greyd_forms' ),
							'<a href="https://policies.google.com/privacy">' . __( "Privacy policy", 'greyd_forms' ) . '</a>',
							'<a href="https://policies.google.com/terms">' . __( "Terms", 'greyd_forms' ) . '</a>'
						),
						'param_name'       => 'hide',
						'edit_field_class' => 'vc_col-xs-12',
						'admin_label'      => true,
						'value'            => array(
							_x( "Yes", 'small', 'greyd_forms' ) => 'true',
						),
					),

					// Design Tab
					array(
						'type'       => 'css_editor',
						'heading'    => __( 'CSS', 'greyd_forms' ),
						'param_name' => 'css',
						'group'      => __( "Design settings", 'greyd_forms' ),
					),
				),
			)
		);
	}

	/**
	 * Hidden Fields
	 *
	 * @shortcode 'vc_form_hidden'
	 */
	public function hidden_field_module() {
		vc_map(
			array(
				'name'        => __( "Hidden field", 'greyd_forms' ),
				'description' => __( "Transmission of hidden values", 'greyd_forms' ),
				'base'        => $this->pre . 'hidden',
				'category'    => $this->category,
				'weight'      => $this->weight,
				'icon'        => plugins_url( '../assets/icon/forms_hidden.svg', __FILE__ ),
				'params'      => array(

					// Überschrift
					array(
						'type'       => 'seperator',
						'heading'    => __( "General", 'greyd_forms' ),
						'param_name' => 'seperator_title',
					),

					// Name
					array(
						'type'             => 'textfield',
						'heading'          => __( "Field name", 'greyd_forms' ),
						'description'      => __( "Unique value of the field that is passed with the form.", 'greyd_forms' ),
						'param_name'       => 'name',
						'edit_field_class' => 'vc_col-xs-6 required',
						'admin_label'      => true,
					),
					array(
						'type'       => 'new_line',
						'param_name' => 'new_line_value',
					),

					// Überschrift
					array(
						'type'       => 'sub_seperator',
						'heading'    => __( "Field value", 'greyd_forms' ),
						'param_name' => 'seperator_value',
					),

					// Value type
					array(
						'type'             => 'dropdown',
						'heading'          => __( "Type", 'greyd_forms' ),
						'param_name'       => 'type',
						'edit_field_class' => 'vc_col-xs-6',
						'admin_label'      => true,
						'value'            => array(
							_x( "manual input", 'small', 'greyd_forms' ) => 'static',
							_x( "fill dynamically", 'small', 'greyd_forms' ) => 'dynamic',
						),
					),

					// Static value
					array(
						'type'             => 'textfield',
						'heading'          => __( "Value", 'greyd_forms' ),
						'param_name'       => 'value',
						'edit_field_class' => 'vc_col-xs-6',
						'admin_label'      => true,
						'dependency'       => array(
							'element' => 'type',
							'value'   => 'static',
						),
					),

					// Dynamic value
					array(
						'type'             => 'dropdown',
						'heading'          => __( "Value type", 'greyd_forms' ),
						'param_name'       => 'dyn_type',
						'edit_field_class' => 'vc_col-xs-6',
						// 'admin_label'   =>  true,
						'value'            => array(
							_x( "URL parameter", 'small', 'greyd_forms' )   => 'urlparam',
							_x( "session cookie", 'small', 'greyd_forms' )  => 'cookie',
							_x( "current URL", 'small', 'greyd_forms' )    => 'url',
						),
						'dependency'       => array(
							'element' => 'type',
							'value'   => 'dynamic',
						),
					),

					// URL param
					array(
						'type'             => 'textfield',
						'heading'          => __( "Enter the name of the URL parameter", 'greyd_forms' ),
						'param_name'       => 'value_urlparam',
						'edit_field_class' => 'vc_col-xs-12',
						'dependency'       => array(
							'element' => 'dyn_type',
							'value'   => 'urlparam',
						),
						'description'      => __( "Example: For the URL <u>www.website.com/?source=google</u> you have to enter <b>'source'</b> in this field so that the value of the hidden field becomes <b>'google'</b>.", 'greyd_forms' ),
					),

					// Cookie
					array(
						'type'             => 'textfield',
						'heading'          => __( "Name of the cookie", 'greyd_forms' ),
						'param_name'       => 'value_cookie',
						'edit_field_class' => 'vc_col-xs-12',
						'dependency'       => array(
							'element' => 'dyn_type',
							'value'   => 'cookie',
						),
						'description'      => __( "Enter the unique name of the cookie here.", 'greyd_forms' ),
					),
				),
			)
		);
	}

	/**
	 * Math operation
	 *
	 * @shortcode 'vc_form_math'
	 * @since 0.8.8
	 */
	public function math_module() {
		vc_map(
			array(
				'name'        => __( "Mathematical field", 'greyd_forms' ),
				'description' => __( "Conditional calculation of a field value", 'greyd_forms' ),
				'base'        => $this->pre . 'math',
				'category'    => $this->category,
				'weight'      => $this->weight,
				'icon'        => plugins_url( '../assets/icon/forms_math.svg', __FILE__ ),
				'params'      => array_merge(
					array(

						// General
						array(
							'type'       => 'seperator',
							'heading'    => __( "General", 'greyd_forms' ),
							'param_name' => 'seperator_title',
						),
						array(
							'type'             => 'textfield',
							'heading'          => __( "Field name", 'greyd_forms' ),
							'description'      => __( "Unique value of the field that is passed with the form.", 'greyd_forms' ),
							'param_name'       => 'name',
							'edit_field_class' => 'vc_col-xs-6 required',
							'admin_label'      => true,
						),
						array(
							'type'             => 'textfield',
							'heading'          => __( "Decimal places", 'greyd_forms' ),
							'description'      => __( "Number of decimal places of the field value. (default: 0)", 'greyd_forms' ),
							'param_name'       => 'decimals',
							'edit_field_class' => 'vc_col-xs-6',
							'admin_label'      => true,
						),
						array(
							'type'        => 'math_operator',
							'heading'     => __( "Value", 'greyd_forms' ),
							'param_name'  => 'value',
							'admin_label' => true,
						),

						// Display
						array(
							'type'       => 'seperator',
							'heading'    => __( "Appearance", 'greyd_forms' ),
							'param_name' => 'seperator_display',
						),
						array(
							'type'        => 'checkbox',
							'description' => '&nbsp;',
							'param_name'  => 'display',
							'value'       => array(
								_x( "Show result", 'small', 'greyd_forms' ) => 'display_result',
								_x( "Show formula", 'small', 'greyd_forms' ) => 'display_formula',
							),
						),
						array(
							'type'             => 'colorselect',
							'heading'          => __( "Color", 'greyd_forms' ),
							'param_name'       => 'color',
							'edit_field_class' => 'vc_col-xs-6',
							'dependency'       => array(
								'element'   => 'display',
								'not_empty' => true,
							),
						),
						array(
							'type'             => 'dropdown',
							'heading'          => __( "Appearance", 'greyd_forms' ),
							'param_name'       => 'tag',
							'edit_field_class' => 'vc_col-xs-3',
							'value'            => array(
								_x( "default", 'small', 'greyd_forms' ) => '',
								_x( "bold", 'small', 'greyd_forms' ) => 'strong',
								'H1' => 'h1',
								'H2' => 'h2',
								'H3' => 'h3',
								'H4' => 'h4',
								'H5' => 'h5',
								'H6' => 'h6',
							),
							'dependency'       => array(
								'element'   => 'display',
								'not_empty' => true,
							),
						),
						array(
							'type'             => 'dropdown',
							'heading'          => __( "Alignment", 'greyd_forms' ),
							'param_name'       => 'align',
							'edit_field_class' => 'vc_col-xs-3',
							'value'            => array(
								_x( "left", 'small', 'greyd_forms' ) => 'left',
								_x( "center", 'small', 'greyd_forms' ) => 'center',
								_x( "right", 'small', 'greyd_forms' ) => 'right',
							),
							'dependency'       => array(
								'element'   => 'display',
								'not_empty' => true,
							),
						),
						array(
							'type'       => 'info_text',
							'param_name' => 'display_info',
							'text'       => __( "A mathematical field is not a front-end field.", 'greyd_forms' ) . '<br><br>' . __( "You can either display the field value here, or use the dynamic placeholders in headings and text.", 'greyd_forms' ),
							'styling'    => 'info',
					// 'edit_field_class' => 'vc_col-xs-8',
						),

						// Conditional Values
						array(
							'type'       => 'seperator',
							'heading'    => __( "Conditional values", 'greyd_forms' ),
							'param_name' => 'seperator_conditions',
						),
						array(
							'type'        => 'checkbox',
							'description' => '&nbsp;',
							'param_name'  => 'enable_conditions',
							'value'       => array(
								_x( "Change field value depending on condition", 'small', 'greyd_forms' ) => 'true',
							),
						),
						array(
							'type'       => 'param_group',
							'heading'    => __( "Conditions", 'greyd_forms' ),
							'param_name' => 'conditions',
							'dependency' => array(
								'element' => 'enable_conditions',
								'value'   => 'true',
							),
							'params'     => array_merge(
								array(
									array(
										'type'             => 'math_operator',
										'heading'          => __( "If", 'greyd_forms' ),
										'param_name'       => 'field1',
										'admin_label'      => true,
										'edit_field_class' => 'vc_col-xs-5',
										'rows'             => 3,
										'inline_descr'     => '',
										'placeholder'      => "{field_01} * 2",
									),
									array(
										'type'             => 'dropdown',
										'heading'          => __( "Is", 'greyd_forms' ),
										'param_name'       => 'operator',
										'edit_field_class' => 'vc_col-xs-2',
										'admin_label'      => true,
										'value'            => array(
											_x( "greater (>)", 'small', 'greyd_forms' ) => 'greater',
											_x( "greater than or equal to (>=)", 'small', 'greyd_forms' ) => 'greater_equal',
											_x( "smaller (<)", 'small', 'greyd_forms' ) => 'smaller',
											_x( "less than or equal to (<=)", 'small', 'greyd_forms' ) => 'smaller_equal',
											_x( "equal (==)", 'small', 'greyd_forms' ) => 'is',
										),
									),
									array(
										'type'             => 'math_operator',
										'heading'          => __( "Than", 'greyd_forms' ),
										'param_name'       => 'field2',
										'admin_label'      => true,
										'edit_field_class' => 'vc_col-xs-5',
										'rows'             => 3,
										'inline_descr'     => '',
										'placeholder'      => "{field_02} / 3",
									),
									array(
										'type'        => 'math_operator',
										'heading'     => __( "Then", 'greyd_forms' ),
										'param_name'  => 'value',
										'admin_label' => true,
										'placeholder' => __( "The field then takes this value", 'greyd_forms' ),
									),
								)
							),
						),
					)
				),
			)
		);
	}

	/**
	 * Button steps (multistep forms)
	 *
	 * @shortcode 'vc_form_button_steps'
	 */
	public function button_steps_module() {
		vc_map(
			array(
				'name'        => __( "Next / Back", 'greyd_forms' ),
				'description' => __( "Navigation between the steps of a multi-level form", 'greyd_forms' ),
				'base'        => $this->pre . 'button_steps',
				'category'    => $this->category,
				'weight'      => $this->weight,
				'icon'        => plugins_url( '../assets/icon/forms_steps.svg', __FILE__ ),
				'params'      => array_merge(
					array(

						// Überschrift
						array(
							'type'       => 'seperator',
							'heading'    => __( "General", 'greyd_forms' ),
							'param_name' => 'seperator_title',
						),

						// Text
						array(
							'type'             => 'textfield',
							'heading'          => __( "text", 'greyd_forms' ),
							'description'      => __( "What should be on the button? (default: next)", 'greyd_forms' ),
							'param_name'       => 'text',
							'edit_field_class' => 'vc_col-xs-5',
							'admin_label'      => true,
						),

						// Type
						array(
							'type'             => 'dropdown',
							'heading'          => __( "Action", 'greyd_forms' ),
							'param_name'       => 'action',
							'edit_field_class' => 'vc_col-xs-4',
							'admin_label'      => true,
							'value'            => array(
								_x( "move on to the next step", 'small', 'greyd_forms' ) => 'next_step',
								_x( "go back to the previous step", 'small', 'greyd_forms' ) => 'prev_step',
								_x( "go to certain step", 'small', 'greyd_forms' ) => 'exact_step',
							),
						),

						// Gehe zu Schritt:
						array(
							'type'             => 'textfield',
							'heading'          => __( "Step number or ID", 'greyd_forms' ),
							'description'      => "<small style='display:inline-block;line-height:130%;'>" . __( "<b>Attention:</b> If mandatory fields are skipped, this can cause problems when submitting the form.", 'greyd_forms' ) . '</small>',
							'param_name'       => 'step_number',
							'edit_field_class' => 'vc_col-xs-3',
							'dependency'       => array(
								'element' => 'action',
								'value'   => 'exact_step',
							),
						),

						array(
							'type'       => 'new_line',
							'param_name' => 'new_line_icon',
						),
					),
					// layout options
					array(
						array(
							'type'       => 'seperator',
							'heading'    => __( "Appearance", 'greyd_forms' ),
							'param_name' => 'seperator_layout',
						),
						// alignment
						array(
							'type'             => 'dropdown',
							'heading'          => __( "Alignment", 'greyd_forms' ),
							'param_name'       => 'alignment',
							'edit_field_class' => 'vc_col-xs-4',
							'admin_label'      => true,
							'value'            => array(
								_x( "left", 'small', 'greyd_forms' ) => 'left',
								_x( "center", 'small', 'greyd_forms' ) => 'center',
								_x( "right", 'small', 'greyd_forms' ) => 'right',
							),
						),
						// width
						array(
							'type'             => 'textfield',
							'heading'          => __( "Width", 'greyd_forms' ),
							'description'      => __( "in px or %", 'greyd_forms' ),
							'param_name'       => 'width',
							'edit_field_class' => 'vc_col-xs-4',
						),
						// Größe
						array(
							'type'             => 'dropdown',
							'heading'          => __( "Size", 'greyd_forms' ),
							'description'      => __( "How big should the button be?", 'greyd_forms' ),
							'param_name'       => 'size',
							'edit_field_class' => 'vc_col-xs-4',
							'value'            => array(
								_x( "default", 'small', 'greyd_forms' ) => '',
								_x( "big", 'small', 'greyd_forms' ) => '_big',
								_x( "small", 'small', 'greyd_forms' ) => '_small',
							),
						),
					),
					array(

						array(
							'type'       => 'new_line',
							'param_name' => 'new_line_type',
						),
						// type
						array(
							'type'             => 'dropdown',
							'heading'          => __( "Appearance", 'greyd_forms' ),
							'description'      => __( "What should the button look like?", 'greyd_forms' ),
							'param_name'       => 'type',
							'edit_field_class' => 'vc_col-xs-4',
							'admin_label'      => true,
							'value'            => array(
								_x( "primary button", 'small', 'greyd_forms' ) => '_button',
								_x( "secondary button", 'small', 'greyd_forms' ) => '_button _sec',
								_x( "alternate button", 'small', 'greyd_forms' ) => '_button _trd',
								_x( "primary link", 'small', 'greyd_forms' ) => '_link',
								_x( "secondary link", 'small', 'greyd_forms' ) => '_link _sec',
								_x( "overwrite individually", 'small', 'greyd_forms' ) => 'custom',
							),
						),

					),
					// merge with helper array for custom element
					\vc\helper::custom_element_params_vc( 'btn', 'type', 'custom' ),
					// Icon
					\vc\helper::custom_icon_params_vc( '' )
				),
			)
		);
	}

	/**
	 * Submit button
	 *
	 * @shortcode 'vc_form_button'
	 */
	public function submit_button_module() {
		vc_map(
			array(
				'name'        => __( "Submit button", 'greyd_forms' ),
				'description' => __( "Trigger to submit the form", 'greyd_forms' ),
				'base'        => $this->pre . 'button',
				'category'    => $this->category,
				'weight'      => $this->weight,
				'icon'        => plugins_url( '../assets/icon/forms_button.svg', __FILE__ ),
				'params'      => array_merge(
					array(

						// Überschrift
						array(
							'type'       => 'seperator',
							'heading'    => __( "General", 'greyd_forms' ),
							'param_name' => 'seperator_title',
						),

						// // Type
						// array(
						// 'type'        => 'dropdown',
						// 'heading'     => __("Appearance", 'greyd_forms'),
						// 'description' => __('Wie soll der button dargestellt werden', 'greyd_forms'),
						// 'param_name'  => 'type',
						// 'edit_field_class' => 'vc_col-xs-6',
						// 'admin_label' => true,
						// 'value' => array(
						// 'Primary'      => '',
						// 'Secondary'      => 'sec',
						// ),
						// ),

						// Text
						array(
							'type'             => 'textarea',
							'heading'          => __( "text", 'greyd_forms' ),
							'description'      => __( "What should be on the button? (default: send)", 'greyd_forms' ),
							'param_name'       => 'text',
							'edit_field_class' => 'vc_col-xs-6',
							'admin_label'      => true,
						),

						// // Breite
						// array(
						// 'type'        => 'textfield',
						// 'heading'     => __('Breite in px oder %', 'greyd_forms'),
						// 'description' => __("Hier können Sie die Breite des Buttons überschreiben.", 'greyd_forms'),
						// 'param_name'  => 'width',
						// 'edit_field_class' => 'vc_col-xs-6',
						// ),

						// // Ausrichtung
						// array(
						// 'type'        => 'dropdown',
						// 'heading'     => __("Alignment", 'greyd_forms'),
						// 'param_name'  => 'alignment',
						// 'edit_field_class' => 'vc_col-xs-6',
						// 'value' => array(
						// 'Linksbündig'      => 'left',
						// 'Zentriert'      => 'center',
						// 'Rechtsbündig'      => 'right'
						// ),
						// ),

						array(
							'type'       => 'new_line',
							'param_name' => 'new_line_icon',
						),
					),
					// layout options
					array(
						array(
							'type'       => 'seperator',
							'heading'    => __( "Appearance", 'greyd_forms' ),
							'param_name' => 'seperator_layout',
						),
						// alignment
						array(
							'type'             => 'dropdown',
							'heading'          => __( "Alignment", 'greyd_forms' ),
							'param_name'       => 'alignment',
							'edit_field_class' => 'vc_col-xs-4',
							'admin_label'      => true,
							'value'            => array(
								_x( "left", 'small', 'greyd_forms' ) => 'left',
								_x( "center", 'small', 'greyd_forms' ) => 'center',
								_x( "right", 'small', 'greyd_forms' ) => 'right',
							),
						),
						// width
						array(
							'type'             => 'textfield',
							'heading'          => __( "Width", 'greyd_forms' ),
							'description'      => __( "in px or %", 'greyd_forms' ),
							'param_name'       => 'width',
							'edit_field_class' => 'vc_col-xs-4',
						),
						// Größe
						array(
							'type'             => 'dropdown',
							'heading'          => __( "Size", 'greyd_forms' ),
							'description'      => __( "How big should the button be?", 'greyd_forms' ),
							'param_name'       => 'size',
							'edit_field_class' => 'vc_col-xs-4',
							'value'            => array(
								_x( "default", 'small', 'greyd_forms' ) => '',
								_x( "big", 'small', 'greyd_forms' ) => '_big',
								_x( "small", 'small', 'greyd_forms' ) => '_small',
							),
						),
					),
					array(

						array(
							'type'       => 'new_line',
							'param_name' => 'new_line_type',
						),
						// type
						array(
							'type'             => 'dropdown',
							'heading'          => __( "Appearance", 'greyd_forms' ),
							'description'      => __( "What should the button look like?", 'greyd_forms' ),
							'param_name'       => 'type',
							'edit_field_class' => 'vc_col-xs-4',
							'admin_label'      => true,
							'value'            => array(
								_x( "primary button", 'small', 'greyd_forms' ) => '',
								_x( "secondary button", 'small', 'greyd_forms' ) => 'sec',
								_x( "alternate button", 'small', 'greyd_forms' ) => 'trd',
								_x( "overwrite individually", 'small', 'greyd_forms' ) => 'custom',
							),
						),

					),
					// merge with helper array for custom element
					\vc\helper::custom_element_params_vc( 'btn', 'type', 'custom' ),
					// Icon
					\vc\helper::custom_icon_params_vc( '' )
				),
			)
		);
	}

	/**
	 * Add deprecated modules
	 */
	public function deprecated_modules() {

		/**
		 * Info notice
		 *
		 * @shortcode 'vc_form_info'
		 */
		vc_map(
			array(
				'name'        => __( "Note", 'greyd_forms' ),
				'description' => __( "Info text with icon", 'greyd_forms' ),
				'base'        => $this->pre . 'info',
				'category'    => $this->category,
				'weight'      => $this->weight,
				'deprecated'  => '0.8.1',
				'icon'        => plugins_url( '../assets/icon/forms_info.svg', __FILE__ ),
				'params'      => array(

					// Überschrift
					array(
						'type'       => 'seperator',
						'heading'    => __( "Content", 'greyd_forms' ),
						'param_name' => 'seperator_title',
					),

					// Text
					array(
						'type'             => 'textarea_html',
						'heading'          => __( "text", 'greyd_forms' ),
						'description'      => __( "Enter the note text here.", 'greyd_forms' ),
						'value'            => __( "I am a note.", 'greyd_forms' ),
						'param_name'       => 'content',
						'edit_field_class' => 'vc_col-xs-12',
						'admin_label'      => true,
					),

					// Color
					array(
						'type'       => 'colorselect',
						'heading'    => __( "Font color", 'greyd_forms' ),
						// 'description' => __("Standard: hellgrau", 'greyd_forms'),
						'param_name' => 'textcolor',
					),

					// Überschrift
					array(
						'type'       => 'seperator',
						'heading'    => __( 'Icon', 'greyd_forms' ),
						'param_name' => 'seperator_title',
					),

					// Icon
					array(
						'type'        => 'attach_image',
						'heading'     => __( 'Icon', 'greyd_forms' ),
						'description' => __( "Icon next to the text.", 'greyd_forms' ),
						'param_name'  => 'icon',
					),

					// width
					array(
						'type'             => 'textfield',
						'heading'          => __( "Width", 'greyd_forms' ),
						'description'      => __( 'in px', 'greyd_forms' ),
						'value'            => '20px',
						'param_name'       => 'iconwidth',
						'edit_field_class' => 'vc_col-xs-3',
					),

					// margin
					array(
						'type'             => 'textfield',
						'heading'          => __( "Space", 'greyd_forms' ),
						'description'      => __( "Space from the text. (Unit: in px)", 'greyd_forms' ),
						'value'            => '8px',
						'param_name'       => 'iconmargin',
						'edit_field_class' => 'vc_col-xs-3',
					),

					// Design Tab
					array(
						'type'       => 'css_editor',
						'heading'    => __( 'CSS', 'greyd_forms' ),
						'param_name' => 'css',
						'group'      => __( "Design settings", 'greyd_forms' ),
					),
				),
			)
		);
	}


	/**
	 * =================================================================
	 *                          CONTROLS
	 * =================================================================
	 */

	/**
	 * Add custom controls
	 */
	public function add_custom_controls() {

		// add vc.js script
		vc_add_shortcode_param(
			'__vc_js__',
			function( $settings, $value ) {
				return '';
			},
			plugins_url( 'assets/vc-edit.js', __FILE__ )
		);

		// add math control
		vc_add_shortcode_param(
			'math_operator',
			function( $settings, $value ) {
				return $this->math_operator_control( $settings, $value );
			}
		);
	}

	/**
	 * Math operation control
	 *
	 * @param array  $settings   The param settings.
	 * @param string $value     Field value.
	 * @param string $class     Extra CSS class.
	 */
	public function math_operator_control( $settings, $value, $class = 'wpb_vc_param_value' ) {

		$name         = esc_attr( $settings['param_name'] );
		$rows         = isset( $settings['rows'] ) ? intval( esc_attr( $settings['rows'] ) ) : 5;
		$placeholder  = isset( $settings['placeholder'] ) ? esc_attr( $settings['placeholder'] ) : __( "Enter your formulas and fields here, e.g. 100 / ( 2.13 * 10 )", 'greyd_forms' );
		$inline_descr = isset( $settings['inline_descr'] ) ? esc_attr( $settings['inline_descr'] ) : false;
		$operators    = array( '+', '-', '*', '/', '^()', '√()', 'log()', '(', ')' );

		ob_start();

		echo "<textarea name='$name' class='textarea_raw_html $name $class' rows='$rows' placeholder='$placeholder'>$value</textarea>";

		// fields
		echo '<p>' . __( "Fields:", 'greyd_forms' ) . '&nbsp;';
		foreach ( $this->inputs as $i => $name ) {
			if ( $i !== 0 && ! empty( $name ) ) {
				echo "<span class='form_tag' onclick='vc_forms.insertTagText(this);'>{" . Helper::make_input_name( $name, false ) . '}</span>';
			}
		}

		// operators
		echo ' ' . __( "Operators:", 'greyd_forms' ) . ' ';
		foreach ( $operators as $operator ) {
			echo "<span class='form_tag' onclick='vc_forms.insertTagText(this);'>" . $operator . '</span>';
		}

		// description
		if ( $inline_descr === false ) {
			$inline_descr = __( "Dynamic placeholders are exchanged with their respective field values and are always updated.", 'greyd_forms' ) .
			' ' .
			__( "Make sure to insert only fields with numeric values. Non-numeric values are usually treated as \"0\".", 'greyd_forms' );
		}
		if ( ! empty( $inline_descr ) ) {
			echo "<br><i style='color: #999;'>$inline_descr</i>";
		}

		echo '</p>';

		$return = ob_get_contents();
		ob_end_clean();
		return $return;
	}


	/**
	 * =================================================================
	 *                          MODIFY MODULES
	 * =================================================================
	 */

	/**
	 * Modify some shortcode based modules
	 */
	public function mod_default_modules() {

		// inside the vc edit window, post id is set via $_POST
		$post_id   = isset( $_POST['post_id'] ) ? $_POST['post_id'] : null;
		$post_type = get_post_type( $post_id );

		if ( $post_id && $post_type === $this->config->plugin_post_type ) {

			// mod the headline
			$this->add_form_tags_to_shortcode_param( 'vc_headlines', 'title' );

			// mod the text
			$this->add_form_tags_to_shortcode_param( 'vc_column_text', 'content' );
		}
	}

	/**
	 * Add form field-tags to shortcode param
	 *
	 * @param string $shortcode     Name of the shortcode.
	 * @param string $param_name    Name of the shortcode param.
	 * @param bool   $overwrite     Whether to overwrite the original param value.
	 */
	public function add_form_tags_to_shortcode_param( $shortcode, $param_name, $overwrite = true ) {

		$map = \WPBMap::getShortCode( $shortcode );
		if (
			empty( $shortcode ) ||
			empty( $param_name ) ||
			! $map ||
			! is_array( $map ) ||
			! isset( $map['params'] )
		) {
			return false;
		}

		foreach ( (array) $map['params'] as $params ) {
			if ( $params['param_name'] == $param_name ) {
				// get the new text
				$description = '</span><p>' . __( "Fields:", 'greyd_forms' ) . '&nbsp;';
				foreach ( $this->inputs as $i => $name ) {
					if ( $i !== 0 && ! empty( $name ) ) {
						$description .= "<span class='form_tag' onclick='vc_forms.insertTagText(this);'>{" . Helper::make_input_name( $name, false ) . '}</span>';
					}
				}
				$description .= "<br><i style='color: #999;'>" . __( "Dynamic placeholders are exchanged with their respective field values and are always updated.", 'greyd_forms' ) . '</i>
				</p><span>';

				// update the param
				$params['description'] = ( $overwrite ? '' : $params['description'] . ' ' ) . $description;

				// update the shortcode
				vc_update_shortcode_param( $shortcode, $params );
				return true;
			}
		}
	}

	/**
	 * Modify visual composer modules
	 *
	 *  - remove default modules inside forms
	 *  - remove form modules outside forms
	 */
	public function remove_modules_by_posttype() {

		// remove vc elements for post-type 'tp_forms'
		if ( get_post_type() == $this->config->plugin_post_type ) {

			$remove_modules = array(
				'vc_form',
				'vc_tta_accordion',
				'vc_video',
				'vc_cbutton_anchor',
				'vc_smshare',
				'vc_smchannels',
				'vc_search_form',
				'vc_footernav',
				'vc_posts_links',
				'vc_posts_overview',
				'vc_posts_details_tp',
				'vc_dropdownnav',
				'dynamic',
				'vc_multimedia',
				'vc_raw_html',
				'vc_raw_js',
				'vc_cbutton',
				'vc_icon',
				'vc_cond_content',
				'vc_search',
				'vc_counter',
				// "vc_content_box",
				// "vc_list",
				'ninja_form',
				'cf7',
			);
			$remove_modules = apply_filters( 'greyd_forms_remove_vc_modules', $remove_modules );
			foreach ( $remove_modules as $module ) {
				vc_remove_element( $module );
			}

			// remove weiter/zurück if not multistep
			if ( isset( $_GET['post'] ) && ! get_post_meta( $_GET['post'], 'multistep', true ) ) {
				// vc_remove_element( $this->pre."button_steps" ); // solved via js & css for instant visibility

				// rename section if multistep
			} else {
				vc_map_update(
					'vc_section',
					array(
						'name'        => __( "Content section (step)", 'greyd_forms' ),
						'description' => __( "Step in a multi-level form", 'greyd_forms' ),
					)
				);
			}
			// Third party removes
			\vc\helper::remove_vc_plugin_elements();
		}
		// remove form elements for all post-types other than 'tp_forms'
		else {
			foreach ( $this->shortcodes as $module ) {
				vc_remove_element( $this->pre . $module );
			}
		}
	}


	/**
	 * =================================================================
	 *                          HELPER
	 * =================================================================
	 */

	/**
	 * Insert Options for Dropdown & Radio Buttons
	 */
	public function make_options() {
		$return = array_merge(
			array(
				// Unter-Überschrift
				array(
					'type'       => 'seperator',
					'heading'    => __( "Options", 'greyd_forms' ),
					'param_name' => 'seperator_new',
				),

				// Eingabeart
				array(
					'type'             => 'dropdown',
					'heading'          => __( "Entry type", 'greyd_forms' ),
					'description'      => __( "How do you want to create the fields?", 'greyd_forms' ),
					'param_name'       => 'inputtype',
					'edit_field_class' => 'vc_col-xs-4',
					'value'            => array(
						_x( "individually (recommended)", 'small', 'greyd_forms' ) => 'default',
						_x( "collectively", 'small', 'greyd_forms' ) => 'list',
						_x( "use pre-made list", 'small', 'greyd_forms' ) => 'predefined',
					),
				),

				// Optionen
				array(
					'type'             => 'textarea',
					'heading'          => __( "Options", 'greyd_forms' ),
					'description'      => __( "Please separate individual options by comma. If the displayed description is to be different from the transmitted value, this must be specified with a \"=\": Value=Display.", 'greyd_forms' ),
					'param_name'       => 'list_options',
					'edit_field_class' => 'vc_col-xs-12',
					'dependency'       => array(
						'element' => 'inputtype',
						'value'   => 'list',
					),
				),

				// Optionen
				array(
					'type'       => 'param_group',
					'heading'    => __( "Options", 'greyd_forms' ),
					'param_name' => 'options',
					'dependency' => array(
						'element' => 'inputtype',
						'value'   => 'default',
					),
					'params'     => array_merge(
						array(
							array(
								'type'             => 'textfield',
								'heading'          => __( "Display", 'greyd_forms' ),
								'description'      => __( "Description of the option for the user.", 'greyd_forms' ),
								'param_name'       => 'show',
								'admin_label'      => true,
								'edit_field_class' => 'vc_col-xs-4',
							),
							array(
								'type'             => 'textfield',
								'heading'          => __( "Value", 'greyd_forms' ),
								'description'      => __( "Information to be submitted when the field is selected.", 'greyd_forms' ),
								'param_name'       => 'value',
								'admin_label'      => true,
								'edit_field_class' => 'vc_col-xs-4 required',
							),
							array(
								'type'             => 'checkbox',
								'heading'          => __( "On pageload", 'greyd_forms' ),
								'param_name'       => 'selected',
								'admin_label'      => true,
								'edit_field_class' => 'vc_col-xs-4',
								'value'            => array(
									_x( "selected", 'small', 'greyd_forms' ) => 'selected',
								),
							),
						)
					),
				),
			),
			$this->make_predefined_lists(
				array(
					'element' => 'inputtype',
					'value'   => 'predefined',
				)
			)
		);
		return $return;
	}

	/**
	 * Insert form tags with description
	 */
	public function make_form_tags( $description = '' ) {

		$return = '<p>' . __( "Fields:", 'greyd_forms' ) . '&nbsp;';
		foreach ( $this->inputs as $i => $name ) {
			if ( $i !== 0 && ! empty( $name ) ) {
				$return .= "<span class='form_tag'>{" . Helper::make_input_name( $name, false ) . '}</span>';
			}
		}
		$return .= "<br>
			<i style='color: #999;'>" .
				__( "Dynamic placeholders are exchanged with their respective field values and are always updated.", 'greyd_forms' ) .
				( empty( $description ) ? '' : ' ' ) . $description .
			'</i>
		</p>';

		return $return;
	}

	/**
	 * Insert predefined Lists for Dropdown & Radio Buttons
	 */
	public function make_predefined_lists( $dependancy = array() ) {

		$ph = array( 'all' => __( "show all", 'greyd_forms' ) );

		// get predefined arrays
		$countrycodes     = array_flip( (array) VC_Helper::get_dropdown_array( 'countrycodes', $ph ) );
		$countrycodes_all = array_flip( (array) VC_Helper::get_dropdown_array( 'countrycodes_all', $ph ) );
		$currencies       = array_flip( (array) VC_Helper::get_dropdown_array( 'currencies', $ph ) );
		$currencies_all   = array_flip( (array) VC_Helper::get_dropdown_array( 'currencies_all', $ph ) );
		$languages        = array_flip( (array) VC_Helper::get_dropdown_array( 'languages', $ph ) );
		$languages_all    = array_flip( (array) VC_Helper::get_dropdown_array( 'languages_all', $ph ) );

		// return array
		$return = array(
			// vorgefertigte Liste auswählen
			array(
				'type'             => 'dropdown',
				'heading'          => __( "List", 'greyd_forms' ),
				'description'      => __( "Which pre-made list would you like to use?", 'greyd_forms' ),
				'param_name'       => 'predefined_lists',
				'edit_field_class' => 'vc_col-xs-4',
				'value'            => array(
					_x( "please select", 'small', 'greyd_forms' ) => '',
					_x( "country abbreviation", 'small', 'greyd_forms' ) . ' ' . __( "(common)", 'greyd_forms' )      => 'countrycodes',
					_x( "country abbreviation", 'small', 'greyd_forms' ) . ' ' . __( "(all)", 'greyd_forms' )    => 'countrycodes_all',
					_x( "countries", 'small', 'greyd_forms' ) . ' ' . __( "(common)", 'greyd_forms' )            => 'countrynames',
					_x( "countries", 'small', 'greyd_forms' ) . ' ' . __( "(all)", 'greyd_forms' )                 => 'countrynames_all',
					_x( "languages", 'small', 'greyd_forms' ) . ' ' . __( "(common)", 'greyd_forms' )          => 'languages',
					_x( "languages", 'small', 'greyd_forms' ) . ' ' . __( "(all)", 'greyd_forms' )               => 'languages_all',
					_x( "currencies", 'small', 'greyd_forms' ) . ' ' . __( "(common)", 'greyd_forms' )         => 'currencies',
					_x( "currencies", 'small', 'greyd_forms' ) . ' ' . __( "(all)", 'greyd_forms' )              => 'currencies_all',
				),
				'dependency'       => $dependancy,
			),

			// Countrynames
			array(
				'type'             => 'checkbox',
				'heading'          => __( "Select countries", 'greyd_forms' ),
				'param_name'       => 'countrynames_options',
				'edit_field_class' => 'vc_col-xs-4 checkbox_list',
				'value'            => $countrycodes,
				'dependency'       => array(
					'element' => 'predefined_lists',
					'value'   => 'countrynames',
				),
			),

			// Countrycodes
			array(
				'type'             => 'checkbox',
				'heading'          => __( "Select country abbreviations", 'greyd_forms' ),
				'param_name'       => 'countrycodes_options',
				'edit_field_class' => 'vc_col-xs-4 checkbox_list',
				'value'            => $countrycodes,
				'dependency'       => array(
					'element' => 'predefined_lists',
					'value'   => 'countrycodes',
				),
			),

			// Währungen
			array(
				'type'             => 'checkbox',
				'heading'          => __( "Select currencies", 'greyd_forms' ),
				'param_name'       => 'currencies_options',
				'edit_field_class' => 'vc_col-xs-4 checkbox_list',
				'value'            => $currencies,
				'dependency'       => array(
					'element' => 'predefined_lists',
					'value'   => 'currencies',
				),
			),

			// Sprachen
			array(
				'type'             => 'checkbox',
				'heading'          => __( "Select languages", 'greyd_forms' ),
				'param_name'       => 'languages_options',
				'edit_field_class' => 'vc_col-xs-4 checkbox_list',
				'value'            => $languages,
				'dependency'       => array(
					'element' => 'predefined_lists',
					'value'   => 'languages',
				),
			),

			// Countrynames all
			array(
				'type'             => 'checkbox',
				'heading'          => __( "Select countries", 'greyd_forms' ),
				'param_name'       => 'countrynames_all_options',
				'edit_field_class' => 'vc_col-xs-4 checkbox_list',
				'value'            => $countrycodes_all,
				'dependency'       => array(
					'element' => 'predefined_lists',
					'value'   => 'countrynames_all',
				),
			),

			// Countrycodes all
			array(
				'type'             => 'checkbox',
				'heading'          => __( "Select country abbreviations", 'greyd_forms' ),
				'param_name'       => 'countrycodes_all_options',
				'edit_field_class' => 'vc_col-xs-4 checkbox_list',
				'value'            => $countrycodes_all,
				'dependency'       => array(
					'element' => 'predefined_lists',
					'value'   => 'countrycodes_all',
				),
			),

			// Währungen all
			array(
				'type'             => 'checkbox',
				'heading'          => __( "Select currencies", 'greyd_forms' ),
				'param_name'       => 'currencies_all_options',
				'edit_field_class' => 'vc_col-xs-4 checkbox_list',
				'value'            => $currencies_all,
				'dependency'       => array(
					'element' => 'predefined_lists',
					'value'   => 'currencies_all',
				),
			),

			// Sprachen all
			array(
				'type'             => 'checkbox',
				'heading'          => __( "Select languages", 'greyd_forms' ),
				'param_name'       => 'languages_all_options',
				'edit_field_class' => 'vc_col-xs-4 checkbox_list',
				'value'            => $languages_all,
				'dependency'       => array(
					'element' => 'predefined_lists',
					'value'   => 'languages_all',
				),
			),
		);
		return $return;
	}
}
