<?php
/*
  Comments: Plugin File for Enqueue Scripts
*/
namespace Greyd\Forms;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

new Enqueue_Deprecated( $config );
class Enqueue_Deprecated {

	/**
	 * Holds plugin config array
	 *
	 * @var object
	 */
	private $config;

	/**
	 * Holds plugin textdomain
	 *
	 * @var string
	 */
	private $textdomain;

	/**
	 * Holds plugin uri
	 *
	 * @var string
	 */
	private $plugin_uri;

	/**
	 * Holds plugin css uri
	 *
	 * @var string
	 */
	private $assets_url;

	/**
	 * Class constructor
	 */
	public function __construct( $config ) {

		// set config
		$this->config = (object) $config;

		// Setup
		$this->plugin_uri = plugin_dir_url( $this->config->plugin_file );
		$this->assets_url = $this->plugin_uri . 'inc/deprecated/vc/assets';

		// enqueue styles and scripts
		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_frontend_scripts' ), 12 );
		add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_admin_scripts' ), 100 );
	}

	/**
	 * Enqueue scripts and styles
	 */
	public function enqueue_frontend_scripts() {

		// Multistep Script
		wp_register_script(
			'greyd-forms-multistep-script-deprecated',
			$this->assets_url . '/public-multistep.js',
			array( 'jquery' ),
			'1.6.9',
			true
		);
		wp_enqueue_script( 'greyd-forms-main-script' );
		wp_enqueue_style( 'greyd-forms-main-style' );
		wp_enqueue_script( 'greyd-forms-condition-script' );
		wp_enqueue_script( 'greyd-forms-multistep-script-deprecated' );
	}

	/**
	 * Enqueue backend scripts and styles.
	 */
	public function enqueue_admin_scripts() {

		$screen   = get_current_screen();
		$posttype = get_post_type() ? get_post_type() : $screen->post_type;

		// get version number
		$plugin_version = get_plugin_data( $this->config->plugin_file )['Version'];

		// Admin Backend
		wp_register_style( 'greyd-forms-admin_css', $this->assets_url . '/admin.css', null, $plugin_version, 'all' );
		wp_enqueue_style( 'greyd-forms-admin_css' );

		// Check cpt for meta-box-styling
		if ( $posttype === 'tp_forms' || $posttype === 'tp_forms_entry' ) {

			// Backend Style
			wp_register_style( 'greyd-forms-backend_css', $this->assets_url . '/backend.css', null, $plugin_version, 'all' );
			wp_enqueue_style( 'greyd-forms-backend_css' );

			// Backend Scripts
			wp_register_script( 'greyd-forms-backend_js', $this->assets_url . '/backend.js', array( 'jquery' ), $plugin_version, true );
			wp_enqueue_script( 'greyd-forms-backend_js' );

			// global wordings for javascript files
			$wordings = array(
				'new_condition' => __( "other condition", 'greyd_forms' ),
			);
			wp_add_inline_script( 'greyd-forms-backend_js', 'var forms_wordings = ' . json_encode( $wordings ) . ';' );
		}

		if ( $screen->base === 'post' || $screen->base === 'edit' ) {
			$forms = Helper::get_all_forms();
			wp_add_inline_script( 'default_admin_js', 'var greyd_forms = ' . json_encode( $forms ) . ';' );
		}
	}
}
