<?php
/**
 * Register all blocks necessary for Greyd.Forms.
 *
 * @since 1.9.7
 *
 * @package Greyd.Forms
 */
namespace Greyd\Forms;

new Block_Patterns( $config );

class Block_Patterns {

	/**
	 * Hold the plugin config
	 *
	 * @var object
	 */
	private $config;

	/**
	 * Constructor.
	 */
	public function __construct( $config ) {

		$this->config = (object) $config;

		add_action( 'init', array( $this, 'register_block_pattern_categories' ), 9 );
		add_action( 'greyd_block_pattern_plugins', array( $this, 'register_block_pattern_plugin' ) );
	}

	/**
	 * Register block pattern categories.
	 *
	 * @since 1.9.7
	 */
	public function register_block_pattern_categories() {

		$pattern_categories = array(
			'greyd-forms' => array(
				'label' => __( 'Greyd.Forms', 'greyd_forms' ),
			),
		);

		foreach ( $pattern_categories as $name => $properties ) {
			register_block_pattern_category( $name, $properties );
		}
	}

	/**
	 * Register block patterns for a plugin.
	 *
	 * @since 1.9.7
	 *
	 * @param string $plugin_path The path to the plugin directory.
	 * @param string $text_domain The plugin text domain.
	 */
	public function register_block_pattern_plugin( $plugins ) {

		$plugins['greyd_forms'] = array(
			'path'        => $this->config->plugin_path,
			'text_domain' => 'greyd_forms',
		);

		return $plugins;
	}
}
