<?php
/*
	Comments: Plugin File for Form Generator Settings
*/
namespace Greyd\Forms;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

new Export( $config );
class Export {

	private $config;

	public function __construct( $config ) {
		// set config
		$this->config = (object) $config;

		if ( is_admin() ) {
			// Add Submenu Item
			add_action( 'admin_menu', array( $this, 'add_export_page' ) );

			add_action( 'plugins_loaded', array( $this, 'trigger_export' ), 1 );
		}

	}

	public function add_export_page() {

		add_submenu_page(
			'edit.php?post_type=' . $this->config->plugin_post_type, // Parent Slug
			__( 'Greyd.Forms', 'greyd_forms' ) . ' › ' . __( "Export entries", 'greyd_forms' ), // Page Title
			__( "Export", 'greyd_forms' ), // Menu Title
			'manage_options', // capability
			'greyd_forms_export', // Menu slug
			array( $this, 'render_export_page' ) // callback function
		);

	}

	public function render_export_page() {

		// debug
		// $this->export_entries_by_form(108);
		echo "<div class='wrap'>";
		echo "<h1 style='margin-bottom:2em;'>" . get_admin_page_title() . '</h1>';
		settings_errors();

		echo "<form method='post' class='greyd_tile export_wrapper'>";

		echo '<div>';
		echo '<h4>' . __( "Select form", 'greyd_forms' ) . '</h4>';

		$forms = Helper::get_all_forms();
		if ( count( $forms ) > 0 ) {
			echo '<fieldset>';
			foreach ( $forms as $id => $title ) {
				$entries = Helper::get_entries_by_form_id( $id );
				$count   = ! $entries || empty( $entries ) ? 0 : count( $entries );
				echo "<label for='$id' style='" . ( $count === 0 ? 'pointer-events: none;opacity: 0.4;' : '' ) . "'>
                    <input type='radio' name='form' value='$id' id='$id' " . ( count( $forms ) === 1 ? "checked='checked'" : '' ) . " required/><span>$title (" . sprintf( __( "%s entries", 'greyd_forms' ), ( $count === 0 ? __( "none", 'greyd_forms' ) : $count ) ) . ')</span>
                </label><br>';
			}
			echo '</fieldset>';
		} else {
			echo Helper::render_info_box(
				array(
					'style' => 'blue',
					'text'  => __( "no form created yet", 'greyd_forms' ),
				)
			);
		}
		echo "<input type='hidden' name='greyd_entry_export' value='true'/>";
		echo '</div>';

		echo "<div style='text-align:center;'>";
		echo "<button type='submit' name='submit' id='submit' class='button button-primary large' value='export'>" . _x( "download entries as CSV-file", 'small', 'greyd_forms' ) . '</button>';
		echo "<small class='color_light'>" . __( "The download starts automatically.", 'greyd_forms' ) . '</small>';
		echo '</div>';

		echo '</form>';

		echo '</div>';
	}

	public function trigger_export() {
		if ( isset( $_POST ) && isset( $_POST['greyd_entry_export'] ) && isset( $_POST['form'] ) ) {
			$this->export_entries_by_form( $_POST['form'] );
		}
	}

	public function export_entries_by_form( $form = '' ) {
		if ( empty( $form ) ) {
			return false;
		}

		/*
			get all entries by form
		*/
		$entries = Helper::get_entries_by_form_id( $form );
		if ( empty( $entries ) || ! is_array( $entries ) ) {
			return false;
		}

		/*
			get all keys from entries
		*/
		$keys = $this->get_entry_row_keys( $entries );
		// debug($keys);

		/*
			get all the data
		*/
		$all_data = array();
		foreach ( (array) $entries as $id ) {
			$all_data[ $id ] = Helper::get_formatted_entry_data( $id );
		}

		/*
			append data to rows
		*/
		$rows = array();
		foreach ( $all_data as $id => $data ) {
			$row = array();
			foreach ( $keys as $key ) {
				if ( $key === 'ID' ) {
					$row[] = $id;
				} else {
					$row[] = isset( $data[ $key ] ) ? $data[ $key ] : '';
				}
			}
			$rows[] = $row;
		}
		// debug($rows);

		/*
			export file
		*/
		$export = array_merge( array( $keys ), $rows );
		// debug($export);
		$file_name = preg_replace( '/\s+/', '_', get_the_title( $form ) ) . '-' . __( "Entries", 'greyd_forms' ) . '-' . date( 'y_m_d' );
		self::download_array_as_csv( $export, $file_name );
	}

	public function get_entry_row_keys( $entries = array() ) {
		/*
			get form- & meta-data seperately
		*/
		$form_data = array();
		foreach ( (array) $entries as $id ) {
			$form_data[ $id ] = Helper::get_formatted_entry_data( $id, 'data' );
		}
		// debug($form_data);

		$meta_data = array();
		foreach ( (array) $entries as $id ) {
			$meta_data[ $id ] = Helper::get_formatted_entry_data( $id, 'meta' );
		}
		// debug($meta_data);

		/*
			collect all the keys
		*/
		$keys = array( 'ID' );
		// collect the form keys first
		foreach ( $form_data as $id => $data ) {
			if ( is_array( $data ) ) {
				foreach ( $data as $key => $val ) {
					if ( ! isset( array_flip( $keys )[ $key ] ) ) {
						$keys[] = $key;
					}
				}
			}
		}
		// then collect the meta keys
		foreach ( $meta_data as $id => $data ) {
			if ( is_array( $data ) ) {
				foreach ( $data as $key => $val ) {
					if ( ! isset( array_flip( $keys )[ $key ] ) ) {
						$keys[] = $key;
					}
				}
			}
		}
		return $keys;
	}

	public static function download_array_as_csv( $array, $filename = '' ) {

		$filename = empty( $filename ) ? __( "Form export", 'greyd_forms' ) . '-' . date( 'y_m_d' ) : $filename;
		$filename = strpos( $filename, '.csv' ) === false ? $filename . '.csv' : $filename;

		header( 'Cache-Control: must-revalidate, post-check=0, pre-check=0' );
		header( 'Content-Description: File Transfer' );
		header( 'Content-type: application/csv' );
		header( 'Content-Disposition: attachment; filename="' . $filename . '";' );
		header( 'Expires: 0' );
		header( 'Pragma: public' );

		$fh = @fopen( 'php://output', 'w' );

		// loop through the array
		foreach ( $array as $line ) {
			// generate csv line
			fputcsv( $fh, $line, ';' );
		}

		// close the file
		fclose( $fh );
		// make sure nothing else is sent, our file is done
		exit;
	}
}
