<?php
/**
 * Greyd.Forms post-export extension
 *
 * This file is an extension of the Core Greyd.Suite Post
 * Import/Export Feature.
 *
 * @see greyd-plugin/inc/post-export.php
 */
namespace Greyd\Forms;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

new Form_Export();
class Form_Export {

	public function __construct() {
		add_filter( 'greyd_export_post_meta-verify_link', array( $this, 'prepare_verify_link' ), 10, 3 );
		add_filter( 'greyd_import_post_meta-verify_link', array( $this, 'set_verify_link' ), 10, 2 );
		add_filter( 'greyd_export_post_meta-opt_out_link', array( $this, 'prepare_opt_out_link' ), 10, 3 );
		add_filter( 'greyd_import_post_meta-opt_out_link', array( $this, 'set_opt_out_link' ), 10, 2 );

		add_filter( 'greyd_filter_post_content_before_post_import', array( $this, 'replace_validation_patterns_before_import' ), 10, 3 );
	}

	/**
	 * Modify verify_link url before export
	 *
	 * @filter 'greyd_export_post_meta-verify_link'
	 *
	 * @param mixed $meta_value
	 * @param int   $post_id
	 * @param array $args       Export arguments
	 *
	 * @return mixed $meta_value
	 */
	public function prepare_verify_link( $meta_value, $post_id, $args = array() ) {

		if ( is_numeric( $meta_value ) ) {
			if ( isset( $args['append_nested'] ) && $args['append_nested'] ) {
				do_action( 'greyd_post_export_log', sprintf( "  - value for 'verify_link' is an ID -> prepare post '%s' for export.", $meta_value ) );
				do_action( 'greyd_post_export_log', "\r\n---------------------" );
				self::call_post_export_func( 'prepare_post', $meta_value, $args );
				do_action( 'greyd_post_export_log', "\r\n---------------------\r\n" );
				$meta_value = '{{' . $meta_value . '}}';
			} else {
				$meta_value = self::call_post_export_func( 'prepare_strings', get_permalink( $meta_value ), $post_id, false );
				do_action( 'greyd_post_export_log', sprintf( "  - URL of 'verify_link' was preparred for export: %s", $meta_value ) );
			}
		} else {
			do_action( 'greyd_post_export_log', sprintf( "  - URL of 'verify_link' was preparred for export: %s", $meta_value ) );
		}

		return $meta_value;
	}

	/**
	 * Modify verify_link url after import
	 *
	 * @filter 'greyd_import_post_meta-verify_link'
	 *
	 * @param mixed $meta_value
	 * @param int   $post_id
	 *
	 * @return mixed $meta_value
	 */
	public function set_verify_link( $meta_value, $post_id ) {

		if ( preg_match( '/\{\{(.+?)\}\}/', $meta_value, $matches ) ) {
			$inner = isset( $matches[1] ) ? $matches[1] : '';

			// ID found
			if ( is_numeric( $inner ) ) {

				$replace_string = $inner;
				if ( class_exists( '\Greyd\Post_Export' ) ) {
					$replace_string = isset( \Greyd\Post_Export::$posts[ $inner ] ) ? \Greyd\Post_Export::$posts[ $inner ] : $inner;
				} elseif ( class_exists( '\tp\management\Post_Export' ) ) {
					$replace_string = isset( \tp\management\Post_Export::$posts[ $inner ] ) ? \tp\management\Post_Export::$posts[ $inner ] : $inner;
				}

				$meta_value = preg_replace( '/\{\{(.+?)\}\}/', $replace_string, $meta_value );
				do_action( 'greyd_post_export_log', sprintf( "  - ID '%s' in the field 'verify_link' was replaced with '%s'", $inner, $replace_string ) );
			} else {
				$meta_value = self::call_post_export_func( 'replace_strings', $meta_value, $post_id, false );
				do_action( 'greyd_post_export_log', sprintf( "  - All strings in the field '%s' were replaced", $key ) );
			}
		}

		return $meta_value;
	}

	/**
	 * Modify opt_out_link url before export
	 *
	 * @filter 'greyd_export_post_meta-opt_out_link'
	 *
	 * @param mixed $meta_value
	 * @param int   $post_id
	 * @param array $args       Export arguments
	 *
	 * @return mixed $meta_value
	 */
	public function prepare_opt_out_link( $meta_value, $post_id, $args = array() ) {

		if ( is_numeric( $meta_value ) ) {
			if ( isset( $args['append_nested'] ) && $args['append_nested'] ) {
				do_action( 'greyd_post_export_log', sprintf( "  - value for 'opt_out_link' is an ID -> prepare post '%s' for export.", $meta_value ) );
				do_action( 'greyd_post_export_log', "\r\n---------------------" );
				self::call_post_export_func( 'prepare_post', $meta_value, $args );
				do_action( 'greyd_post_export_log', "\r\n---------------------\r\n" );
				$meta_value = '{{' . $meta_value . '}}';
			} else {
				$meta_value = self::call_post_export_func( 'prepare_strings', get_permalink( $meta_value ), $post_id, false );
				do_action( 'greyd_post_export_log', sprintf( "  - URL of 'opt_out_link' was preparred for export: %s", $meta_value ) );
			}
		} else {
			do_action( 'greyd_post_export_log', sprintf( "  - URL of 'opt_out_link' was preparred for export: %s", $meta_value ) );
		}

		return $meta_value;
	}

	/**
	 * Modify opt_out_link url after import
	 *
	 * @filter 'greyd_import_post_meta-opt_out_link'
	 *
	 * @param mixed $meta_value
	 * @param int   $post_id
	 *
	 * @return mixed $meta_value
	 */
	public function set_opt_out_link( $meta_value, $post_id ) {

		if ( preg_match( '/\{\{(.+?)\}\}/', $meta_value, $matches ) ) {
			$inner = isset( $matches[1] ) ? $matches[1] : '';

			// ID found
			if ( is_numeric( $inner ) ) {

				$replace_string = $inner;
				if ( class_exists( '\Greyd\Post_Export' ) ) {
					$replace_string = isset( \Greyd\Post_Export::$posts[ $inner ] ) ? \Greyd\Post_Export::$posts[ $inner ] : $inner;
				} elseif ( class_exists( '\tp\management\Post_Export' ) ) {
					$replace_string = isset( \tp\management\Post_Export::$posts[ $inner ] ) ? \tp\management\Post_Export::$posts[ $inner ] : $inner;
				}

				$meta_value = preg_replace( '/\{\{(.+?)\}\}/', $replace_string, $meta_value );
				do_action( 'greyd_post_export_log', sprintf( "  - ID '%s' in the field 'opt_out_link' was replaced with '%s'", $inner, $replace_string ) );
			} else {
				$meta_value = self::call_post_export_func( 'replace_strings', $meta_value, $post_id, false );
				do_action( 'greyd_post_export_log', sprintf( "  - All strings in the field '%s' were replaced", $key ) );
			}
		}

		return $meta_value;
	}

	/**
	 * Add backslashes to the validation patterns inside the post_content
	 * to supprt proper escaping.
	 *
	 * @filter 'greyd_filter_post_content_before_post_import'
	 *
	 * @param string $content    The post content.
	 * @param int    $post_id    The post ID.
	 * @param object $post       The post object.
	 */
	public function replace_validation_patterns_before_import( $content, $post_id, $post ) {

		$content = preg_replace_callback(
			'/\spattern="([^"]+?)"/',
			function( $match ) {
				return ' pattern="' . addslashes( $match[1] ) . '"';
			},
			$content
		);

		return $content;
	}

	/**
	 * Call function from core Post_Export class with backward compatiblity.
	 *
	 * @since 1.4.5
	 *
	 * @param string $function_name
	 * @param mixed  ...$args
	 *
	 * @return mixed
	 */
	public static function call_post_export_func( $function_name ) {

		$args = func_get_args();
		array_shift( $args );

		$method = '';

		if ( method_exists( '\Greyd\Post_Export_Helper', $function_name ) ) {
			$method = '\Greyd\Post_Export_Helper';
		}
		else if ( method_exists( '\Greyd\Post_Export', $function_name ) ) {
			$method = '\Greyd\Post_Export';
		}
		else if ( method_exists( '\tp\management\Post_Export', $function_name ) ) {
			$method = '\tp\management\Post_Export';
		}

		if ( ! empty( $method ) ) {
			return count( $args ) === 0
				? call_user_func( $method . '::' . $function_name )
				: call_user_func_array( $method . '::' . $function_name, $args );
		}

		return null;
	}
}
