/**
 * Greyd.Forms Statistics backend script
 */

document.addEventListener( 'DOMContentLoaded', function () {
	Statistics.init();
} );

const Statistics = new function () {

	this.debug = true;

	this.CHART_CONFIG = {
		interactions_by_field: {
			type: 'bar',
			data: { datasets: [] },
			options: {
				plugins: {
					legend: {
						display: false
					},
					title: {
						text: '',
						display: true
					},
				},
				scales: {
					x: {
						title: {
							text: '',
							display: true
						}
					},
					y: {
						title: {
							text: '',
							display: true
						},
						ticks: {
							stepSize: 1
						},
					},
				},
				maintainAspectRatio: false,
			}
		},
		interactions_by_day: {
			type: 'bar',
			data: { datasets: [] },
			options: {
				plugins: {
					title: {
						text: '',
						display: true
					},
					decimation: {
						enabled: true,
						algorithm: 'lttb',
						samples: 10,
					},
					legend: {
						display: false
					}
				},
				scales: {
					x: {
						type: 'time',
						time: {
							minUnit: 'day',
							tooltipFormat: 'dd.MM.yyyy',
						},
						ticks: {
							autoSkip: true,
							autoSkipPadding: 1,
							stepSize: 10,
						},
						title: {
							display: true,
							text: '',
						}
					},
					y: {
						title: {
							display: true,
							text: '',
							ticks: {
								stepSize: 1
							},
						}
					}
				},
				maintainAspectRatio: false,
			}
		},
		forms_by_day: {
			type: 'bar',
			data: { datasets: [] },
			options: {
				plugins: {
					title: {
						text: '',
						display: true
					},
					decimation: {
						enabled: true,
						algorithm: 'lttb',
						samples: 10,
					},
					legend: {
						display: false
					}
				},
				scales: {
					x: {
						type: 'time',
						time: {
							minUnit: 'day',
							tooltipFormat: 'dd.MM.yyyy',
						},
						ticks: {
							autoSkip: true,
							autoSkipPadding: 1,
							stepSize: 10,
						},
						title: {
							display: true,
							text: '',
						}
					},
					y: {
						title: {
							display: true,
							text: '',
							ticks: {
								stepSize: 1
							},
						}
					}
				},
				maintainAspectRatio: false,
			}
		}
	};

	this.init = function () {
		jQuery( '.greyd_statistic canvas' ).each( function () {

			const canvas = jQuery( this );
			const data = JSON.parse(canvas.data( 'source' ));
			const mode = canvas.attr( 'id' );
			const config = Statistics.CHART_CONFIG[ mode ];

			config.options.plugins.title.text = canvas.data( 'title' );
			config.options.scales.x.title.text = canvas.data( 'label-x' );
			config.options.scales.y.title.text = canvas.data( 'label-y' );

			Statistics.loadChart(
				data,
				config,
				canvas[ 0 ]
			);
		} );
	};

	/**
	 * Attaches a chartjs chart to el.
	 * 
	 * @param array  data    the filtered data
	 * @param string mode   respective mode of the config
	 * @param object el     dom object to attach to
	 */
	this.loadChart = function ( data, config, el ) {

		const colors = [ '#2271b1', 'currentColor', '#FF9F29' ];

		if ( Statistics.debug ) console.log( "Creating Chart with following Data:" );
		if ( Statistics.debug ) console.log( data );

		Object.keys( data ).forEach( function ( key ) {
			config[ 'data' ][ 'datasets' ].push( {
				label: key,
				data: data[ key ],
				backgroundColor: colors.shift()
			} );
		} );

		// context element has to be a canvas
		const ctx = el.getContext( '2d' );

		new Chart( ctx, config );
	};
};