<?php
/**
 * Greyd.Forms Statistics enqueue of scripts & styles
 */
namespace Greyd\Forms;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

new Stats_Enqueue( $config );
class Stats_Enqueue {

	private $config;
	private $plugin_uri;
	private $css_uri;
	private $js_uri;
	private $module;

	public function __construct( $config ) {
		// set config
		$this->config = (object) $config;

		// Setup
		$this->plugin_uri = plugin_dir_url( $this->config->plugin_file );
		$this->css_uri    = $this->plugin_uri . 'inc/features/statistics/assets/css';
		$this->js_uri     = $this->plugin_uri . 'inc/features/statistics/assets/js';
		$this->module     = 'statistics';

		add_action( 'wp_enqueue_scripts', array( $this, 'register_frontend_scripts' ), 11 );
		add_filter( 'render_block', array( $this, 'maybe_enqueue_frontend_scripts' ), 10, 2 );

		add_action( 'admin_enqueue_scripts', array( $this, 'load_backend' ), 100 );
	}

	/**
	 * Register scripts and styles in the frontend.
	 *
	 * We only register the scripts here and conditionally enqueue them in
	 * the maybe_enqueue_frontend_scripts function based on which blocks are
	 * rendered on the page.
	 */
	public function register_frontend_scripts() {

			// get version number
		if ( ! function_exists( 'get_plugin_data' ) ) {
			require_once ABSPATH . '/wp-admin/includes/plugin.php';
		}
		$plugin_version = get_plugin_data( $this->config->plugin_file )['Version'];
		
		// Register
		wp_register_script(
			'greyd-forms-statistics-script',
			$this->js_uri . '/frontend.js',
			array( 'jquery' ),
			$plugin_version,
			true
		);
	}

	/**
	 * Enqueue frontend scripts and styles conditionally based
	 * on which blocks are rendered on the page.
	 *
	 * @param string $block_content     pre-rendered Block Content
	 * @param object $block             parsed Block
	 *
	 * @return string $block_content    altered Block Content
	 */
	public function maybe_enqueue_frontend_scripts( $block_content, $block ) {

		if ( $block['blockName'] === 'greyd/form' ) {
			
			if ( ! wp_script_is( 'greyd-forms-statistics-script', 'enqueued' ) ) {
				wp_enqueue_script( 'greyd-forms-statistics-script' );
			}
		}

		return $block_content;
	}

	public function load_backend() {

		$screen   = get_current_screen();
		$posttype = get_post_type() ? get_post_type() : $screen->post_type;

		// get version number
		$plugin_version = get_plugin_data( $this->config->plugin_file )['Version'];

		// add chartjs library only on forms statistics page
		if ( $screen->base === $this->config->plugin_post_type . '_page_' . $this->module ) {

			wp_register_style( $this->config->plugin_name . '_' . $this->module . '_backend_css', $this->css_uri . '/backend.css', null, $plugin_version, 'all' );
			wp_enqueue_style( $this->config->plugin_name . '_' . $this->module . '_backend_css' );

			wp_register_script( $this->config->plugin_name . '_chart_js', $this->js_uri . '/libs/chart.min.js', array(), $plugin_version, true );
			wp_enqueue_script( $this->config->plugin_name . '_chart_js' );

			wp_register_script( $this->config->plugin_name . '_chart_js_date_fns_bundle', 'https://cdn.jsdelivr.net/npm/chartjs-adapter-date-fns/dist/chartjs-adapter-date-fns.bundle.min.js', null, $plugin_version, true );
			wp_enqueue_script( $this->config->plugin_name . '_chart_js_date_fns_bundle' );

			wp_register_script( $this->config->plugin_name . '_' . $this->module . '_backend_js', $this->js_uri . '/backend.js', array(), $plugin_version, true );
			wp_localize_script(
				$this->config->plugin_name . '_' . $this->module . '_backend_js',
				'local_' . $this->module,
				array(
					'ajaxurl' => admin_url( 'admin-ajax.php' ),
					'nonce'   => wp_create_nonce( $this->module ),
				)
			);
			wp_enqueue_script( $this->config->plugin_name . '_' . $this->module . '_backend_js' );

		}
	}
}
