/**
 * Greyd.Forms Surveys backend script
 */

document.addEventListener( 'DOMContentLoaded', function () {
	Surveys.init();
} );

const Surveys = new function () {

	this.debug = false;
	this.defaultColors = [
		"#3366CC", "#DC3912", "#FF9900", "#109618", "#990099", "#3B3EAC", "#0099C6",
		"#DD4477", "#66AA00", "#B82E2E", "#316395", "#994499", "#22AA99", "#AAAA11",
		"#6633CC", "#E67300", "#8B0707", "#329262", "#5574A6", "#651067"
	];

	this.init = function () {
		jQuery( '.greyd_survey canvas' ).each( function () {

			const canvas = jQuery( this );
			const data = JSON.parse( canvas.data( 'source' ) );

			const config = {
				type: 'doughnut',
				data: { labels: [], datasets: [] }
			};

			Surveys.loadChart(
				data,
				config,
				canvas[ 0 ]
			);
		} );
	};

	/**
	 * Attaches a chartjs chart to el.
	 * 
	 * @param array  data    the filtered data
	 * @param string mode   respective mode of the config
	 * @param object el     dom object to attach to
	 */
	this.loadChart = function ( data, config, el ) {

		if ( Surveys.debug ) console.log( "Creating Chart with following Data:" );
		if ( Surveys.debug ) console.log( data );

		config[ 'data' ][ 'datasets' ] = [];

		// push labels
		Object.keys( data ).forEach( function ( key ) {
			config[ 'data' ][ 'labels' ].push( key );
		} );
		// push values
		config[ 'data' ][ 'datasets' ].push( { data: Object.values( data ), backgroundColor: this.defaultColors } );

		// context element has to be a canvas
		const ctx = el.getContext( '2d' );

		new Chart( ctx, config );
	};
};