<?php
/**
 * Greyd.Forms Survey enqueue of scripts & styles
 */
namespace Greyd\Forms;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

new Surveys_Enqueue( $config );
class Surveys_Enqueue {

	private $config;
	private $plugin_uri;
	private $css_uri;
	private $js_uri;
	private $module;

	public function __construct( $config ) {
		// set config
		$this->config = (object) $config;

		// Setup
		$this->plugin_uri = plugin_dir_url( $this->config->plugin_file );
		$this->css_uri    = $this->plugin_uri . 'inc/features/surveys/assets/css';
		$this->js_uri     = $this->plugin_uri . 'inc/features/surveys/assets/js';
		$this->module     = 'surveys';

		add_action( 'admin_enqueue_scripts', array( $this, 'load_backend' ), 100 );
	}

	public function load_backend() {

		$screen   = get_current_screen();
		$posttype = get_post_type() ? get_post_type() : $screen->post_type;

		// get version number
		$plugin_version = get_plugin_data( $this->config->plugin_file )['Version'];

		// add chartjs library only on forms survey page
		if ( $screen->base === $this->config->plugin_post_type . '_page_' . $this->module ) {

			wp_register_style( $this->config->plugin_name . '_' . $this->module . '_backend_css', $this->css_uri . '/backend.css', null, $plugin_version, 'all' );
			wp_enqueue_style( $this->config->plugin_name . '_' . $this->module . '_backend_css' );

			wp_register_script( $this->config->plugin_name . '_chart_js', $this->js_uri . '/libs/chart.min.js', array(), $plugin_version, true );
			wp_enqueue_script( $this->config->plugin_name . '_chart_js' );

			wp_register_script( $this->config->plugin_name . '_' . $this->module . '_backend_js', $this->js_uri . '/backend.js', array('jquery'), $plugin_version, true );
			wp_localize_script(
				$this->config->plugin_name . '_' . $this->module . '_backend_js',
				'local_' . $this->module,
				array(
					'ajaxurl' => admin_url( 'admin-ajax.php' ),
					'nonce'   => wp_create_nonce( $this->module ),
				)
			);
			wp_enqueue_script( $this->config->plugin_name . '_' . $this->module . '_backend_js' );
		}
	}
}
