<?php
/*
	Comments: Plugin File for Visual Composer Meta Box
*/
namespace Greyd\Forms;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

new Metabox( $config );

class Metabox {

	private $config;

	public function __construct( $config ) {
		// set config
		$this->config = (object) $config;

		$this->init_meta_box();
		// add Meta Box
		add_action( 'add_meta_boxes', array( $this, 'add_meta_box_event' ) );
		// save Meta Information
		add_action( 'save_post', array( $this, 'save_post' ), 20, 2 );
	}

	// Add Meta Box Event
	public function add_meta_box_event() {
		add_meta_box(
			'vc_form_info', // ID
			__( "Settings", 'greyd_forms' ), // Title
			array( $this, 'render_meta_box' ), // Callback
			$this->config->plugin_post_type, // CPT name
			'advanced', // advanced = at bottom of page
			'default' // Priority
			// array $callback_args = null // Arguments passed to the callback
		);
	}

	// Vars
	public $pages;
	public $all_names   = array();
	public $all_options = array();
	public $menu_tabs   = array();
	public $post_args   = array(
		// Allgemein
		'required_text',
		'required_align', // Pflichtfelder
		'after_form',
		'jump_to',
		'jump_to_link',
		'success_message',
		'popup_bg_color', // Folgeaktion
		'form_mode',
		// E-Mails
		'mail_to',
		'mail_from',
		'mail_from_name',
		'subject',
		'mail_note', // Admin Mail
		'verify_user',
		'verify_mail_from_name',
		'verify_mail_from',
		'verify_email',
		'verify_mail_subject',
		'verify_mail_content',
		'verify_link',
		'verify_link_name',
		'verify_link_color', // DOI
		'user_gets_mail',
		'user_mail_from_name',
		'user_mail_from',
		'user_email',
		'user_mail_subject',
		'user_mail_content',
		'send_opt_out',
		'opt_out_link',
		'opt_out_link_name',
		'opt_out_link_color', // User Mail
		// Erweitert
		'hide_tooltips',
		'ignore_gutter',
		'block_send',
		'multistep',
		'multistep_style',
		'multistep_transition',
		'same_stepheight', // Multistep
		'progress_bar',
		'progress_height',
		'progress_align',
		'progress_width',
		'pagination_width',
		'progress_margin',
		'progress_radius',
		'progress_color',
		'progress_bar_color', // Progress Bar
	);

	public $custom_post_args = array( 'required_style' );

	public function init_meta_box() {
		foreach ( $this->post_args as $name ) {
			register_post_meta(
				$this->config->plugin_post_type,
				$name,
				$args = array(
					'single'       => true,
					'show_in_rest' => false,
				)
			);
		}
		foreach ( $this->custom_post_args as $name ) {
			register_post_meta(
				$this->config->plugin_post_type,
				$name,
				$args = array(
					'single'       => true,
					'show_in_rest' => false,
				)
			);
		}
	}

	public function render_meta_box( $post ) {
		// debug(get_post_meta($post->ID));

		// Get all names from Post
		$this->all_names   = Helper::get_all_input_names( $post->ID );
		$this->all_options = array_merge(
			array(
				__( "please select", 'greyd_forms' ),
			),
			$this->all_names
		);

		// Get all Pages
		$this->pages = get_pages();

		// Register Menu Tabs
		$menu_tabs = array(
			array(
				'href'    => 'general',
				'name'    => __( "General", 'greyd_forms' ),
				'call'    => array( $this, 'render_general' ),
				'general' => true, // whether to render in general options
			),
			array(
				'href'    => 'mails',
				'name'    => __( "Emails", 'greyd_forms' ),
				'call'    => array( $this, 'render_mails' ),
				'general' => true,
			),
			array(
				'href'    => 'api',
				'name'    => __( "Interfaces", 'greyd_forms' ),
				'call'    => array( $this, 'render_api' ),
				'general' => true,
			),
			array(
				'href'    => 'entry_delete',
				'name'    => __( "Automatic Deletion of Entries", 'greyd_forms' ),
				'call'    => array( $this, 'render_entry_delete' ),
				'general' => true,
			),
			array(
				'href'    => 'more',
				'name'    => __( "Extended", 'greyd_forms' ),
				'call'    => array( $this, 'render_more' ),
				'general' => true,
			),
		);

		// Add Filter for manipulation of tabs
		$this->menu_tabs = apply_filters( 'formmeta_menu_tabs', $menu_tabs );

		// Outer Wrapper
		echo "<div class='tabbed_meta_box'>";

		// Tabbed Menu
		$active_tab = 0;
		echo "<ul class='meta_tab_bar'>";
			$i = 0;
		foreach ( $this->menu_tabs as $option ) {
			$option = (object) $option;
			$active = $i === $active_tab ? 'active' : '';
			echo "<li><a class='link $active' data-href='#formsettings_$option->href'>$option->name</a></li>";
			$i++;
		}
		echo '</ul>';

		// Tabbed Content
		echo "<div class='meta_tab_content'>";
			$i = 0;
		foreach ( $this->menu_tabs as $option ) {
			$option = (object) $option;
			$style  = $i === $active_tab ? 'display:block;' : 'display:none;';

			echo "<div id='formsettings_$option->href' style='$style'>";
				$call = $option->call;
				call_user_func( $call, $post, $this->all_options );
			echo '</div>';
			$i++;
		}
		echo '</div>';

		// Footer
		echo "<div class='meta_footer'>";
			// Speichern Button
			$action = 'save';
		if ( get_current_screen()->action === 'add' ) {
			$action = 'publish';
		}
			submit_button( $text = __( "Save changes", 'greyd_forms' ), $type = 'primary huge', $name = $action, $wrap = true, $other_attributes = null );
		echo '</div>';

		// End of Wrapper
		echo '</div>';
	}


	// General Settings
	public function render_general( $post ) {

		// DESIGN

		// Vars
		$required_style  = get_post_meta( $post->ID, 'required_style', true ) ? get_post_meta( $post->ID, 'required_style', true ) : 'required';
		$required_fields = ( $required_style === 'required' || $required_style === 'both' ) ? 'checked' : '';
		$optional_fields = ( $required_style === 'optional' || $required_style === 'both' ) ? 'checked' : '';
		$required_text   = get_post_meta( $post->ID, 'required_text', true );
		$required_align  = get_post_meta( $post->ID, 'required_align', true );

		// Options
		$align_options = array(
			array(
				'value' => 'left',
				'name'  => _x( "left", 'small', 'greyd_forms' ),
			),
			array(
				'value' => 'center',
				'name'  => _x( "center", 'small', 'greyd_forms' ),
			),
			array(
				'value' => 'right',
				'name'  => _x( "right", 'small', 'greyd_forms' ),
			),
			array(
				'value' => 'hidden',
				'name'  => _x( "hide", 'small', 'greyd_forms' ),
			),
		);

		// FOLGEAKTIONEN

		// Vars
		$after_form      = get_post_meta( $post->ID, 'after_form', true );
		$jump_to         = get_post_meta( $post->ID, 'jump_to', true );
		$jump_to_link    = get_post_meta( $post->ID, 'jump_to_link', true );
		$success_message = get_post_meta( $post->ID, 'success_message', true );
		$popup_bg_color  = get_post_meta( $post->ID, 'popup_bg_color', true );

		// Options
		$after_form_options = array(
			array(
				'value' => 'default',
				'name'  => _x( "message below the form", 'small', 'greyd_forms' ),
			),
			array(
				'value' => 'popup',
				'name'  => _x( "popup above the form", 'small', 'greyd_forms' ),
			),
			array(
				'value' => 'fullscreen',
				'name'  => _x( "fullscreen popup", 'small', 'greyd_forms' ),
			),
			array(
				'value' => 'page',
				'name'  => _x( "open new page", 'small', 'greyd_forms' ),
			),
		);
		$jump_to_options    = array(
			array(
				'value' => '--',
				'name'  => _x( "select page", 'small', 'greyd_forms' ),
			),
			array(
				'value' => 'STARTPAGE',
				'name'  => _x( "open home page", 'small', 'greyd_forms' ),
			),
			array(
				'value' => 'LINK',
				'name'  => _x( "enter external link", 'small', 'greyd_forms' ),
			),
		);

		// send is blocked
		$block_send = get_post_meta( $post->ID, 'block_send', true ) ? true : false;
		if ( $block_send ) {
			echo Helper::render_info_box(
				array(
					'style' => 'blue',
					'text'  => __( "These settings are blocked by the „prevent sending\" option under „Extended“. Disable the option and save your changes to re-enable all settings.", 'greyd_forms' ),
				)
			);
		}

		// START RENDERING
		echo "<table class='form_meta_box " . ( $block_send ? 'disabled' : '' ) . "'>";

		// // Header
		// echo "<tr>".
		// "<th colspan=2><div>".__("Appearance",'greyd_forms')."</div></th>".
		// "</tr>";

		$form_mode_options = array(
			'normal'     => array(
				'value' => 'normal',
				'label' => _x( "Generate entry", 'small', 'greyd_forms' ),
				'tabs'  => array_map(
					function( $tab ) {
						return isset( $tab['general'] ) && $tab['general'] === false ? null : $tab['href'];
					},
					$this->menu_tabs
				),
			),
			'block_send' => array(
				'value' => 'block_send',
				'label' => _x( "Non-submittable form", 'small', 'greyd_forms' ),
				'tabs'  => array(
					'general',
				),
			),
		);

		/**
		 * @filter 'greyd_forms_metabox_formmode_options'
		 */
		$form_mode_options = apply_filters( 'greyd_forms_metabox_formmode_options', $form_mode_options, $post );

		$form_mode = get_post_meta( $post->ID, 'form_mode', true );

		$form_mode = ! empty( $form_mode ) ? $form_mode : 'normal';

		echo '<tr>';
			echo "<td id='form_mode_options' data-form-mode-options='" . json_encode( $form_mode_options ) . "'>" . __( "Form mode", 'greyd_forms' ) . '</td>';
			echo '<td>';
		foreach ( $form_mode_options as $option ) {
			$checked = $form_mode === $option['value'] ? 'checked' : '';

			echo "<label for='{$option['value']}'>";
				echo "<input type='radio' id='{$option['value']}' name='form_mode' value='{$option['value']}' {$checked}>";
				echo $option['label'];
			echo '</label><br>';
		}
			echo '</td>';
		echo '</tr>';

		// Zeile 1: Required Style
		echo '<tr>';
			echo '<td>' . __( "Mandatory", 'greyd_forms' ) . '</td>';

			echo '<td>';
			echo "<label for='required_fields'><input type='checkbox' name='required_fields' id='required_fields' value='required_fields' data-text='' $required_fields>&nbsp;" .
				sprintf( __( "Mark required fields with: %s.", 'greyd_forms' ), "<span style='color:red;'>*</span>" ) . '</label><br>';

			echo "<label for='optional_fields' style='margin:7px 0 20px;'><input type='checkbox' name='optional_fields' id='optional_fields' value='optional_fields' data-text='' $optional_fields>&nbsp;" .
				sprintf( __( "Mark optional fields with: %s.", 'greyd_forms' ), "<span style='opacity:.6;'>(optional)</span>" ) . '</label><br>';

			echo '</td>';
		echo '</tr>';

		// Zeile 2: Required Text
		echo "<tr data-condition='required_fields' data-value='required_fields true'" . ( $required_fields === 'checked' ? '' : " class='hide'" ) . '>';
			echo '<td>' .
					__( "Note", 'greyd_forms' ) .
					'<small>' . __( "Text at the end of the form explaining the asterisk markers. (Default: mandatory fields)", 'greyd_forms' ) . '</small>' .
				 '</td>';

			echo '<td>';
				echo "<input type='text' name='required_text' value='$required_text' placeholder='" . __( "e.g. \"marked fields are required.\"", 'greyd_forms' ) . "'>";
				echo "<label for='required_align' style='margin-right: 10px;'>" . __( "Appearance:", 'greyd_forms' ) . "</label>";
				echo "<select name='required_align' style='max-width:200px;margin:0;'>";
					echo "<optgroup label='" . __( "Alignment", 'greyd_forms' ) . "'>";
					foreach ( $align_options as $option ) {
						$option = (object) $option;
						$s      = $required_align == $option->value ? 'selected="selected"' : '';
						if ( $option->value == 'hidden' ) {
							echo "<optgroup label='" . __( "Display", 'greyd_forms' ) . "'>";
						}
						echo "<option value='$option->value' $s> $option->name </option>";
					}
				echo '</select>';

			echo '</td>';
		echo '</tr>';

		echo "<tr><td colspan=2 class='subhead'><hr></td></tr>"; // Divider

		// FOLGEAKTION
		echo '<tr>';
			echo '<td>' .
					__( "Follow-up action", 'greyd_forms' ) .
					'<small>' . __( "What do you want to happen after the user submits the form?", 'greyd_forms' ) . '</small>' .
				 '</td>';
			echo '<td>';

				// Action after Form
				echo "<select name='after_form'>";
				foreach ( $after_form_options as $obj ) {
					$obj = (object) $obj;
					$s   = $after_form == $obj->value ? 'selected="selected"' : '';
					echo "<option value='$obj->value' $s> $obj->name </option>";
				}
				echo '</select><br>';

				// if after_form is 'page' --> where should we jump to?
				echo "<div data-condition='after_form' data-value='page'" . ( $after_form == 'page' ? '' : " class='hide'" ) . '>';

					// Jump to actions
					echo "<select name='jump_to'>";
						echo "<optgroup label='" . __( "Action", 'greyd_forms' ) . "'>";
						foreach ( $jump_to_options as $obj ) {
							$obj = (object) $obj;
							$s   = $jump_to == $obj->value || ( empty( $jump_to ) && $obj->value == '--' ) ? 'selected="selected"' : '';
							echo "<option value='$obj->value' $s> $obj->name </option>";
						}
						echo "<optgroup label='" . __( "Available pages", 'greyd_forms' ) . "'>";
						foreach ( $this->pages as $page ) {
							$s = $jump_to == $page->ID ? 'selected="selected"' : '';
							echo "<option value='$page->ID' $s> $page->post_title</option>";
						}
					echo '</select>';

					// Jump to link
					// if jump_to is 'link' --> insert link
					echo "<input type='url' name='jump_to_link' value='" . ( ! empty( $jump_to_link ) ? $jump_to_link : 'https://' ) . "' data-condition='jump_to' data-value='LINK'" . ( $jump_to == 'LINK' ? '' : " class='hide' disabled" ) . '>';
				echo '</div>';

				// Text der Nachricht
				echo "<textarea type='text' name='success_message' placeholder='" . __( "Enter the message here.", 'greyd_forms' ) . "' rows='5' " .
					 "data-condition='after_form' data-value='default'" .
					 ( ( $after_form === 'default' || empty( $after_form ) ) ? '' : " class='hide' disabled" ) . ">$success_message</textarea>";

				// Pop-up-Template Info
				echo "<div data-condition='after_form' data-value='popup fullscreen'" . ( $after_form == 'popup' || $after_form == 'fullscreen' ? '' : " class='hide' disabled" ) . '>';
					echo "<i class='info'>" .
						sprintf( __( "Please create a new template called %s to define the look of your popup.", 'greyd_forms' ), '<b>form_popup_' . $post->ID . '</b>' ) .
						'</i>';
				echo '</div>';

			echo '</td>';
		echo '</tr>';

		// Pop-up Color
		echo "<tr data-condition='after_form' data-value='popup fullscreen'" . ( $after_form == 'popup' || $after_form == 'fullscreen' ? '' : " class='hide' disabled" ) . '>';
			echo '<td>' .
					__( "Background color", 'greyd_forms' ) .
					'<small>' . __( "of the popup", 'greyd_forms' ) . '</small>' .
				 '</td>';
			echo '<td>';
					echo "<input name='popup_bg_color' type='text' class='mm-color-picker' value='$popup_bg_color' />";
			echo '</td>';
		echo '</tr>';

		echo '</table>';

	}


	// Mail Settings
	public function render_mails( $post ) {

		$is_greyd_blocks = ( function_exists( 'is_greyd_blocks' ) && is_greyd_blocks() ) || ( class_exists('\Greyd\Settings') && \Greyd\Settings::get_setting( array( 'site', 'builder' ) ) ) == 'gg-gg';

		// ADMIN MAIL
		$mail_to        = get_post_meta( $post->ID, 'mail_to', true );
		$mail_from      = get_post_meta( $post->ID, 'mail_from', true );
		$mail_from_name = get_post_meta( $post->ID, 'mail_from_name', true );
		$subject        = get_post_meta( $post->ID, 'subject', true );
		$mail_note      = get_post_meta( $post->ID, 'mail_note', true );

		// USER MAIL
		$user_gets_mail      = get_post_meta( $post->ID, 'user_gets_mail', true ) ? 'checked' : '';
		$user_mail_from_name = get_post_meta( $post->ID, 'user_mail_from_name', true );
		$user_mail_from      = get_post_meta( $post->ID, 'user_mail_from', true );
		$user_email          = get_post_meta( $post->ID, 'user_email', true );
		$user_mail_subject   = get_post_meta( $post->ID, 'user_mail_subject', true );
		$user_mail_content   = get_post_meta( $post->ID, 'user_mail_content', true );

		$verify_user           = get_post_meta( $post->ID, 'verify_user', true ) ? 'checked' : '';
		$verify_mail_from_name = get_post_meta( $post->ID, 'verify_mail_from_name', true );
		$verify_mail_from      = get_post_meta( $post->ID, 'verify_mail_from', true );
		$verify_email          = get_post_meta( $post->ID, 'verify_email', true );
		$verify_mail_subject   = get_post_meta( $post->ID, 'verify_mail_subject', true );
		$verify_mail_content   = get_post_meta( $post->ID, 'verify_mail_content', true );
		$verify_link           = get_post_meta( $post->ID, 'verify_link', true );
		$verify_link_name      = get_post_meta( $post->ID, 'verify_link_name', true );
		$verify_link_color     = get_post_meta( $post->ID, 'verify_link_color', true );

		$send_opt_out       = get_post_meta( $post->ID, 'send_opt_out', true ) ? 'checked' : '';
		$opt_out_link       = get_post_meta( $post->ID, 'opt_out_link', true );
		$opt_out_link_name  = get_post_meta( $post->ID, 'opt_out_link_name', true );
		$opt_out_link_color = get_post_meta( $post->ID, 'opt_out_link_color', true );

		// send is blocked
		$block_send = get_post_meta( $post->ID, 'block_send', true ) ? true : false;
		if ( $block_send ) {
			echo Helper::render_info_box(
				array(
					'style' => 'blue',
					'text'  => __( "These settings are blocked by the „prevent sending\" option under „Extended“. Disable the option and save your changes to re-enable all settings.", 'greyd_forms' ),
				)
			);
		}

		// START RENDERING
		// echo "<table class='form_meta_box'>";
		echo "<table class='form_meta_box " . ( $block_send ? 'disabled' : '' ) . "'>";

		// Header
		echo '<tr>' .
				'<th colspan=2><div>' . __( "Admin email", 'greyd_forms' ) . '</div></th>' .
			 '</tr>';

		// Zeile 0: mail
		echo '<tr>';
			echo '<td>' .
					__( "Recipient", 'greyd_forms' ) .
					'<small>' . __( "To which email address(es) should the form be sent?", 'greyd_forms' ) . '</small>' .
				 '</td>';
			echo '<td>';
				echo "<textarea type='text' name='mail_to' placeholder='example@mail.de, other@mail.de' rows='1' class='no-margin'>$mail_to</textarea>";
				echo "<i class='info'>";
					echo __( "Please separate multiple email addresses with a comma followed by an empty space.", 'greyd_forms' );
					echo '<br>';
					echo __( "Dynamic elements", 'greyd_forms' ) . ':';
					foreach ( $this->all_names as $key => $val ) {
						echo " [$val]";
					}
				echo '</i>';
			echo '</td>';
		echo '</tr>';

		// Zeile 1: Absender
		echo '<tr>';
			echo '<td>' .
					__( "Sender", 'greyd_forms' ) .
					'<small>' . __( "Which information do you want to display as the sender?", 'greyd_forms' ) . '</small>' .
				 '</td>';
			echo "<td class='flex-row'>";
				echo "<input type='text' name='mail_from_name' value='$mail_from_name' placeholder='" . __( "name", 'greyd_forms' ) . "'>";
				echo "<input type='text' name='mail_from' value='$mail_from' placeholder='" . __( "Email address", 'greyd_forms' ) . "'>";
			echo '</td>';
		echo '</tr>';

		// Zeile 2: subject
		echo '<tr>';
			echo '<td>' .
					__( "Subject", 'greyd_forms' ) . '</td>';
			echo '<td>';
				// Insert subject
				echo "<input type='text' name='subject' value='$subject' placeholder='" . __( "Enter the subject of the email here.", 'greyd_forms' ) . "'>";
			echo '</td>';
		echo '</tr>';

		// Zeile 3: content
		echo '<tr>';
			echo '<td>' .
					__( "Content", 'greyd_forms' ) . '</td>';
			echo '<td>';
				echo "<textarea type='text' name='mail_note' placeholder='" . __( "Optional note at the beginning of the email", 'greyd_forms' ) . "' rows='3'>$mail_note</textarea>";
				echo "<i class='info'>" . __( "The content of the email automatically reflects all the user’s entered values in the following format: 'Field name: <b>User’s input</b>'", 'greyd_forms' ) . '</i>';
			echo '</td>';
		echo '</tr>';

		// USER MAIL

		// Header
		echo '<tr>' .
				'<th colspan=2><div>' . __( "User email", 'greyd_forms' ) . '</div></th>' .
			 '</tr>';

		// 2-OPT-IN
		// Subheader
		echo '<tr>' .
				"<th colspan=2 class='subhead'>" . __( "Double opt-in", 'greyd_forms' ) . '</th>' .
			 '</tr>';

		// Zeile 0: Checkbox
		echo '<tr>';
			echo '<td>' .
					__( "Send verification email", 'greyd_forms' ) .
					'<small>' . __( "The user will receive an email authentication. A confirmation email will only be sent afterwards.", 'greyd_forms' ) . '</small>' .
				 '</td>';
			echo '<td>';
				echo "<input type='checkbox' name='verify_user' value='verify_user' $verify_user data-text='" . __( "Yes", 'greyd_forms' ) . "'>";
			echo '</td>';
		echo '</tr>';

		// Zeile 1: Absender
		echo "<tr data-condition='verify_user' data-value='true'" . ( $verify_user == true ? '' : " class='hide'" ) . '>';
			echo '<td>' .
					__( "Sender", 'greyd_forms' ) .
					'<small>' . __( "Which information do you want to display as the sender?", 'greyd_forms' ) . '</small>' .
				 '</td>';
			echo "<td class='flex-row'>";
				echo "<input type='text' name='verify_mail_from_name' value='$verify_mail_from_name' placeholder='" . __( "name", 'greyd_forms' ) . "'>";
				echo "<input type='text' name='verify_mail_from' value='$verify_mail_from' placeholder='" . __( "Email address", 'greyd_forms' ) . "'>";
			echo '</td>';
		echo '</tr>';

		// Zeile 2: email Feld
		echo "<tr data-condition='verify_user' data-value='true'" . ( $verify_user == true ? '' : " class='hide'" ) . '>';
			echo '<td>' .
					__( "Recipient", 'greyd_forms' ) .
					'<small>' . __( "Which form field should be submitted as the user’s email address?", 'greyd_forms' ) . '</small>' .
				 '</td>';
			echo '<td>';
				echo "<select name='verify_email'>";
				foreach ( $this->all_options as $key => $val ) {
					$s = $verify_email == $val ? 'selected="selected"' : '';
					echo "<option value='$val' $s> $val </option>";
				}
				echo '</select>';
			echo '</td>';
		echo '</tr>';

		// Zeile 3: subject
		echo "<tr data-condition='verify_user' data-value='true'" . ( $verify_user == true ? '' : " class='hide'" ) . '>';
			echo '<td>' .
					__( "Subject", 'greyd_forms' ) . '</td>';
			echo '<td>';
				echo "<input type='text' name='verify_mail_subject' value='$verify_mail_subject' placeholder='" . __( "Enter the subject of the email here.", 'greyd_forms' ) . "'>";
			echo '</td>';
		echo '</tr>';

		// Zeile 4: content
		echo "<tr data-condition='verify_user' data-value='true'" . ( $verify_user == true ? '' : " class='hide'" ) . '>';
			echo '<td>' .
					__( "Content", 'greyd_forms' ) .
					"<span class='small'>";
						echo __( "Dynamic elements", 'greyd_forms' ) . ':';
						foreach ( $this->all_names as $key => $val ) {
							echo "<br>[$val]";
						}
						echo '<br>[opt_in_link]';
						echo '<br><br><i class="info">' . __( "You can also use these dynamic placeholders in other fields, such as the subject, sender or email addresses.", 'greyd_forms' ) . '</i>';
					echo '</span>';
			echo '</td>';
			echo '<td>';
				wp_editor(
					htmlspecialchars_decode( $verify_mail_content ),
					'verify_mail_content',
					$settings = array(
						'textarea_name' => 'verify_mail_content',
						'editor_height' => 200,
						'media_buttons' => true,
						'tinymce'       => ! $is_greyd_blocks,
					)
				);
				echo "<i class='info'>" . __( "Enter the contents of the email here. A confirmation link is automatically sent along. If you want to include dynamic form elements, copy them from the left and paste them into your email text.", 'greyd_forms' ) . '</i>';
			echo '</td>';
		echo '</tr>';

		// Zeile 5: Link
		echo "<tr data-condition='verify_user' data-value='true'" . ( $verify_user == true ? '' : " class='hide'" ) . '>';
			echo '<td>' .
					__( "Verification link", 'greyd_forms' ) .
					'<small>' . __( "Where should the user be directed after clicking on the confirmation link?", 'greyd_forms' ) . '</small>' .
				 '</td>';
			echo "<td><div class='flex-row'>";

				$is_custom_verify_link = ! empty( $verify_link ) && ! is_numeric( $verify_link );
				echo "<select name='verify_link'>";
					echo '<option value="">' . __( "select page", 'greyd_forms' ) . '</option>';
					echo '<option value="home" '.( $opt_out_link == 'home' ? 'selected="selected"' : '' ).'>' . __( 'Homepage', 'greyd_forms' ) . '</option>';
					foreach ( $this->pages as $page ) {
						$s = $verify_link == $page->ID ? 'selected="selected"' : '';
						echo "<option value='$page->ID' $s> $page->post_title</option>";
					}
					$s = $is_custom_verify_link ? 'selected="selected"' : '';
					echo "<option value='custom' $s> " . __( "individual URL", 'greyd_forms' ) . '</option>';
				echo '</select>';
				echo "<input class='" . ( $is_custom_verify_link ? '' : 'hidden' ) . "' type='text' name='verify_link_custom' value='" . ( $is_custom_verify_link ? $verify_link : get_site_url() ) . "' placeholder='" . __( "individual URL", 'greyd_forms' ) . "'>";
				echo "<input type='text' name='verify_link_name' value='$verify_link_name' placeholder='" . __( "Link text", 'greyd_forms' ) . "'>";
			echo '</div>';

			echo "<input name='verify_link_color' type='text' class='mm-color-picker' value='$verify_link_color' style='margin-right:2.5em;' />";
			echo '</td>';
		echo '</tr>';

		// Bestätigungsmail

		// Subheader
		echo '<tr>' .
				"<th colspan=2 class='subhead'><div>" . __( "Confirmation email", 'greyd_forms' ) . '</div></th>' .
			 '</tr>';

		// Zeile 0: Checkbox
		echo '<tr>';
			echo '<td>' .
					__( "Send confirmation email", 'greyd_forms' ) .
					'<small>' . __( "The user will receive an email after submitting the form.", 'greyd_forms' ) . '</small>' .
				 '</td>';
			echo '<td>';
				echo "<input type='checkbox' name='user_gets_mail' value='user_gets_mail' $user_gets_mail data-text='" . __( "Yes", 'greyd_forms' ) . "'>";

			echo '</td>';
		echo '</tr>';

		// Zeile 1: Absender
		echo "<tr data-condition='user_gets_mail' data-value='true'" . ( $user_gets_mail == true ? '' : " class='hide'" ) . '>';
			echo '<td>' .
					__( "Sender", 'greyd_forms' ) .
					'<small>' . __( "Which information do you want to display as the sender?", 'greyd_forms' ) . '</small>' .
				 '</td>';
			echo "<td class='flex-row'>";
				echo "<input type='text' name='user_mail_from_name' value='$user_mail_from_name' placeholder='" . __( "name", 'greyd_forms' ) . "'>";
				echo "<input type='text' name='user_mail_from' value='$user_mail_from' placeholder='" . __( "Email address", 'greyd_forms' ) . "'>";
			echo '</td>';
		echo '</tr>';

		// Zeile 2: email Feld
		echo "<tr data-condition='user_gets_mail' data-value='true'" . ( $user_gets_mail == true ? '' : " class='hide'" ) . '>';
			// only show if user-mail-field is not chosen already (via 2-opt-in)
			echo "<td data-condition='verify_email' data-value='" . $this->all_options[0] . "'" . ( $verify_email == $this->all_options[0] || empty( $verify_email ) ? '' : " class='hide' disabled" ) . '>' .
					__( "Recipient", 'greyd_forms' ) .
					'<small>' . __( "Which form field contains the user’s email address?", 'greyd_forms' ) . '</small>' .
				 '</td>';
			// only show if user-mail-field is not chosen already (via 2-opt-in)
			echo "<td data-condition='verify_email' data-value='" . $this->all_options[0] . "'" . ( $verify_email == $this->all_options[0] || empty( $verify_email ) ? '' : " class='hide' disabled" ) . '>';
				echo "<select name='user_email'>";
				foreach ( $this->all_options as $key => $val ) {
					$s = $user_email == $val ? 'selected="selected"' : '';
					echo "<option value='$val' $s> $val </option>";
				}
				echo '</select>';
			echo '</td>';
		echo '</tr>';

		// Zeile 3: subject
		echo "<tr data-condition='user_gets_mail' data-value='true'" . ( $user_gets_mail == true ? '' : " class='hide'" ) . '>';
			echo '<td>' .
					__( "Subject", 'greyd_forms' ) . '</td>';
			echo '<td>';
				echo "<input type='text' name='user_mail_subject' value='$user_mail_subject' placeholder='" . __( "Enter the subject of the email here.", 'greyd_forms' ) . "'>";
			echo '</td>';
		echo '</tr>';

		// Zeile 4: content
		echo "<tr data-condition='user_gets_mail' data-value='true'" . ( $user_gets_mail == true ? '' : " class='hide'" ) . '>';
			echo '<td>' .
					__( "Content", 'greyd_forms' ) .
					"<span class='small'>";
						echo __( "Dynamic elements", 'greyd_forms' ) . ':';
						foreach ( $this->all_names as $key => $val ) {
							echo "<br>[$val]";
						}
						echo '<br>[opt_out_link]';
						echo '<br><br><i class="info">' . __( "You can also use these dynamic placeholders in other fields, such as the subject, sender or email addresses.", 'greyd_forms' ) . '</i>';
					echo '</span>';
				echo '</td>';
			echo '<td>';
				wp_editor(
					htmlspecialchars_decode( $user_mail_content ),
					'user_mail_content',
					$settings = array(
						'textarea_name' => 'user_mail_content',
						'editor_height' => 200,
						'media_buttons' => true,
						'tinymce'       => ! $is_greyd_blocks,
					)
				);
				echo "<i class='info'>" . __( "Enter the contents of the email here. If you want to include dynamic form elements, copy them from the left and paste them into your email text.", 'greyd_forms' ) . '</i>';
			echo '</td>';
		echo '</tr>';

		// Zeile 5: Link
		echo "<tr data-condition='user_gets_mail' data-value='true'" . ( $user_gets_mail == true ? '' : " class='hide'" ) . '>';
			echo '<td>' .
					__( "Opt-out link", 'greyd_forms' ) .
					'<small>' . __( "Do you want to send an opt-out link in the email?", 'greyd_forms' ) . '</small>' .
				 '</td>';
			echo '<td><div>';
				echo "<input type='checkbox' name='send_opt_out' value='send_opt_out' $send_opt_out style='margin-bottom:1em;' data-text='" . __( "Yes", 'greyd_forms' ) . "'>";
					echo "<div data-condition='send_opt_out' data-value='true'" . ( $send_opt_out == true ? '' : " class='hide'" ) . '>';
						echo "<div class='flex-row'>";

							$is_custom_opt_out_link = ! empty( $opt_out_link ) && ! is_numeric( $opt_out_link );
							echo "<select name='opt_out_link' data-condition='send_opt_out' data-value='true'" . ( $send_opt_out == true ? '' : " class='hide'" ) . '>';
								echo '<option value="">' . __( "select page", 'greyd_forms' ) . '</option>';
								echo '<option value="home" '.( $opt_out_link == 'home' ? 'selected="selected"' : '' ).'>' . __( 'Homepage', 'greyd_forms' ) . '</option>';
								foreach ( $this->pages as $page ) {
									$s = $opt_out_link == $page->ID ? 'selected="selected"' : '';
									echo "<option value='$page->ID' $s>$page->post_title</option>";
								}
								$s = $is_custom_opt_out_link ? 'selected="selected"' : '';
								echo "<option value='custom' $s> " . __( "individual URL", 'greyd_forms' ) . '</option>';
							echo '</select>';
							echo "<input class='" . ( $is_custom_opt_out_link ? '' : 'hidden' ) . "' type='text' name='opt_out_link_custom' value='" . ( $is_custom_opt_out_link ? $opt_out_link : get_site_url() ) . "' placeholder='" . __( "individual URL", 'greyd_forms' ) . "'>";
							echo "<input type='text' name='opt_out_link_name' value='$opt_out_link_name' placeholder='" . __( "Link text", 'greyd_forms' ) . "' data-condition='send_opt_out' data-value='true'" . ( $send_opt_out == true ? '' : " class='hide'" ) . '>';

						echo '</div>';

						echo "<input name='opt_out_link_color' type='text' class='mm-color-picker' value='$opt_out_link_color'/>";

					echo '</div>';
				echo '</div>';
			echo '</td>';
		echo '</tr>';

		echo '</table>';

		do_action( 'greyd_forms_render_optout_warning' );

	}


	// Erweiterte Einstellungen
	public function render_more( $post ) {

		// Darstellung
		$hide_tooltips = get_post_meta( $post->ID, 'hide_tooltips', true ) ? 'checked' : '';

		// start rendering
		echo "<table class='form_meta_box'>";

		// Header
		echo '<tr>' .
				'<th colspan=2><div>' . __( "Appearance", 'greyd_forms' ) . '</div></th>' .
			 '</tr>';

		// Hide Tooltips
		echo '<tr>';
			echo '<td>' .
					__( 'Tooltips', 'greyd_forms' ) .
					'<small>' . __( "When enabled, no tool tips are displayed.", 'greyd_forms' ) . '</small>' .
				 '</td>';
			echo '<td>';
				echo "<input type='checkbox' name='hide_tooltips' value='hide_tooltips' data-text='" . __( "hide", 'greyd_forms' ) . "' $hide_tooltips>";
			echo '</td>';
		echo '</tr>';

		echo '</table>';
	}


	// API Settings
	public function render_api( $post ) {

		// send is blocked
		$block_send = get_post_meta( $post->ID, 'block_send', true ) ? true : false;
		if ( $block_send ) {
			echo Helper::render_info_box(
				array(
					'style' => 'blue',
					'text'  => __( "These settings are blocked by the „prevent sending\" option under „Extended“. Disable the option and save your changes to re-enable all settings.", 'greyd_forms' ),
				)
			);
			echo "<div class='" . ( $block_send ? 'disabled' : '' ) . "'>";
		}

		do_action( 'render_metabox_interface', $post, $this->all_options );

		if ( $block_send ) {
			echo '</div>';
		}

	}
	public function render_entry_delete( $post ) {
		do_action( 'render_metabox_entry_delete', $post, $this->all_options );
	}


	// Save Post Information
	public function save_post( $post_id, $post ) {

		if ( ! is_admin() ) {
			return;
		}
		if ( $post->post_type != $this->config->plugin_post_type ) {
			return;
		}
		if ( empty( $_POST ) ) {
			return;
		}
		if ( isset( $_POST['action'] ) && $_POST['action'] === 'greyd_ajax' ) {
			return; // form inserted via ajax
		}
		// REGULAR OPTIONS

		// Save all post meta arguments
		foreach ( $this->post_args as $name ) {
			$val = isset( $_POST[ $name ] ) ? esc_attr( $_POST[ $name ] ) : null;

			if ( $val == 'custom' && ( $name == 'verify_link' || $name == 'opt_out_link' ) ) {
				$val = isset( $_POST[ $name . '_custom' ] ) ? esc_attr( $_POST[ $name . '_custom' ] ) : null;
			}
			update_post_meta( $post_id, $name, $val );
		}

		// CUSTOM OPTIONS

		// Required Styling
		$required_fields = isset( $_POST['required_fields'] ) ? esc_attr( $_POST['required_fields'] ) : null;
		$optional_fields = isset( $_POST['optional_fields'] ) ? esc_attr( $_POST['optional_fields'] ) : null;
		if ( $required_fields === 'required_fields' && $optional_fields === 'optional_fields' ) {
			$required_style = 'both';
		} elseif ( $required_fields === 'required_fields' ) {
			$required_style = 'required';
		} elseif ( $optional_fields === 'optional_fields' ) {
			$required_style = 'optional';
		} else {
			$required_style = 'none';
		}
		// Save
		update_post_meta( $post_id, 'required_style', $required_style );

		// API & THIRD PARTY OPTIONS
		// add action for more post meta vars
		do_action(
			'formmeta_save',
			array(
				'data'    => $_POST,
				'post_id' => $post_id,
			)
		);

	}
}
