<?php
/**
 * Register the custom post type.
 */
namespace Greyd\Forms;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

new Register( $config );
class Register {

	private $config;

	function __construct( $config ) {

		// set config
		$this->config = (object) $config;

		// define and add custom post type
		add_action( 'init', array( $this, 'add_forms_post_type' ) );
	}

	// add custom post type
	public function add_forms_post_type() {

		$post_type = $this->config->plugin_post_type;

		$name     = __( "Forms", 'greyd_forms' );
		$singular = __( "Form", 'greyd_forms' );

		$post_type_labels    = array(
			'name'               => $name,
			'singular_name'      => $singular,
			'menu_name'          => $name,
			'name_admin_bar'     => $singular,
			'add_new'            => sprintf( __( "Create", 'greyd_forms' ), $singular ),
			'add_new_item'       => sprintf( __( "Create %s", 'greyd_forms' ), $singular ),
			'new_item'           => sprintf( __( "New %s", 'greyd_forms' ), $singular ),
			'edit_item'          => sprintf( __( "Edit %s", 'greyd_forms' ), $singular ),
			'view_item'          => sprintf( __( "Show %s", 'greyd_forms' ), $singular ),
			'all_items'          => sprintf( __( "All %s", 'greyd_forms' ), $name ),
			'search_items'       => sprintf( __( "Search %s", 'greyd_forms' ), $singular ),
			'parent_item_colon'  => sprintf( __( "Parent %s", 'greyd_forms' ), $singular ),
			'not_found'          => sprintf( __( "No %s found", 'greyd_forms' ), $name ),
			'not_found_in_trash' => sprintf( __( "No %s found in the the trash", 'greyd_forms' ), $singular ),
		);
		$post_type_arguments = array(
			'labels'              => $post_type_labels,
			'description'         => __( "Description", 'greyd_forms' ),
			'public'              => true,
			'exclude_from_search' => true,
			'publicly_queryable'  => false,
			'show_ui'             => true,
			'show_in_menu'        => true,
			'show_in_nav_menus'   => false,
			'show_in_rest'        => true, // gutenberg support
			'query_var'           => true,
			'rewrite'             => array( 'slug' => $post_type ),
			'capability_type'     => 'page',
			// 'has_archive'        => true,
			// 'hierarchical'       => true,
			'menu_position'       => 23,
			// 'menu_icon'          => plugins_url( $this->config->plugin_name.'/assets/icon/greyd-menuicon-forms.svg' ),
			'menu_icon'           => 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjAiIGhlaWdodD0iMjAiIHZpZXdCb3g9IjAgMCAyMCAyMCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZmlsbC1ydWxlPSJldmVub2RkIiBjbGlwLXJ1bGU9ImV2ZW5vZGQiIGQ9Ik0yLjUgMy4yNUMyLjUgMi4yODM1IDMuMjgzNSAxLjUgNC4yNSAxLjVIMTQuMjVDMTUuMjE2NSAxLjUgMTYgMi4yODM1IDE2IDMuMjVWMTIuMjVIMTQuNVYzLjI1QzE0LjUgMy4xMTE5MyAxNC4zODgxIDMgMTQuMjUgM0g0LjI1QzQuMTExOTMgMyA0IDMuMTExOTMgNCAzLjI1VjE2LjI1QzQgMTYuMzg4MSA0LjExMTkzIDE2LjUgNC4yNSAxNi41SDkuMjVWMThINC4yNUMzLjI4MzUgMTggMi41IDE3LjIxNjUgMi41IDE2LjI1VjMuMjVaIiBmaWxsPSIjRjZGN0Y3Ii8+CjxwYXRoIGZpbGwtcnVsZT0iZXZlbm9kZCIgY2xpcC1ydWxlPSJldmVub2RkIiBkPSJNMTkuNzcwMyAxMy4yOTAyTDE0LjA1OTQgMTguNzkxNEwxMS4yMjk3IDE2LjA2NTZMMTIuMjcwMyAxNC45ODUzTDE0LjA1OTQgMTYuNzA4NkwxOC43Mjk3IDEyLjIwOThMMTkuNzcwMyAxMy4yOTAyWiIgZmlsbD0iI0Y2RjdGNyIvPgo8cGF0aCBmaWxsLXJ1bGU9ImV2ZW5vZGQiIGNsaXAtcnVsZT0iZXZlbm9kZCIgZD0iTTEyLjc1IDYuNUg1Ljc1VjVIMTIuNzVWNi41WiIgZmlsbD0iI0Y2RjdGNyIvPgo8cGF0aCBkPSJNNy41MTE2IDkuMjU3NTdDNy41MTE2IDkuODA5ODUgNy4wNjM4OSAxMC4yNTc2IDYuNTExNiAxMC4yNTc2QzUuOTU5MzIgMTAuMjU3NiA1LjUxMTYgOS44MDk4NSA1LjUxMTYgOS4yNTc1N0M1LjUxMTYgOC43MDUyOSA1Ljk1OTMyIDguMjU3NTcgNi41MTE2IDguMjU3NTdDNy4wNjM4OSA4LjI1NzU3IDcuNTExNiA4LjcwNTI5IDcuNTExNiA5LjI1NzU3WiIgZmlsbD0iI0Y2RjdGNyIvPgo8cGF0aCBmaWxsLXJ1bGU9ImV2ZW5vZGQiIGNsaXAtcnVsZT0iZXZlbm9kZCIgZD0iTTExLjc1IDEwSDguNzVWOC41SDExLjc1VjEwWiIgZmlsbD0iI0Y2RjdGNyIvPgo8L3N2Zz4K',
			'supports'            => array( 'title', 'editor', 'custom-fields' ),
		);

		// register post_type and taxonony
		register_post_type( $post_type, $post_type_arguments );
	}
}
