<?php
/*
Plugin Name:    Greyd.Forms
Description:    Greyd.Forms is the form generator in Greyd.Suite with which you can create any type of form quickly and easily – and automatically in your website design. From simple contact forms with double opt-in to complex multistep forms with CRM connection, dynamic content and mathematical calculations everything is possible with the native features of Greyd.Forms.
Plugin URI:     https://greyd.io
Author:         Greyd
Author URI:     https://greyd.io
Version:        2.0
Text Domain:    greyd_forms
Domain Path:    /languages/
*/
namespace Greyd\Forms;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( !defined( 'GREYD_FORMS_VERSION' ) ) {
	define( 'GREYD_FORMS_VERSION', '2.0' );
}

// config vars
$config = array(
	'plugin_name_full'  => 'Greyd.Forms',
	'plugin_name'       => 'greyd_tp_forms',
	'plugin_post_type'  => 'tp_forms',
	'plugin_textdomain' => 'greyd_forms',
	'plugin_file'       => __FILE__,
	'plugin_path'       => __DIR__,
	'update_file'       => 'https://update.greyd.io/public/plugins/greyd_forms/metadata.json',
	'required_versions' => array(
		'greyd_suite'  => '1.8.0',
		'greyd_hub'    => '1.8.0',
		'greyd_blocks' => '1.8.0',
	),
);

// add version infos to 'greyd_versions' filter
add_filter(
	'greyd_versions',
	function( $versions ) use ( $config ) {
		if ( ! function_exists( 'get_plugin_data' ) ) {
			require_once ABSPATH . 'wp-admin/includes/plugin.php';
		}
		$versions[ $config['plugin_textdomain'] ] = array(
			'version'  => get_plugin_data( $config['plugin_file'] )['Version'],
			'required' => $config['required_versions'],
		);
		return $versions;
	}
);

// init
require_once __DIR__ . '/manage.php';

// core
require_once __DIR__ . '/inc/register-post-type.php';
require_once __DIR__ . '/inc/helper.php';
require_once __DIR__ . '/inc/handle.php';
require_once __DIR__ . '/inc/admin-menu.php';
require_once __DIR__ . '/inc/enqueue.php';
require_once __DIR__ . '/inc/register-blocks.php';
require_once __DIR__ . '/inc/render.php';

// admin only
if ( is_admin() ) {
	include_once __DIR__ . '/inc/metabox.php';
	include_once __DIR__ . '/inc/entry.php';
	include_once __DIR__ . '/inc/settings.php';
}

// features
require_once __DIR__ . '/inc/features/statistics/init.php';
require_once __DIR__ . '/inc/features/honeypot.php';
require_once __DIR__ . '/inc/features/block-patterns.php';
require_once __DIR__ . '/inc/features/export.php';
require_once __DIR__ . '/inc/features/post-export.php';
require_once __DIR__ . '/inc/features/surveys/init.php';

// interfaces
require_once __DIR__ . '/interfaces/class-greyd-forms-interface.php';

// deprecated
require_once __DIR__ . '/inc/deprecated/vc/init.php';
