jQuery( function () {
	hubspot.init();
} );

var hubspot = new function () {

	this.apikey = 'input[name="greyd_forms_interface_settings[hubspot][apikey]"]';
	this.token = 'input[name="greyd_forms_interface_settings[hubspot][auth_token]"]';
	this.lists = 'input[name="greyd_forms_interface_settings[hubspot][lists]"]';

	this.init = function () {
		$ = jQuery;

		$( hubspot.apikey ).on( 'change keyup', hubspot.updateState );
		$( hubspot.token ).on( 'change keyup', hubspot.updateState );

		$( '#hubspot .button.getLists' ).on( "click", hubspot.getLists );
		hubspot.getLists();
	};

	this.getLists = function () {
		var apikey = $( hubspot.apikey ).val();
		const token = $( hubspot.token ).val();


		if ( ( typeof apikey === 'undefined' || apikey.length === 0 ) && ( typeof token === 'undefined' || token.length === 0 ) )
			return false;

		$( '#hubspot .empty, #hubspot .set, #hubspot ._error' ).addClass( 'hidden' );
		$( '#hubspot .loader' ).parent().addClass( 'loading' ).css( 'display', 'inline-block' );

		console.log( local_hubspot );

		$.ajax( {
			type: 'POST',
			url: local_hubspot.ajaxurl,
			data: {
				action: local_hubspot.action,
				_ajax_nonce: local_hubspot.nonce,
				mode: 'hubspot',
				data: {
					apikey: apikey,
					token: token
				}
			},
			success: function ( response, textStatus, XMLHttpRequest ) {
				console.log( response );

				$( '#hubspot .loader' ).parent().removeClass( 'loading' ).css( 'display', 'none' );

				if ( response.indexOf( 'success::' ) > -1 ) {
					var msg = response.split( 'success::' );
					var lists = JSON.parse( msg[ 1 ] );
					console.log( lists );
					$( hubspot.lists ).val( msg[ 1 ] );
					$( '#hubspot .set ul' ).html( '' );
					$.each( lists, function ( id, name ) {
						if ( id === 'none' ) return;
						$( '#hubspot .set ul' ).append( "<li><strong>" + name + "</strong> (ID: " + id + ")</li>" );
					} );
					if ( $( '#hubspot .set ul' ).html() === '' ) {
						$( '#hubspot .set ul' ).append( "<li>" + lists.none + "</li>" );
					}


					$( '#hubspot .set' ).removeClass( 'hidden' );

				} else if ( response.indexOf( 'error::' ) > -1 ) {
					var msg = response.split( 'error::' );
					console.warn( msg[ 1 ] );
					console.warn( $( '#hubspot ._error .text' ) );
					$( '#hubspot ._error .text' ).html( msg[ 1 ] );
					$( '#hubspot ._error' ).removeClass( 'hidden' );
				}


			},
			error: function ( XMLHttpRequest, textStatus, errorThrown ) {
				console.warn( errorThrown );

				$( '#hubspot .loader' ).parent().removeClass( 'loading' ).css( 'display', 'none' );
				$( '#hubspot ._error' ).removeClass( 'hidden' );


			}
		} );
	};

	this.updateState = function () {
		console.log( 'changed' );

		var apikey = $( hubspot.apikey ).val();
		var token = $( hubspot.token ).val();

		if ( ( typeof apikey === 'undefined' || apikey.length === 0 ) && ( typeof token === 'undefined' || token.length === 0 ) ) {
			$( '#hubspot .not_ready' ).removeClass( 'hidden' );
			$( '#hubspot .ready' ).addClass( 'hidden' );
		} else {
			$( '#hubspot .not_ready' ).addClass( 'hidden' );
			$( '#hubspot .ready' ).removeClass( 'hidden' );
		}

		// reset lists
		$( hubspot.lists ).val( '' );
		$( '#hubspot .set, #hubspot ._error' ).addClass( 'hidden' );
		$( '#hubspot .empty' ).removeClass( 'hidden' );
	};

	this.showToken = function () {
		const target = document.querySelector( this.token );
		if ( target.type === "password" ) {
			target.type = "text";
		} else {
			target.type = "password";
		}
	};
	this.handlePaste = function () {
		const target = document.querySelector( this.token );
		navigator.clipboard.readText()
			.then( ( copied ) => {
				target.value = copied;
			} );
	};


};