<?php

return array(
	'name'     => __( 'HubSpot', 'greyd_forms' ),

	// register settings
	'settings' => array(
		'description' => __( "Connect your HubSpot to automatically generate contacts from forms.", 'greyd_forms' ),
		'options'     => array(
			'auth_token' => __( 'Auth-Token', 'greyd_forms' ),
			'lists'      => __( "Static lists:", 'greyd_forms' ),
		),
	),

	// register fields
	'metabox'  => array(
		'enable' => array(
			'title'       => __( "Create contact?", 'greyd_forms' ),
			'description' => __( "Do you want to automatically generate a HubSpot contact through a completed form?", 'greyd_forms' ),
		),
		'normal' => array(
			'fields' => array(
				'email'          => _x( "email", 'small', 'greyd_forms' ),
				'firstname'      => _x( "first name", 'small', 'greyd_forms' ),
				'lastname'       => _x( "last name", 'small', 'greyd_forms' ),
				'salutation'     => _x( "salutation", 'small', 'greyd_forms' ),

				'phone'          => _x( "phone number", 'small', 'greyd_forms' ),
				'mobilephone'    => _x( "Mobile", 'small', 'greyd_forms' ),
				'fax'            => _x( "Fax", 'small', 'greyd_forms' ),

				'address'        => _x( "Address line", 'small', 'greyd_forms' ),
				'zip'            => _x( "zip", 'small', 'greyd_forms' ),
				'city'           => _x( "city", 'small', 'greyd_forms' ),
				'state'          => _x( "State/region", 'small', 'greyd_forms' ),

				'jobtitle'       => _x( "Job title", 'small', 'greyd_forms' ),
				'company'        => _x( "Company name", 'small', 'greyd_forms' ),
				'website'        => _x( "Website URL", 'small', 'greyd_forms' ),
				'industry'       => _x( "Sector", 'small', 'greyd_forms' ),

				'hs_language'    => _x( "preferred language", 'small', 'greyd_forms' ),
				'message'        => _x( "Message", 'small', 'greyd_forms' ),
				'lifecyclestage' => _x( "Lifecycle phase", 'small', 'greyd_forms' ),
			),
		),
		'custom' => array(
			'fields'      => true,
			'description' => sprintf(
				__( "Here you can pass your individual HubSpot properties. %s", 'greyd_forms' ),
				"<a href='https://knowledge.hubspot.com/de/contacts/how-can-i-create-a-custom-property' target='_blank'>" . __( "Create custom properties", 'greyd_forms' ) . '</a>'
			),
		),
		'meta'   => array(
			'title'  => __( "Actions", 'greyd_forms' ),
			'fields' => array(
				'list'   => array(
					'type'  => 'select',
					'label' => __( "Add contact to static list", 'greyd_forms' ),
					'value' => self::get_option( 'hubspot', 'lists' ),
				),
				'update' => array(
					'type'  => 'checkbox',
					'label' => __( "Do you want to update the contact if the email already exists in your CRM?", 'greyd_forms' ),
				),
			),
		),
	),
	'optout'   => false,
);
