jQuery( function () {
	mailchimp.init();
} );

var mailchimp = new function () {

	this.apikey = 'input[name="greyd_forms_interface_settings[mailchimp][apikey]"]';
	this.dc = 'input[name="greyd_forms_interface_settings[mailchimp][dc]"]';
	this.lists = 'input[name="greyd_forms_interface_settings[mailchimp][lists]"]';
	this.selectedList = 'select[name="interface_settings[mailchimp][meta][memberslist]"]';
	this.fieldDropdowns = 'select[name*="interface_settings[mailchimp][normal][api]"]';



	this.init = function () {
		$ = jQuery;

		//Get Lists
		$( mailchimp.apikey ).on( 'change keyup', mailchimp.updateState );
		$( mailchimp.dc ).on( 'change keyup', mailchimp.updateState );

		$( '#mailchimp .button.getLists' ).on( "click", mailchimp.getLists );
		mailchimp.getLists();


		//Get Fields
		$( this.selectedList ).on( 'change', mailchimp.getMergeFields );
		mailchimp.getMergeFields();
	};


	this.getLists = function () {

		var apikey = $( mailchimp.apikey ).val();
		var dc = $( mailchimp.dc ).val();


		if ( typeof apikey === 'undefined' || apikey.length === 0 || typeof dc === 'undefined' || dc.length === 0 )
			return false;

		$( '#mailchimp .empty, #mailchimp .set, #mailchimp ._error' ).addClass( 'hidden' );
		$( '#mailchimp .loader' ).parent().addClass( 'loading' ).css( 'display', 'inline-block' );

		//console.log( local_mailchimp );

		$.ajax( {
			type: 'POST',
			url: local_mailchimp.ajaxurl,
			data: {
				action: local_mailchimp.action,
				_ajax_nonce: local_mailchimp.nonce,
				mode: 'mailchimp',
				data: {
					apikey: apikey,
					dc: dc
				}
			},
			success: function ( response, textStatus, XMLHttpRequest ) {
				console.log( response );

				$( '#mailchimp .loader' ).parent().removeClass( 'loading' ).css( 'display', 'none' );

				if ( response.indexOf( 'success::' ) > -1 ) {
					var msg = response.split( 'success::' );
					var lists = JSON.parse( msg[ 1 ] );

					// console.log(lists);
					$( mailchimp.lists ).val( msg[ 1 ] );
					$( '#mailchimp .set ul' ).html( '' );


					$.each( lists, function ( id, list ) {
						$( '#mailchimp .set ul' ).append( "<li><strong>" + list + "</strong> (ID: " + id + ")</li>" );
					} );
					$( '#mailchimp .set' ).removeClass( 'hidden' );

				} else if ( response.indexOf( 'error::' ) > -1 ) {
					var msg = response.split( 'error::' );
					console.warn( msg[ 1 ] );
					$( '#mailchimp ._error .text' ).html( msg[ 1 ] );
					$( '#mailchimp ._error' ).removeClass( 'hidden' );
				}

			},
			error: function ( XMLHttpRequest, textStatus, errorThrown ) {
				console.warn( errorThrown );

				$( '#mailchimp .loader' ).parent().removeClass( 'loading' ).css( 'display', 'none' );
				$( '#mailchimp ._error' ).removeClass( 'hidden' );


			}
		} );
	};

	this.getMergeFields = function () {

		var list = $( mailchimp.selectedList ).val();
		// console.log(list);

		if ( typeof list === 'undefined' || list.length === 0 )
			return false;

		$.ajax( {
			type: 'POST',
			url: local_mailchimp.ajaxurl,
			data: {
				action: local_mailchimp.action,
				_ajax_nonce: local_mailchimp.nonce,
				mode: 'mailchimp',
				data: {
					list: list
				}
			},
			success: function ( response, textStatus, XMLHttpRequest ) {
				//console.log(response);


				if ( response.indexOf( 'success::' ) > -1 ) {
					var msg = response.split( 'success::' );
					var merge_fields = JSON.parse( msg[ 1 ] );
					var init_field_value = '';


					$( 'select[name*="interface_settings[mailchimp][normal][api]"] option[value!="none"][value!="email"]' ).each( function () { // Selektor cleanen?
						$( this ).remove();
					} );


					//add Fields to Dropdowns
					$.each( merge_fields, function ( tag, field ) {
						$( mailchimp.fieldDropdowns ).append( $( '<option value="' + tag + '::' + field.type + '">' + field.name + '</option>' ) );
					} );


					//check for initial field value and add selected attribute
					$( mailchimp.fieldDropdowns ).each( function () {

						init_field_value = $( this ).attr( "data-init-value" );

						if ( init_field_value.indexOf( "::" ) !== -1 ) {
							init_field_value = init_field_value.split( "::" );
							$( this ).children( 'option' ).each( function ( value ) {
								value = $( this ).val();
								value = value.split( "::" );
								if ( value[ 0 ] === init_field_value[ 0 ] ) {
									$( this ).attr( 'selected', 'selected' );
								}
							} );
						} else {
							$( this ).children( 'option' ).each( function ( value ) {
								value = $( this ).val();
								if ( value === init_field_value ) {
									$( this ).attr( 'selected', 'selected' );

								}
							} );
						}
					} );


				} else if ( response.indexOf( 'error::' ) > -1 ) {
					var msg = response.split( 'error::' );
					console.warn( msg[ 1 ] );
				}

			},
			error: function ( XMLHttpRequest, textStatus, errorThrown ) {
				console.warn( errorThrown );
			}
		} );
	};

	this.updateState = function () {

		var apikey = $( mailchimp.apikey ).val();
		var dc = $( mailchimp.dc ).val();


		if ( typeof apikey === 'undefined' || apikey.length === 0 || typeof dc === 'undefined' || dc.length === 0 ) {
			$( '#mailchimp .not_ready' ).removeClass( 'hidden' );
			$( '#mailchimp .ready' ).addClass( 'hidden' );
		} else {
			$( '#mailchimp .not_ready' ).addClass( 'hidden' );
			$( '#mailchimp .ready' ).removeClass( 'hidden' );
		}

		// reset lists
		$( mailchimp.lists ).val( '' );
		$( '#mailchimp .set, #mailchimp ._error' ).addClass( 'hidden' );
		$( '#mailchimp .empty' ).removeClass( 'hidden' );
	};

};