<?php

return array(
	'name'     => __( 'Mailchimp', 'greyd_forms' ),

	// register settings
	'settings' => array(
		'description' => __( "Connect your Mailchimp account to automatically generate recipients from forms.", 'greyd_forms' ),
		'options'     => array(
			'apikey' => __( "API key:", 'greyd_forms' ),
			'dc'     => __( "Server abbreviation", 'greyd_forms' ),
			'lists'  => __( "Recipient lists:", 'greyd_forms' ),
		),
	),

	// register fields
	'metabox'  => array(
		'enable'   => array(
			'title'       => __( "Create recipient?", 'greyd_forms' ),
			'description' => __( "Do you want to automatically generate a Mailchimp recipient through a completed form?", 'greyd_forms' ),
		),
		'normal'   => array(
			'description' => __( "Select which form field to fill the respective Mailchimp entry with. The fields are synchronized with your created merge fields from Mailchimp. Reload the page or change your list to refresh the fields.", 'greyd_forms' ),
			'fields'      => array(
				// Default Audience Fields
				'email' => _x( "email", 'small', 'greyd_forms' ),
			),
		),


		'pre_meta' => array(
			'title'  => __( "Actions", 'greyd_forms' ),
			'fields' => array(
				'memberslist' => array(
					'type'  => 'select',
					'label' => __( "Recipient list", 'greyd_forms' ),
					'value' => self::get_option( 'mailchimp', 'lists' ),
				),
			),
		),
	),
	'optout'   => true,
);
