jQuery( function () {
	mailjet.init();
} );

var mailjet = new function () {

	this.apikey = 'input[name="greyd_forms_interface_settings[mailjet][apikey]"]';
	this.apisecret = 'input[name="greyd_forms_interface_settings[mailjet][apisecret]"]';
	this.lists = 'input[name="greyd_forms_interface_settings[mailjet][lists]"]';

	this.selectedList = 'select[name="interface_settings[mailjet][meta][contactlist]"]';
	this.fieldDropdowns = 'select[name*="interface_settings[mailjet][normal][api]"]';

	this.init = function () {
		$ = jQuery;

		//Get Lists
		$( mailjet.apikey ).on( 'change keyup', mailjet.updateState );
		$( mailjet.apisecret ).on( 'change keyup', mailjet.updateState );

		$( '#mailjet .button.getLists' ).on( "click", mailjet.getLists );
		mailjet.getLists();

		// Get Fields
		$( this.selectedList ).on( 'change', mailjet.getContactProperties );
		mailjet.getContactProperties();
	};


	this.getLists = function () {

		var apikey = $( mailjet.apikey ).val();
		var apisecret = $( mailjet.apisecret ).val();


		if ( typeof apikey === 'undefined' || apikey.length === 0 || typeof apisecret === 'undefinded' || apisecret.length === 0 )
			return false;

		$( '#mailjet .empty, #mailjet .set, #mailjet ._error' ).addClass( 'hidden' );
		$( '#mailjet .loader' ).parent().addClass( 'loading' ).css( 'display', 'inline-block' );

		console.log( local_mailjet );

		$.ajax( {
			type: 'POST',
			url: local_mailjet.ajaxurl,
			data: {
				action: local_mailjet.action,
				_ajax_nonce: local_mailjet.nonce,
				mode: 'mailjet',
				data: {
					apikey: apikey,
					apisecret: apisecret
				}
			},
			success: function ( response, textStatus, XMLHttpRequest ) {
				console.log( response );

				$( '#mailjet .loader' ).parent().removeClass( 'loading' ).css( 'display', 'none' );

				if ( response.indexOf( 'success::' ) > -1 ) {
					var msg = response.split( 'success::' );
					var lists = JSON.parse( msg[ 1 ] );

					// console.log(lists);
					$( mailjet.lists ).val( msg[ 1 ] );
					$( '#mailjet .set ul' ).html( '' );


					$.each( lists, function ( id, list ) {
						$( '#mailjet .set ul' ).append( "<li><strong>" + list + "</strong> (ID: " + id + ")</li>" );
					} );
					$( '#mailjet .set' ).removeClass( 'hidden' );

				} else if ( response.indexOf( 'error::' ) > -1 ) {
					var msg = response.split( 'error::' );
					console.warn( msg[ 1 ] );
					$( '#mailjet ._error .text' ).html( msg[ 1 ] );
					$( '#mailjet ._error' ).removeClass( 'hidden' );
				}

			},
			error: function ( XMLHttpRequest, textStatus, errorThrown ) {
				console.warn( errorThrown );
				$( '#mailjet .loader' ).parent().removeClass( 'loading' ).css( 'display', 'none' );
				$( '#mailjet ._error' ).removeClass( 'hidden' );

			}
		} );
	};

	this.getContactProperties = function () {

		var list = $( mailjet.selectedList ).val();
		// console.log(list);

		if ( typeof list === 'undefined' || list.length === 0 )
			return false;

		$.ajax( {
			type: 'POST',
			url: local_mailjet.ajaxurl,
			data: {
				action: local_mailjet.action,
				_ajax_nonce: local_mailjet.nonce,
				mode: 'mailjet',
				data: {
					list: list
				}
			},
			success: function ( response, textStatus, XMLHttpRequest ) {
				console.log( response );


				if ( response.indexOf( 'success::' ) > -1 ) {
					var msg = response.split( 'success::' );
					var contact_properties = JSON.parse( msg[ 1 ] );
					var init_field_value = '';


					$( 'select[name*="interface_settings[mailjet][normal][api]"] option[value!="none"][value!="email"]' ).each( function () { // Selektor cleanen?
						$( this ).remove();
					} );


					//add Fields to Dropdowns
					$.each( contact_properties, function ( id, field ) {
						$( mailjet.fieldDropdowns ).append( $( '<option value="' + id + '::' + field.name + '">' + field.name + '</option>' ) );
					} );

					//check for initial field value and add selected attribute
					$( mailjet.fieldDropdowns ).each( function () {

						init_field_value = $( this ).attr( "data-init-value" );

						if ( init_field_value.indexOf( "::" ) !== -1 ) {
							init_field_value = init_field_value.split( "::" );
							$( this ).children( 'option' ).each( function ( value ) {
								value = $( this ).val();
								value = value.split( "::" );
								if ( value[ 0 ] === init_field_value[ 0 ] ) {
									$( this ).attr( 'selected', 'selected' );
								}
							} );
						} else {
							$( this ).children( 'option' ).each( function ( value ) {
								value = $( this ).val();
								if ( value === init_field_value ) {
									$( this ).attr( 'selected', 'selected' );

								}
							} );
						}
					} );


				} else if ( response.indexOf( 'error::' ) > -1 ) {
					var msg = response.split( 'error::' );
					console.warn( msg[ 1 ] );
				}

			},
			error: function ( XMLHttpRequest, textStatus, errorThrown ) {
				console.warn( errorThrown );
			}
		} );
	};

	this.updateState = function () {

		var apikey = $( mailjet.apikey ).val();
		var apisecret = $( mailjet.apisecret ).val();


		if ( typeof apikey === 'undefined' || apikey.length === 0 || typeof apisecret === 'undefined' || apisecret.length === 0 ) {
			$( '#mailjet .not_ready' ).removeClass( 'hidden' );
			$( '#mailjet .ready' ).addClass( 'hidden' );
		} else {
			$( '#mailjet .not_ready' ).addClass( 'hidden' );
			$( '#mailjet .ready' ).removeClass( 'hidden' );
		}

		$( '#mailjet .set, #mailjet ._error' ).addClass( 'hidden' );
		$( '#mailjet .empty' ).removeClass( 'hidden' );
	};

};