<?php

return array(
	'name'     => __( 'Mailjet', 'greyd_forms' ),

	// register settings
	'settings' => array(
		'description' => __( "Connect your Mailjet account to automatically generate recipients from forms.", 'greyd_forms' ),
		'options'     => array(
			'apikey'    => __( "API key:", 'greyd_forms' ),
			'apisecret' => __( 'API-Secret:', 'greyd_forms' ),
			'lists'     => __( "Recipient lists:", 'greyd_forms' ),
			// 'dc'        => __("Server abbreviation", 'greyd_forms'),
		),
	),

	// register fields
	'metabox'  => array(
		'enable'   => array(
			'title'       => __( "Create recipient?", 'greyd_forms' ),
			'description' => __( "Do you want to automatically generate a Mailjet recipient through a completed form?", 'greyd_forms' ),
		),
		'normal'   => array(
			'description' => __( "Choose which form field you want to fill the respective Mailjet entry.", 'greyd_forms' ),
			'fields'      => array(

				'email' => _x( "email", 'small', 'greyd_forms' ),
			),
		),


		'pre_meta' => array(
			'title'  => __( "Actions", 'greyd_forms' ),
			'fields' => array(
				'contactlist' => array(
					'type'  => 'select',
					'label' => __( "Recipient list", 'greyd_forms' ),
					'value' => self::get_option( 'mailjet', 'lists' ),
				),
			),
		),
	),
	// 'optout' => true
);
