<?php
namespace Greyd\Forms\Interfaces;

use \Greyd\Forms\Helper;

use \Mailjet\Resources;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Mailjet_Handler {

	public static $errors = array();
	public static $client;

	public function __construct( $apikey, $apisecret ) {

		if ( empty( $apikey ) || empty( $apisecret ) ) {
			return false;
		}

		Helper::include_library(
			array(
				'path' => __DIR__,
				'file' => '/mailjet-apiv3-php-no-composer-master/vendor/autoload.php',
				'url'  => 'https://update.greyd.io/libs/mailjet-apiv3-php-no-composer-master.zip',
			)
		);

		self::$client = new \Mailjet\Client( $apikey, $apisecret );

	}

	public static function get_lists() {
		$return   = array();
		$response = self::$client->get( Resources::$Contactslist );
		$lists    = $response->success() ? $response->getData() : array();

		foreach ( $lists as $list ) {
			$return[ $list['ID'] ] = $list['Name'];
		}

		return $return;
	}


	public static function get_contact( $args = array() ) {
		$return = false;

		// return if no email is set
		if ( ! isset( $args['email'] ) ) {
			return false;
		}

		// set vars
		$email = isset( $args['email'] ) ? substr( $args['email'], 0, 255 ) : null;

		$response = self::$client->get( Resources::$Contact, array( 'id' => $email ) );

		return $response !== null ? $response : $return;
	}

	public static function create_contact( $args = array() ) {
		$return = false;

		// return if no email is set
		if ( ! isset( $args['email'] ) ) {
			return false;
		}

		// set vars
		$email = isset( $args['email'] ) ? substr( $args['email'], 0, 255 ) : null;

		$body = array(
			'Email' => $email,
			// 'IsExcludedFromCampaigns' => "true",
			// 'Name' => "New Contact",
		);

		$response = self::$client->post( Resources::$Contact, array( 'body' => $body ) );

		return $response !== null ? $response : $return;
	}

	public static function add_contact_to_list( $contact_id, $list_id ) {
		$return = false;

		if ( ! isset( $contact_id ) || ! isset( $list_id ) ) {
			return false;
		}

		$body = array(
			'ContactID' => $contact_id,
			'ListID'    => $list_id,
		);

		$response = self::$client->post( Resources::$Listrecipient, array( 'body' => $body ) );

		return $response !== null ? $response : $return;

	}

	public static function update_contact_properties( $contact_id, $properties ) {
		$return = false;

		if ( ! isset( $contact_id ) || ! isset( $properties ) ) {
			return false;
		}

		$body = array(
			'Data' => $properties,
		);

		$response = self::$client->put(
			Resources::$Contactdata,
			array(
				'id'   => $contact_id,
				'body' => $body,
			)
		);

		return $response !== null ? $response : $return;
	}

	public static function get_contact_properties( $list_id ) {

		// return if list-id is missing
		if ( ! isset( $list_id ) || empty( $list_id ) ) {
			return false;
		}

		$response = self::$client->get( Resources::$Contactmetadata );

		$contact_properties = $response->success() ? $response->getData() : array();

		foreach ( $contact_properties as $contact_property ) {
			$return[ $contact_property['ID'] ] = array(
				'name' => $contact_property['Name'],
				'type' => $contact_property['Datatype'],
			);
		}

		return $return;
	}
}
