jQuery( function () {
	rapidmail.init();
} );

var rapidmail = new function () {

	this.user = 'input[name="greyd_forms_interface_settings[rapidmail][user]"]';
	this.pw = 'input[name="greyd_forms_interface_settings[rapidmail][password]"]';
	this.lists = 'input[name="greyd_forms_interface_settings[rapidmail][lists]"]';

	this.init = function () {
		$ = jQuery;

		$( rapidmail.user + ", " + rapidmail.pw ).on( 'change keyup', rapidmail.updateState );

		$( '#rapidmail .button.getLists' ).on( "click", rapidmail.getLists );
		rapidmail.getLists();
	};

	this.getLists = function () {
		var user = $( rapidmail.user ).val();
		var pw = $( rapidmail.pw ).val();

		if ( typeof user === 'undefined' || user.length === 0 || typeof pw === 'undefined' || pw.length === 0 )
			return false;

		$( '#rapidmail .empty, #rapidmail .set, #rapidmail ._error' ).addClass( 'hidden' );
		$( '#rapidmail .loader' ).parent().addClass( 'loading' ).css( 'display', 'inline-block' );

		console.log( local_rapidmail );

		$.ajax( {
			type: 'POST',
			url: local_rapidmail.ajaxurl,
			data: {
				action: local_rapidmail.action,
				_ajax_nonce: local_rapidmail.nonce,
				mode: 'rapidmail',
				data: {
					user: user,
					password: pw
				}
			},
			success: function ( response, textStatus, XMLHttpRequest ) {
				console.log( response );

				$( '#rapidmail .loader' ).parent().removeClass( 'loading' ).css( 'display', 'none' );

				if ( response.indexOf( 'success::' ) > -1 ) {
					var msg = response.split( 'success::' );
					var lists = JSON.parse( msg[ 1 ] );
					console.log( lists );
					$( rapidmail.lists ).val( msg[ 1 ] );
					$( '#rapidmail .set ul' ).html( '' );
					$.each( lists, function ( id, name ) {
						$( '#rapidmail .set ul' ).append( "<li><strong>" + name + "</strong> (ID: " + id + ")</li>" );
					} );


					$( '#rapidmail .set' ).removeClass( 'hidden' );

				} else if ( response.indexOf( 'error::' ) > -1 ) {
					var msg = response.split( 'error::' );
					console.warn( msg[ 1 ] );
					$( '#rapidmail ._error .text' ).html( msg[ 1 ] );
					$( '#rapidmail ._error' ).removeClass( 'hidden' );
				}


			},
			error: function ( XMLHttpRequest, textStatus, errorThrown ) {
				console.warn( errorThrown );

				$( '#rapidmail .loader' ).parent().removeClass( 'loading' ).css( 'display', 'none' );
				$( '#rapidmail ._error' ).removeClass( 'hidden' );


			}
		} );
	};

	this.updateState = function () {
		console.log( 'changed' );

		var user = $( rapidmail.user ).val();
		var pw = $( rapidmail.pw ).val();

		if ( typeof user === 'undefined' || user.length === 0 || typeof pw === 'undefined' || pw.length === 0 ) {
			$( '#rapidmail .not_ready' ).removeClass( 'hidden' );
			$( '#rapidmail .ready' ).addClass( 'hidden' );
		} else {
			$( '#rapidmail .not_ready' ).addClass( 'hidden' );
			$( '#rapidmail .ready' ).removeClass( 'hidden' );
		}

		// reset lists
		$( rapidmail.lists ).val( '' );
		$( '#rapidmail .set, #rapidmail ._error' ).addClass( 'hidden' );
		$( '#rapidmail .empty' ).removeClass( 'hidden' );
	};

};