<?php

return array(
	'name'     => __( 'Rapidmail', 'greyd_forms' ),

	// register settings
	'settings' => array(
		'description' => __( "Connect your Rapidmail account to automatically generate recipients from forms.", 'greyd_forms' ),
		'options'     => array(
			'user'     => __( "API username:", 'greyd_forms' ),
			'password' => __( "API password:", 'greyd_forms' ),
			'lists'    => __( "Recipient lists:", 'greyd_forms' ),
		),
	),

	// register fields
	'metabox'  => array(
		'enable' => array(
			'title'       => __( "Create recipient?", 'greyd_forms' ),
			'description' => __( "Do you want to automatically generate a Rapidmail recipient through a completed form?", 'greyd_forms' ),
		),
		'normal' => array(
			'fields' => array(
				'email'     => _x( "email", 'small', 'greyd_forms' ),
				'firstname' => _x( "first name", 'small', 'greyd_forms' ),
				'lastname'  => _x( "last name", 'small', 'greyd_forms' ),
				'gender'    => _x( "Sex", 'small', 'greyd_forms' ),
				'title'     => _x( "salutation", 'small', 'greyd_forms' ),
				'zip'       => _x( "zip", 'small', 'greyd_forms' ),
				'birthdate' => _x( "Birthday", 'small', 'greyd_forms' ),
				'extra1'    => _x( 'Extra 1', 'small', 'greyd_forms' ),
				'extra2'    => _x( 'Extra 2', 'small', 'greyd_forms' ),
				'extra3'    => _x( 'Extra 3', 'small', 'greyd_forms' ),
				'extra4'    => _x( 'Extra 4', 'small', 'greyd_forms' ),
				'extra5'    => _x( 'Extra 5', 'small', 'greyd_forms' ),
				'extra6'    => _x( 'Extra 6', 'small', 'greyd_forms' ),
				'extra7'    => _x( 'Extra 7', 'small', 'greyd_forms' ),
				'extra8'    => _x( 'Extra 8', 'small', 'greyd_forms' ),
				'extra9'    => _x( 'Extra 9', 'small', 'greyd_forms' ),
				'extra10'   => _x( 'Extra 10', 'small', 'greyd_forms' ),

				/**
				 *  extra 'BIG' fields (for textares etc.) can be found in the API docs
				 *  link: https://developer.rapidmail.wiki/documentation.html?urls.primaryName=Recipients#/Recipients/post_recipients
				 *
				 *  Anyway, I couldn't find them inside the application
				 *  as they're no default, they are deactivated for the moment to not mislead the admin
				 */
				// 'extrabig1'     => _x( 'Extra big 1', 'small', 'greyd_forms' ),
				// 'extrabig2'     => _x( 'Extra big 2', 'small', 'greyd_forms' ),
				// 'extrabig3'     => _x( 'Extra big 3', 'small', 'greyd_forms' ),
				// 'extrabig4'     => _x( 'Extra big 4', 'small', 'greyd_forms' ),
				// 'extrabig5'     => _x( 'Extra big 5', 'small', 'greyd_forms' ),
				// 'extrabig6'     => _x( 'Extra big 6', 'small', 'greyd_forms' ),
				// 'extrabig7'     => _x( 'Extra big 7', 'small', 'greyd_forms' ),
				// 'extrabig8'     => _x( 'Extra big 8', 'small', 'greyd_forms' ),
				// 'extrabig9'     => _x( 'Extra big 9', 'small', 'greyd_forms' ),
				// 'extrabig10'    => _x( 'Extra big 10', 'small', 'greyd_forms' ),
			),
		),
		'meta'   => array(
			'title'  => __( "Actions", 'greyd_forms' ),
			'fields' => array(
				'recipientlist'  => array(
					'type'  => 'select',
					'label' => __( "Recipient list", 'greyd_forms' ),
					'value' => self::get_option( 'rapidmail', 'lists' ),
				),
				'activationmail' => array(
					'type'  => 'checkbox',
					'label' => __( "Send activation email?", 'greyd_forms' ),
				),
				'update'         => array(
					'type'  => 'checkbox',
					'label' => __( "Do you want to update the recipient if the email already exists in the list?", 'greyd_forms' ),
				),
			),
		),
	),
	'optout'   => true,
);
