<?php

return array(
	'name'     => __( 'Salesforce', 'greyd_forms' ),

	// register settings
	'settings' => array(
		'description' => __( "Connect your Salesforce account to automatically generate leads from your forms.", 'greyd_forms' ),
		'options'     => array(
			'organisation_id' => __( 'Organisation ID:', 'greyd_forms' ),
		),
	),

	// register fields
	'metabox'  => array(
		'enable' => array(
			'title'       => __( "Generate lead?", 'greyd_forms' ),
			'description' => __( "Do you want to automatically generate a Salesforce lead from a completed form?", 'greyd_forms' ),
		),
		'normal' => array(
			'fields' => array(
				'email'      => _x( "email", 'small', 'greyd_forms' ),
				'first_name' => _x( "first name", 'small', 'greyd_forms' ),
				'last_name'  => _x( "last name", 'small', 'greyd_forms' ),
				'salutation' => _x( "salutation", 'small', 'greyd_forms' ),
				'company'    => _x( "company", 'small', 'greyd_forms' ),
				'phone'      => _x( "phone number", 'small', 'greyd_forms' ),
				'street'     => _x( "street", 'small', 'greyd_forms' ),
				'zip'        => _x( "zip", 'small', 'greyd_forms' ),
				'city'       => _x( "city", 'small', 'greyd_forms' ),
				'country'    => _x( "country", 'small', 'greyd_forms' ),
				'URL'        => _x( "website", 'small', 'greyd_forms' ),
			),
		),
		'custom' => array(
			'fields'      => true,
			'description' => sprintf(
				__( "Here you can transmit your individual Salesforce lead fields. You can find the name of the fields in Salesforce in the 'Object Manager' under 'Fields and Labels'. %s", 'greyd_forms' ),
				"<a href='https://www.youtube.com/watch?v=HJdoPYb6mjw' target='_blank'>" . __( "How to create a custom field", 'greyd_forms' ) . '</a>'
			),
		),
		'meta'   => array(
			'fields' => array(
				'lead_source' => array(
					'type'  => 'text',
					'label' => __( "Lead source", 'greyd_forms' ),
					'value' => __( 'Greyd.Forms', 'greyd_forms' ),
				),
				'lead_descr'  => array(
					'type'  => 'textarea',
					'label' => __( "Description", 'greyd_forms' ),
					'value' => __( "This is an automated lead generated with Greyd.Forms.", 'greyd_forms' ),
				),
			),
		),
	),
	'optout'   => false,
);
