jQuery( function () {
	samdock.init();
} );

var samdock = new function () {

	this.email = 'input[name="greyd_forms_interface_settings[samdock][email]"]';
	this.password = 'input[name="greyd_forms_interface_settings[samdock][password]"]';
	this.auth = 'input[name="greyd_forms_interface_settings[samdock][authentication]"]';

	this.init = function () {
		$ = jQuery;

		//Get Lists
		$( samdock.email ).on( 'change keyup', samdock.updateState );
		$( samdock.password ).on( 'change keyup', samdock.updateState );

		$( '#samdock .get_access_token' ).on( 'click', this.checkAuth );
	};

	this.checkAuth = function () {
		var email = $( samdock.email ).val();
		var password = $( samdock.password ).val();

		if ( typeof email === 'undefined' || email.length === 0 || typeof password === 'undefinded' || password.length === 0 )
			return false;

		// $('#samdock .get_access_token, #samdock .set, #samdock ._error').addClass('hidden');
		$( '#samdock .get_access_token, #samdock .set, #samdock ._error' ).addClass( 'hidden' );

		$( '#samdock .loader' ).parent().addClass( 'loading' ).css( 'display', 'inline-block' );

		console.log( local_samdock );

		$.ajax( {
			type: 'POST',
			url: local_samdock.ajaxurl,
			data: {
				action: local_samdock.action,
				_ajax_nonce: local_samdock.nonce,
				mode: 'samdock',
				data: {
					email: email,
					password: password
				}
			},
			success: function ( response, textStatus, XMLHttpRequest ) {
				console.log( response );

				$( '#samdock .loader' ).parent().removeClass( 'loading' ).css( 'display', 'none' );

				if ( response.indexOf( 'success::' ) > -1 ) {
					var msg = response.split( 'success::' );
					$( samdock.auth ).val( msg[ 1 ] );
					$( '#samdock ._success' ).removeClass( 'hidden' );
				} else if ( response.indexOf( 'error::' ) > -1 ) {
					var msg = response.split( 'error::' );
					console.warn( msg[ 1 ] );
					$( '#samdock ._error .text' ).html( msg[ 1 ] );
					$( '#samdock ._error, #samdock .get_access_token' ).addClass( 'hidden' );
					$( '#samdock ._error, #samdock .get_access_token.retry' ).removeClass( 'hidden' );
				}
			},
			error: function ( XMLHttpRequest, textStatus, errorThrown ) {
				console.warn( errorThrown );
				$( '#samdock .loader' ).parent().removeClass( 'loading' ).css( 'display', 'none' );
				$( '#samdock ._error' ).removeClass( 'hidden' );

			}
		} );
	};

	this.updateState = function () {

		const email = $( samdock.email ).val();
		const password = $( samdock.password ).val();


		if ( ( typeof email === 'undefined' || email.length === 0 ) || ( typeof password === 'undefined' || password.length === 0 ) ) {
			$( '#samdock ._info.nocredentials' ).removeClass( 'hidden' );
			$( '#samdock .get_access_token' ).not( '.retry' ).addClass( 'hidden' );
		} else {
			$( '#samdock ._info.nocredentials' ).addClass( 'hidden' );
			$( '#samdock .get_access_token' ).not( '.retry' ).removeClass( 'hidden' );
		}

		if ( !$( '#samdock ._error' ).hasClass( 'hidden' ) && !$( '#samdock .get_access_token.retry' ).hasClass( 'hidden' ) ) {
			$( '#samdock .get_access_token' ).not( '.retry' ).addClass( 'hidden' );
		} else {
			$( '#samdock .get_access_token' ).not( '.retry' ).removeClass( 'hidden' );
		}
		$( '#samdock ._success' ).addClass( 'hidden' );
	};

};