jQuery( function () {
	webhook.init();
} );

var webhook = new function () {

	this.select = 'select[name^="interface_settings[webhook][custom][frm]"]';
	this.input = 'input[name^="interface_settings[webhook][custom][api]"]';

	this.init = function () {
		$ = jQuery;

		// on load
		$.each( $( webhook.select ), function () {
			webhook.updatePlaceholder( this );
		} );

		// on change event
		$( webhook.select ).on( 'change', function () {
			webhook.updatePlaceholder( this );
		} );

		// add onchange event for new rows
		$( 'body' ).on( 'api_row_updated', function ( e, row ) {

			var select = row.find( webhook.select );

			webhook.updatePlaceholder( select[ 0 ] );

			select.on( 'change', function () {
				webhook.updatePlaceholder( this );
			} );
		} );
	};

	this.emptyValues = [ "", "--", "select", "please select", "choose", "please choose", "none", "bitte wählen", "bitte auswählen" ];

	this.updatePlaceholder = function ( elem ) {
		var selectValue = $( elem ).val(),
			input = $( elem ).parent().next().next().children( webhook.input ),
			inputValue = input.val();

		if ( inputValue && inputValue.length > 0 ) return;

		if ( typeof selectValue === 'undefined' || !selectValue || selectValue.length === 0 || webhook.emptyValues.includes( selectValue ) ) {
			input.val( '' );
		} else {
			input.val( selectValue );
		}
	};

};