<?php

return array(
	'name'     => __( 'Webhook', 'greyd_forms' ),

	// register settings
	'settings' => array(
		'description' => __( "Connect your forms to individual interfaces.", 'greyd_forms' ),
		'options'     => array(
			'info' => '&nbsp;',
		),
	),

	// register fields
	'metabox'  => array(
		'enable' => array(
			'title'       => __( "Send to individual webhook?", 'greyd_forms' ),
			'description' => __( "Automatically send form entries to an individual interface of your choice.", 'greyd_forms' ),
		),
		'custom' => array(
			'fields'      => true,
			'title'       => __( "Set fields", 'greyd_forms' ),
			'description' => __( "Here you can set which fields are sent to the webhook with which name.", 'greyd_forms' ),
			'api_fields'  => __( "Field name", 'greyd_forms' ),
		),
		'meta'   => array(
			'title'  => __( "Webhook settings", 'greyd_forms' ),
			'fields' => array(
				'url'    => array(
					'type'  => 'text',
					'label' => __( 'Webhook URL', 'greyd_forms' ),
				),
				'method' => array(
					'type'  => 'select',
					'label' => "<a href='https://www.w3schools.com/tags/ref_httpmethods.asp' target='_blank'>" . __( "Method", 'greyd_forms' ) . '</a>',
					'value' => array(
						'post'    => 'POST',
						'get'     => 'GET',
						'put'     => 'PUT',
						'patch'   => 'PATCH',
						'delete'  => 'DELETE',
						'head'    => 'HEAD',
						'connect' => 'CONNECT',
						'options' => 'OPTIONS',
						'trace'   => 'TRACE',
					),
				),
				'format' => array(
					'type'  => 'select',
					'label' => __( 'Format', 'greyd_forms' ),
					'value' => array(
						'json' => __( "as JSON (default)", 'greyd_forms' ),
						'url'  => __( "URL encoded", 'greyd_forms' ),
					),
				),
			),
		),
	),
	'optout'   => false,
);
