jQuery( function () {
	zapier.init();
} );

var zapier = new function () {

	this.select = 'select[name^="interface_settings[zapier][custom][frm]"]';
	this.input = 'input[name^="interface_settings[zapier][custom][api]"]';

	this.init = function () {
		$ = jQuery;

		// on load
		$.each( $( zapier.select ), function () {
			zapier.updatePlaceholder( this );
		} );

		// on change event
		$( zapier.select ).on( 'change', function () {
			zapier.updatePlaceholder( this );
		} );

		// add onchange event for new rows
		$( 'body' ).on( 'api_row_updated', function ( e, row ) {

			var select = row.find( zapier.select );

			zapier.updatePlaceholder( select[ 0 ] );

			select.on( 'change', function () {
				zapier.updatePlaceholder( this );
			} );
		} );
	};

	this.emptyValues = [ "", "--", "select", "please select", "choose", "please choose", "none", "bitte wählen", "bitte auswählen" ];

	this.updatePlaceholder = function ( elem ) {
		var selectValue = $( elem ).val(),
			input = $( elem ).parent().next().next().children( zapier.input ),
			inputValue = input.val();

		if ( inputValue && inputValue.length > 0 ) return;

		if ( typeof selectValue === 'undefined' || !selectValue || selectValue.length === 0 || zapier.emptyValues.includes( selectValue ) ) {
			input.val( '' );
		} else {
			input.val( selectValue );
		}
	};
};