<?php

return array(
	'name'     => __( 'Zapier', 'greyd_forms' ),

	// register settings
	'settings' => array(
		'description' => __( "Connect your Zapier account to automatically generate contacts from forms.", 'greyd_forms' ),
		'options'     => array(
			'info' => '&nbsp;',
		),
	),

	// register fields
	'metabox'  => array(
		'enable'   => array(
			'title'       => __( "Send to Zapier?", 'greyd_forms' ),
			'description' => __( "Do you want to send a completed form to Zapier?", 'greyd_forms' ),
		),
		'custom'   => array(
			'fields'      => true,
			'title'       => __( "Set fields", 'greyd_forms' ),
			'description' => __( "Here you can set which fields are sent to Zapier with which name.", 'greyd_forms' ),
			'api_fields'  => __( "Field name", 'greyd_forms' ),
		),
		'pre_meta' => array(
			'title'  => __( "Webhook settings", 'greyd_forms' ),
			'fields' => array(
				'url' => array(
					'type'  => 'text',
					'label' => __( 'Webhook URL', 'greyd_forms' ),
				),
			),
		),
		'help'     => array(
			'title'   => __( "How do I connect my form to Zapier?", 'greyd_forms' ),
			'content' =>
				'<ol>' .
					'<li>' . __( "Create a new Zap.", 'greyd_forms' ) . '</li>' .
					'<li>' . __( "Select \"Webhooks by Zapier\" as the app and \"Catch Hook\" as the event.", 'greyd_forms' ) . '</li>' .
					'<li>' . __( "Zapier now generates your custom webhook URL. Insert it at the top.", 'greyd_forms' ) . '</li>' .
					'<li>' . __( "Set the fields you want to send to Zapier at the top and save the form.", 'greyd_forms' ) . '</li>' .
					'<li>' . __( "Now you need to fill out and submit the form once on your website to feed Zapier with data.", 'greyd_forms' ) . '</li>' .
					'<li>' . __( "In Zapier, click \"Test Trigger\". Your newly entered data should now appear there.", 'greyd_forms' ) . '</li>' .
					'<li>' . __( "Done! Now you can connect this form to over 2,000 applications!", 'greyd_forms' ) . '</li>' .
				'</ol>',
		),
	),
	'optout'   => false,
);
