<?php
namespace Greyd\Forms\Interfaces;

use \Greyd\Forms\Helper;


if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

new Zapier();

class Zapier {

	const INTERFACE = 'zapier';

	public function __construct() {

		// settings
		add_action( 'render_setting_' . self::INTERFACE . '_info', array( $this, 'render_info' ), 10, 2 );

		// admin script
		add_action( 'admin_enqueue_scripts', array( $this, 'load_backend' ) );

		// handler
		add_filter( 'handle_after_doi_' . self::INTERFACE, array( $this, 'send' ), 10, 4 );
	}

	/**
	 * Render Setting
	 */
	public function render_info( $pre = '', $value = null ) {

		$option = 'info';
		$slug   = $pre . '[' . $option . ']';
		echo "<input type='hidden' id='$slug' class='regular-text' name='$slug' value='true'>";

		echo "<div style='margin-top:-30px;'>" .
			'<p><i>' .
			sprintf(
				__( "Use %1\$sWebhooks by Zapier%2\$s to connect Greyd.Forms with Zapier. This will give you a custom URL to enter in your forms.", 'greyd_forms' ),
				"<a href='https://zapier.com/page/webhooks/' target='_blank'>",
				'</a>'
			) .
			'</i></p><br>' .
			"<img style='max-width:630px;' src='" . plugin_dir_url( 'greyd_tp_forms/init.php' ) . '/interfaces/' . self::INTERFACE . '/assets/screenshot.png' . "'></img>" .
		'</div>';
	}


	/**
	 * admin script
	 */
	public function load_backend() {

		$posttype = get_post_type() ? get_post_type() : get_current_screen()->post_type;

		if ( $posttype === 'tp_forms' ) {

			$dir = plugin_dir_url( 'greyd_tp_forms/init.php' ) . '/interfaces/' . self::INTERFACE . '/';
			wp_register_script( self::INTERFACE . '_backend_js', $dir . 'assets/backend.js', 'jquery' );
			wp_enqueue_script( self::INTERFACE . '_backend_js' );
		}
	}

	/**
	 * Send form data to zapier webhook
	 *
	 * @filter handle_after_doi_{{interface}}
	 *
	 * @param mixed  $response      The response to return.
	 * @param string $entry_id      The Post ID of the entry.
	 * @param array  $form_data     The user data, keyed by the field name.
	 * @param array  $postmeta      The form post_meta for this specific interface.
	 *
	 * @return mixed    If true is is returned, a default success message is logged to the entry.
	 */
	public function send( $response, $entry_id, $formdata, $postmeta ) {

		// meta
		$name = Greyd_Forms_Interface::get_config( self::INTERFACE, 'name' );
		$url  = isset( $postmeta['meta'] ) && isset( $postmeta['meta']['url'] ) ? $postmeta['meta']['url'] : '';

		if ( empty( $url ) ) {
			return false;
		}

		// save meta in entry
		Greyd_Forms_Interface::update_entry_data( $entry_id, self::INTERFACE, array( 'url' => $url ) );

		// get fields
		$interface_data = array();
		$fields         = isset( $postmeta['custom'] ) ? (array) $postmeta['custom'] : array();

		// modify fields
		foreach ( $fields as $key => $val ) {
			$value = isset( $formdata[ $val ] ) ? html_entity_decode( $formdata[ $val ] ) : '';

			// convert checkbox value to bool
			$value = strpos( $value, '[on]' ) !== false ? true : ( strpos( $value, '[off]' ) !== false ? false : $value );

			if ( $value !== '' ) {
				$interface_data[ $key ] = $value;
			}
		}
		// do_action('formhandler_error', $interface_data); // debug

		/**
		 * Filter the data send to the interface.
		 *
		 * @filter greyd_forms_interface_response_{{interface}}
		 *
		 * @param array  $interface_data  Data send to the interface.
		 * @param int    $entry_id        WP_Post ID of the entry.
		 * @param array  $fields          Validated form data.
		 * @param array  $postmeta        The form post_meta for this specific interface.
		 */
		$interface_data = apply_filters( 'greyd_forms_interface_data_' . self::INTERFACE, $interface_data, $entry_id, $formdata, $postmeta );

		// post to zapier
		$response = Greyd_Forms_Interface::send_http_request( $url, $interface_data );

		// success
		$response = isset( $response['body'] ) ? json_decode( $response['body'], true ) : $response;
		if ( isset( $response['status'] ) && $response['status'] === 'success' ) {
			return true;
		}
		// error
		else {
			// loging error
			$text = '';
			foreach ( $response as $k => $v ) {
				$text = $text === '' ? $k . ': ' . $v : $text . ', ' . $k . ': ' . $v;
			}
			$text = sprintf( __( "Failed to send to %s", 'greyd_forms' ), $name ) . ' (' . $text . ')';
			Helper::log_entry_state( $entry_id, $name . ': ' . $text );
		}

		// return
		return $response;
	}

}
