<?php

return array(
	'name'     => __( 'Zoom Webinar', 'greyd_forms' ),

	// register settings
	'settings' => array(
		'description' => __( "Enable webinar registrations with Greyd.Forms.", 'greyd_forms' ),
		'options'     => array(
			'client_id'      => __( 'Client ID', 'greyd_forms' ),
			'client_secret'  => __( 'Client Secret', 'greyd_forms' ),
			'authentication' => __( "Authentification", 'greyd_forms' ),
			'webinars'       => __( "Webinars", 'greyd_forms' ),
		),
	),

	// register fields
	'metabox'  => array(
		'enable' => array(
			'title'       => __( "Sign up for Zoom webinar?", 'greyd_forms' ),
			'description' => __( "Send the form entry to the Zoom webinar API.", 'greyd_forms' ),
		),
		'normal' => array(
			'fields' => array(
				'email'      => _x( "email", 'small', 'greyd_forms' ),
				'first_name' => _x( "first name", 'small', 'greyd_forms' ),
				'last_name'  => _x( "last name", 'small', 'greyd_forms' ),
				'address'    => _x( "address", 'small', 'greyd_forms' ),
				'city'       => _x( "city", 'small', 'greyd_forms' ),
				'country'    => _x( "country", 'small', 'greyd_forms' ),
				'zip'        => _x( "zip code", 'small', 'greyd_forms' ),
				'state'      => _x( "state", 'small', 'greyd_forms' ),
				'phone'      => _x( "phone number", 'small', 'greyd_forms' ),
				'industry'   => _x( "sector / industry", 'small', 'greyd_forms' ),
				'org'        => _x( "company", 'small', 'greyd_forms' ),
				'job_title'  => _x( "job title", 'small', 'greyd_forms' ),
				'comments'   => _x( "comment", 'small', 'greyd_forms' ),
			),
		),
		'meta'   => array(
			'title'  => __( 'Webinar', 'greyd_forms' ),
			'fields' => array(
				'webinar' => array(
					'type'         => 'select',
					'label'        => __( "Select webinar", 'greyd_forms' ),
					'value'        => self::get_option( 'zoom_webinar', 'webinars' ),
					'empty_option' => true,
					'description'  => __( "Once you have selected a webinar and saved your changes, you can use the “Zoom Webinar Info” module to display dynamic information in the front end.", 'greyd_forms' ),
				),
			),
		),
	),
	'optout'   => true,
);
