<?php
/*
Feature Name:   Accessibility
Description:    Help to make your website accessible.
Plugin URI:     https://greyd.io
Author:         Greyd
Author URI:     https://greyd.io
Version:        0.0.1
Text Domain:    greyd_hub
Domain Path:    /languages/
priority:       20
*/

/**
 * Greyd Accessability Tweaks.
 * @since 1.4.5
 */
namespace Greyd\Extensions;

use Greyd\Settings as Settings;
// use Greyd\Helper as Helper;

if( ! defined( 'ABSPATH' ) ) exit;

/**
 * disable if plugin wants to run standalone
 */
if ( !class_exists( "Greyd\Admin" ) ) {
	// reject activation
	if (!function_exists('get_plugins')) require_once ABSPATH.'wp-admin/includes/plugin.php';
	$plugin_name = get_plugin_data(__FILE__)['Name'];
	deactivate_plugins( plugin_basename( __FILE__ ) );
	// return reject message
	die(sprintf("%s can not be activated as standalone Plugin.", $plugin_name));
}

new Accessibility();
class Accessibility {

	/**
	 * Constructor
	 */
	public function __construct() {

		// add settings
		add_filter( 'greyd_settings_default_site', array($this, 'add_setting') );
		add_filter( 'greyd_settings_basic', array($this, 'render_settings'), 10, 3 );
		add_filter( 'greyd_settings_more_save', array($this, 'save_settings'), 10, 3 );
		
		add_filter( 'greyd_autogenerate_attachment_image_alt', array($this, 'autogenerate_attachment_image_alt'), 10, 3 );
	}

	/*
	=================================================================
		SETTINGS
	=================================================================
	*/

	/**
	 * Get default settings
	 */
	public static function get_defaults() {

		$defaults = array( 
			'accessibility' => array(
				'do_not_auto_generate_alt_texts' => false
			)
		);

		return $defaults;
	}

	/**
	 * Add default settings
	 * @see filter 'greyd_settings_default_site'
	 */
	public function add_setting($settings) {

		// add default settings
		$settings = array_replace_recursive(
			$settings,
			self::get_defaults()
		);

		return $settings;
	}

	/**
     * Get the current settings .
     */
    public static function get_settings() {

        // get from settings
        return Settings::get_setting( array('site', 'accessibility') );
    }


	/**
	 * Render the settings
	 * 
	 * @param string $content   Content of all additional settings.
	 * @param string $mode      'site' | 'network_site' | 'network_admin'
	 * @param array $data       Current settings.
	 * 
	 */
	public function render_settings( $content, $mode, $data ) {

		$defaults = self::get_defaults();
		$settings = $data["site"]['accessibility'];

		$enable = $settings["do_not_auto_generate_alt_texts"];
		// $auto_alt_enabled = apply_filters( "greyd_generate_auto_alt_texts", false );

		// var_error_log($settings);

		$content .=  "<h2>".__("Accessibility", 'greyd_hub')."</h2>";
		$content .= "
		<table class='form-table'>
			<tr>
				<th>".__("Alt texts", 'greyd_hub')."</th>
				<td>
					<label for='accessibility[do_not_auto_generate_alt_texts]'>
					<input type='checkbox' id='accessibility[do_not_auto_generate_alt_texts]' name='accessibility[do_not_auto_generate_alt_texts]' ".( $enable ? "checked='checked'" : "" )."/>
						<span>".__("Do not generate alt texts automatically", 'greyd_hub')."</span><br>
				</td>
			</tr>
		</table>";
		return $content;
	}

	/**
	 * Save site settings
	 * @see filter 'greyd_settings_more_save'
	 * 
	 * @param array $site       Current site settings.
	 * @param array $defaults   Default values.
	 * @param array $data       Raw $_POST data.
	 */
	public function save_settings( $site, $defaults, $data ) {

		// make new settings
		$site['accessibility'] = array(
			'do_not_auto_generate_alt_texts' => isset($data['accessibility']['do_not_auto_generate_alt_texts']) && $data['accessibility']['do_not_auto_generate_alt_texts'] === "on" ? true : $defaults['accessibility']['do_not_auto_generate_alt_texts']
		);

		return $site;
	}

	/**
	 * Disable autogenerated image alt text if setting is true.
	 * 
	 * @param bool $enable          Whether autogeneration is enabled.
	 * @param int $attachment_id    Attachement post ID.
	 * @param string $type          'alt', 'title' or 'caption'
	 * 
	 * @return false
	 */
	public function autogenerate_attachment_image_alt( $enable, $attachment_id, $type ) {
		$accessibility_settings = self::get_settings();
		return !(
			isset($accessibility_settings['do_not_auto_generate_alt_texts']) &&
			$accessibility_settings['do_not_auto_generate_alt_texts'] == "on"
		);
	}

}