<?php
/*
Feature Name:   Blocks
Description:    Register Greyd Blocks.
Plugin URI:     https://greyd.io
Author:         Greyd
Author URI:     https://greyd.io
Version:        0.9
Text Domain:    greyd_hub
Domain Path:    /languages/
Priority:       98
Forced:         true
*/
namespace greyd\blocks;
// namespace Greyd\Block;

if ( !defined( 'ABSPATH' ) ) exit;

// escape if greyd_blocks <= 1.14.0 is still active
if ( !\Greyd\Features::load_blocks_features() ) return;

// escape if feature still runs in other plugin
if ( class_exists( 'greyd\blocks\blocks' ) ) return;

// keep version constant for compatibility
if ( !defined( 'GREYD_BLOCKS_VERSION' ) ) {
	define( 'GREYD_BLOCKS_VERSION', GREYD_VERSION );
}

// includes
require_once __DIR__.'/blocks.php';
require_once __DIR__.'/enqueue.php';
require_once __DIR__.'/helper.php';
require_once __DIR__.'/render.php';
require_once __DIR__.'/meta.php';
require_once __DIR__.'/patterns.php';
require_once __DIR__.'/wpml.php';

// blocks
require_once __DIR__.'/image/init.php';
require_once __DIR__.'/button/init.php';
require_once __DIR__.'/accordion/init.php';
require_once __DIR__.'/list/init.php';
require_once __DIR__.'/popover/init.php';
require_once __DIR__.'/form/init.php';
require_once __DIR__.'/conditional-content/init.php';
require_once __DIR__.'/search/init.php';
require_once __DIR__.'/tabs/init.php';
require_once __DIR__.'/hotspot/init.php';
require_once __DIR__.'/menu/init.php';
require_once __DIR__.'/navigation/init.php';
require_once __DIR__.'/iframe/init.php';
require_once __DIR__.'/anchor/init.php';
require_once __DIR__.'/woocommerce/init.php';

/**
 * Enable beta blocks before release
 * @since 1.6.0
 */
if ( defined( 'GREYD_ENABLE_BETA_BLOCKS') && constant( 'GREYD_ENABLE_BETA_BLOCKS' ) ) {
	
}
